/*
 *	Copyright 1990 by Rayan S. Zachariassen, all rights reserved.
 *	This will be free software, but only when it is finished.
 */

#ifndef	Z_SIFT_H
#define	Z_SIFT_H
#include "token.h"

struct vaccess {	/* in a list of this structure */
	struct vaccess	*next;
	struct conscell	*l;		/* points at variable name in :env */
};

struct si_retab {
	struct si_retab	*next;
	regexp		*rep;
	struct token	*startp[NSUBEXP];
	struct token	*endp[NSUBEXP];
};

struct siftinfo {
	struct token	*tlist;		/* token list for sift expression */
	struct vaccess	*accessed;	/* variables dependencies of expr. */
	int		label;		/* label to go to when reevaluating */
	regexp		*program;	/* compiled regular expression stack */
	struct si_retab	*subexps;	/* linked list of subexpressions */
};

extern int v_record;			/* record variable accesses */
extern int v_changed;			/* antecedent variable changed */
extern struct vaccess *v_accessed;	/* list of variables accessed */
extern void v_written();		/* a variable value changed */

#endif	/* Z_SIFT_H */
