/*
 *	Copyright 1988 by Rayan S. Zachariassen, all rights reserved.
 *	This will be free software, but only when it is finished.
 */

/*
 * Common routine to fiddle control file tag characters.
 */

#include <stdio.h>
#include "hostenv.h"
#include <sys/file.h>

#ifndef	L_SET
#define	L_SET	0
#endif	/* L_SET */

int
lockaddr(fd, offset, was, new)
	int	fd;
	long	offset;
	char	was;
	char	new;
{
	char	c;

	if (lseek(fd, offset, L_SET) < 0L) {
		(void) fprintf(stderr, "lockaddr: lseek failure\n");
		return 0;
	}
	if (read(fd, &c, 1) != 1) {
		(void) fprintf(stderr, "lockaddr: read failure\n");
		return 0;
	}
	if (c == was) {
		if (lseek(fd, offset, L_SET) < 0L) {
			fprintf(stderr, "lockaddr: lseek2 failure\n");
			return 0;
		}
		return write(fd, &new, 1) == 1;
	}
	fprintf(stderr, "lockaddr: expected '%c' found '%c'\n", was, new);
	return 0;
}

