/* Copyright (c) 1992 Vincent Cate
 * All Rights Reserved.
 *
 * Permission to use and modify this software and its documentation
 * is hereby granted, provided that both the copyright notice and this
 * permission notice appear in all copies of the software, derivative works
 * or modified versions, and any portions thereof, and that both notices
 * appear in supporting documentation.  This software or any derivate works
 * may not be sold or distributed without prior written approval from
 * Vincent Cate.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND VINCENT CATE DISCLAIMS ALL
 * WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS.  IN NO EVENT SHALL
 * VINCENT CATE BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
 * OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
 * OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE
 * OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Users of this software agree to return to Vincent Cate any improvements
 * or extensions that they make and grant Vincent Cate the rights to
 * redistribute these changes.
 *
 */



/* UNFSD - copyright Mark A Shand, May 1988.
 * This software maybe be used for any purpose provided
 * the above copyright notice is retained.  It is supplied
 * as is, with no warranty expressed or implied.
 */

#include "alexincs.h"
#include "alex.h"
#include "unfsd.h"
#include "mount.h"


void rd_mlist(), add_mlist(), rm_mlist();
static mountlist mlhead = NULL;
static struct timeval TIMEOUT = { 25, 0 };


FILE *debugLog = NULL;
char argbuf[512];


init_Log()
{
    char Name[100];

    if (debugLog != NULL) {
        return;
    }

    (void) strcpy(Name, TMPDIR);
    (void) strcat(Name, "/alexmountd.log");
    SetLogBaseName(Name);
    InitReadOnlyVariables();               /* needs to be first before any Logs() */

    ToLog(DBMAJOR, "init_Log in unfsmntd");

    rd_mlist();
}


int Logcall(name1, arg1, rqstp)
char    *name1;
char    *arg1;
struct svc_req  *rqstp;
{
    int i;
    struct authunix_parms *unix_cred;

    if (debugLog == NULL) {
        init_Log();
    }

    ToLog(DBMAJOR, "%s [ %d %d ", name1, 
                            rqstp->rq_cred.oa_flavor, rqstp->rq_cred.oa_length);

    if (rqstp->rq_cred.oa_flavor == AUTH_UNIX) {
        unix_cred = (struct authunix_parms *) rqstp->rq_clntcred;
        ToLog(DBMAJOR, "%.24s %s %d.%d ",
            ctime(&unix_cred->aup_time),
            unix_cred->aup_machname,
            unix_cred->aup_uid,
            unix_cred->aup_gid);
        if (unix_cred->aup_len > 0) {
            for (i = 0; i < unix_cred->aup_len; i++) {
                ToLog(DBMAJOR, "%c%d", (i==0?'(':','),
                    unix_cred->aup_gids[i]);
            }
            ToLog(DBMAJOR, ") ");
        }
    }
    ToLog(DBMAJOR, "]\n\t%s\n", arg1);
    flushLog();

    return(0);
}


extern int CheckFileCache()
{
    ToLog(DBERROR, "\nCheckFileCache was called in unfsmntd!!!!!  BUG ERROR!!!!!\n");
    return(-1);
}

char LastUidStr[]="Vince.Cate";


int unfsmntd_init()
{
    init_Log();                /* this does InitReadOnlyVariables(); */
    fh_init();
}

void *mountproc_null_1(argp, rqstp)
void *argp;
struct svc_req *rqstp;
{
    static char res;

    bzero((char *) &res, sizeof(res));
    Logcall("mountproc_null_1", "", rqstp);
    return(&res);
}


fhstatus *mountproc_mnt_1(argp, rqstp)
dirpath *argp;
struct svc_req *rqstp;
{
    static fhstatus res;
    struct stat stbuf;
    extern int errno;
    u_long saddr;
    struct hostent *hp;

    saddr = rqstp->rq_xprt->xp_raddr.sin_addr.s_addr;

    bzero((char *) &res, sizeof(res));
    (void) sprintf(argbuf, "%s", *argp);
    Logcall("mountproc_mnt_1", argbuf, rqstp);

    if (strcmp(*argp, "/") != 0) {                 /* remote people think they mount "/" */
        (void) sprintf(argbuf, "%s", *argp);
        Logcall("mountproc_mnt_1 ERROR refused ", argbuf, rqstp);
        res.fhs_status = EACCES;

    } else if (stat(*argp, &stbuf) < 0) {  /* was AlexInfoCompatStat(*argp, &stbuf, NULL, "mount",0) */
        res.fhs_status = errno;

    } else if ((stbuf.st_mode & S_IFMT) != S_IFDIR) {
        res.fhs_status = ENOTDIR;

    } else {
        res.fhs_status = 0;
        res.fhs_status = fh_create(&(res.fhstatus_u.fhs_fhandle), (char *) *argp);
    }


    LogN("mountproc_mnt_1 returning status of ", (int) res.fhs_status);

    if (res.fhs_status == 0) {
        hp = gethostbyaddr((caddr_t)&saddr, sizeof(saddr), AF_INET);
        if (hp) {
            add_mlist(hp->h_name, "/", 1);
        } else {
            Log("mountproc_mnt_1  gethostbyaddr failed");
        }
    }

    (void) sprintf(argbuf, " status=%d ", (int) res.fhs_status);
    Logcall("mountproc_mnt_1", argbuf, rqstp);

    return (&res);
}


mountlist *mountproc_dump_1(argp, rqstp)
void *argp;
struct svc_req *rqstp;
{

    Logcall("mountproc_dump_1", "", rqstp);

    return (&mlhead);                          /* sure hope nobody thinks they should free this */
}


/* umount */
void *mountproc_umnt_1(argp, rqstp)
dirpath *argp;
struct svc_req *rqstp;
{
    static char res;
    u_long saddr;
    struct hostent *hp;

    (void) sprintf(argbuf, "%s", *argp);
    Logcall("mountproc_umnt_1", argbuf, rqstp);


    saddr = rqstp->rq_xprt->xp_raddr.sin_addr.s_addr;
    hp = gethostbyaddr((caddr_t)&saddr, sizeof(saddr), AF_INET);
    if (hp) {
        rm_mlist(hp->h_name, "/");
    }

    bzero((char *) &res, sizeof(res));
    return (&res);
}



void *mountproc_umntall_1(argp, rqstp)
void *argp;
struct svc_req *rqstp;
{
    static char res;
    u_long saddr;
    struct hostent *hp;

    Logcall("mountproc_umntall_1", "", rqstp);

    saddr = rqstp->rq_xprt->xp_raddr.sin_addr.s_addr;
    hp = gethostbyaddr((caddr_t)&saddr, sizeof(saddr), AF_INET);
    if (hp) {
         rm_mlist(hp->h_name, NULL);
    }

    bzero((char *) &res, sizeof(res));
    return(&res);
}


exportlist *mountproc_export_1(argp, rqstp)
void *argp;
struct svc_req *rqstp;
{
    static exportnode res;
    static exportlist pres = &res;

    bzero((char *) &res, sizeof(res));

    Logcall("mountproc_export_1", "", rqstp);

    res.ex_dir = "/";
    res.ex_groups = NULL;
    res.ex_next = NULL;
    return (&pres);      /* XXX pres? */
}


exportlist *mountproc_exportall_1(argp, rqstp)
void *argp;
struct svc_req *rqstp;
{
    Logcall("mountproc_exportall_1", "", rqstp);
    return (mountproc_export_1(argp, rqstp));
}


void rd_mlist()
{
    FILE *rmtab;
    char line[1024], *dirp, *endp;

    if ((rmtab = fopen(PATH_RMTAB, "r")) == NULL)
        return;

    while (fgets(line, sizeof(line), rmtab)){
        if ((dirp = index(line, ' ')) == NULL)
            continue;
        *dirp++ = '\0';
        while (*dirp == ' ')
            dirp++;
        if ((endp = index(dirp, '\n')) != NULL ||
                (endp = index(dirp, ' ')) != NULL)
            *endp = '\0';
        if (strlen(line) >= MNTNAMLEN || strlen(dirp) >= MNTPATHLEN)
            continue;
        add_mlist(line, dirp, 0);
    }

#if DEBUGLEVEL>5
    save_mlist(); 
#endif
}

/*  Thanks to Juergen Hannken for fixing up the mounlist code */

save_mlist()
{
    FILE *rmtab;
    mountlist mltmp;

    if ((rmtab = fopen(PATH_RMTAB, "w")) != NULL) {
        for (mltmp = mlhead; mltmp; mltmp = mltmp->ml_next) {
            fprintf(rmtab, "%s %s\n", mltmp->ml_hostname, mltmp->ml_directory);
        }
        fclose(rmtab);
    }
}

void add_mlist(hostp, dirp, update)
char *hostp, *dirp;
int update;
{
    mountlist *mlp = &mlhead;
    char lowerhostp[100];

    (void) strcpy(lowerhostp, hostp);
    ToLower(lowerhostp);

    while (*mlp) {
        if (streql((*mlp)->ml_hostname, lowerhostp) && streql((*mlp)->ml_directory, dirp)) {
            return;                              /* already in list so return */
        }
        mlp = &(*mlp)->ml_next;                  
    }

    if ((*mlp = (mountlist) malloc(sizeof(struct mountbody))) == NULL) {
        MallocDeath("add_mlist out of memory");
    }

    (*mlp)->ml_hostname = strsave(lowerhostp);
    (*mlp)->ml_directory = strsave(dirp);
    (*mlp)->ml_next = NULL;

    if (update) {
        save_mlist();
    }
}


void rm_mlist(hostp, dirp)
char *hostp, *dirp;
{
    mountlist *mlp = &mlhead, mltmp;
    char lowerhostp[MAXPATH];

    (void) strcpy(lowerhostp, hostp);
    ToLower(lowerhostp); 

    while (*mlp) {
        if (streql((*mlp)->ml_hostname, lowerhostp) &&
                ((dirp==NULL) || streql((*mlp)->ml_directory, dirp))) {
            mltmp = *mlp;
            *mlp = (*mlp)->ml_next;
            free(mltmp->ml_hostname);
            free(mltmp->ml_directory);
            free(mltmp);
        } else {
            mlp = &(*mlp)->ml_next;
        }
    }

    save_mlist();
}



