/*
** pdes.h - Pidentd DES encryption stuff
**
** Copyright (c) 1997 Peter Eriksson <pen@lysator.liu.se>
**
** This program is free software; you can redistribute it and/or
** modify it as you wish - as long as you don't claim that you wrote
** it.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
*/

#ifndef PIDENTD_PDES_H
#define PIDENTD_PDES_H

typedef unsigned short int_16;
typedef unsigned int   int_32;

struct info
{
    int_32 checksum;
    int_16 random;
    int_16 uid;
    int_32 date;
    int_32 ip_local;
    int_32 ip_remote;
    int_16 port_local;
    int_16 port_remote;
};

typedef union data
{
    struct info   fields;
    int_32        longs[6];
    unsigned char chars[24];
} data;


extern int pdes_init(char *keyfile);
extern int pdes_encrypt(struct kernel *kp, char buffer[33]);
extern int pdes_decrypt(void);
     
#endif

