#include <stdio.h>
#include <cdefs.h>
#include <sys/types.h>
#ifdef __STDC__
#include <stdlib.h>
#endif
#include "protos.h"


int	pstrcmp __P((char *, char *));

#define SRT_SIZE 16384

main()
{
	int	size = 0;
	int	iRead;
	char	*buffer = malloc(SRT_SIZE);
	char	*spot;
	int	nLines = 0;
	char   **ptrs, **this;


	/*
	 * pass 1; read the file
	 */
	if (!buffer)
		perror("malloc");

	while ((iRead = read(0, buffer + size, SRT_SIZE)) > 0)
	{
		size += iRead;
		buffer = realloc(buffer, size + SRT_SIZE);
		if (!buffer)
			perror("realloc");
	}

	buffer = realloc(buffer, size + 1);
	if (!buffer)
		perror("realloc");
	buffer[size] = '\n';

	/*
	 * count the lines, and replace newlines with nulls
	 */
	for (spot = buffer; spot <= buffer + size; spot++)
		if (*spot == '\n')
		{
			nLines++;
			if (!(nLines % 500))
				fprintf(stderr, "reading %d\r", nLines);
			*spot = '\0';
		}
	nLines--;
	putc('\n', stderr);

	/*
	 * build an array of pointers to the lines
	 */
	ptrs = (char **) malloc(nLines * sizeof (char *));

	if (!ptrs)
		perror("malloc");
	spot = buffer;
	for (this = ptrs; this < ptrs + nLines; this++)
	{
		*this = spot;
		while (*spot++) ;
	}

	/*
	 * sort them
	 */
	qsort(ptrs, nLines, sizeof (char *), pstrcmp);

	/*
	 * output them
	 */
	while (nLines--)
		puts(*ptrs++);
	exit(0);
}

int 
pstrcmp(p1, p2)
	char *p1, *p2;
{
	return (strcmp(*(char **) p1, *(char **) p2));
}
