;;; zenirc-finnish.el --- Finnish message catalog for ZenIRC

;; Copyright (C) 1995 Valtteri Vuorikoski

;; Author: Valtteri Vuorikoski <vuori@sci.fi>
;; Maintainer: friedman@prep.ai.mit.edu
;; Keywords: extensions
;; Created: 1995/05/23

;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.
;;
;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with this program; if not, you can either send email to this
;; program's maintainer or write to: The Free Software Foundation,
;; Inc.; 675 Massachusetts Avenue; Cambridge, MA 02139, USA.

;;; Commentary:

;; If you're using emacs 19, loading iso-ascii.el or doing
;; M-x standard-display-european on X displays makes 8-bit characters
;; easier to see.

;;; Code:

(require 'zenirc)

(zenirc-lang-define-catalog
 'finnish
 '((s001 . "[info] Hukkaat aikaasi.\n")
   (s002 . "[info] Irkkiserverisi on %s ajaen ircd-versiota %s\n")
   (s003 . "[info] Tm serveri luotiin %s\n")
   (s200 . "[info] %s (%s) Linkki -> %s\n") ; Version reply from /trace
   (s202 . "[info] %s H.S. -> %s\n")
   (s203 . "[info] %s Hmmm -> IP-osoite: %s\n") ; Unknown connection
   (s204 . "[info] %s Oper -> %s\n") ; Operator connection
   (s205 . "[info] %s Kyttj -> %s\n") ; User connection
   (s206 . "[info] %s Serveri -> %s %s %s %s \n") ; Server connection
   (s208 . "[info] %s %s -> %s\n") ; New type connection
   (s209 . "[info] %s Luokka -> %s = %s\n") ; What the classes means
   (s211 . "[info] %s linkki ylhll %s sek\nLhetetty: %s/%s, Vastaanotettu: %s/%s, SendQ: %s\n")
   (s212 . "[info] %s\t->\ttimes: %s\tbytes: %s\n") ; Command stats
   (s213 . "[info] C kone/nimi/port/luok: %s/%s/%s/%s\n")      ; C-lines
   (s214 . "[info] N kone/nimi/port/luok: %s/%s/%s/%s\n") ; N-lines
   (s215 . "[info] %s kone/nimi/luokka:\t%s/%s/%s\n") ; I-lines
   (s216 . "[info] K kone/kyttj:\t%s/%s\n") ; K-lines
   (s217 . "[info] Q %s/%s/%s/%s/%s\n") ; Q-lines
   (s218 . "[info] Luokka: %s Ping-taajuus: %s Connectaustaajuus: %s Max Linkkkej: %s SendQ: %s\n") ; Y-lines
   (s219 . "[info] /statsien loppu.\n")
   (s221 . "[info] User-moodisi on: %s\n")
   (s241 . "[info] LEAF-serverin hostmaski/syvyys:\t\t%s/%s\n") ; L-lines
   (s242 . "[info] %s\n") ; Uptime of server
   (s243 . "[info] %s nickki/kyttj@kone:\t%s/%s\n") ; O-lines
   (s244 . "[info] HUB  hostmaski/serveri:\t%s/%s\n") ; H-lines
   (s251 . "[info] %s/%s nkyv/nkymtnt kyttj %s:ll serverill.\n")
   (s252 . "[info] %s isoa moloa linjalla.\n")
   (s253 . "[info] %s tuntematonta yhteytt.\n")
   (s254 . "[info] %s kannua\n")
   (s255 . "[info] %s clientti and %s serveri yhteydess thn serveriin\n")
   (s256 . "[info] Administratiivinen informaatio %s:lle:\n") ; /admin line 1
   (s257 . "[info] %s\n") ; /admin line 2
   (s258 . "[info] %s\n") ; /admin line 3
   (s259 . "[info] %s\n") ; /admin line 4
   (s261 . "[info] %s Tiedosto -> %s %s\n") ; Logfile trace
   (s301 . "[info] %s on pois: %s\n")
   (s302 . "[info] userhost: %s\n") ; userhost reply
   (s303 . "[info] Tll hetkell aikaa hukkaamassa: %s\n") ; ison reply
   (s305 . "[info] Et ole en poissa\n")
   (s306 . "[info] Olet poissa\n")
   (s311 . "[info] %s (%s@%s) on %s\n") ; user part of /whois list
   (s312 . "[info] %s kytt serveri %s (%s)\n")
   (s313 . "[info] %s on Iso Molo.\n") ; /whois operator status
   (s314 . "[info] %s (%s@%s) oli %s\n") ; user part of /whowas list
   (s315 . "[info] /who:n loppu.\n")
   (s317 . "[info] %s on iDLaillut %s\n") ; /whois idle time
   (s318 . "[info] /whois:in loppu.\n")
   (s319 . "[info] %s on kannuilla: %s\n") ; channel part of whois data
   (s321 . "[info] Kannu            Populaa Otsikko\n") ; header for LIST cmd
   (s322 . "[info] %-15s %-5s %s\n")  ; each channel in LIST cmd
   (s323 . "[info] /listin loppu.\n")  ; trailer for LIST cmd
   (s324 . "[info] Moodi kannulle %s on %s %s\n") ; channel mode
   (s331 . "[info] %s:ll ei ole otsikkoa\n") ; no topic message
   (s332 . "[info] %s otsikko: %s\n")   ; topic message
   (s333 . "[info] %s:n asetti %s kello %s\n") ; topic set time
   (s341 . "[info] Kutsuit %s:n kanavalle %s\n") ; invite reply
   (s342 . "[info] Pyydt %s: hukkaamaan aikaansa\n") ; summon reply
   (s351 . "[info] Versio: %s %s %s\n") ; version reply
   (s352_header . "[info] Nickki  Stat Kanavan nimi Kyttj@kone (Hopseja  Nimi)\n") ; header for /who list reply
   (s352 . "[info] %-9s %-3s  %-15s %s@%s (%s)\n") ; /who list reply
   (s353 . "[info] Kyttji kannulla %s: %s\n") ; displayed after channel join
   (s364 . "[info] %s %s %s\n")       ; /links reply
   (s365 . "[info] /linksin loppu\n")  ; end of /links reply
   (s367 . "[info] %s banni %s\n")      ; banlist reply
   (s368 . "[info] Bannilistan loppu\n") ; end of banlist reply
   (s371 . "[info] %s\n")             ; info reply
   (s372 . "[motd] %s\n")		; message of the day
   (s375 . "[motd] Pivn viesti:\n") ; start of motd
   (s376 . "[motd] Pivn viestin loppu\n")    ; displayed at end of motd
   (s381 . "[info] Olet nyt Iso Molo\n") ; irc op status
   (s382 . "[info] Poltan hashista: %s\n")  ; rehash server msg
   (s391 . "[info] Aika serverilt %s: %s\n") ; TIME reply
   (s392 . "[info] Tili   Terminaali  Kone\n") ; header for users rpl
   (s393 . "[info] %s\n")             ; body of users rpl
   (s395 . "[info] Ei ketn kotona\n") ; nobody for users rpl
   (s401 . "[info] Ei moista nickki/kannua: %s\n") ; there is no such nick/chan
   (s402 . "[info] Ei moista serveri: %s\n") ; there is no such server
   (s403 . "[info] Ei moista kanavaa: %s\n") ; there is no such channel
   (s404 . "[info] Et voi lhett %s:lle.\n") ; you can't send to channel
   (s405 . "[info] Liian monta kanavaa: %s\n") ; too many channels
   (s406 . "[info] Serverill ei ole tietoa nickist: %s\n") ; no whowas data
   (s407 . "[info] Liian monta vastaanottajaa. Viesti ei lhetetty: %s\n") ; user@host
   (s409 . "[info] Alkuper ei mritelty.\n") ; ping error reply
   (s411 . "[info] Ei vastaanottajaa.\n") ; no recipient given
   (s412 . "[info] Ei mitn lhetettv.\n") ; you didn't send anything.
   (s413 . "[info] Ei toplevel-domainia: %s\n") ; no toplevel domain spec
   (s414 . "[info] Villikortti toplevel-domainissa: %s\n") ; wild toplevel
   (s421 . "[info] Tm nytt minusta purkitetulta lihalta: %s\n") ; you sent server spam
   (s422 . "[info] Ei motdia (liekit /adminissa mainittua Isoa Moloa)\n")
   (s423 . "[info] Ei admin-infoa. Vihjeetn Iso Molo ajaa serveri.\n")
   (s431 . "[info] Ei nickki annettu\n") ; you didn't provide a nick
   (s432 . "[info] Invalidi nickki: %s\n")
   (s433 . "[info] Nickki jo kytss: %s\n")
   (s436 . "[info] Nickkitrmysmurhatappo: %s\n")
   (s441 . "[info] %s ei ole kannulla %s\n") ; can't do it to those not present
   (s442 . "[info] Et ole kannulla %s.\n") ; you can't do that dave.
   (s443 . "[info] %s on jo kannulla %s.\n") ; invite error
   (s444 . "[info] %s ei ole loggautunut sisn\n") ; SUMMON reply
   (s445 . "[info] Iso Molo ei anna sinun summonoida\n")
   (s446 . "[info] Iso Molo ei anna sinun nhd /usereita\n")
   (s451 . "[info] Et ole rekisteritynyt\n") ; gotta do the USER NICK thing
   (s461 . "[info] Ei tarpeeksi parametrej: %s\n") ; as 421
   (s462 . "[info] Et voi rekisterity uudelleen\n") ; cannot USER twice
   (s463 . "[info] Fasistisika-Iso Molo ei anna sinun kytt tt serveri\n")
   (s464 . "[info] Vr salasana\n") ; bad PASS command
   (s465 . "[info] Sinulla ei ole lupaa kytt tt serveri.\n") ; creep
   (s467 . "[info] Avain kanavalle %s on jo asetettu\n") ; chan key set already
   (s471 . "[info] Et voi joinata %s:lle (luuserilimiitti saavutettu).\n") ; too many ppl
   (s472 . "[info] %s on tuntematon moodi.\n") ; duh
   (s473 . "[info] Et voi joinata %s:lle (hommaa invite).\n") ; fascist nerds
   (s474 . "[info] Et voi joinata %s:lle %s (bannattu).\n") ; you're banned
   (s475 . "[info] Et voi joinata %s:lle (vr avainsana).\n") ; bad key
   (s481 . "[info] Et ole tarpeeksi Iso Molo tehdksesi tuota.\n") ; oper only
   (s482 . "[info] Et ole voimansiirtokone %s:ll.\n") ; chanop needed
   (s483 . "[info] Et voi tappaa serveri. Doh!\n") ; can't kill a server
   (s491 . "[info] Isoja Moloja ei sallita sinun koneeltasi\n") ; no o-line
   (s501 . "[info] Tuntematon moodilippu\n") ; you did something silly
   (s502 . "[info] Et voi vaihtaa toisten kyttjien moodia\n") ; as above
   (action . "(lhetetty %s:lle)\n") ; ctcp action sent
   (action-echo . "(lhetetty %s:lle)") ; ctcp action sent
   (connect-failed . "[error] En voinut connectata %s:n porttiin %d, koska: %s\n")
   (connect-try . "[info] Connectailen %s:n porttiin %d...\n")
   (connect-abort . "[info] Konnektaus serveriin abortoitu.\n")
   (ctcp_action . "[action->%s] %s %s\n") ; ctcp ACTION display
   (ctcp_clientinfo . "[query] CLIENTINFO %s:lt %s:lle\n")
   (ctcp_errmsg . "[query] ERRMSG %s:lt %s:lle\n")
   (ctcp_finger . "[query] FINGER %s:lt %s:lle\n")
   (ctcp_ping . "[query] PING %s:lt %s:lle\n")
   (ctcp_ping_reply . "[reply] PING: %s on %s sekunnin matkan pss\n")
   (ctcp_source . "[query] SOURCE %s:lt %s:lle\n")
   (ctcp_time . "[query] TIME %s:lt %s:lle\n")
   (ctcp_userinfo . "[query] USERINFO %s:lt %s:lle\n")
   (ctcp_version . "[query] VERSION %s:lt %s:lle\n")
   (debug  . "[debug] %s\n")          ; displayed by debugging code
   (error . "[%s] %s\n")              ; server error message
   (invite . "[info] %s kutsuu sinut %s:lle.\n") ; invite
   (join_you . "[info] Joinaan kannulle: %s\n")
   (join . "[info] %s on joinannut %s:lle\n")
   (kick . "[info] %s on potkittu kanavalta %s %s:n toimesta\n") ; someone was peeved
   (kick_you . "[info] Sinut on potkittu %s:lt %s:n toimesta\n") ; loser
   (kill . "[info] Sinut on raukkamaisesti tapettu: %s") ; your time is up.
   (mode . "[info] %s on vaihtanut moodia %s:lle: %s\n") ; MODE change
   (nick . "[info] %s on vaihtanut nickki: %s\n") ; nick change
   (newcatalog . "[info] Viestikatalogi asetettu %s:ksi\n")
   (nocatalog . "[error] Ei viestikatalogia mritelty %s:lle\n")
   (nosend . "[info] Sinulla ei ole uhria jolle lhett\n") ; msg not sent
   (notice . "{%s%s} %s\n")           ; NOTICE
   (notice_you . "{%s} %s\n")         ; NOTICE sent to your nick
   (notify_list . "[info] Tmnhetkinen ajanhukkaajalistasi: %s\n")
   (notify_on . "[info] tunnistettu %s aikaa hukkaamassa.\n")
   (notify_off . "[info] tunnen, ett %s on lopettanut ajanhukkaamisen.\n")
   (now_querying . "[info] Tmnhetkinen uhrisi on %s.\n") ; /query foo
   (part_you . "[info] Hivyn: %s (%s)\n") ; your part from channel message
   (part . "[info] %s on hipynyt %s:lt (%s)\n") ; part from channel message
   (pong . "[info] %s sanoo ojnk.\n")  ; pong message from server
   (privmsg . "<%s%s> %s\n")          ; PRIVMSG
   (privmsg_you . "*%s* %s\n")        ; PRIVMSG sent to your nick
   (protocol_violation . "[error] Tm rivi ei ole IRC-protokollan mukainen.\n[error] Valita serverin administraattorille:\n%s: %s\n")
   (query . "[query] %s:lt %s:lle sislt %s\n") ; ctcp query
   (query_unknown . "on tuntematon CTCP-viesti")
   (query_unbalanced . "[eptasapainoinen ctcp] %s:lt %s:lle sislt %s\n")
   (query_unbalanced_reply . "on eptasapainoinen CTCP-viesti")
   (quit . "[info] %s lopetti ajanhukkaamisen: %s\n") ; user signoff
   (reply . "[reply] %s:lt %s:lle sislt %s\n") ; ctcp reply
   (reply_unbalanced . "[eptasapainoinen vastaus] %s:lt %s:lle sislt %s\n")
   (send . "(lhetetty %s:lle)\n") ; you sent a message/notice
   (send-echo . "(lhetetty %s:lle)") ; you sent a message/notice
   (sentinel . "\nZenIRC lopetettu aikaan %s\n") ; process sentinel message
   (server . "[server] %s\n")         ; unknown server message
   (signal . "[signaali %s]")        ; signal in echo area
   (topic . "[info] %s vaihtoi otsikon kanavalla %s: %s\n") ; topic message
   (wallops . "-%s- %s\n")            ; WALLOPS notice
   ))

(provide 'zenirc-finnish)

;;; zenirc-finnish.el ends here