;;; zenirc-swedish.el --- Swedish message catalog for ZenIRC

;; Copyright (C) 1993, 1994 Ben A. Mesander
;; Copyright (C) 1993, 1994, 1995, 1996 Per Persson

;; Author: Per Persson <pp@gnu.ai.mit.edu>
;;         Ben A. Mesander <ben@gnu.ai.mit.edu>
;;         Noah Friedman <friedman@prep.ai.mit.edu>
;; Maintainer: pp@gnu.ai.mit.edu
;; Keywords: extensions
;; Created: 1993/06/03

;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.
;;
;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with this program; if not, you can either send email to this
;; program's maintainer or write to: The Free Software Foundation,
;; Inc.; 675 Massachusetts Avenue; Cambridge, MA 02139, USA.

;;; Commentary:

;; "it's like operating a nazi sub or something."
;;    --Ben A. Mesander <ben@gnu.ai.mit.edu>

;; If you're using emacs 19, loading iso-ascii.el or doing
;; M-x standard-display-european on X displays makes 8-bit characters
;; easier to see.

;;; Code:

(require 'zenirc)

(zenirc-lang-define-catalog
 'swedish
 '((join_you . "[info] Du deltar nu i mtet: %s\n")
   (join . "[info] %s deltar nu i mtet %s\n")
   (s001 . "[info] Du kastar bort tid.\n") ; welcome to irc message
   ;; server name & version # msg
   (s002 . "[info] Din IRK server r %s och kr IRKD version %s\n")
   ;; when the server was built
   (s003 . "[info] Den hr IRK servern skapades %s\n")
   ;; # users on connect message
   (s251 . "[info] Det finns %s synliga och %s osynliga klienter p %s serverar.\n")
   (s200 . "[info] %s Lnk -> version: %s\n") ; Version reply from /trace
   (s202 . "[info] %s H.S. -> %s\n")    ; Trace handshake
   (s203 . "[info] %s Hmmm -> IP address: %s\n") ; Unknown connection
   (s204 . "[info] %s Oper -> %s\n")    ; Operator connection
   (s205 . "[info] %s Klie -> %s\n")    ; User connection
   (s206 . "[info] %s Serv -> %s %s %s %s \n") ; Server connection
   (s208 . "[info] %s %s -> %s\n")      ; New type connection
   (s209 . "Klas -> %s = %s\n")         ; What the classes means
   ;; Linkinfo
   (s211 . "[info] %s lnk har varit uppe %s sekunder\nSnt %s/%s, Mottagit %s/%s, SndK: %s\n")
   (s212 . "[info] %s\t->\tgnger: %s\tbytes: %s\n") ; Command stats
   (s213 . "[info] C msk/nam/prt/kls: %s/%s/%s/%s\n") ; C-lines
   (s214 . "[info] N msk/nam/prt/kls: %s/%s/%s/%s\n") ; N-lines
   (s215 . "[info] %s maskin/namn:\t%s/%s\n") ; I-lines
   (s216 . "[info] K maskin/anvndarnamn:\t%s/%s\n") ; K-lines
   (s217 . "[info] Q %s/%s/%s/%s/%s\n") ; Q-lines
   ;; Y-lines
   (s218 . "[info] Klass: %s Ping frek: %s Lnk frek: %s Max lnkar: %s SndK: %s\n")
   (s219 . "[info] Slut p /stats.\n") ; End of /stats I guess
   (s221 . "[info] Din nuvarande status r: %s\n") ; user mode
   (s241 . "[info] LV  maskinmask/djup:\t\t%s/%s\n") ; L-lines
   (s242 . "[info] %s\n")               ; Uptime of server
   (s243 . "[info] %s smeknamn/anvndare@maskin:\t%s/%s\n") ; O- or o-lines
   (s244 . "[info] GREN maskinmask/servernamn:\t%s/%s\n") ; H-lines
   ;; # users on connect message
   (s251 . "[info] Det finns %s synliga och %s osynliga klienter p %s serverar.\n")
   (s252 . "[info] Det finns %s verkliga nollor aktiva.\n") ; irc operators msg
   (s253 . "[info] Det finns %s oknda uppkopplingar.\n") ; unk connects msg
   (s254 . "[info] Det finns %s mten.\n") ; number of channels
   ;; # of clients and servers
   (s255 . "[info] Det finns %s klienter och %s servrar uppkopplade till den hr servern.\n")
   (s256 . "[info] Administrativ information fr %s:\n") ; /admin line 1
   (s257 . "[info] %s\n")               ; line 2 of admin information
   (s258 . "[info] %s\n")               ; line 3 of admin information
   (s259 . "[info] %s\n")               ; line 4 of admin information
   (s261 . "[info] %s Fil -> %s %s\n")  ; Logfile trace
   (s301 . "[info] %s r borta: %s\n") ; someone is away
   (s302 . "[info] anvndaraddress: %s\n") ; userhost reply
   (s303 . "[info] ` %s' slsar fr nrvarande tid.\n")
   (s305 . "[info] Du r nu tillbaka.\n")
   (s306 . "[info] Du r borta.\n")
   (s311 . "[info] %s (%s@%s) r %s\n") ; user part of /whois list
   ;; server part of /whois list
   (s312 . "[info] %s anvnder servern %s (%s)\n")
   (s313 . "[info] %s r en verklig nolla.\n") ; /whois operator status
   (s314 . "[info] %s (%s@%s) var %s\n") ; user part of /whowas list
   (s315 . "[info] Slut p /who\n")  ; end of /who list replies
   (s318 . "[info] Slut p /whois\n") ; end of /whois list replies
   (s317 . "[info] %s har varit inaktiv %d\n") ; /whois idle time
   (s319 . "[info] %s r p: %s\n") ; channel part of whois data
   (s321 . "[info] Mte\tAnvndare\tRubrik\n") ; header for LIST cmd
   (s322 . "[info] %s\t%s\t%s\n")       ; each channel in LIST cmd
   (s323 . "[info] Slut p /list\n") ; trailer for LIST cmd
   (s324 . "[info] Status fr %s r %s %s\n") ; channel mode
   (s331 . "[info] %s har ingen rubrik.\n") ; no topic message
   (s332 . "[info] %s rubrik: %s\n")    ; topic message
   (s341 . "[info] Du inbjuder %s till %s\n") ; invite reply
   (s342 . "[info] Du ber %s att kasta bort tid.\n") ; summon reply
   (s351 . "[info] Version: %s %s %s\n") ; version reply
   ;; header for /who list reply
   (s352_header . "[info] Smeknamn  Stat Namn av Mte  Anvndare@adress        Namn\n")
   (s352 . "[info] %-9s %-3s  %-15s %s@%s (%s)\n") ; /who list reply
   (s353 . "[info] Klienter p %s: %s\n") ; displayed after channel join
   (s364 . "[info] %s %s %s\n")         ; /links reply
   (s365 . "[info] slut p /links\n") ; end of /links reply
   (s367 . "[info] %s portningar %s\n") ; banlist reply
   (s368 . "[info] slut p portningslistan.\n") ; end of banlist reply
   (s371 . "[info] %s\n")               ; info reply
   (s372 . "[motd] %s\n")		; message of the day
   (s375 . "[motd] Dagens meddelande:\n") ; start of motd
   (s376 . "[motd] Slut p dm.\n")   ; displayed at end of motd
   (s381 . "[info] Du r nu en verklig nolla.\n") ; irc op status
   (s382 . "[info] ter brdgrdar: %s\n") ; rehash server msg
   (s391 . "[info] Lokal tid p servern %s r: %s\n") ; TIME reply
   (s392 . "[info] Anvndar# Terminal  Address\n") ; header for users rpl
   (s393 . "[info] %s\n")               ; body of users rpl
   (s395 . "[info] Ingen r ploggad.\n") ; nobody for users rpl
   ;; there is no such nick/chan
   (s401 . "[info] Det finns inget sdant smeknamn/mte: %s\n")
   (s402 . "[info] Ingen server med det namnet: %s\n") ; no such server

   (s403 . "[info] Inget mte med det namnet: %s\n") ; no such channel
   (s404 . "[info] Du kan inte snda till %s\n") ; can't send to channel
   (s405 . "[info] Du deltar redan i tio mten: %s\n") ; too many channels
   ;; no whowas data
   (s406 . "[info] Ngot sdant smeknamn finns inte i serverns databas: %s\n")
   ;; user@host
   (s407 . "[info] Dubbla mottagare. Inget meddelande snt: %s\n")
   (s409 . "[info] Ingen sndare given.\n") ; ping error reply
   (s411 . "[info] Ingen mottagare given.\n") ; no recipient given
   (s412 . "[info] Ingen text att snda.\n") ; you didn't send anything.
   (s413 . "[info] Ingen toppniv domain: %s\n") ; no toplevel domain spec
   (s414 . "[info] Jokertecken i toppniv domain: %s\n")
   (s421 . "[info] Det hr ser ut som nonsens fr mig: %s\n")
   (s422 . "[info] Ngon verklig nolla har inte tillrckligt hg IQ fr att ha en dm fil.\n")
   (s423 . "[info] Ngon verklig nolla p %s r ignorant nog att inte lgga upp administrations info.\n")
   (s431 . "[info] Inget smeknamn givet.\n") ; you didn't provide a nick
   (s432 . "[info] Ogiltigt smeknamn: %s\n") ; invalid nick
   (s433 . "[info] Smeknamnet %s anvnds redan.\n") ; invalid nick
   (s436 . "[info] Smeknamns kollision: %s\n") ; nickicide
   ;; can't do it to those not present
   (s441 . "[info] %s r deltar inte i %s\n")
   (s442 . "[info] Du r deltar inte i %s\n") ; you can't do that dave.
   (s443 . "[info] %s deltar redan i mtet %s\n") ; invite error
   (s444 . "[info] %s r inte ploggad.\n") ; SUMMON reply
   (s445 . "[info] Ngon verklig nolla lter dig inte anvnda /summon\n")
   (s446 . "[info] Ngon verklig nolla lter dig inte anvnda /users\n")
   (s451 . "[info] Du har inte registrerat dig.\n")
   (s461 . "[info] Inte nog med parametrar: %s\n") ; as 421
   (s462 . "[info] Du fr inte registrera dig flera gnger.\n")
   (s463 . "[info] Ngon fascistisk nolla lter dig inte koppla upp dig.\n")
   (s464 . "[info] Passordet r inkorrekt.\n") ; bad PASS command
   (s465 . "[info] Du r inte omtyckt p den hr server, byt genast ditt krk.\n")
   ;; chan key set already
   (s467 . "[info] Nyckeln r redan satt fr %s\n")
   ;; too many ppl
   (s471 . "[info] Du kan inte delta i %s (anvndar antalet verskridit).\n")
   (s472 . "[info] %s r en oknd status flagga.\n") ; duh
   (s473 . "[info] Du kan inte delta i %s (mste vara inbjuden).\n")
   (s474 . "[info] Du kan inte delta i %s (portad).\n") ; you're banned
   (s475 . "[info] Du kan inte delta i %s (fel kanal nyckel).\n") ; bad key
   (s481 . "[info] Du r inte en verklig nolla.\n") ; oper only
   (s482 . "[info] Du r inte nog mktig att %s\n") ; chanop needed
   ;; can't kill a server
   (s483 . "[info] Bl, du kan inte dda en server.\n")
   ;; no o-line
   (s491 . "[info] Inga verkliga nollor tilltna frn din address.\n")
   (s501 . "[info] Oknd klient status flagga.\n")
   (s502 . "[info] Kan inte ndra status fr andra klienter.\n")
   (action . "(skickat till %s=\n")
   (action-echo . "(skickat till %s)")
   (ctcp_action . "[action->%s] %s %s\n")
   (ctcp_clientinfo . "[frga] CLIENTINFO frn %s till %s\n")
   (ctcp_errmsg . "[frga] ERRMSG frn %s till %s\n")
   (ctcp_finger . "[frga] FINGER frn %s till %s\n")
   (ctcp_ping . "[frga] PING frn %s till %s\n")
   (ctcp_source . "[frga] SOURCE frn %s till %s\n")
   (ctcp_time . "[frga] TIME frn %s till %s\n")
   (ctcp_userinfo . "[frga] USERINFO frn %s till %s\n")
   (ctcp_version . "[frga] VERSION frn %s till %s\n")
   (debug . "[debug] %s\n")             ; displayed by debugging code
   (error . "[%s] %s\n")                ; server error message
   (invite . "[info] %s tycker att du borde komma till %s\n") ; invite
   (kick . "[info] %s har blivit sparkad frn %s av %s\n")
   (kick_you . "[info] Du har blivit sparkad frn %s av %s\n")
   (kill . "[info] Du har blivit mrdad: %s") ; your time is up.
   (mode . "[info] %s har ndrat statusen fr %s: %s\n") ; MODE change
   (nick . "[info] %s har bytt smeknamn till %s\n") ; nick change
   (nosend . "[info] du har inget nuvarande offer att snda till.\n")
   (notice . "{%s%s} %s\n")             ; NOTICE
   (notice_you . "{%s} %s\n")           ; NOTICE sent to your nick
   (notify_list . "[info] Din nuvarande radar lista: %s\n")
   (notify_on . "[info] Aha! %s slsar viktig tid.\n")
   (notify_off . "[info] Aha! %s slutade slsa viktig tid.\n")
   (now-querying . "[info] Nuvarande offer r %s\n") ; /query foo
   (part_you . "[info] Lmnar: %s (%s)\n") ; your part from channel message
   (part . "[info] %s har lmnat %s (%s)\n") ; part from channel message
   (pong . "[info] %s sger ojnk.\n")
   (privmsg . "<%s%s> %s\n")            ; PRIVMSG
   (privmsg_you . "*%s* %s\n")          ; PRIVMSG sent to your nick
   (query . "[frga] frn %s till %s innehllande %s\n") ; ctcp query
   (query_unknown . "r en oknd CTCP frga.")
   (query_unbalanced . "[OBALANCERAD frga] frn %s till %s innehllande %s\n")
   (query_unbalanced_reply . "r en obalancerad CTCP frga.")
   (quit . "[info] %s slutade slsa viktig tid: %s\n") ; user signoff
   (reply . "[svar] frn %s till %s innehllande %s\n") ; ctcp reply
   (reply_unbalanced . "[OBALANCERAT svar] frn %s till %s innehllande %s\n")
   (send . "(skickat till %s)\n")       ; you sent a message/notice
   (send-echo . "(skickat till %s)")       ; you sent a message/notice
   (server . "[server] %s\n")           ; unknown server message
   (signal . "[signal i %s]")           ; signal in echo area
   (topic . "[info] %s bytte rubriken fr %s till: %s\n") ; topic message
   (wallops . "-%s- %s\n")              ; WALLOPS notice
   ))

(provide 'zenirc-swedish)

;;; zenirc-swedish.el ends here
