;;;
;;;
;;; zenirc-format-nickuserhost.el --- format nick!user@host strings for 
;;;                                   zenirc.el

;;; Copyright (C) 1993, 1994 Ben A. Mesander

;;; Author: Ben A. Mesander <ben@gnu.ai.mit.edu>
;;;         Charles Hannum <mycroft@gnu.ai.mit.edu>
;;; Maintainer: ben@gnu.ai.mit.edu
;;; Keywords: extensions
;;; Created: 1993/06/03

;;; $Id: zenirc-format-nickuserhost.el,v 1.5 1994/04/27 17:47:31 ben Exp $

;;; This program is free software; you can redistribute it and/or modify
;;; it under the terms of the GNU General Public License as published by
;;; the Free Software Foundation; either version 2, or (at your option)
;;; any later version.
;;;
;;; This program is distributed in the hope that it will be useful,
;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;; GNU General Public License for more details.
;;;
;;; You should have received a copy of the GNU General Public License
;;; along with this program; if not, you can either send email to this
;;; program's maintainer or write to: The Free Software Foundation,
;;; Inc.; 675 Massachusetts Avenue; Cambridge, MA 02139, USA.

;;; Commentary:

;;; Despite the irc protocol spec, sometimes you get a string that is just
;;; a hostname. To try to detect this, this routine just returns the hostname
;;; if all it finds is a nick with no user and host information that contains 
;;; a "." (which is not a legal character in a nickname). This will lose if a 
;;; user chooses the same nickname as a server in the local domain that isn't 
;;; using the FQDN. In this case, there is no way to tell if the message came 
;;; from the user or the server.
;;;

;;; Code:

;;
;; set this to just "%s" for ircII-style display
;;
(defvar zenirc-user-format "%s!%s@%s"
  "*Format for nick, user, host data")

;;
;; override the default in the client
;;
(zenirc-add-hook 'zenirc-format-nickuserhost-hook
		 'zenirc-format-nickuserhost-fun)

(defun zenirc-format-nickuserhost-fun (nickuserhost)
  (let (nick user host match1 match2)
    (setq zenirc-run-next-hook nil)
    (setq nick (substring nickuserhost 0 (string-match "[!@]" nickuserhost)))
    (setq match1 (match-end 0))
    (if (string-match "!" nickuserhost)
	(progn
	  (setq user (substring nickuserhost match1 
				(string-match "@" nickuserhost match1)))
	  (setq match2 (match-end 0)))
      (setq user "")
      (setq match2 match1))
    (if (string-match "@" nickuserhost)
	(setq host (substring nickuserhost match2 (length nickuserhost)))
      (setq host ""))
    (if (and (string= user "") (string= host "") 
	     (string-match "\\." nick))
	;; "nick" is really a hostname if it has a . in it. This is a
	;; violation of the RFC spec for irc protocol, but servers do it
	;; anyway.
	(format "%s" nick)
      (format zenirc-user-format nick user host))))
