/*
 * mail.c: Ok, so I gave in.  I added mail checking.  So sue me. 
 *
 * Written By Michael Sandrof
 *
 * Copyright(c) 1990 
 *
 * See the COPYRIGHT file, or do a HELP IRCII COPYRIGHT 
 */
#define MAIL_TWO

#include <sys/types.h>
#if defined(XD88) || defined(SVR4)
# define R_DIRENT 1
# include <dirent.h>
# include <fcntl.h>
#endif /* defined(XD88) || defined(SVR4) */
#ifdef ESIX
# include <lan/net_types.h>
# include <dirent.h>
# include <fcntl.h>
# define direct dirent
#endif /* ESIX */
#include <sys/file.h>
#ifndef ESIX
#  ifndef R_DIRENT
#    include <sys/dir.h>
#  endif
#endif /* ESIX */
#if (defined(POSIX) || defined (UNICOS)) && !defined(_IBMR2)
# include <sys/fcntl.h>
#endif /* POSIX */
#include <sys/stat.h>
#include "lastlog.h"
#include "irc.h"
#include "mail.h"
#include "hook.h"
#include "vars.h"
#include "ircaux.h"
#include "output.h"

static	char	*mail_path = null(char *);

/* init_mail: this initialized the path to the users mailbox */
static	void init_mail()
{
	char	*tmp_mail_path;

	if (mail_path)
		return; /* why do it 2000 times?  -lynx */

#ifdef UNIX_MAIL
	if (tmp_mail_path=getenv("MAIL"))  /* If env.var MAIL is defined */
		strmcpy(buffer, tmp_mail_path, BIG_BUFFER_SIZE);
				/*then use it - Goodi */
	else
	{
		strmcpy(buffer, UNIX_MAIL, BIG_BUFFER_SIZE);
		strmcat(buffer, "/", BIG_BUFFER_SIZE);
		strmcat(buffer, username, BIG_BUFFER_SIZE);
	}
	malloc_strcpy(&mail_path, buffer);
#else
# ifdef AMS_MAIL
	strmcpy(buffer, my_path, BIG_BUFFER_SIZE);
	strmcat(buffer, "/", BIG_BUFFER_SIZE);
	strmcat(buffer, AMS_MAIL, BIG_BUFFER_SIZE);
	malloc_strcpy(&mail_path, buffer);
# endif /* AMS_MAIL */
#endif /* UNIX_MAIL */
}

#ifdef AMS_MAIL
/*
 * count_files: counts all the visible files in the specified directory and
 * returns that number as the function value 
 */
static	unsigned int	count_files(dir_name, lasttime)
char	*dir_name;
Long	lasttime;
{
	DIR	*dir;
	struct	direct	*dirbuf;
	unsigned int	cnt;
	int	fd;
	char	LetterName[BIG_BUFFER_SIZE+1];
	struct	stat	LetterInfo;
	static	int	VirginProgram = 1;
	int	lastlog_level;

	if ((dir = opendir(dir_name)) == null(DIR *))
		return (0);
	cnt = 0;
	lastlog_level = set_lastlog_msg_level(LOG_CRAP);
	while ((dirbuf = readdir(dir)) != null(struct direct *))
	{
		if (*(dirbuf->d_name) != '.')
		{
			cnt++;
			sprintf(LetterName, "%s/%s", dir_name, dirbuf->d_name);
			stat_file(LetterName, &LetterInfo);
			if (get_int_var(MAIL_VAR) == 2 &&
				LetterInfo.st_ctime>lasttime && !VirginProgram)
			{
				if ((fd = open(LetterName, O_RDONLY)) == -1)
				    say("Unable to check headers on new mail");
				else
				{
					while (dgets(LetterName,
						BIG_BUFFER_SIZE, fd) > 0 &&
						*LetterName != '\n' &&
						*LetterName != '\0')

					{
						LetterName[strlen(LetterName) -
							- 1] = '\0';
						if (!strncmp(LetterName,
						    "From", 4) ||
						    !strncmp(LetterName,
						    "Subject:", 8))
							say("%s", LetterName);
					}
					new_close(fd);
				}
			}
		}
	}
	VirginProgram = 0;
	closedir(dir);
	set_lastlog_msg_level(lastlog_level);
	return (cnt);
}
#endif /* AMS_MAIL */

/*
 * check_mail_status: returns 0 if mail status has not changed, 1 if mail
 * status has changed 
 */
int	check_mail_status()
{

#if defined(AMS_MAIL) || defined(UNIX_MAIL)
	struct	stat	stat_buf;
	static	time_t	old_stat = 0L;

#ifndef TELNET_CLIENT
	if (!get_int_var(MAIL_VAR))
	{
		old_stat = 0L;
		return (0);
	}
	init_mail();
	if (stat_file(mail_path, &stat_buf) == -1)
		return (0);
	if (stat_buf.st_ctime > old_stat)
	{
		old_stat = stat_buf.st_ctime;
		return (1);
	}
#endif /* TELNET_CLIENT */
#endif /* defined(AMS_MAIL) || defined(UNIX_MAIL) */
	return (0);
}

/*
 * check_mail: This here thing counts up the number of pieces of mail and
 * returns it as static string.  If there are no mail messages, null is
 * returned. 
 */
char	*check_mail()
{

#if !defined(AMS_MAIL) && !defined(UNIX_MAIL)
	return	null(char *);
#else
	static	unsigned int	cnt = 0;
	static	time_t	old_stat = 0L;
	static	char	ret_str[8];
	struct	stat	stat_buf;
	unsigned int	new_cnt = 0;
	char	tmp[8];
	static	int	VirginProgram = 1;  /* It's its first time */
	int	lastlog_level;

#ifdef UNIX_MAIL
	int	des;
#endif /* UNIX_MAIL */

#ifdef TELNET_CLIENT
	return (null(char *));
#else
	init_mail();
#ifdef UNIX_MAIL
	if (stat_file(mail_path, &stat_buf) == -1)
		return (null(char *));
	lastlog_level = set_lastlog_msg_level(LOG_CRAP);
	if (stat_buf.st_ctime > old_stat)
	{
		old_stat = stat_buf.st_ctime;
		if ((des = open(mail_path, O_RDONLY, 0)) >= 0)
		{
			new_cnt = 0;
			while (dgets(buffer, BIG_BUFFER_SIZE, des) > 0)
			{
				if (!strncmp(MAIL_DELIMITER, buffer,
					sizeof(MAIL_DELIMITER) - 1))
				{
					new_cnt++;
# ifdef MAIL_TWO
					if (new_cnt>cnt && !VirginProgram &&
					    get_int_var(MAIL_VAR)==2)

					{
						/*buffer[strlen(buffer)-1]='\0';
						say("%s", buffer); */
						while (dgets(buffer,
							BIG_BUFFER_SIZE, des) >
							0 && *buffer != '\0' &&
							*buffer != '\n')

						{
							buffer[strlen(buffer)-1]
								= '\0';
							if (!strncmp(buffer,
							    "From:", 5) ||
							    !strncmp(buffer,
							    "Subject:", 8))
								say("%s",
								    buffer);
						}
					}
# endif
				}
			}
			VirginProgram=0;
			new_close(des);
		}
#else
# ifdef AMS_MAIL
		if (stat_file(mail_path, &stat_buf) == -1)
		{
			set_lastlog_msg_level(lastlog_level);
			return (null(char *));
		}
		if (stat_buf.st_ctime > old_stat)
		{
			new_cnt = count_files(mail_path, old_stat);
			old_stat = stat_buf.st_ctime;
		}
# endif /* AMS_MAIL */
#endif /* UNIX_MAIL */
		/* yeeeeack */
		sprintf(tmp, "%d", new_cnt - cnt);
		sprintf(buffer, "%d", new_cnt);
		if (new_cnt > cnt)
		{
			if (do_hook(MAIL_LIST, "%s %s", tmp, buffer) &&
			    get_int_var(MAIL_VAR)==1)
				echo(null(char *), "*** You have new email.");
		}
		cnt = new_cnt;
	}
	set_lastlog_msg_level(lastlog_level);
	if (cnt && (cnt < 65536))
	{
		sprintf(ret_str, "%d", cnt);
		return (ret_str);
	}
	else
		return (null(char *));
#endif /* TELNET_CLIENT */
#endif /* !defined(AMS_MAIL) && !defined(UNIX_MAIL) */
}
