;;;
;;; $Id: irchat-vars.el,v 1.6 1994/07/28 07:43:50 tmo Exp $
;;;
;;; see file irchat-copyright.el for change log and copyright info

(provide 'irchat-vars)

;;;
;;; user modifiable variables
;;;

(defvar irchat-command-window-height 5
  "*How large should Command window be on startup.")

(defvar irchat-use-full-window t
  "*If non-nil, IRCHAT will use whole emacs window. Annoying for GNUS-
users, therefore added by nam.")

(defvar irchat-want-traditional nil
  "*Do we want Irchat to feel like IrcII.")

(defvar irchat-one-buffer-mode nil
  "*When non-nil, irchat will put up only a dialogue-buffer (on the
screen). Useful for those (perverts) who use 24 line terminals.")

(defvar irchat-variables-file "~/.irchat_vars.el"
  "*Where to look for variables. Helps to remove clutter from your .emacs.
This feature is most likely to dissappear in near future. The preferred 
way is to put irchat variables on .emacs or file loaded from there.")
 
;;;
;;;  Where to connect
;;;
(defvar irchat-server (or (getenv "IRCSERVER") "irc.eunet.fi")
  "*Name of the host running the IRC server. 
Value initialized from the IRCSERVER environment variable if one is set")

(defvar irchat-service 
  (let ((ircport-env (getenv "IRCPORT")))
    (if ircport-env
	(if (> (string-to-int ircport-env) 0)
	    (string-to-int ircport-env)
	  ircport-env)
      6667))
  "*IRC service name or (port) number.")

(defvar irchat-nickname (or (getenv "IRCNICK") (user-real-login-name))
  "*The nickname you want to use in IRC.
Default is the environment variable IRCNICK, or your login name.")

(defvar irchat-startup-channel nil
  "*The channel to join automatically at startup.
If nil, do not join any channel.")

(defvar irchat-reconnect-automagic nil
  "*Automatic reconnection, default is disabled")

(defvar irchat-ask-for-nickname t
  "*Ask for nickname if irchat was entered with \\[universal-argument].")

(defvar irchat-grow-tail "_"
  "*Add irchat-grow-tail to nick when reconnecting. Otherwise you might get
killed again if automagic reconnect is too fast.")

;;;
;;;  Hooks, each message type has its own hook. These are used to setup
;;;  variables, buffers &c
;;;
(defvar irchat-Command-mode-hook nil
  "*A hook for IRCHAT Command mode.")

(defvar irchat-Dialogue-mode-hook nil
  "*A hook for IRCHAT Dialogue mode.")

(defvar irchat-Exit-hook nil
  "*A hook executed when signing off IRC.")

;;;
;;;  DCC
;;;
(defvar irchat-dcc-program "dcc"
  "*Name of the external dcc-program.")

(defvar irchat-dcc-directory "~/tmp" 
  "*Directory where irchat-dcc puts its files.")

(defvar irchat-dcc-port 1200 
  "*Default port for DCC operations.")

;;;
;;;  Format strings for various messages
;;;
(defvar irchat-myformat-string ">"
  "*Format for own messages.")

(defvar irchat-format-string ">%s<"
  "*Format string for private messages being sent.")

(defvar irchat-format-string1 "=%s="
  "*Format string for arriving private messages.")

(defvar irchat-format-string2 "<%s>"
  "*Format string for arriving messages to current channel.")

(defvar irchat-format-string3 "<%s:%s>"
  "*Format string for arriving messages to current channel from outside the channel.")

(defvar irchat-format-string4 "(%s)"
  "*Format string for arriving messages to other channel from outside the channel.")

(defvar irchat-format-string5 "(%s:%s)"
  "*Format string for arriving messages to other channel from outside the channel.")

(defvar irchat-change-prefix ""
  "*String to add before any change msg, used for customisation of
IRCHAT to suit old users of the irc-loser-client.")

(defvar irchat-notice-prefix "*** Notice: "
  "*String to add before any notice message.")

(defvar irchat-broadcast-prefix "*** Broadcast: "
  "*String to add before any Broadcast message")

(defvar irchat-wallops-prefix "*** Notice: "
  "*String to add before any WALLOPS message")

;;;
;;;  Buffers
;;;
(defvar irchat-Command-buffer "*IRC Commands*"
  "*Name of Command input buffer")
(defvar irchat-Dialogue-buffer "*IRC Dialogue*"
  "*Name of Dialogue output buffer")
(defvar irchat-KILLS-buffer "*IRC KILLS*")
(defvar irchat-IGNORED-buffer "*IRC IGNORED*")
(defvar irchat-WALLOPS-buffer "*IRC WALLOPS*")

;;;
;;;  Misc
;;;

(defvar irchat-blink-parens t
  "*Should we blink matching parenthesis in irchat command buffer?")

(defvar irchat-show-wallops t
  "*Show wallops messages if usermode +ws")

(defvar irchat-ignore-extra-notices t
  "*Don't show NOTICEs with \"as being away\" unless they come from
the local server.")

(defvar irchat-shorten-kills t
  "*Shorten KILL messages to about one line.")

(defvar irchat-ignore-changes nil
  "*Ignore changes? Good in topic-wars/link troubles.")

(defvar irchat-ignore-fakes nil
  "*If non nil, ignore fake notices if receiving them.")

(defvar irchat-signoff-msg ""
  "*Default signoff message")

(defvar irchat-beep-on-bells nil
  "*If non-nil, and the IRC Dialogue buffer is not selected in a window,
an IRC message arriving containing a bell character, will cause you
to be notified.
If value is 'always, an arriving bell will always cause a beep (or flash).")

(defvar irchat-system-fqdname (system-name)
  "*The fully qualified domain name of the system.
Default is what (system-name) returns.")

;;;
;;;  Send/Receive files
;;;
(defvar irchat-file-accept nil
  "*Do we accept files.")

(defvar irchat-file-confirm-save nil
  "*Do we want confirmation on saving files.")

;;;
;;;  Userinfos
;;;
(defvar irchat-client-userinfo "No user information given."
  "*Userinfo message given to anyone asking.")

(defvar irchat-pollnames-interval (* 60 10)
  "*Interval the names are polled from server")

(defvar irchat-timestamp-interval (* 60 10)
  "*Interval in seconds between timestamps in dialogue-buffer, nil for none.")

(defvar irchat-timestamp-format "*** Time: %s"
  "*Format-string for timestamp.")

;;;
;;;  Conversions: Not used.
;;;
(defvar irchat-send-convert-list nil 
  "*Convert characters before sending to server." )

(defvar irchat-receive-convert-list nil
  "*Convert characters after receiving from server." )

;;;
;;;  Ignores
;;;
(defvar irchat-kill-nickname nil
  "*A list of nicknames, as symbols, to ignore.  Messages from these people
won't be displayed.")

(defvar irchat-kill-realname nil
  "*A list of real names of people to ignore. Messages from them
won't be displayed.")

(defvar irchat-kill-logon nil
  "*A list of logon names (user@host.dom.ain). Messages from them
won't be displayed.")

;;;
;;; eof
;;;
