/* help.c -- Provide some rudimentary help within the application.
 *
 * Copyright (C) 1992, Bradley C. Spatz, bcs@ufl.edu
 * Last edited: Wed Oct 7 20:58:41 1992 by bcs (Bradley C. Spatz) on wasp
 */

#include <stdio.h>
#include <string.h>
#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/Cardinals.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/Sme.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>

#include "global.h"
#include "replies.h"

static String *topic_list=NULL;


#define MAX_TOPICS 30
static char *topics[MAX_TOPICS];

static String *get_help_list()
{
   int code, stanza, num_topics;
   char *topic;

   if (topic_list != NULL) {
      for (code=0; topic_list[code] != NULL; code++) {
	 free(topic_list[code]);
      }
   }

   /* Determine the topics available for xph. */
   sprintf(buf, "help xph\n");
   write_ns(buf);
   read_ns(line);
   if (strncmp(line, "-200:1:", 7) != 0) {
      /* Shit, no xph help.  Eat the response and notify the user. */
      while (atoi(line) != LR_OK) {
	 read_ns(line);
      }
      return(NULL);
   }

   /* Ok.  We can assume we have help for xph.  Eat the first line and
    * begin parsing the topic names.  Eat the last line of the stanza and
    * continue for the rest of the response (annoying "native" topics).
    */
   num_topics = 0;
   read_ns(line);
   topic = word(line, ':', 2);
   while (*topic == ' ') topic++;
   while (strncmp(topic, "To view", 7) != 0) {
      topics[num_topics] = (char *) malloc(strlen(topic)+1);
      strcpy(topics[num_topics], topic);
      num_topics++;
      read_ns(line);
      topic = word(line, ':', 2);
      while (*topic == ' ') topic++;
   }
   topics[num_topics] = NULL;

   /* Eat the remainder of the response. */
   while (atoi(line) != LR_OK) {
      read_ns(line);
   }

#if 0
   fprintf(stderr, "Parsed the following help topic list:\n");
   for (code=0; topics[code] != NULL; code++) {
      fprintf(stderr, "   %s\n", topics[code]);
   }
#endif

   return((num_topics == 0) ? NULL : topics);
}


static void
get_help_text(widget, client_data, call_data)
Widget widget;
XtPointer client_data, call_data;
{
   Widget help_popup, hform, htext, hdismiss;
   String item, topic, the_text;
   int code, maxstr;
   XawTextPosition maxpos, curpos;

   busy_cursor();
   
   /* Get the menu (normalized) and topic names.  Then build a popup panel
    * with a text widget and a dismiss button.  Once realized, query the
    * server for the text and insert it into the text widget.
    */
   XtVaGetValues(widget, XtNlabel, &item, NULL);
   topic = topic_list[(int) client_data];

   help_popup = XtVaCreatePopupShell(item, applicationShellWidgetClass,
				     toplevel, XtNtitle, item, NULL);
   hform = XtCreateManagedWidget("hform", formWidgetClass, help_popup,
				 NULL, ZERO);
   htext = XtVaCreateManagedWidget("htext", asciiTextWidgetClass, hform,
				   XtNscrollVertical, XawtextScrollWhenNeeded,
				   XtNdisplayCaret, FALSE, NULL);
   hdismiss = XtVaCreateManagedWidget("hdismiss", commandWidgetClass, hform,
				      XtNfromVert, htext, XtNlabel, "Dismiss",
				      NULL);
   XtAddCallback(hdismiss, XtNcallback, destroy_widget, (XtPointer) hform);
   
   /* Ok.  Realize the widget, contact the server, and add the help text
    * to the text widget.  Ignore the first line of the response; it is
    * merely the help topic name, which we already know.
    */
   XtRealizeWidget(help_popup);
   sprintf(line, "help xph %s\n", topic);
   write_ns(line);
   read_ns(line);
   read_ns(line);
   maxstr = 0;
   maxpos = 0;
   curpos = 0;
   if (atoi(line) == -(LR_OK)) {
      do {
	 the_text = word(line, ':', 2);
	 curpos = curpos + strlen(the_text) + 1;
	 if (strlen(the_text) > maxstr) {
	    maxstr = strlen(the_text);
	    maxpos = curpos;
	 }
	 XawAsciiAppend(htext, the_text);
	 XawAsciiAppend(htext, "\n");
	 read_ns(line);
      } while (atoi(line) != LR_OK);
   }
   else {
      XawAsciiAppend(htext, word(line, ':', 1));
   }

   /* Since we know the position of the end of the longest line, we 
    * position the cursor there, and force a resize.  That way, all the
    * text will always be seen with no user-resizes needed.
    * A hack I agree, but I know no other clean X way to do this.
    */
   XawTextSetInsertionPoint(htext, (XawTextPosition) maxpos-1);
   XtCallActionProc(htext, "end-of-line", NULL, NULL, ZERO);
   XtCallActionProc(htext, "beginning-of-file", NULL, NULL, ZERO);

   /* Ok.  render the help window. */
   unbusy_cursor();
   XtPopup(help_popup, XtGrabNone);
}


String normalize_name(name)
String name;
{
   static char norm[80];
   int i;
   
   /* Strip off the preceeding .. and change underscores to spaces. */
   strcpy(buf, name);
   strtok(buf, "..");
   strcpy(norm, strtok(NULL, ".."));
   for (i=0; norm[i] != '\0'; i++)
      if (norm[i] == '_')
	 norm[i] = ' ';
   return(norm);
}

void create_help_menu(widget)
Widget widget;		
{
   Widget hmenu, hitem;
   String menu_name, item_name;
   int i;

   /* Create a simple popup menu that lists the help topics for xph
    * available from the server.
    */
   /* Make sure we got help from the server. */
   if ((topic_list = get_help_list()) == NULL) {
      /* No help is available.  Turn off the button. */
      XtVaSetValues(widget, XtNsensitive, FALSE, NULL);
   }
   else {
      /* Check if we've already created a menu.  If so, delete it before
       * creating a new one.
       */
      XtVaGetValues(widget, XtNmenuName, &menu_name, NULL);
      if (strcmp(menu_name, "menu") != 0) {
	 XtDestroyWidget(XtNameToWidget(widget, "hmenu"));
      }

      XtVaSetValues(widget, XtNmenuName, "hmenu", XtNsensitive, TRUE, NULL);
      hmenu = XtVaCreatePopupShell("hmenu", simpleMenuWidgetClass, widget,
				   XtNlabel, "Select a help topic:", NULL);
      hitem = XtCreateManagedWidget(item_name, smeLineObjectClass, hmenu,
				    NULL, ZERO);
      for (i=0; topic_list[i] != NULL; i++) {
	 item_name = normalize_name(topic_list[i]);
	 hitem = XtCreateManagedWidget(item_name, smeBSBObjectClass, hmenu,
				       NULL, ZERO);
	 XtAddCallback(hitem, XtNcallback, get_help_text, (XtPointer) i);
      }
   }
}

