/* Copyright 1990 GROUPE BULL -- See licence conditions in file COPYRIGHT */
/* mio.c:
 *
 *  XPM
 *  I/O utility for XPM file format
 *  Developed by Arnaud Le Hors
 */

/* Official version number */
char *RCS_Version = "$XpmVersion: 3.0a $";

/* Internal version number */
char      *RCS_Id = "$Id: xpm.shar,v 2.9 1991/04/11 12:03:20 lehors Exp $";

#include "xpmP.h"
#include <sys/types.h>
#include <sys/stat.h>

LFUNC(atoui, unsigned int, (char *p));

static unsigned int atoui(p)
char *p;
{
        register int n;

        n = 0;
        while(*p >= '0' && *p <= '9')
                n = n*10 + *p++ - '0';
        return(n);
}

mnextstring(mdata)		/* skip to the end of the current string */
MData *mdata;			/* and the beginning of the next one */
{ char  c;
    switch(mdata->type) {
    case MARRAY:
	mdata->cptr = (mdata->stream.data)[++mdata->line];
	break;
    case MFILE:
    case MPIPE:
	while ((c = mgetc(mdata)) != mdata->Eos && c != EOF);
	if (mdata->Bos)
	    while ((c = mgetc(mdata)) != mdata->Bos && c != EOF);
	break;
    }
}

unsigned int mnextui(mdata)	/* skip whitespace and return the following */
MData *mdata;			/* unsigned int 			    */
{ char buf[BUFSIZ];

  mnextw(mdata, buf);
  return(atoui(buf));
}

char mgetc(mdata)		/* return the current character */
MData *mdata;
{ char c;
  register unsigned int n = 1, a;
  unsigned int notend;

    switch(mdata->type) {
    case MARRAY:
	return(*mdata->cptr++);
    case MFILE:
    case MPIPE:
	c = getc(mdata->stream.file);
	if (mdata->Bcmt && c == mdata->Bcmt[0]) {
	    mdata->Comment[0] = c;
	    /* skip the string begining comment
	     */
	    while ((mdata->Comment[n] = getc(mdata->stream.file)) 
		   == mdata->Bcmt[n]
		   && mdata->Bcmt[n] != '\0' && mdata->Comment[n] != EOF) n++;
	    if (mdata->Bcmt[n] != '\0') { 
		/* this wasn't the begining of a comment */
		for (a = 1; a < n; a++)
		    mungetc(mdata->Comment[a], mdata);
		return(c);
	    }
	    /* store comment 
	     */
	    mdata->Comment[0] = mdata->Comment[n];
	    notend = 1;
	    n = 0;
	    while (notend) {
		while (mdata->Comment[n] != mdata->Ecmt[0] 
		       && mdata->Comment[n] != EOF)
		    mdata->Comment[++n] = getc(mdata->stream.file);
		mdata->CommentLength = n++;
		a = 1;
		while ((mdata->Comment[n] = getc(mdata->stream.file)) 
		       == mdata->Ecmt[a]
		       && mdata->Ecmt[a] != '\0' && mdata->Comment[n] != EOF) {
		    a++; n++; 
		}
		if (mdata->Ecmt[a] == '\0') { 
		    /* this is the end of the comment */
		    notend = 0;
		    mungetc(mdata->Comment[n], mdata);
		}
	    }
	    c = mgetc(mdata);
	}
	return(c);
    }
}


char mungetc(c, mdata)		/* push the given character back */
int c;
MData *mdata;
{ 
    switch(mdata->type) {
    case MARRAY:
	return(*--mdata->cptr = c);
    case MFILE:
    case MPIPE:
	return(ungetc(c, mdata->stream.file));
    }
}


mskipwhite(mdata)		/* skip whitespace */
MData *mdata;
{ char c;

    switch(mdata->type) {
    case MARRAY:
	while (*mdata->cptr == SPC || *mdata->cptr == TAB) 
	    mdata->cptr++;
	break;
    case MFILE:
    case MPIPE:
	while ((c = mgetc(mdata)) == SPC || c == TAB);
	mungetc(c, mdata);
	break;
    }
}


unsigned int mnextw(mdata, buf)	/* skip whitespace and return the following */
MData *mdata;			/* word					    */
char *buf;
{ register unsigned int n = 0;

    mskipwhite(mdata);
    switch(mdata->type) {
    case MARRAY:
	while ((buf[n] = *mdata->cptr++) != SPC 
	       && buf[n] != TAB && buf[n] != mdata->Eos && buf[n] != EOF) n++;
	mdata->cptr--;
	break;
    case MFILE:
    case MPIPE:
	while ((buf[n] = mgetc(mdata)) != SPC 
	       && buf[n] != TAB && buf[n] != mdata->Eos && buf[n] != EOF) n++;
	ungetc(buf[n],mdata->stream.file); 
	break;
    }
  return(n);
}

mgetcmt(mdata, cmt)		/* get the current comment line */
MData *mdata;
char **cmt;
{
    switch(mdata->type) {
    case MARRAY:
	break;
    case MFILE:
    case MPIPE:
	if (mdata->CommentLength) {
	    *cmt = (char *) malloc(mdata->CommentLength + 1);
	    strncpy(*cmt, mdata->Comment, mdata->CommentLength);
	    (*cmt)[mdata->CommentLength] = '\0';
	    mdata->CommentLength = 0;
	} else
	    *cmt = NULL;
	break;
    }
}


int mreadopen(filename, mdataptr)
char *filename;
MData **mdataptr;
{ MData *mdata;
  char *compressfile, buf[BUFSIZ];
  struct stat status;

  if (! (mdata = (MData *)malloc(sizeof(MData)))) {
      return(PixmapNoMemory);
  }
  if (!filename) {
      mdata->stream.file = (stdin);
      mdata->type = MFILE;
  } else {
      if ((strlen(filename) > 2) && 
	  !strcmp(".Z", filename + (strlen(filename) - 2))) {
	  mdata->type= MPIPE;
	  sprintf(buf, "uncompress -c %s", filename);
	  if (! (mdata->stream.file = popen(buf, "r"))) {
	      free(mdata);
	      mdata = NULL;
	      return(PixmapOpenFailed);
	  }
      } else {
	  if (! (compressfile = (char*)malloc(strlen(filename) + 3))) {
	      free(mdata);
	      mdata = NULL;
	      return(PixmapNoMemory);
	  }
	  strcpy(compressfile, filename);
	  strcat(compressfile, ".Z");
	  if (!stat(compressfile, &status)) {
	      sprintf(buf, "uncompress -c %s", compressfile);
	      if (! (mdata->stream.file = popen(buf, "r"))) {
		  free(mdata);
		  free(compressfile);
		  mdata = NULL;
		  return(PixmapOpenFailed);
	      }
	      mdata->type= MPIPE;
	  } else {
	      if (! (mdata->stream.file = fopen(filename, "r"))) {
		  free(mdata);
		  free(compressfile);
		  mdata = NULL;
		  return(PixmapOpenFailed);
	      }
	      mdata->type = MFILE;
	  }
	  free(compressfile);
      }
  }
  *mdataptr = mdata;
  return(PixmapSuccess);
}

int mwriteopen(filename, mdataptr)
char *filename;
MData **mdataptr;
{ MData *mdata;
  char buf[BUFSIZ];

  if (! (mdata = (MData *)malloc(sizeof(MData)))) {
      return(PixmapNoMemory);
  }
  if (!filename) {
      mdata->stream.file = (stdout);
      mdata->type = MFILE;
  } else {
      if ((strlen(filename) > 2) && 
	  !strcmp(".Z", filename + (strlen(filename) - 2))) {
	  sprintf(buf, "compress > %s", filename);
	  if (! (mdata->stream.file = popen(buf, "w"))) {
	      free(mdata);
	      mdata = NULL;
	      return(PixmapOpenFailed);
	  }
	  mdata->type = MPIPE;
      } else {
	  if (! (mdata->stream.file = fopen(filename, "w"))) {
	      free(mdata);
	      mdata = NULL;
	      return(PixmapOpenFailed);
	  }
	  mdata->type = MFILE;
      }
  }
  *mdataptr = mdata;
  return(PixmapSuccess);
}

int mdataopen(data, mdataptr)
char **data;
MData **mdataptr;
{ MData *mdata;

  if (! (mdata = (MData *)malloc(sizeof(MData)))) { 
      return(PixmapNoMemory);
  }
  mdata->type = MARRAY;
  mdata->stream.data = data;
  mdata->cptr = *data;
  mdata->line = 0;
  mdata->CommentLength = 0;
  mdata->Bcmt = mdata->Ecmt = NULL;
  mdata->Bos = mdata->Eos = '\0';
  *mdataptr = mdata;
  return(PixmapSuccess);
}

mclose(mdata)
MData *mdata;
{
    switch(mdata->type) {
    case MARRAY:
	break;
    case MFILE:
	if (mdata->stream.file != (stdout) && mdata->stream.file != (stdin))
	    fclose(mdata->stream.file);
	break;
    case MPIPE:
	pclose(mdata->stream.file);
    }
    free(mdata);
    mdata = NULL;
}
