#include <sys/types.h>
#include <stdio.h>
#include <netdb.h>
#include <ctype.h>


char *malloc();

/*

Stdin has things like:

Host cica.cica.indiana.edu  (1.2.3)
Last updated 18:46 12 Feb 1992

    Location: /pub
      DIRECTORY drwxr-xr-x        512  Jul 31 23:39  graphics

Host cs.orst.edu

    Location: /pub/next
      DIRECTORY drwxr-xr-x       1024  Jul 12 12:13  graphics
    Location: /pub/next/sources
      DIRECTORY drwxr-xr-x       1024  Aug  1 17:02  graphics

---------------------------------------------------------------------
And this program puts to stdout things like:

/alex/edu/indiana/circa/circa/pub/graphics
     DIRECTORY drwxr-xr-x        512  Jul 31 23:39  graphics

/alex/edu/orst/cs/pub/next/graphics
      DIRECTORY drwxr-xr-x       1024  Jul 12 12:13  graphics

/alex/edu/orst/cs/pub/next/sources/graphics
      DIRECTORY drwxr-xr-x       1024  Aug  1 17:02  graphics

*/


void ToLower(s)
char *s;
{
    for (; *s != 0; s++) {
        if (isupper(*s)) {
            *s=tolower(*s);
        }
    }
}


/*  Input:     "sam.cs.cmu.edu"
 *  Returns:   "/edu/cmu/cs/sam"
 *  Destructive operation
 */
int NameToPath(namepath)
char *namepath;
{
    char LIFO[20][100];
    int length, seg, outi, cur, onlyonepart;

    seg=0;
    outi=0;
    onlyonepart=0;

    length=strlen(namepath);

    for (cur=0; cur<length; cur++) {
        if (namepath[cur] == '.') {
            LIFO[seg][outi]=NULL;
            seg++;
            outi=0;
        } else {
            LIFO[seg][outi]=namepath[cur];
            outi++;
        }
    }
    LIFO[seg][outi]=NULL;

    if (seg==0) onlyonepart=1;

    cur=0;
    for (; seg>=0; seg--) {
        namepath[cur++]='/';
        strcpy(&namepath[cur], LIFO[seg]);
        cur += strlen(LIFO[seg]);
    }
    namepath[cur]=NULL;

    return(onlyonepart);
}


/*   Copy s1 into s2   - same order as strcpy  
 */
CopyTillSpace(s2, s1)
char *s2, *s1;
{
    int i;

    while ((s1 != NULL) && (*s1 != 0) && (!isspace(*s1))) {
        *s2++ = *s1++;
    }
    *s2=0;
}


/*  Copies the last token from a string
 */
GetLastToken(ins, outs)
char *ins, *outs;
{
    int i, j;

    if ((ins == NULL) || (outs == NULL)) {
        fprintf(stderr, "GetLastToken ERROR we hate NULL pointers\n");
        return;
    }

    i=strlen(ins);

    for(i--; (i>0) && isspace(ins[i]) ; i--) {       /* ignore spaces at the end */
        ;
    }

    while( (i>0) && (!(isspace(ins[i]))) ) {         /* back up to start or space */
        i--;
    }

    if (isspace(ins[i]))  i++;                       /* want stuff after this space */

    for(j=0; (ins[i] != 0); j++) {
        outs[j] = ins[i++];                          /* copy out the token */
    }

    outs[j]=0;                                       /* and terminate it */
}



NoDoubleSlash(s)
char *s;
{
    char *s2;

    for (; (s != NULL) && (*s != 0); s++) {
        if ((s[0] == '/') && (s[1] == '/')) {
            for (s2=s; (s2 != NULL) && (*s2 != 0); s2++) {
                s2[0]=s2[1];
            }
        }
    }
}


StandardForm(name)
char *name;
{

/*
    struct hostent *h;             / * gethostbyname has its own static area * /

    h = gethostbyname(name);

    if (h != NULL) {
        (void) strcpy(name, h->h_name);
    } else {
        fprintf(stderr, "archiefilter found invalid hostname\n");
    }
 */        
    ToLower(name);
}


#define AHOST      "Host"
#define ALOCATION  "Location:"
#define AFILE      "FILE"
#define ADIRECTORY "DIRECTORY"
#define AUPDATE    "Last updated"

main()
{
    int i;
    char Host[200], Dir[200], File[200];
    char line[200], tmp[300];
   
    Host[0]=0;
    Dir[0]=0;
    File[0]=0;
 
    while (gets(line) != NULL) {
        for (i=0; (i<strlen(line)) && (line[i] == ' '); i++) {
            ;
        }
        if ((strlen(&line[i]) > 1) && (strncmp(line, AUPDATE, strlen(AUPDATE))) != 0) {
            if (0 == strncmp(&line[i], AHOST,      strlen(AHOST))) {
                CopyTillSpace(Host, &line[i+strlen(AHOST)+1]);
                StandardForm(Host);
                NameToPath(Host);
            } else if (0 == strncmp(&line[i], ALOCATION, strlen(ALOCATION))) {
                        strcpy(Dir, &line[i+strlen(ALOCATION)+1]); 
            } else if ((0 == strncmp(&line[i], ADIRECTORY,  strlen(ADIRECTORY))) ||
                       (0 == strncmp(&line[i], AFILE,       strlen(AFILE)))) {
                if (Host[0]==0) {
                    fprintf(stderr, "No host name for this file\n");
                }
                if (Dir[0]==0) {
                    fprintf(stderr, "Did not see an archie Location (directory)\n");
                }
                GetLastToken(line, File);
                tmp[0]=0;
                (void) strcat(tmp, "/alex");
                (void) strcat(tmp, Host);
                (void) strcat(tmp, Dir);
                (void) strcat(tmp, "/");
                (void) strcat(tmp, File);
                NoDoubleSlash(tmp);
                printf("%s\n", tmp);
                printf("%s\n\n",line);
            } else {
                fprintf(stderr, "archiefilter hates this input\n");
            }
        }
    }
} 

            

