/*
 * ignore.h: header for ignore.c 
 *
 * Copyright 1990 Michael Sandrof
 * Copyright 1997 EPIC Software Labs
 * See the COPYRIGHT file, or do a HELP IRCII COPYRIGHT 
 */

#ifndef __ignore_h__
#define __ignore_h__

/* Type of ignored nicks */
#define IGNORE_MSGS	1 << 0
#define IGNORE_PUBLIC	1 << 1
#define IGNORE_WALLS	1 << 2
#define IGNORE_WALLOPS	1 << 3
#define IGNORE_INVITES	1 << 4
#define IGNORE_NOTICES	1 << 5
#define IGNORE_NOTES	1 << 6
#define IGNORE_CTCPS	1 << 7
#define IGNORE_CRAP	1 << 8
#define IGNORE_ALL 	(IGNORE_MSGS | IGNORE_PUBLIC | IGNORE_WALLS | \
			 IGNORE_WALLOPS | IGNORE_INVITES | IGNORE_NOTICES | \
			 IGNORE_NOTES | IGNORE_CTCPS | IGNORE_CRAP)

#define IGNORED 	1
#define DONT_IGNORE 	2
#define HIGHLIGHTED 	-1

extern	int	ignore_usernames;
extern	char	*highlight_char;

	int	check_ignore 		(char *, char *, int);
	int	check_ignore_channel 	(char *, char *, char *, int);
	void	ignore 			(char *, char *, char *);
	char *	get_ignores_by_pattern	    (char *, int);
	char *	get_ignore_types_by_pattern  (char *);
	char *	get_ignore_patterns_by_type (char *);

#endif /* _IGNORE_H_ */
