/* WIDE AREA INFORMATION SERVER SOFTWARE
   No guarantees or restrictions.  See the readme file for the full standard
   disclaimer.    
*/


/* implements the search part of irext.h 
   (search_word and finished_search_word)
   Stub for tracy shen.
 */

#include "cdialect.h"
#include "irfiles.h"
#include "irsearch.h"
#include "irext.h"
#include <string.h>

/*===========================*
 *===  Setting Paramters  ===*
 *===========================*/

long max_hit_retrieved = 0;

long set_query_parameter (mask, parameters)
     long mask;
     query_parameter_type * parameters;
{
  switch (mask)
    {
    case SET_MAX_RETRIEVED_MASK:
      max_hit_retrieved = parameters->max_hit_retrieved;
      break;
    default:
      break;
    }
}



/*=============================*	
 *===  Searching for words  ===*
 *=============================*/

long search_word(word,char_pos, line_pos, weight, doc_id, dictionary_value,
		 db)
     char *word; /* the word to be searched for */
     long char_pos;		/* the position of the start of the word */
     long line_pos;		/* is this needed? not for signature system */
     long weight;		/* how important the word looks syntactically,
				   such as is it bold */
     long doc_id;		/* current document, seed words is 0,
				   then it increments into the relevant 
				   document */
     long dictionary_value;	/* this is from the disk dictionary,
				   a signature system would use weight,
				   inverted file systems would put
				   position information */
     database *db;
{
  return sig_search_word(word, char_pos, line_pos,
			 weight, 0L, doc_id, 0L, dictionary_value, db);
}



/*===================*
 *===  Best Hits  ===*
 *===================*/


long finished_search_word(db)
     database *db;
{ 
  return(sig_finished_search_word(db));
}


/* returns the next best hit */
long best_hit(doc_id, score)
     long *doc_id;	
     long *score;
{
  return(sig_best_hit(NULL, doc_id, NULL, score));
}

long finished_best_hit()
{ 
  return(sig_finished_best_hit());
}
