// DocControl.h
//
// Free software created 1 Feb 1992
// by Paul Burchard <burchard@math.utah.edu>.
//
// Provides an abstract superclass to act as App's delegate and handle
// opening and closing of documents.  You'll connect Document menu items
// in IB to target their messages to this object.
//
// The subclass do the following in its -init method:
//
//	* Give -setDocHandlers: a List of Doc subclasses (this list will
//		be freed by the DocControl class when it's done with it).
//	* Set launchWithCreateDoc to YES, if you want the app to launch with
//		an newly created open document (except when explicitly
//		launched by an openFile:: message).  This will use the first 
//		Doc handler in the list.
//
// Most subclasses will probably also want to subclass the method
//
//	+ (const char *)defaultFolder	Default folder for Open/Save Panels,
//					when Doc subclass is unknown.
//
// Also, the stringTable points to an NXStringTable (to be created in IB)
// translating the following strings:
//	"/UNTITLED"
//	"Revert"
//	"Revert to saved version of %s?"
//	"Close"
//	"%s has been modified.\nSave it?"
//	"Open"
//	"Cannot read %s!"
//	"Save"
//	"Cannot write %s!"
//	"Yes"
//	"No"
//	"OK"
//	"Cancel"
//

#import <objc/Object.h>
#import <objc/HashTable.h>
#import <objc/NXStringTable.h>

@interface DocControl:Object
{
    id DocHandlers;
    const char **fileTypes;
    BOOL launchWithCreateDoc;
    id convertWindowToDoc;
    id stringTable;
}

- init;
- setDocHandlers:HandlerList;
- appDidInit:sender;
- free;
+ (const char *)defaultFolder;
- appWillTerminate:sender;
- (BOOL)appAcceptsAnotherFile:sender;
- handlerForFile:(const char *)fileName;
- (int)app:sender openFile:(const char *)fileName type:(const char *)aType;
- setMainDoc:aDoc;
- mainDoc;
- stringTable;

// Basic Doc operations.
// All return the Doc on success (except -closeDoc:andFree: returns self).
- createDocForHandlerAt:(int)hNum;
- openForHandlerAt:(int)hNum name:(const char *)fileName;//may be NULL
- saveDoc:theDoc as:(BOOL)yn;
- revertDocToSaved:theDoc;
- closeDoc:theDoc andFree:(BOOL)yn;

// Menu items.
- open:sender; // allows all file types, determines handler afterwards
- open1:sender; // uses first handler
- open2:sender; // uses second handler
- open3:sender; // uses third handler
- createDoc:sender; // uses default (=first) handler
- createDoc1:sender; // uses first handler
- createDoc2:sender; // uses second handler
- createDoc3:sender; // uses third handler
- saveAs:sender;
- save:sender;
- revertToSaved:sender;
- close:sender;

@end
