// WAISControl.h
//
// Free software created 1 Feb 1992
// by Paul Burchard <burchard@math.utah.edu>.
//
// Additional strings used in string table:
//	"WAIStation"
//	"Can't create folder for WAIS documents"
//	"Can't create folder for WAIS sources"
//	"Can't create folder for WAIS questions"
//

#import "DocControl.h"
#import <cthreads.h>

#define WAISTATION_VERSION "1.9"

#ifdef TELL_USER
#define WAIS_USER NXUserName()
#else
#define WAIS_USER "anonymous"
#endif

typedef struct retrieval_args_struct
{
    id docList;
    mutex_t requestMutex;
    condition_t requestCondition;
}
    *retrieval_args;

@interface WAISControl:DocControl
{
    // Panels.
    id helpPanel;
    id infoPanel;
    id prefsPanel;
    id prefsIsOpenOnRetrieval;
    id prefsSystemFolder;
    id prefsUserFolder;
    id prefsSearchLimit;
    id prefsIWC;
    id sourcePalettePanel;
    id sourcePaletteIWC;
    id sourcePaletteWell;
    id sourcePaletteBrowser;
    id documentPalettePanel;
    id documentPaletteIWC;
    id documentPaletteWell;
    id documentPaletteBrowser;
    
    // Retrieval thread.
    mutex_t requestMutex;
    condition_t requestCondition;
    cthread_t retrievalThread;
    struct retrieval_args_struct retrievalArgs;
    id retrievalList;
    BOOL isOpenOnRetrieval;
}

+ initialize;
- init;
- free;
+ (const char *)defaultFolder;
- appDidInit:sender;
- help:sender;
- info:sender;
- bugReport:sender;
- signMeUp:sender;
- prefs:sender;
- updatePrefs:sender;
- sourcePalette:sender;
- documentPalette:sender;
- retrieveDocumentsFrom:sender;
- retrieveDocuments:(const char *)keyList;
- cancelRetrievals:sender;
- (BOOL)isDocumentBeingRetrieved:waisDoc;
- (int)openFile:(const char *)fileName ok:(int *)flag;
- (int)removeFile:(const char *)fileName ok:(int *)flag;

@end
