
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!                                                                              !
! Author: M. Tracy Shen
! Program: z39-50-wais.mms 
! Description: Makefile for z39-50-wais library and test programs
! Usage: mms/des=z39-50-wais [/macro="DEBUG=1"] [target,...]
!        valid targets: Z39-50-WAIS-lib, cmem-test, ztest, 
!                       wprot-test, wutil-test
!
!        If no targets are specified, all are updated.
!        Specify the DEBUG macro to update debuggable version of a target.
!                                                                              !
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
!Define macros
!
.IFDEF DEBUG
CC_FLAG = /NOOPT/DEBUG
LNK_FLAG = /DEBUG
FN_FLAG = -DBG
.ELSE
CC_FLAG =
LNK_FLAG =
.ENDIF
!
!Overall system target
!
System depends_on Z39-50-WAIS-lib, cmem-test, -
        wprot-test, wutil-test, ztest
	!complete updating targets
!
Z39-50-WAIS-lib depends_on [-.bin]Z39-50-WAIS-lib$(FN_FLAG).olb
	!complete updating [-.bin]Z39-50-WAIS-lib$(FN_FLAG).olb
!
!
cmem-test depends_on [-.bin]cmem-test$(FN_FLAG).exe
	!complete updating [-.bin]cmem-test$(FN_FLAG).exe
!
!
zprot-test depends_on [-.bin]zprot-test$(FN_FLAG).exe
	!complete updating [-.bin]zptot-test$(FN_FLAG).exe
!
!
wprot-test depends_on [-.bin]wprot-test$(FN_FLAG).exe
	!complete updating [-.bin]wprot-test$(FN_FLAG).exe
!
wutil-test depends_on [-.bin]wutil-test$(FN_FLAG).exe
	!complete updating [-.bin]wutil-test$(FN_FLAG).exe
!
[-.bin]Z39-50-WAIS-lib$(FN_FLAG).olb depends_on [-.bin]zprot$(FN_FLAG).obj, -
        [-.bin]wprot$(FN_FLAG).obj, -
        [-.bin]ztype1$(FN_FLAG).obj, -
        [-.bin]zutil$(FN_FLAG).obj, -
        [-.bin]cutil$(FN_FLAG).obj, -
        [-.bin]transprt$(FN_FLAG).obj, -
        [-.bin]wutil$(FN_FLAG).obj, -
        [-.bin]panic$(FN_FLAG).obj
	!in updating the library
!
[-.bin]zprot$(FN_FLAG).obj depends_on [-.src]zprot.c, [-.src]zprot.h, -
        [-.src]zutil.h, [-.src]cutil.h, [-.src]cdialect.h
	cc $(CC_FLAG) /define=VAX_C/object=[-.bin]zprot$(FN_FLAG).obj -
          /list=[-.lst]zprot$(FN_FLAG).lst -
          [-.src]zprot.c
        library/replace/log [-.bin]Z39-50-WAIS-lib$(FN_FLAG) [-.bin]zprot$(FN_FLAG)
!
[-.bin]wprot$(FN_FLAG).obj depends_on [-.src]wprot.c, -
        [-.src]wprot.h, [-.src]zprot.h [-.src]ztype1.h, -
        [-.src]zutil.h, [-.src]cutil.h, [-.src]cdialect.h
	cc $(CC_FLAG) /define=VAX_C/object=[-.bin]wprot$(FN_FLAG).obj -
                      /list=[-.lst]wprot$(FN_FLAG).lst -
                  [-.src]wprot.c
        library/replace/log [-.bin]Z39-50-WAIS-lib$(FN_FLAG) -
               [-.bin]wprot$(FN_FLAG)
!
[-.bin]ztype1$(FN_FLAG).obj depends_on [-.src]ztype1.c, -
        [-.src]ztype1.h, [-.src]cutil.h, [-.src]zutil.h, [-.src]cdialect.h
	cc $(CC_FLAG) /define=VAX_C -
                      /object=[-.bin]ztype1$(FN_FLAG).obj -
                      /list=[-.lst]ztype1$(FN_FLAG).lst -
          [-.src]ztype1.c
        library/replace/log [-.bin]Z39-50-WAIS-lib$(FN_FLAG) -
               [-.bin]ztype1$(FN_FLAG)
!
[-.bin]zutil$(FN_FLAG).obj depends_on [-.src]zutil.c, [-.src]zutil.h, -
        [-.src]cutil.h, [-.src]cdialect.h
	cc $(CC_FLAG) /define=VAX_C/object=[-.bin]zutil$(FN_FLAG).obj -
                      /list=[-.lst]zutil$(FN_FLAG).lst -
          [-.src]zutil.c
        library/replace/log [-.bin]Z39-50-WAIS-lib$(FN_FLAG) -
               [-.bin]zutil$(FN_FLAG)

!
[-.bin]cutil$(FN_FLAG).obj depends_on [-.src]cutil.c, [-.src]cutil.h, -
        [-.src]cdialect.h, [-.src]panic.h
	cc $(CC_FLAG) /define=VAX_C/object=[-.bin]cutil$(FN_FLAG).obj -
                      /list=[-.lst]cutil$(FN_FLAG).lst -
                  [-.src]cutil.c
        library/replace/log [-.bin]Z39-50-WAIS-lib$(FN_FLAG) [-.bin]cutil$(FN_FLAG)
!
[-.bin]transprt$(FN_FLAG).obj depends_on [-.src]transprt.c, [-.src]transprt.h
	cc $(CC_FLAG) /define=VAX_C/object=[-.bin]transprt$(FN_FLAG).obj -
                      /list=[-.lst]transprt$(FN_FLAG).lst -
                  [-.src]transprt.c
        library/replace/log [-.bin]Z39-50-WAIS-lib$(FN_FLAG) [-.bin]transprt$(FN_FLAG)
!
[-.bin]wutil$(FN_FLAG).obj depends_on [-.src]wutil.c, [-.src]wutil.h, -
        [-.src]wprot.h, [-.src]zprot.h [-.src]ztype1.h, -
        [-.src]zutil.h, [-.src]cutil.h, [-.src]cdialect.h
	cc $(CC_FLAG) /define=(VAX_C,FOR_DUM_TERM)/object=[-.bin]wutil$(FN_FLAG).obj -
          /list=[-.lst]wutil$(FN_FLAG).lst -
          [-.src]wutil.c
        library/replace/log [-.bin]Z39-50-WAIS-lib$(FN_FLAG) [-.bin]wutil$(FN_FLAG)
!
[-.bin]panic$(FN_FLAG).obj depends_on [-.src]panic.c, [-.src]panic.h, -
        [-.src]cdialect.h
	cc $(CC_FLAG) /define=(VAX_C)/object=[-.bin]panic$(FN_FLAG).obj -
          /list=[-.lst]panic$(FN_FLAG).lst -
          [-.src]panic.c
        library/replace/log [-.bin]Z39-50-WAIS-lib$(FN_FLAG) [-.bin]panic$(FN_FLAG)
!
[-.bin]cmem-test$(FN_FLAG).exe depends_on [-.bin]cmem-test$(FN_FLAG).obj
	link $(LNK_FLAG) /exec=[-.bin]cmem-test$(FN_FLAG).exe -
             [-.bin]cmem-test$(FN_FLAG).obj
!
[-.bin]cmem-test$(FN_FLAG).obj depends_on [-.src]cmem.c, -
        [-.src]cutil.h, [-.src]cdialect.h
	cc $(CC_FLAG) /define=VAX_C -
                      /object=[-.bin]cmem-test$(FN_FLAG).obj -
                      /list=[-.lst]cmem-test$(FN_FLAG).lst -
          [-.src]cmem.c
!
[-.bin]ztest$(FN_FLAG).exe depends_on [-.bin]ztest$(FN_FLAG).obj, -
        [-.bin]Z39-50-WAIS-lib$(FN_FLAG).olb
	link $(LNK_FLAG) /exec=[-.bin]ztest$(FN_FLAG).exe -
            [-.bin]ztest$(FN_FLAG).obj, -
            [-.bin]Z39-50-WAIS-lib$(FN_FLAG).olb/lib
!
[-.bin]ztest$(FN_FLAG).obj depends_on [-.src]ztest.c, [-.src]zprot.h, -
        [-.src]ztype1.h, [-.src]zutil.h, [-.src]cutil.h, [-.src]cdialect.h
	cc $(CC_FLAG) /define=VAX_C/object=[-.bin]ztest$(FN_FLAG).obj -
                      /list=[-.lst]ztest$(FN_FLAG).lst -
          [-.src]ztest.c
!
[-.bin]wprot-test$(FN_FLAG).exe depends_on [-.bin]wprot-test$(FN_FLAG).obj, -
        [-.bin]Z39-50-WAIS-lib$(FN_FLAG).olb
	link $(LNK_FLAG) /exec=[-.bin]wprot-test$(FN_FLAG).exe -
            [-.bin]wprot-test$(FN_FLAG).obj, -
            [-.bin]Z39-50-WAIS-lib$(FN_FLAG).olb/lib
!
[-.bin]wprot-test$(FN_FLAG).obj depends_on [-.src]wprot.c, -
        [-.src]wprot.h, [-.src]zprot.h [-.src]ztype1.h, -
        [-.src]zutil.h, [-.src]cutil.h, [-.src]cdialect.h
	cc $(CC_FLAG) /define=(VAX_C,TEST_WAIS_PROTOCOL)/object=[-.bin]wprot-test$(FN_FLAG).obj -
          /list=[-.lst]wprot-test$(FN_FLAG).lst -
          [-.src]wprot.c
!
[-.bin]wutil-test$(FN_FLAG).exe depends_on [-.bin]wutil-test$(FN_FLAG).obj, -
        [-.bin]Z39-50-WAIS-lib$(FN_FLAG).olb
	link $(LNK_FLAG) /exec=[-.bin]wutil-test$(FN_FLAG).exe -
            [-.bin]wutil-test$(FN_FLAG).obj, -
            [-.bin]Z39-50-WAIS-lib$(FN_FLAG).olb/lib
!
[-.bin]wutil-test$(FN_FLAG).obj depends_on [-.src]wutil.c, -
        [-.src]wutil.h, [-.src]wprot.h, [-.src]zprot.h [-.src]ztype1.h, -
        [-.src]zutil.h, [-.src]cutil.h, [-.src]cdialect.h
	cc $(CC_FLAG) /define=(VAX_C,TEST, FOR_DUM_TERM)/object=[-.bin]wutil-test$(FN_FLAG).obj -
          /list=[-.lst]wutil-test$(FN_FLAG).lst -
          [-.src]wutil.c
!
