/* WIDE AREA INFORMATION SERVER SOFTWARE:
   No guarantees or restrictions.  See the readme file for the full standard
   disclaimer.

   This is part of the X user-interface for the WAIS software.  Do with it
   as you please.

   jonathan@Think.COM
*/

/* this file contains X specific code - it is an integral part of XWAIS */

#ifndef lint
static char *RCSid = "$Header: /proj/wais/latest/x/RCS/catalog.c,v 1.1 92/06/23 14:08:10 jonathan Exp Locker: jonathan $";
#endif

#ifndef _C_CATALOG
#define _C_CATALOG

#include "xwais.h"
#include "cat.h"

static Boolean busy = FALSE;
static long last_doc = -1;
static Catbuff scat;
static Widget cviewbutton, csavebutton;

Catbuff build_cat(catalog, source)
char* catalog;
SourceID source;
{
  char database[STRINGSIZE], headline[STRINGSIZE], docid[STRINGSIZE];
  char* p = catalog;
  long i, j, numdocs = 0, start, end, size;
  DocumentID docID;
  DocList dl;
  Catbuff result;
  extern char *strstr(), *index();

  if((result = (Catbuff)s_malloc(sizeof(_Catbuff))) == NULL) {
    PrintStatus(STATUS_URGENT, STATUS_HIGH, BADALLOC_MESSAGE);
    return NULL;
  }

  /* get the database name */
  p = strstr(p, "Catalog for database: ");
  if (p == NULL) return NULL;
  p += strlen("Catalog for database: ");
  memset(database, 0, STRINGSIZE);
  strncpy(database, p, strstr(p, "\n")-p);
  while(numdocs == 0 && p != NULL && *p != 0) {
    sscanf(p, "%d total documents", &numdocs);
    p = strstr(p, "\n")+1;
  }

  /* find the first headline */
  p = strstr(p, "\nHeadline: ");
  if(p != NULL) p++;

  result->source = source;
  result->database = s_strdup(database);
  result->Items = (String*)s_malloc((numdocs+1)*sizeof(String));
  result->headlines = (String*)s_malloc((numdocs+1)*sizeof(String));
  result->Docids = (String*)s_malloc((numdocs+1)*sizeof(String));

  for(i = 0; i < numdocs; i++) {
    if (p == NULL) return NULL;
    /* set the headline */
    p += strlen("Headline: ");
    memset(headline, 0, STRINGSIZE);
    strncpy(headline, p, index(p, '\n')-p);
    result->headlines[i] = s_strdup(headline);

    /* set the docid */
    p = index(p, '\n');
    if(p == NULL) break;
    else p += 1+strlen("DocID: ");
    memset(docid, 0, STRINGSIZE);
    strncpy(docid, p, index(p, '\n')-p);
    result->Docids[i] = s_strdup(docid);

    /* build the printable headline */
    sscanf(docid, "%d %d", &start, &end);
    size = end - start;
    if (size > 1024) 
      sprintf(headline, "%4.1fK %s", size/1024.0, result->headlines[i]);
    else
      sprintf(headline, "%5d %s", size, result->headlines[i]);
    result->Items[i] = s_strdup(headline);
    
    /* go to the next catalog record */
    for(j = 0; j < 3; j++) {
      p = index(p, '\n');
      if(p == NULL) break;
      else p++;
    }
  }
  scat = result;
  return result;
}

static DocumentID
makecatdoc(cat, i)
Catbuff cat;
long i;
{
  DocumentID docID = NULL;

  if((docID = (DocumentID)s_malloc(sizeof(_DocumentID))) != NULL) {
    docID->rawScore = 1000;
    docID->start = docID->end = -1;
    if((docID->doc = (CRetDocument)s_malloc(sizeof(_CRetDocument))) != NULL) {
      docID->doc->sourceID = cat->source;
      docID->doc->numLines = 0;
      docID->doc->numChars = -1;
      docID->doc->best = 0;

      docID->doc->headline = s_strdup(cat->headlines[i]);
      docID->doc->type = (char **)s_malloc(2*sizeof(char*));
      docID->doc->type[0] = s_strdup("TEXT");
      docID->doc->type[1] = NULL;

      docID->doc->id = (DocID*)s_malloc(sizeof(DocID));
      memset(docID->doc->id, 0, sizeof(DocID));
      docID->doc->id->originalDatabase = stringToAny(cat->database);
      docID->doc->id->originalLocalID = stringToAny(cat->Docids[i]);
    }
  }
  return docID;
}

/* ARGSUSED */
static void
ViewCat(w, closure, call_data)
Widget w;
XtPointer closure, call_data;
{
  Catbuff cat = scat;
  static int document_number;

  double_click = FALSE;
  LastClicked = w;

  if(!busy)
    if((document_number = get_selected_item(cat->List->ListWidget)) ==
       NO_ITEM_SELECTED)
      PrintStatus(STATUS_URGENT, STATUS_HIGH, NOSELECT_MESSAGE);
    else {
      DocumentID doc;

      if (document_number != last_doc) {
	last_doc = document_number;
      }
      else {
	messwidget = cat->status;
	if((doc = makecatdoc(cat, document_number)) == NULL)
	  PrintStatus(STATUS_URGENT, STATUS_HIGH, NODOC_MESSAGE);
	else {
	  ViewDoc(doc, doc->doc->type[0], 0, (w == csavebutton));
	}
      }
    }
}

static void
CloseCat(w, closure, call_data)
Widget w;
XtPointer closure, call_data;
{
  Catbuff cat = scat;
  XtPopdown(cat->shell);
}

Widget
MakeCatPopup(parent, cat, name)
Widget parent;
Catbuff cat;
char *name;
{
  Widget frame, button, stringlabelwid, view;
  Arg args[TWO];
  static String items[] = {NULL};

  XtSetArg(args[ZERO], XtNtitle, name);
  XtSetArg(args[ONE], XtNiconName, name);
  cat->shell = XtCreatePopupShell("catpopup", applicationShellWidgetClass,
				  parent, args, TWO);
  frame =
    XtCreateManagedWidget("questionpopupform", formWidgetClass,
			  cat->shell, NULL, ZERO);

  stringlabelwid = MakeLabel(frame, "foo", "Catalog of", NULL, NULL);

  stringlabelwid =
    MakeLabel(frame, "qreslabel", "documents:",
	      stringlabelwid, NULL);

  cviewbutton = button = 
    MakeCommandButton(frame, "view", ViewCat,
		      stringlabelwid, NULL, NULL);

  csavebutton = button =
    MakeCommandButton(frame, "qsave", ViewCat,
		      button, NULL, NULL);

  button =
    MakeCommandButton(frame, "qdone", CloseCat,
		      button, NULL, cat);

  XtSetArg (args[ZERO], XtNallowVert, True);
  XtSetArg (args[ONE], XtNfromVert, NULL);

  view = XtCreateManagedWidget ("rview", viewportWidgetClass,
				frame, args, TWO);

  cat->List = 
    MakeScrollList(view, "catresults", cat->Items,
		   ViewCat, NULL, NULL);

  stringlabelwid =
    MakeLabel(frame, "statuslabel", "Status:",
	      NULL, NULL);

  XtSetArg(args[ZERO], XtNeditType, XawtextEdit);

  cat->status =
    XtCreateManagedWidget("statusWindow", asciiTextWidgetClass,
			  frame, args, ONE);

  return(cat->shell);
}

#endif
