/*
 * Copyright 1993, Bunyip Information Systems. This file is part of the
 * Bunyip WHOIS++ distribution and may be freely distributed as long as
 * this notice remains intact. This file may not be used in any product for
 * commercial gain.
 */

#include <stdio.h>
#include <string.h>
#include <malloc.h>
#include "whois.h"
#include "templates.h"


/* Global head of templates list */

template_str *template_head = (template_str *) NULL;

int read_template_config(config_file)
   char *config_file;

{
   FILE *fp;
   char inbuf[BUFSIZ];
   char *iptr, *tmp_ptr;
   int lineno;
   template_str *template_current;
   int t_count;

   int t_maxcount = DEF_NO_TEMPLATES;

   if((fp = fopen(config_file, "r")) == (FILE *) NULL){

      wPutLine(stdout, wErrorReply(WERR_OPEN_CONFIG, "%s", config_file));
      return(1);
   }


   if((template_head = (template_str *) malloc(DEF_NO_TEMPLATES * sizeof(template_str))) == (template_str *) NULL){

      wPutLine(stdout, wErrorReply(WERR_INTERNAL, "Memory allocation problem"));
      return(1);
   }

   template_current = template_head;

   for(iptr = inbuf, lineno = 1; fgets(iptr, inbuf + sizeof(inbuf) - iptr, fp) != (char *) NULL; lineno++){

      /* continuation lines */

      if((tmp_ptr = strstr(inbuf,CONTINUATION_LINE)) != (char *) NULL){
	 *tmp_ptr = '\0';
	 iptr = tmp_ptr;
	 continue;
      }
	 
      /* Recognise comments */

      if((tmp_ptr = strchr(inbuf,COMMENT_CHAR)) != (char *) NULL)
	 *tmp_ptr = '\0';


      if(sscanf(inbuf, "%s %s %s %[^\n]\n", template_current -> t_name,
					    template_current -> t_path,
					    template_current -> t_dir,
					    template_current -> t_desc) < 2){

	 wPutLine(stdout, wErrorReply(WERR_OPEN_CONFIG, "Insufficient parameters in %s", config_file));
	 return(1);
      }

      template_current -> t_num = t_count;

      if(template_current + 1 > template_head + t_maxcount){
	 template_str *t_ptr;

	 /* reallocate space for more templates */

	 t_maxcount += ADD_NO_TEMPLATES;

	 if((t_ptr = (template_str *) realloc(template_head, t_maxcount * sizeof(template_str))) == (template_str *) NULL){

	    wPutLine(stdout, wErrorReply(WERR_INTERNAL, "Memory allocation problem"));
	    return(1);
	 }
	 else{

	    template_head = t_ptr;
	    template_current = template_head + t_maxcount - ADD_NO_TEMPLATES;
	    t_count++;
	 }
      }
      else{
	 template_current++;
	 t_count++;
      }

   }

   /* mark the end of the list */

   template_current -> t_name[0] = '\0';

   /* close the configuration file */

   fclose(fp);



   for(template_current = template_head; template_current -> t_name[0] != '\0'; template_current++){
      char attr[MAX_TEMPLATE_NAME];
      char desc[MAX_TEMPLATE_DESC];
      int k;

      if((fp = fopen(template_current -> t_path, "r")) == (FILE *) NULL){

	 wPutLine(stdout, wErrorReply(WERR_TMPL_FILE, "%s", template_current -> t_path));
	 return(1);
      }

      template_current -> t_def = wCreateSearch();

      for(iptr = inbuf, lineno = 1; fgets(iptr, inbuf + sizeof(inbuf) - iptr, fp) != (char *) NULL; lineno++){
	 char attrnum[16];
	 WItem *term;

	 /* continuation lines */

	 if((tmp_ptr = strstr(inbuf,CONTINUATION_LINE)) != (char *) NULL){
	    *tmp_ptr = '\0';
	    iptr = tmp_ptr;
	    continue;
	 }
	    
	 /* Recognise comments */

	 if((tmp_ptr = strchr(inbuf,COMMENT_CHAR)) != (char *) NULL)
	    *tmp_ptr = '\0';

	 if(sscanf(inbuf, "%s %s %[^\n]\n", attrnum, attr, desc) < 2){

	    wPutLine(stdout, wErrorReply(WERR_INTERNAL, "Insufficient parameters in template file %s", template_current -> t_path));
	    return(1);
	 }

	 k = strlen(attr);

	 if(attr[k-1] == '*'){

	    attr[k-1] = '\0';
	    k = -1;
	 }
	 else
	    k = -2;

	 term = wAppendTerm(template_current -> t_def, F_ATTR_VAL, attr, desc);

	 /* Check to see if this is the "primary" attribute */

	 if(term)
	    wAppendConstraint(term, attrnum, k == -1 ? "*" : "");
      }

      fclose(fp);

   }

   return(0);
}
	 

      
