/*  
 *  Not all possible error checking is done.
 */  

#include <stdio.h>
#include <string.h>
#include "wutils.h"
#include "wquery.h"
#include "wreply.h"


extern const char *tail proto_((const char *path));
extern void usage proto_((void));
  

const char *prog;


int main(ac, av)
  int ac;
  char **av;
{
  FILE *ifp; /* input from the server */
  FILE *ofp; /* output to the server */
  WItem *c;
  WItem *l;
  WItem *lst;
  char *s;
  char *whost = (char *)0;
  
  prog = tail(av[0]);
  if (ac < 4 || strcmp(av[1], "-h"))
  {
    usage();
  }
  whost = av[2];
  av += 2; ac -= 2;

#if 1
  ifp = stdin; ofp = stdout;
  wSetDebug(3);
#else
  if ( ! wConnect(whost, 0, &ifp, &ofp))
  {
    exit(1);
  }
#endif

  /*  
   *  Construct the head of the query
   */  
  lst = l = wNewWItem();
  l->type = T_SEARCH;
  l->format = F_HEAD;

  /*  
   *  Make a couple of global contraints, starting with the header
   *  item.
   */  
  l->cons = wNewWItem();
  l->cons->type = T_CONS;
  l->cons->format = F_HEAD;

  c = l->cons;

  /*  
   *  Note that even though the list of constraints is attached through the
   *  `cons' pointer, within the constraint list itself the `next' pointer is
   *  used to link the items together.
   */  
  c->next = wNewWItem();
  c->next->type = T_CONS;
  c->next->lhs = strdup("language") ;
  c->next->rhs = strdup("francais");

  c = c->next;

  c->next = wNewWItem();
  c->next->type = T_CONS;
  c->next->lhs = strdup("maxhits") ;
  c->next->rhs = strdup("20");

  /*  
   *  Construct a search term for each argument
   */  
  while (av++, --ac)
  {
    WItem *w;
    char *e = strchr(*av, '=');

    if ( ! e)
    {
      wFreeList(lst);
      exit(1);
    }
    *e = '\0';

    w = wNewWItem();
    w->type = T_SEARCH;
    w->format = F_ATTR_VAL;
    w->lhs = strdup(*av);
    w->rhs = strdup(e+1);

    l->next = w;
    l = w;
  }

  if ((s = wQueryStr(lst)))
  {
    fprintf(stderr, "%s: query is `%s'.\n", prog, s);
  }
  else
  {
    fprintf(stderr, "%s: malformed queryy, `%s'.\n", prog, s);
    exit(1);
  }

  wFreeList(lst);
  if ( ! wPutLine(ofp, s))
  {
    fprintf(stderr, "%s: error transmitting query.\n", prog);
    exit(1);
  }

  if ( ! (lst = wReplyParse(ifp)))
  {
    fprintf(stderr, "%s: error getting reply.\n", prog);
    exit(1);
  }

  /*  
   *  See the source for the routine wPrintList() in wquery.c
   */  

  wPrintList(stderr, lst);
  wFreeList(lst);

  exit(0);
}


const char *tail(path)
  const char *path;
{
  char *p = strrchr(path, '/');
  return p ? p+1 : path;
}


void usage()
{
  fprintf(stderr, "Usage: %s -h <host> <attr>=<value> ...\n", prog);
  exit(1);
}
