#include <stdio.h>
#include "defines.h"
#include "externs.h"


/* ------------------------------------------------------------
		get_token()

   This routine is the lexical analyser. Each time you
   call it, it returns a single token from the input
   buffer.  It terminates on a NULL byte, a newline or a
   carriage return (how thoughtful of it... :-)

   uses global point "ptr" to keep track of current
   location in input buffer. You mess with this at your
   peril...

   See defines.h for list of valid tokens.

------------------------------------------------------------ */

get_token () {

int state, count;

	logit ("get_token:", "into get_token");

	state = START_STATE;

	while (1) {
		switch (state) {
		case START_STATE:
			switch (*ptr) {
			case ' ':
			case '\t':	logit ("get_token:","munch");
					ptr++;
					break;
			case '?':	logit("get_token:","HELP");
					ptr++;
					token_value = HELP;
					return(COMMAND);
			case '!':	logit("get_token:","HANDLE");
					ptr++;
					token_value = HANDLE;
					return(COMMAND);
			case '#':	logit("get_token:","ATTRIBUTE");
					ptr++;
					token_value = ATTRIBUTE;
					return(COMMAND);
			case '.':	logit("get_token:","VALUE");
					ptr++;
					token_value = VALUE;
					return(COMMAND);
			case '\r':
			case '\n':
			case '\0':	logit("get_token:","EOL");
					return(EOL);

			case ',':	logit("get_token:","COMMA");
					ptr++;
					return(COMMA);
			case';':	logit("get_token:","END OF TERM");
					ptr++;
					return(EOT);
			case ':':	logit("get_token:","COLON");
					ptr++;
					return(COLON);
			case '=':	logit("get_token:","EQUALS");
					ptr++;
					return(EQUALS);

			default: /* maybe it's a string */
		if (((*ptr >= 'a')&&(*ptr <= 'z')) ||
		((*ptr >= 'A')&&(*ptr <= 'Z')) ||
		((*ptr >= '0')&&(*ptr <= '9'))) {
				logit("get_token:", "Into string");
				state = IN_STRING_STATE;
				startptr = ptr; /* remember so we can */
				ptr++;		/* copy it later */
				break;
		}

		/* nope, it's bad */
			logit("get_token:","ERROR");
	 		printf ("token_value: %d\n", *ptr);
			ptr++;
			return(BOGUS_TOKEN);
			}

			break;
		
		case IN_STRING_STATE:

			if (((*ptr >= 'a')&&(*ptr <= 'z')) ||
			    ((*ptr >= 'A')&&(*ptr <= 'Z')) ||
				(*ptr=='_') || (*ptr=='-') ||
			    ((*ptr >= '0')&&(*ptr <= '9'))) {
				ptr++;
				break;
			}
		/* else it's the last char of the string */
			count = 0;
			while (startptr !=  ptr) {
				token_string [count++] = *startptr++;
			}
			token_string[count] = '\0';
			logit ("get_token:", token_string);
			return (STRING);
		

		default:
				logit ("get_token", "lost in space");
				return (BOGUS_TOKEN);


		}
	}
}



	
