//	Copyright (c) 1994, University of Kansas, All Rights Reserved
//
//	Class:		TURLView
//	Include File:	turlview.h
//	Purpose:	Provide a view for a URL
//	Remarks/Portability/Dependencies/Restrictions:
//	Revision History:
//		03-28-94	created
#define Uses_TProgram
#define Uses_TDeskTop
#define Uses_TDialog
#define Uses_TInputLine
#define Uses_THistory
#define Uses_TButton
#define Uses_TLabel
#include"turlview.h"
#include<string.h>

void TURLView::search(const char *cp_searchFor)	{
//	Purpose:	Search for a string in the view.
//	Arguments:	cp_searchFor	The string to search for.
//					If NULL then the user is prompted to
//					enter a string.
//	Return Value:	void
//	Remarks/Portability/Dependencies/Restrictions:
//	Revision History:
//		03-28-94	created

	auto char *cp_searching = NULL;

	//	Prompt the user for the search string if need be.
	if(cp_searchFor == NULL || *cp_searchFor == '\0')	{
		//	A dialog must be created to ask the user for
		//	the string to search for.

		//	General use rectangle.
		auto TRect TR(0, 0, 50, 7);

		//	Create a dialog that asks for the search string.
		TDialog *TDp_index = new TDialog(TR, "Search");
		if(TDp_index == NULL)	{
			doslynxmessage("Unable to create index dialog.");
			return;
		}

		//	Set some dialog options.
		TDp_index->options |= ofCentered;

		//      Make the input line to enter the search string.
		TR = TRect(6, 2, 44, 3);
		TInputLine *TILp_searchString = new TInputLine(TR,
			usi_TILURLSize - 1);
		TDp_index->insert(TILp_searchString);


		//	Make the input line's label.
		TR = TRect(5, 1, 27, 2);
		TLabel *TLp_prompt = new TLabel(TR, "~E~nter a Search String",
			TILp_searchString);
		TDp_index->insert(TLp_prompt);

		//	Make the input line's history.
		TR = TRect(45, 2, 48, 3);
		THistory *THp_indexHist = new THistory(TR, TILp_searchString,
			usi_IndexHist);
		TDp_index->insert(THp_indexHist);

		//	Insert the Ok and Cancel buttons.
		auto TButton *TBp_button;
		TR = TRect(9, 4, 21, 6);
		TBp_button = new TButton(TR, "~O~K", cmOK, bfDefault);
		TDp_index->insert(TBp_button);
		TR = TRect(24, 4, 36, 6);
		TBp_button = new TButton(TR, "~C~ancel", cmCancel, bfNormal);
		TDp_index->insert(TBp_button);

		//	Stay in the search string field.
		TDp_index->selectNext(False);

		//	Draw the dialog.
		TDp_index->drawView();

		//	Execute the dialog.
		if(TProgram::deskTop->execView(TDp_index) != cmCancel)	{
			//	User didn't cancel, save what we got.
			auto char ca_buffer[usi_TILURLSize];
			TILp_searchString->getData(ca_buffer);
			cp_searching = newStr(ca_buffer);
		}
		else	{
			//	User canceled.
			return;
		}

		//	Done with dialog.
		destroy(TDp_index);

		//	Reset from where we last searched.
		usi_lastSearchLine = usi_lastSearchOffset = 0U;
	}
	else	{
		//	Copy over the already entered search string.
		cp_searching = newStr(cp_searchFor);
	}

	//	If there exists no search string, do nothing.
	if(cp_searching == NULL || *cp_searching == '\0')	{
		if(cp_searching != NULL)	{
			delete(cp_searching);
		}
		return;
	}

	//	Now, search for the string from the last line and offset
	//	searched forward.
	auto Line L_search;
	auto char ca_linebuf[usi_TILURLSize];
	auto char *cp_foundat;
	while(fsp_temp->eof() == 0 && fsp_temp->bad() == 0)	{
		//	Check to make sure we have not gone past the last
		//	line.
		if(usi_lastSearchLine >= TNSCp_lines->getCount())	{
			doslynxmessage(cp_searching << " not found.");
			if(TAp_search != NULL)	{
				delete(TAp_search);
				TAp_search = NULL;
			}
			drawView();
			break;
		}

		//	 Seek the line offset.
		fsp_temp->seekg((signed long int)(TNSCp_lines->at(
			usi_lastSearchLine)));

		//	Get the line information.
		fsp_temp->read((char *)(&L_search), sizeof(Line));
		if(fsp_temp->gcount() != sizeof(Line))	{
			doslynxmessage("Error in reading temporary file.");
			break;
		}

		//	If our last search offset is greater than the line
		//	length, reset the offset and go on to the next line.
		if(usi_lastSearchOffset >= L_search.ssi_length)	{
			usi_lastSearchOffset = 0U;
			usi_lastSearchLine++;
			continue;
		}

		//	Seek out to the last search offset.
		fsp_temp->seekg((signed long int)usi_lastSearchOffset,
			ios::cur);

		//	Read the remainder of the line.
		fsp_temp->read(ca_linebuf, L_search.ssi_length -
			usi_lastSearchOffset);
		if(fsp_temp->gcount() != L_search.ssi_length -
			usi_lastSearchOffset)	{
			doslynxmessage("Error in reading temporary file.");
			break;
		}

		//	End the read information line.
		ca_linebuf[L_search.ssi_length - usi_lastSearchOffset] = '\0';

		//	Search for the string.
		if((cp_foundat = strstr(ca_linebuf, cp_searching)) == NULL)
		{
			//	Not found, go on to the next line.
			usi_lastSearchOffset = 0U;
			usi_lastSearchLine++;
			continue;
		}

		//	String was found in the line.

		//	If we don't have one already, create the search
		//		text attribute.
		if(TAp_search == NULL)	{
			TAp_search = new TextAttribute(NULL);
		}
		TAp_search->Begin((signed long int)(TNSCp_lines->
			at(usi_lastSearchLine)) + (signed long int)
			usi_lastSearchOffset + (signed long int)(cp_foundat -
			ca_linebuf) + (signed long int)sizeof(Line));
		TAp_search->End(TAp_search->getBegin() + (signed long int)
			strlen(cp_searching));

		//	Set our offset past the find.
		usi_lastSearchOffset += (unsigned short int)(cp_foundat -
			ca_linebuf) + strlen(cp_searching);

		//	Save our deltas so that we know if the screen was
		//	redrawn.  This is a kludge to have our searched for
		//	string light up.
		auto TPoint TP_old = delta;

		//	Don't draw if already on the screen.
		if(usi_lastSearchLine >= delta.y + size.y ||
			usi_lastSearchLine < delta.y)	{
			scrollTo(delta.x, usi_lastSearchLine);
		}

		//	Check to see if screen moved, if not we will redraw.
		if(TP_old == delta)	{
			drawView();
		}

		break;
	}

	//	Clear the temp file status.
	fsp_temp->clear();

	//	Done, release the search string after copying it into
	//	the global last search variable.
	strcpy(ca_searchLast, cp_searching);
	delete(cp_searching);
}