/* Enumeration of modes. You probably won't have to worry about these
	directly since they correspond to the array of names below and you
  can just stick them on a menu and pass the index of the chosen
  mode. */

typedef enum {
  image_mode_cga,
  image_mode_ega,
  image_mode_herc,
  image_mode_vga_640x480x16,
#ifndef RELEASE
  image_mode_vga_320x200x256,
  image_mode_svga_640x480x256,
  image_mode_svga_800x600x256,
  image_mode_svga_1024x768x256,
#endif /* RELEASE */
  image_modes_total
} image_modes;

/* Correspond to entries above; just stick image_mode_names[0] through
	image_mode_names[image_modes_total-1] on a menu. */

extern char *image_mode_names[];

signed short image_viewer(const char *fname, image_modes mode);

