//	Copyright (c) 1993, University of Kansas, All Rights Reserved
//
//	Class:		TURLWindow
//	Include File:	turlwind.h
//	Purpose:	Provide a window for a URL
//	Remarks/Portability/Dependencies/Restrictions:
//	Revision History:
//		12-27-93	created
//		02-09-94	Split all members into seperate files.
#include"turlwind.h"
#include"trace.h"

TURLWindow::~TURLWindow()	{
//	Purpose:	Destructor for the URL window.
//	Arguments:	void
//	Return Value:	none
//	Remarks/Portability/Dependencies/Restrictions:
//	Revision History:
//		01-30-94	created

#ifndef RELEASE
	trace("Destroying window.");
#endif // RELEASE
	//	If there is a view, remove it, destroy it.
	if(TURLV != NULL)	{
		remove(TURLV);
		destroy(TURLV);
	}

	//	If there is a collection, free it.
	if(TNSCp_visited != NULL)	{
		destroy(TNSCp_visited);
	}

	//	Set the window number as of now being free.
	Number(number);

	//	Disable some commands.
	disableCommand(cmSearchIndex);
}
