//	Copyright (c) 1994, University of Kansas, All Rights Reserved
//
//	Class:		TURLWindow
//	Include File:	turlwind.h
//	Purpose:	Provide a window for a URL view.
//	Remarks/Portability/Dependencies/Restrictions:
//	Revision History:
//		03-04-94	created
#include"turlwind.h"

signed short int TURLWindow::Number(signed short int ssi_Win)	{
//	Purpose:	Find a free window number, and mark it as used, or
//			unmark the specified number as not being used.
//	Arguments:	ssi_Win	When ssi_Win is specified as -1, the default
//				value, a free number will be found, otherwise
//				the value of ssi_Win is marked as being free.
//	Return Value:	signed short int	The free window number.
//	Remarks/Portability/Dependencies/Restrictions:
//		Do not be confused by the duplicity of this function.  It's
//		purpose is simple, find a free window number to use, or
//		clear the specified window number as not being used.
//	Revision History:
//		03-04-94	created

	if(ssi_Win == -1)	{
		//	Find a free window number.
		signed short int ssi_findFree;
		for(ssi_findFree = 0; ssi_findFree <= 8; ssi_findFree++)
		{
			if(B_freeWin[ssi_findFree] == True)	{
				break;
			}
		}

		//	Return the free number.
		//	Mark it as used.
		if(ssi_findFree <= 8)	{
			B_freeWin[ssi_findFree] = False;
			return(ssi_findFree + 1);
		}

		//	No free window numbers.
		return(wnNoNumber);
	}

	if(ssi_Win > 0 && ssi_Win <= 9)	{
		//	Mark the window number as now free.
		B_freeWin[ssi_Win - 1] = True;
	}
	//	Return just for the hell of it.
	//	Should consider this a meaningless value.
	return(ssi_Win);
}