;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Copyright (c) 1993, 1994 by William M. Perry (wmperry@spry.com)
;;;
;;; This file is not part of GNU Emacs, but the same permissions apply.
;;;
;;; GNU Emacs is free software; you can redistribute it and/or modify
;;; it under the terms of the GNU General Public License as published by
;;; the Free Software Foundation; either version 2, or (at your option)
;;; any later version.
;;;
;;; GNU Emacs is distributed in the hope that it will be useful,
;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;; GNU General Public License for more details.
;;;
;;; You should have received a copy of the GNU General Public License
;;; along with GNU Emacs; see the file COPYING.  If not, write to
;;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;; New hotlist interface, similar to AIR Mosaics
;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; General plan:
;;; 1. Have forms for adding to a hotlist
;;;    o New x-hotlist url: x-hotlist://add/path/to/hotlst/file.hot?xxxx
;;;

(defvar w3-hotlist-def-file
  (expand-file-name "~/.w3-hot")
  "*The file where W3 can find all the definitions for further
hotlist files and whether they are menus or not.")

(defun url-grok-x-hotlist-url (url)
  (if (not (string-match "x-hotlist://\\([^/]+\\)\\(/[^?]+\\)\\?+\\(.+\\)"
			 url))
      (error "Malformed x-hotlist url: %s" url))
  (list nil (downcase (url-match url 1))
	nil (url-match url 2) (url-match url 3)))

(defun w3-grok-form-request (str)
  "Return an assoc list of name and value pairs form an
x-www-form-urlencoded string."
  (save-excursion
    (set-buffer (get-buffer-create " *url-tmp*"))
    (erase-buffer)
    (insert str)
    (subst-char-in-region (point-min) (point-max) ?& ? )
    (mapcar
     (function
      (lambda (x)
	(cons (w3-unhex-string (car x)) (w3-unhex-string (cdr x)))))
     (w3-parse-args (point-min) (point-max)))))

(defun url-x-hotlist (url)
  (let* ((info (url-grok-x-hotlist-url url))
	 (action (nth 1 info))		; one of add or delete
	 (fname  (nth 3 info))		; full path to the hotlist to act on
	 (data   (w3-grok-form-request (nth 4 info))))	; Misc. info
    (save-excursion
      (set-buffer (get-buffer-create " *url-tmp*"))
      (erase-buffer)
      (if (not (and (file-exists-p fname)
		    (file-readable-p fname)
		    (file-writable-p fname)))
	  (error "Can not modify %s!" fname))
      (insert-file-contents fname)
      )))
  
