/* Copyright (c) Piete Brooks 1988 */
#ifndef	lint
char _RCSId[]="$Header: /Nfs/heaton/glob/src/etc/x25d/src/RCS/commond.c,v 1.15 1991/07/17 09:19:54 pb Exp $";
#endif	lint

/* #include <ctype.h> */

int	line_no = 0;

char *make_regexp(str)
char *str;
{	static	char	buff[1024];
	register char *bufp = buff;
	if (use_regexp || !str || !*str)	return str;

	*bufp++ = '^';
	while(*str) switch (*str)
	{
	case '^':
	case '$':
	case '.':
	case '[':
	case '(':
	case ')':
	case '+':
	case '\\':	*bufp++ = '\\';
	default:	*bufp++ = *str++;			break;
	case '?':	*bufp++ = '.'; str++;			break;
	case '*':	*bufp++ = '.';	*bufp++ = *str++;	break;
	case '|':	*bufp++ ='$';*bufp++= *str++;*bufp++='^';break;
	}
	*bufp++ = '$';
	*bufp = '\0';
	return buff;
};


clear_format(form, zap)
struct format *form;
{
#define	freeup(x)	if (x && zap) free(x);
	freeup(form->p_called_dte);
	freeup(form->p_called_aef);
	freeup(form->p_called_addr);
	freeup(form->p_calling_addr);
	freeup(form->l_command);
	freeup(form->x_banner);
	freeup(form->l_comname);
	freeup(form->l_telnet);
	freeup(form->l_tel_port);
	freeup(form->l_rest);
#undef	freeup
	bzero(form, sizeof (struct format));
	form->l_uid = -1;
	form->l_gid = -1;
	form->l_cug = -1;
}

char *lower(str)
char *str;
{
	register char *s = str;
	if (!str)	return str;

	for (s = str; *s; s++) if (isupper(*s)) *s = tolower(*s);

	return str;
}

grimreaper()
{
  union wait status;
  int pid;

  while ((pid = wait3(&status, WNOHANG, /* NOSTRICT */ 0)) > 0)
  {	int i;
	if (debug & D_CONN) logit(7, "%04x gave %04x\n", pid, status);

	for (i=0; i< MAX_CHILD; i++) if (children[i].pid == pid)
	{	children[i].pid = 0;
		if (children[i].type >= 0 && auth_count[children[i].type])
			auth_count[children[i].type]--;
		break;
	}
	if (i >= MAX_CHILD && (debug & D_ERR))
		logit(1, "Didn't find %04x\n", pid);
  }
}

close_with_diag(fd, clear, diag, exit_rc)
{
	return close_with_diag_and_data(fd, clear, diag, exit_rc, (char *) 0, 0);
}

close_with_diag_and_data(fd, clear, diag, exit_rc, buff, len)
char *buff;
{
	if (debug & D_FAIL)
		logit(1, "close_with_diag fd=%d, %x %x, exit=%x (%x:%d)\n",
		fd, clear, diag, exit_rc, buff, len);
	switch(call_type)
	{
#ifdef	X25_TCP
	case ADDR_TCP:	close(fd);				break;
#endif	X25_TCP
#ifdef	X25
	default:	diag_close_data(fd, clear, diag, exit_rc, buff, len);
								break;
#endif	X25
	}
	if (exit_rc)	exit(exit_rc);
}

/* Read the x29-auth file.
 * Takes no arguments as it may be called by a HUP signal
 */
void read_auth()
{	char line[256];
	char hostname[256];
	FILE *file = fopen(authfile, "r");
	int	n_formats = 0;
	int	ifhost = 0;
	struct stat	statbuf;
	char *data;

	use_regexp	= 0;
	*hostname	= '\0';
	auth_format	= def_auth_format;
	(void) time(&last_auth);

	if ((last_auth - last_log) > logfile_short_interval)
		init_deb("auth read");

	line_no = 0;

	if (!file)
		add_line(def_auth, &n_formats);
	else
	{   int ignore = 0;
	    while (fgets(data=line, sizeof line, file))
	    {	int len = strlen(line);
		int ignore_inc = 0;
		line_no ++;
		if (line[len-1] == '\n') line[--len] = '\0';

		/* if (*line == "#") */
		if (!strncmp(line, IFHOST_PRAGMAT, sizeof IFHOST_PRAGMAT -1))
		{	char *name = line + sizeof IFHOST_PRAGMAT -1;
			if (ifhost) logit(0, "read_auth: nested %s\n",
					IFHOST_PRAGMAT);
			while (isspace(*name)) name++;
			if (!*hostname) gethostname(hostname, sizeof hostname);
			if (strcmp(hostname, name))	ifhost = -1;
			else				ifhost = 1;
		}
		if (!strncmp(line, ELIFHO_PRAGMAT, sizeof ELIFHO_PRAGMAT -1))
		{	char *name = line + sizeof ELIFHO_PRAGMAT -1;
			if (!ifhost) logit(0, "read_auth: %s without %s\n",
				ELIFHO_PRAGMAT, IFHOST_PRAGMAT);
			while (isspace(*name)) name++;
			if (!*hostname) gethostname(hostname, sizeof hostname);
			if (strcmp(hostname, name))	ifhost = -1;
			else				ifhost = 1;
		}
		if (!strncmp(line, ELSEHO_PRAGMAT, sizeof ELSEHO_PRAGMAT -1))
		{	if (!ifhost) logit(0, "read_auth: %s without %s\n",
				ELIFHO_PRAGMAT, IFHOST_PRAGMAT);
			ifhost = -ifhost;
		}
		if (!strncmp(line, ENDIFH_PRAGMAT, sizeof ENDIFH_PRAGMAT -1))
		{	if (!ifhost) logit(0, "read_auth: %s without %s\n",
				ELIFHO_PRAGMAT, IFHOST_PRAGMAT);
			ifhost = 0;
		}
		if (ifhost < 0)	continue;
		if (!strncmp(line, NOREGEXP_PRAGMAT, sizeof NOREGEXP_PRAGMAT -1))
			use_regexp = 0;
		if (!strncmp(line, IGNORE_PRAGMAT, sizeof IGNORE_PRAGMAT -1))
			ignore = 2;
		if (!strncmp(line, REGEXP_PRAGMAT, sizeof REGEXP_PRAGMAT -1))
			use_regexp = 1;
		if (!strncmp(line, FORMATX29_PRAGMAT, sizeof FORMATX29_PRAGMAT -1))
			auth_format = FORMAT_X29;
		if (!strncmp(line, FORMATYBTS_PRAGMAT, sizeof FORMATYBTS_PRAGMAT -1))
			auth_format = FORMAT_YBTS;
		if (!strncmp(line, FORMATGETOPT_PRAGMAT, sizeof FORMATGETOPT_PRAGMAT -1))
			auth_format = FORMAT_GETOPT;
		if (!strncmp(line, DO_PRAGMAT, sizeof DO_PRAGMAT -1))
			data += sizeof DO_PRAGMAT-1;
		if (!strncmp(line, ONLYHOST_PRAGMAT, sizeof ONLYHOST_PRAGMAT -1))
		{	char *name = line + sizeof ONLYHOST_PRAGMAT -1;
			while (isspace(*name)) name++;
			data = name;
			while (*data && ! isspace(*data)) data++;
			if (*data) *data++ = '\0';
			if (!*hostname) gethostname(hostname, sizeof hostname);
			if (strcmp(hostname, name))	ignore = 1;
			else				ignore_inc = 1;
		}

		/* Skip leading white space */
		while(isspace(*data)) data++;
		/* Comment and blank lines are skipped */
		if (ignore-- > 0 || ifhost < 0 || *data == '#' || !*data)
				continue;
	
		add_line(data, &n_formats);
		ignore += ignore_inc;
	    }
	    if (!fstat(fileno(file), &statbuf))
	   	 auth_timestamp = statbuf.st_mtime;
	    time(&last_auth);
	    fclose(file);
	}
	if (n_formats) formats = n_formats;
}

#define	match(prog, str) ((!prog) || regexec(prog, str))

/* ARGSUSED */
valid_request(called_addr, calling_addr, scan)
char *called_addr;
char *calling_addr;
{	int i;

	if (formats <= 0) read_auth();
	for(i=0; i<formats; i++)
	{	int type_flags = format[i].l_flags & (LF_X29 | LF_TS29);
		if (type_flags)
		{	if ( ts29 && !(type_flags & LF_TS29))	continue;
			if (!ts29 && !(type_flags & LF_X29))	continue;
		}
		if(!match(format[i].p_calling_addr, calling_addr)) continue;
		if(!match(format[i].p_called_addr,  called_addr )) continue;
		if(!match(format[i].p_called_dte,   called_dte  )) continue;
		if(!match(format[i].p_called_aef,   called_aef  )) continue;
		if(format[i].l_scan > scan)			   continue;
		return i;
	}
	return -1;
}

char *save_str(s)
char *s;
{	char *new;
	if (!s)	return s;

	new = malloc(strlen(s) +1);

	if (!new) return new;

	strcpy(new, s);
	return new;
}

format_copy(to, from, expand, copy)
struct format *to;
struct format *from;
{
	clear_format(to, 1);
#define	may_copy(x)	(copy) ? save_str(x) : x
#define	may_expand(x)	(x) ? regcomp((expand)?make_regexp(x) :x) :(regexp *)0
	to->p_called_aef	= may_expand(lower(from->s_called_aef));
	to->p_called_dte	= may_expand(lower(from->s_called_dte));
	to->p_called_addr	= may_expand(lower(from->s_called_addr));
	to->p_calling_addr	= may_expand(lower(from->s_calling_addr));
	to->l_command		= may_copy(from->l_command);
	to->x_banner		= may_copy(from->x_banner);
	to->l_comname		= may_copy(from->l_comname);
	to->l_telnet		= may_copy(from->l_telnet);
	to->l_tel_port		= may_copy(from->l_tel_port);
	to->l_rest		= may_copy(from->l_rest);
	to->l_flags		= from->l_flags;
	to->l_uid		= from->l_uid;
	to->l_gid		= from->l_gid;
}

char *decode_flags(form, line, colon)
struct format *form;
char *line;
{	char *getopts = "A:C:FG:HMNS:Ta:b:c:d:g:n:p:rst:u:xy";
	char *argv[20];
	int argc=0;
	char c;
	char *newp = line;
	int i;

	argv[argc++] = "decode_flags";
	argv[argc++] = newp;
	if (form->l_flags) logit(1,"Flags=%x before %s\n",form->l_flags,line);
	while((c = *line++) && c != colon) switch(c)
	{
	case '\t':
	case ' ':	while(*line == ' ' || *line == '\t') line++;
			*newp++ = '\0'; argv[argc++] = newp;	break;
	case '\\':	switch (*line)
			{
			case 'r':	c = '\r';	break;
			case 'n':	c = '\n';	break;
			case 't':	c = '\t';	break;
			case 's':	c = ' ';	break;
			default:	c = *line;	break;
			}
			line++;
	default:	*newp++ = c;				break;
	}
	*newp = '\0';

	optind = 1;
	while ((i = getopt(argc, argv, getopts)) != EOF) switch(i)
	{
	default:
		logit(1, "%s: bad args on line %d for: %s [%s] (%s/%s) -",
			*argv, line_no, *argv, getopts, argv[optind],
			argv[optind-1]);
		for(i=0; i<argc; i++) logit(0, " \"%s\"", argv[i]);
		logit(0, "\n");
		return line;
	case 'A': form->s_called_aef	 = optarg;			break;
	case 'C': form->l_cug		 = atoi(optarg);		break;
	case 'F': form->l_flags		|= LF_FORK;			break;
	case 'G': form->s_calling_addr	 = optarg;			break;
	case 'H': form->l_flags		|= LF_HIDE;			break;
	case 'M': form->l_flags		|= LF_MESSAGE;			break;
	case 'N': form->l_flags		|= LF_NATIVE;			break;
	case 'S': form->l_scan		 = atoi(optarg);		break;
	case 'a': form->s_called_dte	 = optarg;			break;
	case 'b': form->x_banner	 = optarg;			break;
	case 'c': form->l_command	 = optarg;			break;
	case 'd': form->s_called_addr	 = optarg;			break;
	case 'g': form->l_gid		 = atoi(optarg);		break;
	case 'n': form->l_comname	 = optarg;			break;
	case 'r': form->l_flags		|= LF_REV_CHARGE;		break;
	case 's': form->l_flags		|= LF_TS_NOACC;			break;
#ifdef	TELNET
	case 'p': form->l_tel_port	 = optarg;			break;
	case 't': form->l_telnet	 = optarg;			break;
	case 'T': form->l_flags		|= LF_ONLY_TELNET;		break;
#endif	TELNET
	case 'u': form->l_uid		 = atoi(optarg);		break;
	case 'x': form->l_flags		|= LF_X29;			break;
	case 'y': form->l_flags		|= LF_TS29;			break;
	}

	return line;
}

int add_line(line, np)
char *line;
int *np;
{	struct format form;
	char *cp;
	clear_format(&form, 0);
	switch(auth_format)
	{
	default:	logit(1, "Unrecognised format %d\n", auth_format);

	case FORMAT_X29:
	if ((cp=line) && (line=index(form.s_calling_addr=line, ':'))) *line++ = '\0';
	if (cp = index(cp, '@')) { *cp++ = '\0'; form.l_command = cp; }
	else					 form.l_command = DEF_COMMAND;
	if (line && *line) line = decode_flags(&form, line, ':');
	if (line && *line) form.l_rest=line;
	break;
	case FORMAT_YBTS:
	if (line && (line=index(form.l_command=line, ':'))) *line++ = '\0';
	if (line && (line=index(form.s_called_addr=line, ':'))) *line++ = '\0';
	if (line && (line=index(form.s_calling_addr=line, ':'))) *line++ = '\0';
	if (line && *line) line = decode_flags(&form, line, ':');
	if (line && *line) form.l_rest=line;
	break;
	case FORMAT_GETOPT:
	decode_flags(&form, line, '\0');
	}
	if (*np >= MAX_AUTH)
	{	static int warned = 0;
		if (!warned++)
			logit(1, " *** Too many auth lines (%d)\n", MAX_AUTH);
	}
	else
	{	format_copy(&format[*np], &form, 1, 1);
		(*np)++;
	}
}

logit(stamp, s, a,b,c,d,e,f,g,h,i,j)
char *s;
{	logit_file(debfile, stamp, s, a,b,c,d,e,f,g,h,i,j);
}

logit_file(file, stamp, s, a,b,c,d,e,f,g,h,i,j)
FILE *file;
char *s;
{
	extern char *sys_errlist[];
	extern	sys_nerr;
	

	if (file)
	{	int too_many = 0;
		if (logit_counts && logit_counts-- < 0)
		{	too_many++;
			stamp |= 3;
		}
		if (stamp & 1)	fprintf(file, "%04x: ", my_pid);
		if (stamp & 2)	fprintf(file, "%s: ", get_dat());
		if (stamp & 4)	fprintf(file, "%d: ", errno);
		if (stamp & 8)	fprintf(file, "%s: ", 
			(errno < 0 || errno > sys_nerr) ? "<unknown errno>" :
			sys_errlist[errno]);
		if (too_many)
		{	if (file) fprintf(file, "++ ** Too Many Errors **\n");
			exit (99);
		}
		fprintf(file, s, a,b,c,d,e,f,g,h,i,j);
		fflush(file);
	}
}

#ifndef	VESRION
#include "version.h"
#endif	/* VERSION */

char *ver_string(string, lenp)
char *string;
int *lenp;
{	char * version = index((string) ? string : VERSION, ':');
	char *comma;
	int len;
	if (! version)	return version;

	version += 2;
	comma = index(version, ',');
	if (comma)
	{	while (comma[-1] != '/' && comma != version) comma--;
		version = comma;
	}
	if (lenp) (*lenp) = strlen(version) -2;
	return version;
}

/* Open or re-open the debug file */
init_deb(reason)
char *reason;
{	int n_debfd = -2;
	FILE * n_debfile = (FILE *) 0;
	int named_file = (*logfile && strcmp(logfile, "-"));
	int have_one	= debfile != (FILE *) 0;
	int real_one	= debfile && (debfile != stderr);
	int got_std	= -1;

	(void) time(&last_log);

	/* Log what we hope to do */
	if (debfile && (!inetd || real_one))
	{	if (debug & D_LOGF) logit(3, "%spening log file %s ....\n",
			(named_file && !real_one) ? "O" : "Reo",
			(named_file) ? logfile :"stderr");
		fflush(debfile);
	}

	/* If we have a file name, open it. If not and no debfile, use fd 2 */
	if (named_file)
		n_debfd = open(logfile, O_WRONLY | O_APPEND | O_CREAT, 0644);
	else if (!have_one)
		n_debfd = dup(2);


	/* It's a BAD IDEA to open stdin, stdout or stderr as log file ! */
	if (0 <= n_debfd && n_debfd <= 2) n_debfd = nonstdfd(n_debfd, &got_std);

	/* If we opened the fd, try making a stream */
	if (n_debfd == -2)
		;
	else if	(n_debfd >= 0)
	{	n_debfile=fdopen(n_debfd,"a");
		if (n_debfile)
		{	int len;
			char * version = ver_string(VERSION, &len);

			if (debfile != stderr) fclose(debfile);
			debfile = n_debfile;
			debfd = n_debfd;
			if (debug & D_LOGF) logit(3, "%d: %sopened log file %s on %d (%s)\n", 
				my_pid, (named_file && !real_one) ? "" : "re",
				(named_file) ? logfile : "stderr",
				fileno(debfile), reason);
			if (got_std != -1) if (debug & D_LOGF) logit(1, "got_std was %08x\n", got_std);
			if (version) if (debug & D_LOGF) logit(1, "ver: %*.*s\n", len,len, version);
		}
		else
		{	close(n_debfd);
			if (debug & D_LOGF) logit_file((debfile) ? debfile : stderr,
				15, "Failed to open %s stream\n",
				(named_file) ? logfile : "stderr");
		}
	}
	else	logit_file((debfile) ? debfile : stderr,
			15, "Failed to open %s\n",
			(named_file) ? logfile : "stderr");

}

char **split_argv(buff, len)
register char *buff;
{	static char *args[MAXARGS];
	register char **ap = args;

	ap = args;
	while (*buff) {
		while (*buff == ' ' || *buff == '\t')	buff++;
		if (*buff == '"')
		{	buff++;
			if (ap < &args[MAXARGS-2])	*ap++ = buff;
			while (*buff && *buff != '"')	buff++;
		}
		else
		{	if (ap < &args[MAXARGS-2])	*ap++ = buff;
			while (*buff && *buff != ' ' && *buff != '\t')	buff++;
		}
		if (*buff)				*buff++='\0';
	}
	*ap = 0;
	return args;
}

/* Look for $name[+lead][-trail]
 * If name found, sunstitute it's value with lead bytes stripped
 * off the front, and trail off the end
 */
expand_dollar(to, from, len)
register char *from;
register char *to;
{	register char c;
	register i;

	for(; c= *from; *from++) switch(c)
	{
	case '$':
		for(i=0; i<NAMES; i++)
		{   if (strncmp(names[i].name, from+1, names[i].len)==0)
		    {	int lead = 0;
		    	int trail = 0;
			from += names[i].len;
			if (from[1] == '+')
				while('0' <= (c=(++from)[1]) && c <= '9')
					lead = lead*10 + c - '0';
			if (from[1] == '-')
				while('0' <= (c=(++from)[1]) && c <= '9')
					trail = trail*10 + c - '0';
			strcpy(to, (*(names[i].val)) + lead);
			while (*to) to++;
			while (trail-- > 0) to--;
			c = 0;
		}   }
		if (!c)					break;
	default:*to++ = c;				break;
	}
	*to = '\0';
}

char *get_dat()
{	
	long this_time = time(0L);
	char *this_dat = ctime(&this_time);

	this_dat[16] = '\0';		/* Remove sec, year & \n */
	return this_dat + 4;		/* remove day of week */
}

isprints(s)
register char *s;
{	for (; *s; s++) if (!isprint(*s)) return 0;
	return 1;
}

#ifdef	X25_TCP
x25b_logit(mask, format, a1, a2, a3, a4)
{
	fprintf(debfile ? debfile : stderr, format, a1, a2, a3, a4);
}

x25b_perror(mask, format, a1, a2, a3, a4)
{
	fprintf((debfile) ? debfile : stderr, format, a1, a2, a3,a4);
	fflush(stderr);
	perror("");
}

int x25b_debug = 1;
#endif	X25_TCP

send_kill(name)
char *name;
{	FILE *kill_f;
	int pid = 0;

	if (!kill_file || !*kill_file)
	{	logit(3, "No kill file, so cannot kill server\n");
		return 2;
	}

	if (!(kill_f = fopen(kill_file, "r")))
	{	logit(15, "failed to open kill file `%s'\n", kill_file);
		return 3;
	}

	if (fscanf(kill_f, "%d", &pid) != 1 || pid == 0)
	{	logit(3, "failed to read pid from `%s'\n", kill_file);
		fclose(kill_f);
		return 4;
	}

	fclose(kill_f);

	if (pid < 5)
	{	logit(3, "Invalid process id %d (%x)\n", pid, pid);
		return 4;
	}

	if (kill(pid, SIGHUP) == 0)
	{	logit(3, "Hupped %d (%x)\n", pid, pid);
	}
	else if (kill(pid, 0) == 0)
	{	logit(15, "Kill of %d (%x) failed\n", pid, pid);
		return 5;
	}
	else
	{	logit(3, "There is no process %d (%x)\n", pid, pid);
		return 5;
	}
	return 0;
}

is_inetd_arg(arg1)
char *arg1;
{
	register int i;
	for (i=0; i<8; i++) if (!isxdigit(arg1[i])) return 0;
	if (arg1[i++] != '.') return 0;
	for (; arg1[i]; i++) if (!isdigit(arg1[i])) return 0;
	return 1;
}

nonstdfd(fd, vecp)
int fd;
long *vecp;
{       int n1 = dup(fd);
	int n2 = dup(fd);
	int n3 = dup(fd);
	if (vecp) *vecp = (fd & 0xff) | ((n1 && 0xff) << 8) |
		((n2 && 0xff) << 16) | ((n3 && 0xff) << 24);
	if (n3 >= 0) { close(fd); fd = n3; }
	close(n1);
	close(n2);
	return fd;
}

/* Convert uk.ac.foo.bar+rest to rest+bar.foo.ac.uk */
uk2us(to, from)
char *to, *from;
{
	char buff[128];
	char *ptr;

	strcpy(buff, from);

	*to = '\0';

	ptr = index(buff, '+');
	if (ptr)
	{	*ptr++ = '\0';
		strcat(to, ptr);
		strcat(to, "+");
	}
	while (ptr = rindex(buff, '.'))
	{	
		*ptr++ = '\0';
		strcat(to, ptr);
		strcat(to, ".");
	}
	strcat(to, buff);
}
