/*	********************** SUNLINK 5.0 BUGS ***************************
 *
 *
 * SUNFACILBUG
 *	It appears that whenever I try to read the facilities assosiated
 *	with an incoming call, I actually get the facilities which I was
 *	willing to accept, rather than the facilities actually used.
 *	E.g. if I say that I am WILLING to accept reverse charge calls,
 *	then it appears that EVERY call arrives with reverse charging.
 *
 * Fix	Only ask for reverse charge calls if one of the entries allowed it
 *	and set up separate listeners for normal & reverse charge
 *
 *
 * SUNCUDFBUG
 *	V5.0 appears to put the CUDF data into &from.data[1] rather than
 *	from.data (they say that this is a known problem but not a bug).
 *
 * Fix	Fairly reliable: I KNOW that I asked for the first byte of the
 *	CUDF to be 0x01 (x29), so if it is 0x00, then I have the bug.
 *
 *
 * SUNACPTBUG
 *	If an incoming call is closed before it has been accepted,
 *	then the process (even if unpriveledged) falls over and causes
 *	the kernel to panic.
 *
 * Fix	Always accept the call (sigh).
 *	If it is to be rejected, immediately close it ...
 *
 *
 * SUNACPTAPPROVALBUG
 *	It appears that contrary to the documemntation, it is neccessary
 *	to accept all calls, even if X25_CALL_ACPT_APPROVAL has not been
 *	set.
 *
 * Fix	Always accept the call if you want it (does no harm)
 *
 *
 * SUNSTTYCOLSONLY
 *	It appears if a program tries to set the number of columns while
 *	the number of rows is zero, it actually sets the number of rows
 *	to the requested number of columns
 *
 * Fix	only try to set the columns if the rows are set
 *
 * 
 * SUNX25BITSBUG
 *	It appears that the X.25 header bits are saved/stripped when
 *	the X.25 packet arrives, rather than when the data is read.
 *	Thus if there is waiting data when you set X25_HEADER, you will
 * 	be confused.
 *
 * Fix	Set X25_HEADER ASAP & if the first byte contains bits other than
 *	Q, M or D, then shift it down by one byte.
 *
 *
 * SUNMOREBITBUG
 *	It appears if a program sets X25_RECORD_SIZE non-zero, then
 *	resets it to zero, the complete message arrives, but the more
 *	bit is set it it is multiple packets
 *
 * Fix	ignore M bit if X25_RECORD is zero
 *
 *
 * SUBADR_ONLY
 *	It is not possible to listen on a subaddress ignoring main part of DTE
 *
 * Fix	Prefix the current default address
 *
 *
 * X25_RD_LOCAL_ADR
 *	It is not possible to find the called address
 *
 * Fix	Listen on each sub address explicitly.
 * 
 * 
 * SUNINHERITBUG
 *	Certain facilities are not inherited from the listening socket by the
 *	accept()ed socket, or are not documented as such.
 *
 *
 *	********************** SUNLINK 6.0 BUGS ***************************
 *
 * SUNSTTYCOLSONLY, SUNACPTAPPROVALBUG & SUNFACILBUG still present
 * SUNX25BITSBUG now documented as a "feature"
 *
 *
 * SUNCUDF2BUG
 *      V6.0 appears to put the CUDF data into &from.data[-1] rather than
 *      from.data on sun4s.  This means that the data length is lost.
 *
 * Fix	Fairly reliable: I know the length of the object returned.
 *	I know how much pre-amble there is to the address.
 *	This real length == actual length - pre-amble
 *
 * 
 * SUNACPT2BUG
 *	If an incoming call is closed before it has been accepted,
 *	then the clearing codes are junked.
 *
 * Fix	If the call is to be rejected, accept it and immediately close it ...
 *
 */

/* IF running on a sun THEN UNLESS user says no sunlink DO assume SUNLINK */
#ifdef	sun
#ifndef	NOSUNLINK
#ifndef	SUNLINK
#define	SUNLINK
#endif	SUNLINK
#endif	NOSUNLINK
#endif	sun

/* Assume X25_TCP by default */
#ifndef	NOX25_TCP
#ifndef	X25_TCP
#define	X25_TCP
#endif	X25_TCP
#endif	NOX25_TCP

/* Assume TELNET by default */
#ifndef	NOTELNET
#ifndef	TELNET
#define	TELNET
#endif	TELNET
#endif	NOTELNET

#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/mbuf.h>	/* just for MLEN! */
#include <sys/socket.h>
#include <sys/stat.h>
#include <sys/file.h>

#include <stdio.h>
#include <errno.h>
#include <netdb.h>
#include <sgtty.h>
#include <signal.h>
#include <ctype.h>
#include <utmp.h>
#if	defined(X25_TCP) || defined(TELNET)
#endif	defined(X25_TCP) || defined(TELNET)
#include <netinet/in.h>

#ifdef	SUNLINK
#include <sundev/syncstat.h>
#include <netx25/x25_ctl.h>     /* for out-of-band types */
#include <netx25/x25_pk.h>
#include <netx25/x25_ioctl.h>
#else	SUNLINK
#define	Q_BIT	3
#endif	SUNLINK

#define	D_CONN		0x00001	/* Log all connections */
#define	D_ERR		0x00002	/* Log serious errors */
#define	D_FAIL		0x00004	/* log all call failures */
#define	D_CALL		0x00008	/* log call of other program */
#define	D_LOGF		0x00010	/* log all logfile actions */
#define	D_WARN		0x00020	/* Log less serious errors */
#define	D_TRACE		0x00040	/* log lots of trace info */
#define	D_NOFORK	0x00080	/* Don't fork */
#define	D_NODETACH	0x00100	/* Don't detach from tty */
#define	D_NOBACKGROUND	0x00200	/* don't put listener in background */
#define	D_TRACE_CHARS	0x00400	/* Display each character */
#define	D_PTY_INFO	0x00800	/* log each PTY read (512) */
#define	D_PTY_RES	0x01000	/* log each PTY read result (64) */
#define	D_TELNET	0x02000	/* log telnet bits & pieces */
#define	D_SENDX25	0x04000	/* send_x25 info */
#define	D_BITS		0x08000	/* show the bit twidling to do with select */

#define	D_DEF		(D_CONN | D_ERR | D_FAIL | D_CALL)

#if (defined SUNLINK)
#define	X25

/* If user has not specified the version of Sunlink, then try to guess */
#ifndef	SUNLINK_VER

/* At the moment cope with 5.x, 6.x and 7.0 (actually beta) only */
#ifdef	X25_RD_LOCAL_ADR
#ifdef	X25_DEBUG_PR
#define	SUNLINK_VER	700
#else	/* X25_DEBUG_PR */
#define	SUNLINK_VER	600
#endif	/* X25_DEBUG_PR */
#else	/* X25_RD_LOCAL_ADR */
#define	SUNLINK_VER	500
#endif	/* X25_RD_LOCAL_ADR */

#endif	/* SUNLINK_VER */

#if	(SUNLINK_VER < 600)	/* -------- Sunlink 5.x -------- */
#ifndef	NOSUNCUDFBUG
#define	SUNCUDFBUG
#endif	/* NOSUNCUDFBUG */

#ifndef	NOSUNMOREBITBUG
#define	SUNMOREBITBUG
#endif	/* NOSUNMOREBITBUG */

#ifndef	NOSUNACPTBUG
#define	SUNACPTBUG
#endif	/* NOSUNACPTBUG */

#ifndef	NOSUNACPTAPPROVALBUG
#define	SUNACPTAPPROVALBUG
#endif	/* NOSUNACPTAPPROVALBUG */

#ifndef	NOSUNSTTYCOLSONLY
#define	SUNSTTYCOLSONLY
#endif	/* NOSUNSTTYCOLSONLY */

#ifndef	NOSUNX25BITSBUG
#define	SUNX25BITSBUG
#endif	/* NOSUNX25BITSBUG */

#ifndef	NOSUNMOREBITBUG
#define	SUNMOREBITBUG
#endif	/* NOSUNMOREBITBUG */

#ifndef	NOSUNINHERITBUG
#define	SUNINHERITBUG
#endif	/* NOSUNINHERITBUG */
#endif				/* -------- Sunlink 5.x -------- */

				/* -------- Sunlink 6.x -------- */
#if	(SUNLINK_VER < 700) && (SUNLINK_VER >= 600)
#ifndef	NOSUNACPTAPPROVALBUG
#define	SUNACPTAPPROVALBUG
#endif	/* NOSUNACPTAPPROVALBUG */

#ifndef	NOSUNCUDF2BUG
#define	SUNCUDF2BUG
#endif	/* NOSUNCUDF2BUG */

#ifndef	NOSUNACPT2BUG
#define	SUNACPT2BUG
#endif	/* NOSUNACPT2BUG */
#endif				/* -------- Sunlink 6.x -------- */

#if	(SUNLINK_VER < 700)	/* -------- Sunlink [56].x ----- */
#ifndef	NOSUNFACILBUG
#define	SUNFACILBUG
#endif	/* NOSUNFACILBUG */

#ifndef	NOSUNSTTYCOLSONLY
#define	SUNSTTYCOLSONLY
#endif	/* NOSUNSTTYCOLSONLY */

#ifndef	NOSUNX25BITSBUG
#define	SUNX25BITSBUG
#endif	/* NOSUNX25BITSBUG */
#endif				/* -------- Sunlink [56].x ----- */

#endif	/* (defined SUNLINK) */

#ifndef	FD_ISSET
#include "fd.h"
#endif	/* FD_ISSET */

#ifndef	ADR_LEN_MASK
#define	ADR_LEN_MASK	(0x3f)
#endif	/* ADR_LEN_MASK */
