/* Copyright (c) Piete Brooks 1988 */
#ifndef	lint
char RCSid[]="$Header: /Nfs/heaton/glob/src/etc/x25d/src/RCS/x25r.c,v 1.15 1991/07/17 09:21:03 pb Exp $";
#endif	lint

/*
 * X25 relay -- read from X.25 and send to X.25 over TCP
 *
 * Invoked by X.25 listener with fd = 4
 */

#include <stdio.h>
#include <ctype.h>
#include <errno.h>
#include <sys/file.h>
#include <sys/types.h>
#include <sys/ioctl.h>
#include <sys/signal.h>
#include <sys/mbuf.h>		/* just for MLEN! */
#include <sys/socket.h>
#include <sundev/syncstat.h>	/* for struct ss_dstats &tc. */
#include <netx25/x25_ctl.h>	/* for out-of-band types */
#include <netx25/x25_pk.h>
#include <netx25/x25_ioctl.h>
#define	FULL_X25STR
#include "x25b.h"
extern errno;

#ifdef	__STDC__
#ifndef	VOID
#define	VOID void
#endif	VOID
#define	ARGS(x)	x
#else	/* __STDC__ */
#ifndef	VOID
#define	VOID
#endif	VOID
#define	ARGS(x)	()
#endif	/* __STDC__ */

#ifndef	SIG_TYPE
#define	SIG_TYPE	void
#endif	/* SIG_TYPE */

char *getenv();
char *index();
char *ctime();
long time();

int  pollloop	ARGS((int, int));
int  process_tcp ARGS((int, int));
VOID x25_int	ARGS((int));
int  process_x25 ARGS((int, int));
int  sprintf_dtes ARGS((char *, unsigned char *, int));
int  sprintf_facil ARGS((char *, unsigned char *, int));
VOID sprintf_clr ARGS((char *, unsigned char *, int));
VOID sprintf_diag ARGS((char *, X25_CAUSE_DIAG *));
VOID init_deb	ARGS(());
VOID time_stamp	ARGS(());

/*
VOID x25b_logit ARGS((int, char *, ...));
VOID x25b_perror ARGS((int, char *, ...));
int  select	ARGS((int, int *, int *, int *, struct timeval *));
*/

int  dup	ARGS((int));
int  exit	ARGS((int));
int  fflush	ARGS((FILE *));
VOID fprintf	ARGS((FILE *, char *, ...));
int  getopt	ARGS((int, char **, char*));
int  getpid	ARGS(());
int  ioctl	ARGS((int, int, char*));
int  open	ARGS((char *, int, int));
int  perror	ARGS((char *));
int  recv	ARGS((int, char *, int, int));
int  send	ARGS((int, char *, int, int));
int  sleep	ARGS((int));
char *sprintf	ARGS((char *, char *, ...));
int  strcmp	ARGS((char *, char *));
int  x25b_open_x29_2 ARGS((char *, char *, char *, char *, char *, char *, char *, int, int));
int  x25b_open_ybts4 ARGS((char *, char *, char *, char *, char *, char *, char *, int, int, int));
int  x25b_read_data ARGS((int, char *, char *, int));
int  x25b_write_data ARGS((int, char *, char *, int, int));

char logfile[] = "/tmp/x25r.log";
FILE *debfile;
int   debfd;
int   pid;

char optargs[]	= "c:D:H:h:l:x:X:y:Y:z";
extern	char *optarg;
extern	int optind;
int	zap_d	= 0;
int	debug	= 0;
int	x25 = 4;
int	x25_ints = 0;
int	x25_resets = 0;
FILE	*tracefile = (FILE *) 0;
long	start_time = 0;
char extra_info[1024];
SIG_TYPE	(*old_urg)();

VOID main(argc, argv)
char **argv;
{
	int tcp;
	char *x25dte = (char *) 0;
	char *x25name = (char *) 0;
	char *called_dte = (char *) 0;
	char *ybts_called = (char *) 0;
	char *ybts_calling = (char *) 0;
	char *cudf	= (char *) 0;
	char *host	= (char *) 0;
	char *user	= "x25relay-service";
	char *tracefilename = (char *) 0;
	int ybts	= 0;
	int i;

	x25b_debug = zap_d;
	pid = getpid();
	*extra_info = '\0';

	init_deb();

	while ((i = getopt(argc, argv, optargs)) != EOF) switch(i)
	{
	default:
		fprintf(debfile, "%s: bad args for: %s [%s]\n",
			*argv, *argv, optargs);
		fprintf(stderr, "%s: bad args for: %s [%s]\n",
			*argv, *argv, optargs);
		exit(1);
	case 'D': debug = atoi(optarg);					break;
	case 'h': host	= optarg;					break;
	case 'l': tracefilename	= optarg;				break;
	case 'H': x25name= optarg;					break;
	case 'x': x25dte= optarg;					break;
	case 'X': called_dte= optarg;					break;
	case 'Y': ybts_called = optarg;					break;
	case 'y': ybts_calling = optarg;				break;
	case 'z': ybts = -1;						break;
	case 'c': cudf	= optarg;					break;
	case 'u': user	= optarg;					break;
	}

	{	int one=1;
		errno = -1;
		if (ioctl(x25, SIOCSPGRP, (char *) &pid) < 0)
			fprintf(debfile,
			"Failed to set process group for fd %d to %d (%d)\n",
				x25, pid, errno);
		old_urg = signal(SIGURG, x25_int);

		if (ioctl(x25, X25_HEADER, (char *) &one))
			fprintf(debfile,
			"EARLY set X25_HEADER(%d) failed %d\n", x25, errno);
		if (ioctl(x25, X25_RECORD_SIZE, (char *) &one))
			fprintf(debfile, "Failed to set record size\n");
		fflush(debfile);
	}

	if (ybts >= 0)
	{	if (!ybts_called)
		{	ybts_called = getenv("YBTSCALLED");
			if (!ybts_called)
			{	fprintf(debfile, "No ybts_called\n");
				exit(3);
			}
		}
		if (!host)
		{	char *sep;
			host = ybts_called;
			if (sep = index(ybts_called, '.'))
			{	*sep++ = '\0';
				ybts_called = sep;
			}
		}
		if (!ybts_calling)
		{	ybts_calling = getenv("YBTSTEXT");
			if (!ybts_calling)
			{	fprintf(debfile, "No ybts_calling\n");
				exit(3);
			}
		}
		if (!x25dte)
		{	x25dte = getenv("X25DTE");
			if (!x25dte)
			{	fprintf(debfile, "No x25dte\n");
				exit(3);
			}
		}
		if (!called_dte)
		{	called_dte = getenv("CALLED_DTE");
			if (!called_dte)
			{	fprintf(debfile, "No called_dte\n");
			}
		}

		if (!x25name)
		{	x25name = getenv("CALLED_NAME");
			if (!x25name) x25name = getenv("CALLED_SHORTNAME");
			if (!x25name)
			{	fprintf(debfile, "No x25name\n");
			}
		}

		time_stamp();
		fprintf(debfile, "Call to %s with %s%s%s/%s %s/%s\n",
			host,
			(x25name) ? x25name : "", (x25name) ? "=" : "",
			x25dte, ybts_calling,
			(called_dte) ? "*" : called_dte, ybts_called);
		fflush(debfile);
		tcp = x25b_open_ybts4(called_dte, ybts_called,
				x25dte, x25name, ybts_calling,
				host, "ybts-secure", 0, 0, 0);
	}
	else
	{	if (!x25name)
		{	x25name = getenv("CALLED_NAME");
			if (!x25name) x25name = getenv("CALLED_SHORTNAME");
			if (!x25name)
			{	fprintf(debfile, "No x25name\n");
			}
		}
		time_stamp();
		fprintf(debfile, "Call %s:%s%s%s from %s%s%s\n",
			(host)		? host		: "<unset>",
			(called_dte)	? called_dte	: "*",
			(cudf)		? ":"		: "",
			(cudf)		? cudf		: "", 
			(x25name)	? x25name	: "",
			(x25name)	? "="		: "",
			(x25dte)	? x25dte	: "<unset>");
		fflush(debfile);
		tcp = x25b_open_x29_2(called_dte, cudf, x25dte, x25name,
				host, "spad-secure", user, 0, 0);
	}

	if (tcp < 0)
	{	fprintf(debfile, "Open failed\n");
		exit(3);
	}
	if (tracefilename)
	{	char fullname[1024];
		sprintf(fullname, tracefilename, getpid());
		if (tracefile = fopen(fullname, "a"))
			chmod(fullname, 0400);
		else fprintf(debfile, "Open of %s (%s) failed %d\n",
			tracefilename, fullname, errno);
		start_time = time((long *) 0);
	}
	i = pollloop(x25, tcp);
	if (tracefile) flush_log();
	time_stamp();
	fprintf(debfile, "Call cleared by %s%s%s (%d)\n",
		(i == 1) ? "tcp" : (i == 2) ? "x25" : (i == 3) ? "Sel" : 
		(i == 4) ? "bit" : (i == 5) ? "SEL" : "???",
		(*extra_info) ? " " : "", extra_info, errno);
	exit(0);
}

int pollloop(x25, tcp)
{
	int v;
	int	xmask	= 1 << x25;
	int	tmask	= 1 << tcp;
	int	defmask = (xmask | tmask);
	int	max = ((x25 > tcp) ? x25 : tcp) +1;
	int	mask	= defmask;

	while(1)
	{	for (;
		  (v=select(max, &mask, (int *) 0, (int *) 0, 0)) > 0 && mask;
		  mask = defmask)
		{	if (mask&tmask) if (process_tcp(tcp, x25)<=0) return 1;
			if (mask&xmask) if (process_x25(x25, tcp)<=0) return 2;
		}
		time_stamp();
		fprintf(debfile, "select gave %d (%d), mask=%x (%x) -- ",
			v, errno, mask, defmask);
		if (v == -1 && errno == EINTR)
		{	fprintf(debfile, "EINTR, so continue\n");
			continue;
		}
		fprintf(debfile, "time to give up\n");
		return (v <= 0) ? 3 : (mask == 0) ? 4 : 5;
	}
}

/* Read from the TCP stream & write to the X25 stream */
int process_tcp(tcp, x25)
{	char buff[1024+1];
	int qbit = 0;
	int rc;
	int len;
	int skip = 1;
	extern struct x25io _x25io;

	len=x25b_read_data(tcp, buff, buff+skip, sizeof buff-skip);

	if (debug & 4)
	{	int i;
		fprintf(debfile, "Read %d bytes, f=%x",
			len, _x25io.x_flags);
		for (i=0; i<len; i++) fprintf(debfile, " %02x", buff[i] & 0xff);
		fprintf(debfile, "\n");
		fflush(debfile);
	}
	if (_x25io.x_flags & X25F_TSPAD && len > 0)
	{	len++;
		skip--;
		time_stamp();
		fprintf(debfile, "TSPAD %02x (%02x)\n", *buff,_x25io.x_tspad);
		fflush(debfile);
		/**buff = _x25io.x_tspad;*/
		*buff = (*buff == 0x08) ? 0x80 : *buff;
	}
	else if (*buff && (len > 0 || *buff != (char) 0xff)) qbit = *buff;

	if (qbit) if (ioctl(x25, X25_SEND_TYPE, (char *) &qbit) == -1)
			fprintf(debfile, "Failed to set TYPE %02x (%d)\n",
				qbit, errno);
	rc = (len > 0) ? send(x25, buff+skip, len, 0) : len;
	if (rc != len)
	{	time_stamp();
		fprintf(debfile, "send %d gave %d (%d)\n", len, rc, errno);
		fflush(debfile);
	}
	if (qbit)
	{	qbit=0;
		if (ioctl(x25, X25_SEND_TYPE, (char *) &qbit) == -1)
		       fprintf(debfile, "Failed to reset TYPE %02x (%d)\n",
				qbit, errno);
		fflush(debfile);
	}
	return (rc > 0 && len > 0) ? rc : -1;
}

VOID x25_int(sig)
{	int type;
	char data;
	int n;

	if (sig != -1) { time_stamp(); fprintf(debfile, "X25_INT %d\n", sig); }

	while (!ioctl(x25, X25_OOB_TYPE, (char *) &type) && type)	switch(type)
	{
	case INT_DATA:
		errno = -1;
		n = recv(x25, &data, 1, MSG_OOB);
		time_stamp();
		fprintf(debfile, "INT data (%d) was %02x (%d) -- ignored\n",
				n, data, x25_ints);
		if (n <= 0)
		{	fprintf(debfile, "INT ERROR (%d) %d\n", n, errno);
			if (errno == ENOTCONN)	return;
			if (x25_ints > 10) sleep (1 << ((x25_ints/10)-1));
			if (x25_ints > 30)	return;
		}
		x25_ints++;
		break;
	case VC_RESET:
		time_stamp();
		fprintf(debfile, "RESET (%d) -- ignored\n", type, x25_resets);
		x25_resets++;
		break;
	default:
		time_stamp();
		fprintf(debfile, "OOB type %02x -- ignored\n", type);
	}

	fflush(debfile);
}

/* Read from the X25 stream & write to the TCP stream */
int process_x25(x25, tcp)
{	char buff[1024];
	int len;

	x25_int(-1);

	len = recv(x25, buff, sizeof buff, 0);
	if (tracefile) log(buff, len, 0);
	if (debug & 4)
	{	int i;
		fprintf(debfile, "Read %d bytes",
			len);
		for (i=0; i<len; i++) fprintf(debfile, " %02x", buff[i] & 0xff);
		fprintf(debfile, "\n");
		fflush(debfile);
	}
	if (len == 1)
	{	fprintf(debfile, "One byte: %d\n", buff[0] & 0xff);
		return 1;
	}
	if (len > 0) return x25b_write_data(tcp, buff, buff+1, len-1, 0);

	{	X25_CAUSE_DIAG diag;

		if (!ioctl(x25, X25_RD_CAUSE_DIAG, (char *) &diag) &&
			(diag.flags != ((1<<DIAG_TYPE) | (1<<RECV_DIAG)) ||
			 diag.datalen != 2 ||
			 diag.data[0] != 0 ||
			 diag.data[1] != 0 ))
			sprintf_diag(extra_info, &diag);
	}
	return -1;
}

int sprintf_dtes(buff, data, len)
char *buff;
unsigned char *data;
{ if (len > 0)
  { int la1 =  data[0]       & 0x0f;
    int la2 = (data[0] >> 4) & 0x0f;
    int bytes = (la1+la2+1)/2;
    if (len > bytes)
    {	int i;
	sprintf(buff, " Addresses %01x/%01x: ", la1, la2);
	while(*buff) buff++;
        for(i=1; bytes; i++, bytes--)
	{ sprintf(buff, "%02x%s", data[i], (bytes == (la2/2)+1) ? " " : "");
	  while(*buff) buff++;
	}
        return i;
    }
  }
  return 0;
}

int sprintf_facil(buff, data, len)
char *buff;
unsigned char *data;
{ int i;
  int skip = 0;

  for (i=0; i<len; i++)	if (skip)
  {	skip--;
	sprintf(buff, " %02x", data[i]);
	while(*buff) buff++;
  }
  else
  {	int args;

	switch (data[i] & 0xc0)
	{	case 0x00:	args = 1;			break;
		case 0x40:	args = 2;			break;
		case 0x80:	args = 3;			break;
		default:	/* Keep the stupid compiler happy ! */
		case 0xc0:	args = data[i+1] +1;		break;
	}

	if (args > (len -i))	goto defalt;

        switch(data[i])
	{
	case 0x00:
	if ((data[i+1] != 0x00) && (data[i+1] != 0xff))	goto defalt;
	sprintf(buff, " NOM call%s", (data[i+1]) ? "ed" : "ing");
	i += args;
	break;

	case 0xc1:
	if (args != 5)	goto defalt;
	sprintf(buff, " Call Duration %02x%02x%02x%02x",
		data[i+2], data[i+3], data[i+4], data[i+5]);
	i += args;
	break;

	case 0xc2:
	if (args != 9)	goto defalt;
	sprintf(buff, " Call stats %02x%02x%02x%02x %02x%02x%02x%02x",
		data[i+2], data[i+3], data[i+4], data[i+5],
		data[i+6], data[i+7], data[i+8], data[i+9]);
	i += args;
	break;

	defalt:
	sprintf(buff, " invalid");
	while(*buff) buff++;
	default:
	sprintf(buff, " facil %02x len %d", data[i], args);
	skip = args;
	}
	while(*buff) buff++;
  }
  if (skip) sprintf(buff, " -- invalid facilities %d byte%s missing",
		skip, (skip == 1) ? "" : "s");
  return i;
}

VOID sprintf_clr(buff, data, len)
char *buff;
unsigned char *data;
{ int i = 0;
  int facil = 0;

  if (i <= len-2)
  { int inc;
    sprintf(buff, " %02x diag %02x", data[i], data[i+1]);
    i += 2;
    while(*buff) buff++;

    i += (inc = sprintf_dtes(buff, data + i, len -i));
    while(*buff) buff++;

    if (inc && i <= len-1 && data[i] <= len-i)
    { facil = data[i];
      i++;
      sprintf(buff, (facil) ? " Facilities %d:" : " No Facilities", facil);
      while(*buff) buff++;
    }

    i += sprintf_facil(buff, data + i, facil);
    while(*buff) buff++;

    if (i < len)
    { sprintf(buff, " Data:");
      while(*buff) buff++;
      for(; i<len; i++)
      { sprintf(buff, " %02x", data[i]);
        while(*buff) buff++;
      }
    }
  }
}

VOID sprintf_diag(buff, diag)
char *buff;
X25_CAUSE_DIAG *diag;
{
  if (diag->flags & ~((1 << RECV_DIAG) | (1 << DIAG_TYPE)))
	sprintf(buff, " (flags %02x)", diag->flags); while(*buff) buff++;
  if (!(diag->flags & (1<<RECV_DIAG)))
	sprintf(buff, " (no info)"); while(*buff) buff++;
  sprintf(buff, " %s:", (diag->flags & (1<<DIAG_TYPE)) ? "clear" : "reset");
  while(*buff) buff++;
  sprintf_clr(buff, diag->data, diag->datalen);
}

VOID time_stamp()
{	char *t_time;
	long now;

	(void) time(&now);
	t_time = ctime(&now) + 4;
	t_time[15] = 0;
	fprintf(debfile, "%s:%04x: ", t_time, pid);
}

VOID init_deb()
{	if (*logfile && strcmp(logfile, "-") &&
		(debfd = open(logfile, O_WRONLY | O_APPEND | O_CREAT, 0644))&&
		(debfile=fdopen(debfd,"a")));
	else if (debfd = dup(2)) debfile = fdopen(debfd, "a");
}

VOID x25b_logit(mask, format, a1, a2, a3, a4)
char *format;
char *a1, *a2, *a3, *a4;
{
	fprintf(debfile ? debfile : stderr, format, a1, a2, a3, a4);
	fflush(debfile ? debfile : stderr);
}

VOID x25b_perror(mask, format, a1, a2, a3, a4)
char *format;
char *a1, *a2, *a3, *a4;
{
	fprintf((debfile) ? debfile : stderr, format, a1, a2, a3,a4);
	fflush((debfile) ? debfile : stderr);
	perror("");
	fflush(stderr);
}

int x25b_debug = 0;
int pend_n = 0;
u_char pend_buf[128] = { 0 };
long last_time;

log(buff, len, type)
u_char *buff;
int len;
{	int i;
	if (*buff)
	{	if (pend_n && buff != pend_buf) flush_log();
		fprintf(tracefile, "%04x [", time((long *) 0) - start_time);
		for (i=0; i< len; i++) fprintf(tracefile, "%02x", buff[i]);
		fprintf(tracefile, "]\n");
		fflush(tracefile);
	}
	else if (len == 2 && pend_n < sizeof pend_buf && buff != pend_buf)
	{	if (pend_n == 0) last_time = time((long *) 0);
		else if (buff[1] != 0x0d && (time((long *) 0)-last_time > 20))
		{	flush_log();
			last_time = time((long *) 0);
		}
		pend_buf[++pend_n] = buff[1];
		if (buff[1] == 0x0d) flush_log();
	}
	else
	{	if (pend_n && buff != pend_buf) flush_log();
		fprintf(tracefile, "%04x%c", time((long *) 0) - start_time,
			(type) ? ':' : ' ');
		for (i=1; i< len; i++) if (isprint(buff[i]))
				fprintf(tracefile, "%c", buff[i]);
			else	fprintf(tracefile, "\\%02x", buff[i]);
		fprintf(tracefile, "\n");
		fflush(tracefile);
	}
}

flush_log()
{
	if (pend_n)
	{	log(pend_buf, pend_n+1, 1);
		pend_n = 0;
	}
}
