/* Copyright (c) Piete Brooks 1988 */
#ifndef	lint
char RCSid[]="$Header: /Nfs/heaton/glob/src/etc/x25d/src/RCS/x29d.c,v 1.15 1991/07/17 09:21:20 pb Exp $";
#endif	lint
/*
 * X.29 and TS29 server for socket based systems.
 * uses native mode if pty IOCTLS not available.
 * can make trivial TELNET calls to relay.
 */

int notty=1;

#include	"x25d.h"

/* some pragmats used in the auth file */
#ifndef	DO_PRAGMAT
#define	DO_PRAGMAT		"#x29do"
#endif	DO_PRAGMAT
#ifndef	REGEXP_PRAGMAT
#define	REGEXP_PRAGMAT		"#regexp"
#endif	REGEXP_PRAGMAT
#ifndef	NOREGEXP_PRAGMAT
#define	NOREGEXP_PRAGMAT	"#noregexp"
#endif	NOREGEXP_PRAGMAT
#ifndef	IGNORE_PRAGMAT
#define	IGNORE_PRAGMAT		"#ignore"
#endif	IGNORE_PRAGMAT
#ifndef	IFHOST_PRAGMAT
#define	IFHOST_PRAGMAT		"#ifhost"
#endif	IFHOST_PRAGMAT
#ifndef	ELIFHO_PRAGMAT
#define	ELIFHO_PRAGMAT		"#elifhost"
#endif	ELIFHO_PRAGMAT
#ifndef	ELSEHO_PRAGMAT
#define	ELSEHO_PRAGMAT		"#elsehost"
#endif	ELSEHO_PRAGMAT
#ifndef	ENDIFH_PRAGMAT
#define	ENDIFH_PRAGMAT		"#endifhost"
#endif	ENDIFH_PRAGMAT
#ifndef	ONLYHOST_PRAGMAT
#define	ONLYHOST_PRAGMAT	"#onlyhost"
#endif	ONLYHOST_PRAGMAT
#ifndef	FORMATX29_PRAGMAT
#define	FORMATX29_PRAGMAT	"#formatx29"
#endif	FORMATX29_PRAGMAT
#ifndef	FORMATYBTS_PRAGMAT
#define	FORMATYBTS_PRAGMAT	"#formatybts"
#endif	FORMATYBTS_PRAGMAT
#ifndef	FORMATGETOPT_PRAGMAT
#define	FORMATGETOPT_PRAGMAT	"#formatgetopt"
#endif	FORMATGETOPT_PRAGMAT

/* some defaults for the auth file */
#ifndef	DEF_COMMAND
#define	DEF_COMMAND		"/bin/login"
#endif	DEF_COMMAND
#ifndef	DEF_ARGS
#define	DEF_ARGS		"login -h $calling_shortusname"
#endif	DEF_ARGS
#ifndef	DEF_AUTH
#define	DEF_AUTH		"*"
#endif	DEF_AUTH
#ifndef	X29AUTH
#define	X29AUTH			"/etc/x29-auth"
#endif	X29AUTH
#ifndef	X29AUTH_INTERVAL
#define	X29AUTH_INTERVAL	(60 * 5)
#endif	X29AUTH_INTERVAL
#ifndef	MAX_CHILD
#define	MAX_CHILD		40
#endif	MAX_CHILD
#ifndef	MAX_AUTH
#define	MAX_AUTH		100
#endif	MAX_AUTH

#ifndef	KILL_FILE
#define	KILL_FILE		"/usr/adm/x29d.pid"
#endif	KILL_FILE

/* PTY info ... */
#ifndef	DEF_TTYNAME
#define	DEF_TTYNAME		"/dev/ptyp0"
#endif	DEF_TTYNAME
#ifndef	DEVNAME_LEN
#define	DEVNAME_LEN		(sizeof "/dev/")
#endif	DEVNAME_LEN
#ifndef	LAST_PTY
#define	LAST_PTY		(16 * 3)
#endif	LAST_PTY

/* Misc other bits .... */
#ifndef	LOGFILE
#define	LOGFILE			"/usr/adm/x29d.log"
#endif	LOGFILE
#ifndef	LOGFILE_INTERVAL
#define	LOGFILE_INTERVAL	((60 * 60 * 24) + (60 * 20))
#endif	LOGFILE_INTERVAL
#ifndef	LOGFILE_SHORT_INTERVAL
#define	LOGFILE_SHORT_INTERVAL	(60)
#endif	LOGFILE_SHORT_INTERVAL
#ifndef	PID_LEN
#define	PID_LEN			4
#endif	PID_LEN
#ifndef	MAXADDRS
#define	MAXADDRS		40
#endif	MAXADDRS
#ifndef	PKT_SIZ
#define	PKT_SIZ			128
#endif	PKT_SIZ
#ifndef	RAW_GREENBOOK
#define	RAW_GREENBOOK		/* force calls to raw mode */
#endif	RAW_GREENBOOK
#ifndef	MAXARGS
#define	MAXARGS			40	/* maximum size of server arg list */
#endif	MAXARGS
#ifndef	SPARE_SHORTNAME
#define	SPARE_SHORTNAME		0
#endif	SPARE_SHORTNAME
#ifndef	MAX_SHORTNAME
#define	MAX_SHORTNAME		(sizeof wtmp.ut_host - SPARE_SHORTNAME)
#endif	MAX_SHORTNAME

#ifdef	NO_SETSID
#define	setsid()	setpgrp(0,0)
#endif	/* NO_SETSID */

#define logc(x) logit(0, (isprint(x)) ? "%c" : "<%02x>", (x) & 0xff)

/* default param settings */
#define	DEF_P3			50
#define	DEF_P13			4

#include <sys/wait.h>

/*#define TIOCPKT_IOCTL	0x80			/* use pkt mode */
/*#define TIOCREMECHO	_IOW(t, 100, int)	/* local edit/remote echo */
/*#define TIOCTCNTL _IOW(t, 32, int)  /* pty: set/clr intercept ioctl mode */

/* ======================================================================== */
/* Now -- lets work out how to do half-duplex echo supression		    */
/* 									    */
/* IF	TIOCREMECHO				THEN use that		    */
/* ELSE						     discard echo	    */
/* ======================================================================== */
#undef	TIOCREMECHO
#ifdef	TIOCREMECHO
# define HALP_DUP			/* can supress echo */
#endif	TIOCREMECHO

/* ======================================================================== */
/* Now -- lets work out how to detect stty ioctls			    */
/* 									    */
/* IF	TIOCPKT_IOCTL				THEN TIOC_PKT		    */
/* ELIF TIOCTCNTL(sun)				THEN use that		    */
/* ELSE						     use native		    */
/* ======================================================================== */
#undef	TIOCPKT_IOCTL
#ifndef	TIOCTCNTL
#define TIOCTCNTL       _IOW(t, 32, int)
#endif	TIOCTCNTL
#ifdef	TIOCPKT_IOCTL
# define	PKT_MODE
#else	TIOCPKT_IOCTL
# ifdef TIOCTCNTL
#  define	PKT_MODE		/* pkt mode is forced anyway */
# else	TIOCUCNTL

If you REALLY cannot define TIOCPKT_IOCTL in the header file and run
with the new tty_pty.o,
and you cannot catch IOCTL calls (with TIOC[TU]CNTL),
then delete these lines & things should compile.

# endif	TIOCUCNTL
#endif	TIOCPKT_IOCTL
/* ======================================================================== */
/* ======================================================================== */

#include "regexp.h"
#include "regexp.c"
#include "regerror.c"
#include "regsub.c"

#ifdef	X25_TCP
#define	FULL_X25STR
#include "x25b.h"
#endif	X25_TCP

#define X29_INVITATION_TO_CLEAR     1     /* Host to Pad */
#define X29_SET_PARMS               2     /* Host to Pad */
#define X29_INDICATION_OF_BREAK     3     /* Both directions */
#define X29_READ_PARMS              4     /* Host to Pad */
#define X29_SET_AND_READ_PARMS      6     /* Host to Pad */

#define P_1     1	/* Escape */
#define P_2     2	/* Echo		*/
#define P_3     3	/* Forward	*/
#define P_4     4	/* Timeout	*/
#define P_5     5	/* ^s/^Q	*/
#define P_6     6	/* Print net msg*/
#define P_7     7
#define P_8     8
#define P_9     9
#define P_10    10
#define P_11    11
#define P_12    12
#define P_13    13
#define P_14    14
#define P_15    15
#define P_16    16
#define P_17    17
#define P_18    18
#define	P_MAX	P_18

struct x3_struct {
	int x3_params[P_MAX +1];
};
struct	x3_struct	curr_params;

#define param1 curr_params.x3_params[1]
#define param2 curr_params.x3_params[2]
#define param3 curr_params.x3_params[3]
#define param4 curr_params.x3_params[4]
#define param5 curr_params.x3_params[5]
#define param6 curr_params.x3_params[6]
#define param7 curr_params.x3_params[7]
#define param8 curr_params.x3_params[8]
#define param9 curr_params.x3_params[9]
#define param10 curr_params.x3_params[10]
#define param11 curr_params.x3_params[11]
#define param12 curr_params.x3_params[12]
#define param13 curr_params.x3_params[13]
#define param14 curr_params.x3_params[14]
#define param15 curr_params.x3_params[15]
#define param16 curr_params.x3_params[16]
#define param17 curr_params.x3_params[17]
#define param18 curr_params.x3_params[18]

struct x3_struct pass = { 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 1,
		0, 0, 1, 0, 1, 0, 0, 0 };
#ifdef	MACADDR_LEN
#define	NSAP			/* (beta) 7.0 SunNet X.25 */
#endif

#ifdef	ANY_NSAP
#define	NSAP			/* SunNet 7.0 Beta 2 */
#endif	ANY_NSAP

/* Type of listening address */
#ifdef	X25
#define	ADDR_X25_FULL	1
#define	ADDR_X25_SUB	2
#define	ADDR_X25_BASE	3
#endif	X25
#ifdef	X25_TCP
#define	ADDR_TCP	4
#endif	X25_TCP
#ifdef	NSAP
#define	ADDR_NSAP	5
#endif	NSAP

/* Type of PTY */
#define	PTY_PTY		1
#ifdef	TELNET
#define	PTY_TELNET	2
#endif	TELNET

/* auth file format */
#define	FORMAT_X29	1
#define	FORMAT_YBTS	2
#define	FORMAT_GETOPT	3
#define NET_FD 4		/* Child processes expect the net on fd 4 */
#define ENVLEN		(64*40)	/* size of buffer to hold env data */
#define	ENVSIZE		100	/* max # of env variables */

#define	PROFILES	((sizeof profile) / (sizeof profile[0]))
#define	PROF_BYTE	(sizeof protocol_id)	/* proto ID is 0x01, profile*/
#define	TTYNAME_LEN	(sizeof DEF_TTYNAME)
#define	TTY_BASE	(DEVNAME_LEN - 1)
#define NAMES		((sizeof names) / (sizeof names[0]))
#define toHEX(n)	"0123456789ABCDEF"[n]
#define tohex(n)	"0123456789abcdef"[n]

/* Which parameters does the HOST set ? Tell PAD what host wants ... */
#define	send(x)	x, 0,
#define	omit(x)
char tell_pad[] = { (1<<Q_BIT), 0,
	send(P_1)  send(P_2)  send(P_3)  send(P_4)  send(P_5)
	send(P_6)  send(P_7)  send(P_8)  send(P_9)  send(P_10)
	omit(P_11) send(P_12) send(P_13) send(P_14) send(P_15)
	omit(P_16) omit(P_17) omit(P_18)
};
#undef	send
#undef	omit

#define	LF_REV_CHARGE	2		/* Allow reverse charge calls	*/
#define	LF_X29		4		/* this is an X29 call		*/
#define	LF_TS29		8		/* this is a TS29 call		*/
#define	LF_NATIVE	16		/* use native mode		*/
#define	LF_MESSAGE	32		/* use message mode		*/
#define	LF_HIDE		64		/* use hide mode (no echo)	*/
#ifdef	TELNET
#define	LF_ONLY_TELNET	128		/* Only try telnet		*/
#endif	TELNET
#define	LF_FORK		256		/* Fork child directly		*/
#define	LF_TS_NOACC	512		/* Don't do TS accept		*/
#define	M_AUTO		0
#define	M_NATIVE	(M_AUTO + 1)
#define	M_MESSAGE	(M_NATIVE + 1)
#define	M_HIDE		(M_MESSAGE + 1)

union patt {
	regexp	*p_prog;
	char 	*p_str;
};
struct format {
	union patt	l_called_aef;
	union patt	l_called_dte;
	union patt	l_called_addr;
	union patt	l_calling_addr;
	char	*l_command;
	char	*l_comname;
	char	*x_banner;
	char	*l_telnet;
	char	*l_tel_port;
	char	*l_rest;
	int	l_flags;
	int	l_scan;
	int	l_uid;
	int	l_gid;
	int	l_cug;
} format[MAX_AUTH];
#define	s_calling_addr	l_calling_addr.p_str
#define	s_called_addr	l_called_addr.p_str
#define	s_called_aef	l_called_aef.p_str
#define	s_called_dte	l_called_dte.p_str
#define	p_calling_addr	l_calling_addr.p_prog
#define	p_called_addr	l_called_addr.p_prog
#define	p_called_dte	l_called_dte.p_prog
#define	p_called_aef	l_called_aef.p_prog

/* We  are passed (in the second octet of protocol id) the profile */
struct {
	unsigned char	p_id;
	unsigned char	p_width;
	unsigned char	p_cr_fill;
} profile[] = {
	90,	72,	0,
	91,	120,	0,
	92,	80,	1,
	93,	132,	2,
	94,	80,	0
};

struct child {
	int	pid;
	int	type;
} children[MAX_CHILD];

extern char	*ctime();
extern char	*getenv();
extern char	*index();
extern char	*rindex();
extern char	*malloc();

#ifdef	X25
extern accepted;

int	accept_call();
#endif	X25

char	**split_argv();
char	*decode_flags();
char	*get_dat();
char	*lower();
char	*make_regexp();
char	*save_str();
int	add_line();
int	cleanup();
int	clear_format();
#ifdef	X25
int	diag_close();
#endif	X25
int	expand_dollar();
int	format_copy();
int	grimreaper();
int	init_deb();
int	logit();
int	read_dte();
int	valid_request();
void	read_auth();
void	help();

/*extern*/	char *optarg = "";
extern	int optind;
extern	errno;

FILE *debfile	= stderr;
char *address[MAXADDRS];
char *x25link[MAXADDRS];
int  lpidmasklen[MAXADDRS];
int  lpidlen[MAXADDRS];
u_char *lpid[MAXADDRS];
u_char *lpidmask[MAXADDRS];
#ifdef	X25
char *basename[MAXADDRS];
#endif	X25
char *def_auth	= DEF_AUTH;
char unset[] = "<unset>";
char *logfile	= LOGFILE;
char *authfile	= X29AUTH;
char *kill_file = KILL_FILE;
#ifdef	X25
char def_x25_addr[] = "\0<------ space for patching def_x25_addr ----->";
#endif	X25
#ifdef	X25_TCP
char def_tcp_addr[] = "spad-secure\0<------ space for patching def_tcp_addr ----->";
#endif	X25_TCP
char calling_addr[20 + 128];

char *calling_shortname = (char *) 0;
char *calling_givenname = (char *) 0;
char _calling_givenname[128];
char calling_shortusname[128];
char calling_mac[20];
char calling_aef[60];
char calling_dte[20];
char calling_name[128];
char calling_longname[128];
char calling_usname[128];
char calling_longusname[128];
char calling_ybts[128];
char called_dte[20];
char called_aef[60];
char cudf[128 +1];
int  cudflen;
char cudf_hex[128*2 +1];
char called_ybts[128];
char ttynam[TTYNAME_LEN];
char hostname[128];
char pid_text[128];

char *calling_dte_p		= calling_dte;
char *calling_aef_p		= calling_aef;
char *calling_mac_p		= calling_mac;
char *calling_name_p		= calling_name;
char *calling_longname_p	= calling_longname;
char *calling_usname_p		= calling_usname;
char *calling_longusname_p	= calling_longusname;
char *calling_shortusname_p	= calling_shortusname;
char *calling_ybts_p		= calling_ybts;
char *cudf_p			= cudf;
char *cudf_hex_p		= cudf_hex;
char *called_dte_p		= called_dte;
char *called_aef_p		= called_aef;
char *called_ybts_p		= called_ybts;
char *hostname_p		= hostname;
char *pid_text_p		= pid_text;
char *ttynam_p			= ttynam;
char *zap_argv;

char optargs[]	= "A:C:D:F:HIK:L:MNP:W:X:a:b:c:d:f:k:hi:l:m:n:p:s:t";
char pibuf[BUFSIZ], fibuf[BUFSIZ];

int auth_count[MAX_AUTH];
int addr_type[MAXADDRS];
u_char	protocol_id[] = { 0x01 };
u_char	protocol_id_mask[] = { 0xff };
struct	utmp wtmp;
u_char *l_pid_mask = protocol_id_mask;
u_char *l_pid = protocol_id;
int  l_pid_mask_len = sizeof protocol_id_mask;
int  l_pid_len = sizeof protocol_id;

int activehost	= 0;
int addresses	= 0;
int inetd	= 0;
int auth_format;
int auth_line;
int authfile_interval	= X29AUTH_INTERVAL;
int logfile_interval	= LOGFILE_INTERVAL;
int logfile_short_interval= LOGFILE_SHORT_INTERVAL;
int call_type;
int debfd	= 2;
int debug	= D_DEF;
int max_child = -1;
int def_auth_format	= FORMAT_X29;
int formats	= 0;
int fcc		= 0;	/* Not fast call clear */
int in_bytes	= 0;
int in_pkts	= 0;
int max_shortname=MAX_SHORTNAME;
int my_pid;
int n_ebits	= 10;
int n_ibits	= 10;
int no_pty	= 0;	/* the cild has exited, so suck on the pty */
int one		= 1;
int out_bytes	= 0;
int out_pkts	= 0;
int base_logit_counts= 100;
int logit_counts= 100;
int pty;
int pty_type;
int q_bit_on	= 1<<Q_BIT;
int reverse_charged = 0;
int termwidth	= 0;
int ts29	= 0;
int ts29_skip;
int force_mode	= M_AUTO;
#ifdef	PKT_MODE
int use_pkt_tty	= 0;
#endif	PKT_MODE
int doechoplex  = 0;
int use_regexp;
int x25;
int zero	= 0;
int block_log	= 20;	/* Log this many "block"s */
int block_err	= 20;	/* This many "errors" before closing */

unsigned char prof_byte	= 0;
long last_log;		/* last attempt to reopen the log file */
long last_auth;		/* last attempt to look at authfile */
caddr_t last_sbrk = (caddr_t) 0;
time_t auth_timestamp;

#define v(x)	x, sizeof(x) -1
struct {
	char	*name;
	int	len;
	char	**val;
} names[] = {
	{	v("called_cudf_hex"),	&cudf_hex_p,		},
	{	v("called_cudf"),	&cudf_p,		},
	{	v("called_dte"),	&called_dte_p,		},
	{	v("called_aef"),	&called_aef_p,		},
	{	v("called_ybts"),	&called_ybts_p,		},
	{	v("calling_ybts"),	&calling_ybts_p,	},
	{	v("calling_dte"),	&calling_dte_p,		},
	{	v("calling_aef"),	&calling_aef_p,		},
	{	v("calling_mac"),	&calling_mac_p,		},
	{	v("calling_longname"),	&calling_longname_p,	},
	{	v("calling_name"),	&calling_name_p,	},
	{	v("calling_shortname"),	&calling_shortname,	},
	{	v("calling_longusname"),&calling_longusname_p,	},
	{	v("calling_usname"),	&calling_usname_p,	},
	{	v("calling_shortusname"),&calling_shortusname_p,},
	{	v("cudf_hex"),		&cudf_hex_p,		},
	{	v("cudf"),		&cudf_p,		},
	{	v("hostname"),		&hostname_p,		},
	{	v("$"),			&pid_text_p,		},
	{	v("host"),		&hostname_p,		},
	{	v("tty"),		&ttynam_p,		},
	{	v("ttynam"),		&ttynam_p,		}
};
#undef v

main(argc, argv)
register char **argv;
{
	register int s, pid;
#ifdef	X25
#ifdef	SUNLINK
	CONN_DB hosts[MAXADDRS];
	CONN_DB	from;
#if	(SUNLINK_VER < 700)
	FACILITY_DB facil;
#endif
#endif	SUNLINK
#define	HOST	hosts[activehost]
	int	pktsize = 0;
	int	wndsize	= 0;
	char	*base_x25	= (char *) 0;
	char	*x25_link	= (char *) 0;
#endif	X25
#ifdef	X25_TCP
	struct sockaddr_in sins[MAXADDRS], sfrom;
#define	SIN	sins[activehost]
#endif	X25_TCP
	int fds[MAXADDRS];	/* the file descriptors	*/
	int fdt[MAXADDRS];	/* the type of socket	*/
	int maxpfd = getdtablesize();
	int maxfd = 0;
	int listen_fds;
	int fromlen;
	int currhost;
	char *kill_string = (char *) 0;
	fd_set	xx;		/* mask for select */
	int i, t;
	int loop_count = 0;

	chdir("/tmp");
	my_pid = getpid();
	gethostname(hostname, sizeof hostname);
	FD_ZERO(&xx);
#ifdef	FD_SETSIZE
	if (maxpfd > FD_SETSIZE) maxpfd = FD_SETSIZE;
#endif	/* FD_SETSIZE */

	while ((i = getopt(argc, argv, optargs)) != EOF) switch(i)
	{
	default:
		fprintf(stderr, "%s: bad args for: %s [%s] (try -h)\n",
			*argv, *argv, optargs);
		exit(1);
#ifdef	X25
	case 'A': if (addresses < MAXADDRS)
		  {	addr_type[addresses] = ADDR_X25_FULL;
			x25link[addresses] = x25_link;
			lpid[addresses] = l_pid;
			lpidlen[addresses] = l_pid_len;
			lpidmask[addresses] = l_pid_mask;
			lpidmasklen[addresses] = l_pid_mask_len;
			address[addresses++] = optarg;
		  }
		  else fprintf(stderr, " **** address %s ignored\n", optarg);
									break;
	case 'a': if (addresses < MAXADDRS)
		  {	addr_type[addresses] = ADDR_X25_BASE;
			x25link[addresses] = x25_link;
			lpid[addresses] = l_pid;
			lpidlen[addresses] = l_pid_len;
			lpidmask[addresses] = l_pid_mask;
			lpidmasklen[addresses] = l_pid_mask_len;
			address[addresses++] = optarg;
		  }
		  else fprintf(stderr, " **** address %s ignored\n", optarg);
									break;
	case 'b': base_x25 = optarg;
		  if (strlen(base_x25) != 12) fprintf(stderr,
			" **** base address %s is %d characters\n",
			base_x25, strlen(base_x25));
									break;
#endif	X25
	case 'c': def_auth = optarg;					break;
#ifdef	X25
	case 'C': x25_link = optarg;					break;
#endif	X25
	case 'd': x25b_debug = atoi(optarg);				break;
	case 'D': debug = atoi(optarg);					break;
	case 'f': authfile = optarg;					break;
#ifdef	X25
	case 'F': x25_link = optarg;					break;
#endif	/* X25 */
	case 'H': force_mode = M_HIDE;					break;
	case 'h': help(); exit(0);
	case 'I': if (inetd) notty++; inetd++;				break;
	case 'i': authfile_interval = atoi(optarg);			break;
	case 'K': kill_file = optarg;					break;
	case 'k': kill_string = optarg;					break;
	case 'l': logfile = save_str(optarg);				break;
	case 'L': if (i = atoi(optarg))	max_shortname = i;
		  else fprintf(stderr,
		       " **** invalid shortname length %s ignored\n", optarg);
									break;
	case 'M': force_mode = M_MESSAGE;				break;
	case 'm': l_pid_mask = (u_char *) ""; l_pid_mask_len = 0;	break;
	case 'N': force_mode = M_NATIVE;				break;
#ifdef	NSAP
	case 'n': if (addresses < MAXADDRS)
		  {	addr_type[addresses] = ADDR_NSAP;
			x25link[addresses] = x25_link;
			lpid[addresses] = l_pid;
			lpidlen[addresses] = l_pid_len;
			lpidmask[addresses] = l_pid_mask;
			lpidmasklen[addresses] = l_pid_mask_len;
			address[addresses++] = optarg;
		  }
		  else fprintf(stderr, " **** NSAP %s ignored\n", optarg);
									break;
#endif	NSAP
#ifdef	X25_TCP
	case 'p': if (addresses < MAXADDRS)
		  {	addr_type[addresses] = ADDR_TCP;
			address[addresses++] = optarg;
		  }
		  else fprintf(stderr, " **** port %s ignored\n", optarg);
									break;
#endif	X25_TCP
#ifdef	X25
	case 'P': i = atoi(optarg);
		  if ((i & -i) != i)
		  	fprintf(stderr,
			"Packet size (%s) must be a power of two\n", optarg);
		  else if (i < 32 || i > 1024)
			fprintf(stderr,
			"Packet size (%s) is not sensible -- ignored\n",
				optarg);
		  else	pktsize = i;
		  break;
	case 's': if (addresses < MAXADDRS)
		  {	addr_type[addresses] = ADDR_X25_SUB;
			basename[addresses] = base_x25;
			x25link[addresses] = x25_link;
			lpid[addresses] = l_pid;
			lpidlen[addresses] = l_pid_len;
			lpidmask[addresses] = l_pid_mask;
			lpidmasklen[addresses] = l_pid_mask_len;
			address[addresses++] = optarg;
		  }
		  else fprintf(stderr, " **** subaddress %s ignored\n", optarg);
		break;
	case 't': l_pid = (u_char *) ""; l_pid_len = 0;			break;
	case 'W': i = atoi(optarg);
		  if (i < 1 || i > 7)
			fprintf(stderr,
			"Window size (%s) is not sensible -- ignored\n",
				optarg);
		  else	wndsize = i;
		  break;
#endif	X25
	case 'X': max_child = atoi(optarg);
		if (max_child == 0 || max_child >= MAX_CHILD)
		{     fprintf(stderr,
			      "max_child must be 1 - %d. Ignoring `%s'\n",
			      MAX_CHILD, optarg);
		      max_child = -1;
		}							break;
	}

	logit_counts = base_logit_counts;

	if (kill_string) exit(send_kill(kill_string));

	if (optind == 1 && argc == 2 && is_inetd_arg(argv[1]))
		optind++, inetd++;

	zap_argv = argv[0];

	/* ----------------------------------------------------------------
	 * This code has been exec'd by another listener which has decided
	 * that x29d is if fact the relevant server (e.g. ybtsd)
	 * Detect this by looking at the environment.
	 * ----------------------------------------------------------------
	 */
	if (inetd)
	{
		int len = sizeof(sfrom);
		x25 = 0;
		call_type = ADDR_TCP;
		getpeername(x25, (struct sockaddr *)&sfrom, &len);
		init_deb("inetd open");
		goto inetd_to_here;

	}
	{	char *x25dte = getenv("X25DTE");
		if (x25dte)
		{	char *ybtstext = getenv("YBTSTEXT");
			char *ybtscalled = getenv("YBTSCALLED");
			char *called_dte_ = getenv("CALLED_DTE");
			char *calling_givenname= getenv("CALLING_NAME");
			char *protocol = getenv("PROTOCOL");
			init_deb("ybtsd open");

			if (!calling_givenname)
				calling_givenname= getenv("CALLING_SHORTNAME");
			ts29 = 1;
			x25 = 4;
			if (called_dte_)
				strcpy(called_dte, called_dte_);
			else
			{
#ifdef	X25
				if (read_host_addr(x25, called_dte) < 0)
				{	logit(1, "read_host_addr failed\n");
					perror("x29d Cant read host address");
					exit(1);
				}
#endif	X25
			}
#ifdef	X25
			accepted = 1;
#ifdef	X25_TCP
			if (protocol &&
			    (!strcmp(protocol, "SUNLINK") ||
			     !strcmp(protocol, "X25")))
#endif	X25_TCP
				call_type = ADDR_X25_BASE;
#endif	X25
#ifdef	X25_TCP
#ifdef	X25
			if (protocol && !strcmp(protocol, "X25B"))
#endif	X25
				call_type = ADDR_TCP;

			if (call_type == ADDR_TCP)
				x25b_init_system();
#endif	X25_TCP
			strcpy(calling_dte, (x25dte) ? x25dte : unset);
			strcpy(calling_mac, unset);
			strcpy(calling_aef, unset);
			strcpy(called_aef, unset);
			*calling_mac = '\0';
			*calling_aef = '\0';
			*called_aef = '\0';
			strcpy(called_ybts,(ybtscalled) ? ybtscalled : unset);
			strcpy(calling_ybts, (ybtstext) ? ybtstext : unset);
			sprintf(calling_addr, "%s.%s",
				(x25dte) ? x25dte : unset,
				(ybtstext) ? ybtstext : unset);
			if (debug & D_TRACE) logit(1, "%x:%s=%s/%s/%s %s/%s\n",
				calling_givenname,
				(calling_givenname) ? calling_givenname : "<none>",
				calling_mac,
				calling_dte, calling_ybts,
				called_dte, called_ybts);
			read_auth();
			if (! * called_ybts)
			{	if (debug & D_TRACE) logit(0, "%s/%s/%s %s/%s\n",
					calling_mac,
					calling_dte, calling_ybts,
					called_dte, called_ybts);
				strcpy(called_ybts,
					(ybtscalled) ? ybtscalled : unset);
				if (debug & D_TRACE) logit(0, "%s/%s/%s %s/%s\n",
					calling_mac,
					calling_dte, calling_ybts,
					called_dte, called_ybts);
			}
			if (calling_givenname)
			{	strcpy(calling_longname, calling_givenname);
				strcpy(calling_name,     calling_givenname);
			}
			else *calling_longname =  *calling_name = '\0';
			process_call();
		}
	}

	/* If no addresses or subaddresses, listen on null address */
	if (!addresses)
	{
#ifdef	X25
		addr_type[addresses] = ADDR_X25_BASE;
		x25link[addresses] = x25_link;
		address[addresses] = def_x25_addr;
		lpid[addresses] = l_pid;
		lpidlen[addresses] = l_pid_len;
		lpidmask[addresses] = l_pid_mask;
		lpidmasklen[addresses++] = l_pid_mask_len;
#endif
#ifdef	X25_TCP
		addr_type[addresses] = ADDR_TCP;
		address[addresses++] = def_tcp_addr;
#endif
	}

	read_auth();

	/* ----------------------------------------------------------------
	 * Now start up a listener for each address
	 * ----------------------------------------------------------------
	 */
	for (currhost=0, activehost = 0;
		currhost < addresses && activehost < MAXADDRS; currhost++)
	{	int s;
		char *addr = address[currhost];
		if (!addr)
		{	logit(1, "Null address !!\n");
			break;
		}

		switch(addr_type[currhost])
		{
		default:
		logit(1, "Internal confusion -- type %d\n", addr_type[currhost]);
					break;
#ifdef	X25
#ifdef	NSAP
		case ADDR_NSAP:
#endif	NSAP
		case ADDR_X25_BASE:
		case ADDR_X25_FULL:
		case ADDR_X25_SUB:
		{	int one = 1;
#ifdef	NSAP
#ifdef	ANY_NSAP
			if (addr_type[currhost] == ADDR_NSAP)
				HOST.hostlen |= ANY_NSAP | AEF_ON;
#endif	ANY_NSAP
#endif	NSAP
			s = x25_bind_4(address[currhost],
				lpid[currhost], lpidlen[currhost],
				0, &one,
				&HOST, basename[currhost], x25link[currhost],
				addr_type[currhost] == ADDR_X25_SUB ? 1 :
#ifdef	NSAP
				addr_type[currhost] == ADDR_NSAP ? -2 :
#endif	NSAP
				addr_type[currhost] == ADDR_X25_BASE ? 0 :-1);
		}
		if (s < 0)
		{	logit(1, "Failed to listen on '%s' (%d)\n",
					address[currhost], s);
			continue;
		}

		logit(1, "%2d Listening", s);
		if (HOST.hostlen & ADR_LEN_MASK)
		{	logit(0, " on %2x %2d: ", HOST.hostlen & ~ADR_LEN_MASK,
				HOST.hostlen & ADR_LEN_MASK);
			for(i=0; i<((HOST.hostlen & ADR_LEN_MASK)/2); i++)
				logit(0, "%02x", HOST.host[i] & 0xff);
			if (HOST.hostlen & 1)
			  logit(0, "%x",
			   ((HOST.host[(HOST.hostlen&ADR_LEN_MASK)/2])>>4)&0xf);
		}
		if (lpidlen[currhost] > 0)
		{	logit(0, " PID=");
			for(i=0; i<lpidlen[currhost]; i++)
				logit(0, "%02x", lpid[currhost][i] & 0xff);
			if (lpidmasklen[currhost] && lpidlen[currhost])
			{	int mask = 0;
				for(i=0; i<lpidmasklen[currhost]; i++)
				    if ((lpidmask[currhost][i] & 0xff) !=0xff)
					mask++;
				if (mask)
				{	logit(0, " mask ");
					for(i=0; i<lpidmasklen[currhost]; i++)
                        				logit(0, "%02x",
						lpidmask[currhost][i] & 0xff);
				}
			}
		}
		if (basename[currhost])
			logit(0, " base %s", basename[currhost]);
#ifdef	ANY_LINK
		if (! (HOST.hostlen & ANY_LINK))
			logit(0, " only");
#endif	/* ANY_LINK */
		if (x25link[currhost])
			logit(0, " on link %s", x25link[currhost]);
#ifdef	ANY_SUBADDRESS
		if (HOST.hostlen & ANY_SUBADDRESS)
			logit(0, " on any subaddr");
#endif	/* ANY_SUBADDRESS */
#ifdef	EXACT_MATCH
		if (HOST.datalen & EXACT_MATCH)
			logit(0, " with exact PID match");
#endif	/* EXACT_MATCH */
#ifdef	T_FACILITIES
		{	FACILITY facility;
			facility.type = T_FACILITIES;
			if (ioctl(s, X25_GET_FACILITY, &facility))
				logit(1, "Failed to read facilities");
			else if (facility.f_facilities & ~ 0)
				logit(0, " with facilties %x", facility.f_facilities);
		}
#endif
		logit(0, "\n");

		{
int n;
		struct facilities data;
		data.x4_fflags = 0;

		data.x4_fast_select =FACIL_YES;
		data.x4_fflags |= FACIL_F_FAST_SELECT;
#ifndef	SUNFACILBUG
		data.x4_reverse_charge	= 1;
		data.x4_fflags |= FACIL_F_REVERSE_CHARGE;
#else	SUNFACILBUG
		data.x4_reverse_charge	= 0;
		for (i=0; i<formats; i++)
		{	if (format[i].l_flags & LF_REV_CHARGE)
			{	data.x4_reverse_charge	= 1;
				data.x4_fflags |= FACIL_F_REVERSE_CHARGE;
				break;
			}
		}
#endif	SUNFACILBUG
#ifdef		X25_SET_FACILITY
		if (pktsize)
#endif
		{	data.x4_sendpktsize = pktsize;
			data.x4_fflags |= FACIL_F_SENDPKTSIZE;
			data.x4_recvpktsize = pktsize;
			data.x4_fflags |= FACIL_F_RECVPKTSIZE;
		}
#ifdef		X25_SET_FACILITY
		if (wndsize)
#endif
		{	data.x4_sendwndsize = wndsize;
			data.x4_fflags |= FACIL_F_SENDWNDSIZE;
			data.x4_recvwndsize = wndsize;
			data.x4_fflags |= FACIL_F_RECVWNDSIZE;
		}
		if ((n=x25_set_facil(s, &data, 0)) < 0)
		{	perror("x29d Failed to set facilties");
			fprintf(stderr, "\ti.e. %d on %d\n", n, s);
			/* close(s);
			continue;
			*/
		}
		}
#ifdef	SUNLINK
		/* I'll accept or reject the call, thankyou */
		if (ioctl(s, X25_CALL_ACPT_APPROVAL, &one) < 0)
		{	perror("X25_CALL_ACPT_APPROVAL failed");
			close(s);
			continue;
		}
#endif	SUNLINK
		if (x25_listen(s, 5, &one) < 0)
		{	perror("x29d Listen failed");
			close(s);
			continue;
		}
		break;
#endif	X25

#ifdef	X25_TCP
		case ADDR_TCP:
		s = socket(AF_INET, SOCK_STREAM, 0);
		if (s < 0)
		{	perror("x29d Failed to open tcp socket");
			continue;
		}
		bzero(&SIN, sizeof sins[0]);
		SIN.sin_family	= AF_INET;
		{	struct servent *sp = getservbyname(addr, "tcp");
			if (sp == NULL)
			{	if ('0' <= *addr && *addr <= '9')
					SIN.sin_port = htons(atoi(addr));
				else
				{	logit(1, "no %s/tcp service\n", addr);
					close(s);
					continue;
				}
			}
			else SIN.sin_port = sp->s_port;
		}
		logit(1, "%2d Listening on %s (%d)\n", s,
				addr, ntohs(SIN.sin_port));

		if (bind(s, (struct sockaddr *)&SIN, sizeof sins[0]) < 0)
		{	perror("x29d Failed to bind socket");
			close(s);
			continue;
		}
		if (listen(s, 5) < 0)
		{	perror("x29d Listen failed");
			close(s);
			continue;
		}
		break;
#endif	X25_TCP
		}

		if (s >= maxpfd)
		{	fprintf(stderr, "too many fds to listen on\n");
			close(s);
			continue;
		}

		FD_SET(s, &xx);
		if (s+1 > maxfd) maxfd = s+1;
		fdt[activehost  ] = addr_type[currhost];
		fds[activehost++] = s;
	}

	if (!maxfd)
	{	logit(1, "No valid address\n");
		exit(1);
	}

	listen_fds = activehost;

	/* ----------------------------------------------------------------
	 * Now detatch for the tty, catch signals, etc.
	 * ----------------------------------------------------------------
	 */
	if (!(debug & D_NOBACKGROUND))
	{	if (fork()) exit(0);
		else	my_pid = getpid();
	}

	if (kill_file && *kill_file)
	{	FILE *kill = fopen(kill_file, "w");
		if (kill)
		{
			fprintf(kill, "%d\n", my_pid);
			fclose(kill);
		}
		else logit(12, "Failed to open kill file `%s'\n", kill_file);
	}

	init_deb("x29d start");

	if (!(debug & D_NODETACH))
	{	/* No more need for stdin, stderr, etc, so ZAP them */
		close(0);
		close(1);
		close(2);
		i = open("/dev/null", 0);
		if (i >= 0)
		{	(void) dup2(i, 1);
			(void) dup2(i, 2);
			if (i) { dup2(i, 0); close(i);}
		}
		else logit(1, "Failed to open /dev/null");

		if (notty == 1)
		{
		/* and detach the terminal */
		i = open("/dev/tty", 2);
		if (i >= 0)
		{	(void) ioctl(i, TIOCNOTTY, (char *) 0);
			close(i);
		}
		else logit(1, "Failed to open /dev/tty");
		}
		else logit(1, "no notty\n");
	}

	(void) signal(SIGHUP, read_auth);
	(void) signal(SIGCHLD, grimreaper);
	(void) signal(SIGPIPE, SIG_IGN);
	(void) signal(SIGINT, SIG_IGN);
	(void) signal(SIGQUIT, SIG_IGN);

	if (debug & D_TRACE) logit(3, "%d: started with maxfd=%d for %d fd%s (%x)\r\n",
		my_pid, maxfd, listen_fds, (listen_fds) == 1 ? "" : "s", xx);

	/* ----------------------------------------------------------------
	 * Now await an incoming call (or the death of a child)
	 * ----------------------------------------------------------------
	 */
	for(;;)
	{	long this_time;
		int slot;
		int max = (max_child > 0) ? max_child : MAX_CHILD;

		caddr_t sbrk();
		caddr_t this_sbrk;
		fd_set	yy;
		yy = xx;		/* result of select */

		loop_count++;
		if ((this_sbrk = sbrk(0)) != last_sbrk)
		{	if (last_sbrk) logit(3, "Sbrk up by %d on %d (%x -> %x)\n",
				this_sbrk - last_sbrk, loop_count, last_sbrk, this_sbrk);
			last_sbrk = this_sbrk;
		}
		if (select(maxfd, &yy, 0, (int *) 0, 0) <= 0)
		{	if (errno == EINTR)	continue;
			if (debug & D_TRACE) logit(3, "Select on %d fd's failed %d\n",
				maxfd, errno);
			perror("select");
			exit(1);
		}

		activehost = -1;
		for (i=0; i<listen_fds; i++) if (FD_ISSET(fds[i], &yy))
			{ activehost = i; break; }

		if (activehost < 0)
		{	if (debug & D_TRACE) logit(3, "Failed to find any active fds on select\n");
			exit(1);
		}
		s = fds[activehost];

		for (slot=0; slot< max; slot++)
			if (!children[slot].pid) break;

		/* --------------------------------------------------------
		 * We have the (first) incoming call, so process it.
		 * --------------------------------------------------------
		 */
		switch (call_type = fdt[activehost])
		{
#ifdef	X25
#ifdef	NSAP
		case ADDR_NSAP:
#endif	NSAP
		case ADDR_X25_BASE:
		case ADDR_X25_FULL:
		case ADDR_X25_SUB:
		fromlen = sizeof(from);
		x25 = x25_accept(s, &from, &HOST, 0, &one);
		if (slot >= max && max_child >= 0)
		{	logit(1, "Too many children (%d)\n", max_child);
			close_with_diag(x25, 0, 0x11, 0);
		}
		break;
#endif	X25

#ifdef	X25_TCP
		case ADDR_TCP:
		fromlen = sizeof sfrom;
		x25 = accept(s, (struct sockaddr *)&sfrom, &fromlen);
#endif	X25_TCP
		}

		(void) time(&this_time);
		if (x25 < 0)
		{	if (errno == EINTR)	continue;
			if (debug & D_TRACE) logit(15, "accept failed");
			perror("x29d Accept failed");
			exit(1);
		}

logit(3, "Sbrk-0 %x\n", sbrk(0));
if (sbrk(0)!=last_sbrk) logit(3, "Sbrk-5 %x\n", sbrk(0));
		/* Should we look at authfile again ? */
		if ((this_time - last_auth) > authfile_interval)
		{	struct stat statbuf;
if (sbrk(0)!=last_sbrk) logit(3, "Sbrk-5.0 %x\n", sbrk(0));
			if (stat(authfile, &statbuf))
				perror(authfile);
			else if (statbuf.st_mtime != auth_timestamp)
{	logit(3, "Stamp %x -> %x\n", statbuf.st_mtime, auth_timestamp);
				read_auth();
}
			else	last_auth = this_time;
if (sbrk(0)!=last_sbrk) logit(3, "Sbrk-5.1 %x\n", sbrk(0));
		}

if (sbrk(0)!=last_sbrk) logit(3, "Sbrk-6 %x\n", sbrk(0));
		if ((this_time - last_log) > logfile_interval)
			init_deb("interval timer");

		/* --------------------------------------------------------
		 * Fire off a child to process the call (& record the pid)
		 * --------------------------------------------------------
		 */
if (sbrk(0)!=last_sbrk) logit(3, "Sbrk-7 %x\n", sbrk(0));
		if (!(debug & D_NOFORK))
		{
			while ((pid = fork()) < 0)
				sleep(60);
			if (pid < 0) continue;

			if (pid)
			{	close(x25);     /* parent listens */

				if (slot < max)
				{	children[slot].pid = pid;
					children[slot].type= -1;
														}
			}
			else if (slot >= max)
			{	if (max_child >= 0)
				{	logit(1, "Too many children (%d)\n",
	                                        max_child);
					close_with_diag(x25, 0x11, 0x11/*??*/, 1);
														}
				logit(1, "Should have junked as no slot\n");
			}
			else	break;
		}
		else	break;
		logit_counts = base_logit_counts;
	}

	logit_counts = base_logit_counts;
	/* ----------------------------------------------------------------
	 * By the time we get here, the call has been established,
	 * and it is this process' responsibility to do the job in hand.
	 * 
	 * Tidy up any old files, pick up & log any specific info.
	 * ----------------------------------------------------------------
	 */
	my_pid = getpid();
	for (i=0; i<listen_fds; i++) if (FD_ISSET(fds[i], &xx))
		close(fds[i]);

	/* OK -- we have a child processing an incoming call ... */
	switch (fdt[activehost])
	{
#ifdef	X25
#ifdef	NSAP
	case ADDR_NSAP:
#endif	NSAP
	case ADDR_X25_BASE:
	case ADDR_X25_FULL:
	case ADDR_X25_SUB:
	{
	struct facilities data;
	if (x25_read_facil(x25, &data, 0) < 0)
logit(1, "		close_with_diag(x25, 0x00, 0x13, 1);	\n");
	if (debug  &D_TRACE) if (data.x4_reverse_charge)
		if (debug & D_TRACE) logit(1, "Rev %d\n", data.x4_reverse_charge);

	if (data.x4_recvpktsize != 128 ||
	    data.x4_sendpktsize != 128 ||
	    data.x4_recvwndsize != 2 ||
	    data.x4_sendwndsize != 2 ||
	    data.x4_recvthruput ||
	    data.x4_sendthruput)
		if (debug & D_TRACE) logit(1, "pkt=%d/%d, window=%d/%d, thru=%d/%d\n", 
			data.x4_recvpktsize, data.x4_sendpktsize,
			data.x4_recvwndsize, data.x4_sendwndsize,
			data.x4_recvthruput, data.x4_sendthruput);

	reverse_charged = data.x4_reverse_charge;

	bin2hex(&from, calling_dte);
	bin2hex(&HOST, called_dte);
	*calling_mac = '\0';
	*calling_aef = '\0';
	*called_aef = '\0';
#ifdef	X25_RD_LOCAL_ADR
	{	CONN_ADR loc;
		if (ioctl(x25, X25_RD_LOCAL_ADR, &loc)) {
			perror("ioctl(X25_RD_LOCAL_ADR)");
			exit(1);
		}
		bin2hex(&loc, called_dte);
	}
#endif	/* X25_RD_LOCAL_ADR */
#ifdef	T_CALLED_AEF
	{	FACILITY facility;
		facility.type = T_CALLED_AEF;
		if (ioctl(x25, X25_GET_FACILITY, &facility))
			logit(1, "Failed to read called AEF");
		else bintohex(called_aef,
			facility.f_cd_aef, facility.f_cd_aef_len);
	}
#endif
#ifdef	T_CALLING_AEF
	{	FACILITY facility;
		facility.type = T_CALLING_AEF;
		if (ioctl(x25, X25_GET_FACILITY, &facility))
			logit(1, "Failed to read calling AEF");
		else bintohex(calling_aef,
			facility.f_cg_aef, facility.f_cg_aef_len);
	}
#endif
#ifdef	X25_RD_MACADDR
	{	X25_MACADDR mac;
		if (ioctl(x25, X25_RD_MACADDR, &mac)) {
			logit(1, "Failed to read MAC address\n");
		}
		else bintohex(calling_mac, mac.macaddr, mac.maclen * 2);
	}
#endif
	strcpy(calling_addr, calling_dte);

#ifdef	SUNLINK
	bcopy(from.data, cudf, cudflen = from.datalen);
#endif	SUNLINK
	}
	break;
#endif	X25

#ifdef	X25_TCP
	case ADDR_TCP:
	{	struct hostent *host, *gethostbyaddr();
		struct x25io data;
		char *inet_ntoa();
		char *called;

inetd_to_here:
		called = data.x_destination;
		host = gethostbyaddr((char *)&sfrom.sin_addr,
			sizeof (sfrom.sin_addr), AF_INET);

		if (x25b_receive_call(x25, &data) <= 0)
		{	logit(1, "Failed to read caller info %d\n", errno);
			exit(1);
		}

		if (debug) if (debug & D_TRACE) logit(3, "called starts with %02x (%s)\n",
				(*called & 0xff), called);
		/* Is it actually called + calling [+calling name] encoded? */
		if (*called & 0x80)
		{	int called_len  = *(called++)		& 0x7f;
			int calling_len =   called[called_len]	& 0x7f;
			int callingn_len=   called[called_len+calling_len+1];

			strncpy(calling_dte, called+called_len+1,
				calling_len);
			called[called_len] = '\0';
			calling_dte[calling_len] = '\0';
			if (callingn_len)
			{	callingn_len &= 0x7f;
				if (debug) if (debug & D_TRACE) logit(1, "Calling name is %d: %s\n",
					callingn_len,
					called+called_len+calling_len+2);
				if (callingn_len)
				{	calling_givenname=_calling_givenname;
					if (callingn_len >= sizeof _calling_givenname)
					callingn_len = sizeof _calling_givenname -1;
					
					strncpy(calling_givenname,
						called+called_len+calling_len+2,
						callingn_len);
					calling_givenname[callingn_len] = '\0';
				}
			}
		}
		else	*calling_dte = '\0';

		if (debug & D_TRACE) logit(3, "%s@%s => %s\n",
			data.x_username,
			(host) ? host->h_name : inet_ntoa(sfrom.sin_addr),
			(called && *called) ? called : "*");
		strncpy(called_dte, called, sizeof called_dte);
		called_dte[sizeof called_dte -1] = '\0';
		bzero(cudf, sizeof cudf);
		bcopy(data.x_cudf, cudf,
			cudflen = data.x_cudflen);
		strcpy(calling_addr, calling_dte);
#ifdef	X25
		accepted = 1;
#endif	X25
	}
#endif	X25_TCP
	}

	bzero(cudf_hex, sizeof cudf_hex);
	for (i=0; i<cudflen; i++)
	{	cudf_hex[ 2*i   ] = toHEX((cudf[i] >> 4) & 0x0f);
		cudf_hex[(2*i)+1] = toHEX((cudf[i]     ) & 0x0f);
	}

	prof_byte = cudf[PROF_BYTE];
	/* Remember the profile info ... */
	if (cudflen > 1) for (i=0; i< PROFILES; i++)
		if(profile[i].p_id == prof_byte)
			termwidth =profile[i].p_width;

	*calling_longname = '\0';
	*calling_name = '\0';
	process_call();
}

/* ------------------------------------------------------------------------
 * We get here either having decided that some other listerener (e.g. ybtsd)
 * has established the call, or having done it all ourselves.
 * 
 * All connections open, all info gathered, so GO FOR IT !
 * ------------------------------------------------------------------------
 */
process_call()
{	int i, t;
	struct sgttyb b;
	char whence_[120];
	char *whence = whence_;

	lookup_name(calling_name, calling_mac, calling_aef,
		calling_dte, calling_ybts,calling_longname);

	if (*calling_name && calling_givenname &&
	    strcmp(calling_name, calling_givenname))
		if (debug & D_TRACE) logit(1, "Calling name is %s or %s\n",
			calling_name, calling_givenname);

	if (!*calling_name)
	{	if (calling_givenname && *calling_givenname)
			strcpy(calling_name, calling_givenname);
		else	strcpy(calling_name, calling_dte);
	}
	if (!*calling_longname)
	{	if (calling_givenname && *calling_givenname)
			strcpy(calling_longname, calling_givenname);
		else	strcpy(calling_longname, calling_dte);
	}

	calling_shortname = calling_name;
	if (!ts29)
	{	char *a1 = "<a1 unset>", *a2 = "<a2 unset>", *a3 = "", *a4 = "";
		char buff[1024];
		int res = ts_buff_decode8(cudf+PID_LEN, buff, cudflen-PID_LEN,
				(int *) 0, 4, &a1, &a2, &a3, &a4);
		int i;

		if (res >= 2)
		{	if (debug & D_TRACE) logit(1, "CUDF is encoded: <%d:%s|%s|%s|%s>\n",
				res, a1, a2, a3, a4);
			strcat(calling_name, ".");
			strcat(calling_name, a2);
			strcat(calling_longname, ".");
			strcat(calling_longname, a2);
			cudflen = strlen(a1) + PID_LEN;
			bcopy(a1, cudf+PID_LEN, cudflen - PID_LEN);
			bzero(cudf_hex, sizeof cudf_hex);
			for (i=0; i<cudflen; i++)
			{	cudf_hex[ 2*i   ] = toHEX((cudf[i] >> 4)&0x0f);
				cudf_hex[(2*i)+1] = toHEX((cudf[i]     )&0x0f);
			}
		}
	}
	uk2us(calling_shortusname, calling_shortname);
	uk2us(calling_longusname, calling_longname);
	uk2us(calling_usname, calling_name);
	/* Lets try to make a name that'll fit nicely in utmp */
	if (strlen(calling_shortname) > max_shortname)
	{	calling_shortname += strlen(calling_shortname) -
					max_shortname;
		if (calling_shortname[-1] == '.')
			;
		else if (calling_shortname[0] == '.')
			calling_shortname++;
		else if (calling_shortname[1] == '.')
			calling_shortname += 2;
		else if (calling_shortname[2] == '.')
			calling_shortname += 3;
	}

	sprintf(whence, "<%s/%s/%s", calling_mac, calling_aef, calling_name);
	while(*whence) whence++;
	if (strcmp(calling_shortname, calling_name))
		sprintf(whence, "=%s", calling_shortname);
	while(*whence) whence++;
	if (strcmp(calling_addr, calling_name) &&
	    strcmp(calling_addr, calling_shortname))
		sprintf(whence, "|%s", calling_addr);
	while(*whence) whence++;
	sprintf(whence, " >%s/%s", called_aef, (*called_dte) ? called_dte:"*");
	while(*whence) whence++;
	if (prof_byte) sprintf(whence, ":%d", prof_byte);
	while(*whence) whence++;
	if (!ts29) sprintf(whence, ":%*.*s", PID_LEN*2, PID_LEN*2, cudf_hex);
	while(*whence) whence++;
	{ char *p= (ts29) ? called_ybts :
			(isprints(cudf+PID_LEN)) ? cudf+PID_LEN :
						(cudf_hex + PID_LEN*2);
	  if (*p) sprintf(whence, ".%s", p);
	  while(*whence) whence++;
	}
	whence = whence_;
	logit(3, "%s\n", whence);
	/* ----------------------------------------------------------------
	 * Try looking up the call four times:
	 * 	calling addr & ybts/cudf
	 * 	calling name & ybts/cudf
	 * 	calling addr & hex cudf
	 * 	calling name & hex cudf
	 * e.g. 00000801008001 & abc, uk.ac.cam.cl & abc, 
	 *      00000801008001 & 01050d00616263, uk.ac.cam.cl & 01050d00616263
	 * ----------------------------------------------------------------
	 */
	if ((auth_line = valid_request(
		lower((ts29) ? called_ybts : cudf+PID_LEN),
		lower(calling_addr), 1)) < 0)
	    if ((auth_line = valid_request(
		lower((ts29) ? called_ybts : cudf+PID_LEN),
		lower(calling_name), 2)) <0)
	    	if (ts29 || (auth_line = valid_request(lower(cudf_hex),
		    lower(calling_name), 3)) <0)
		    if (ts29 || (auth_line = valid_request(lower(cudf_hex),
			lower(calling_name), 4)) <0)
			{ if (debug & D_TRACE) logit(3, "Sigh ... what can one do ....\n");
			close_with_diag(x25, 0x80, 0x11, 1);
			}

	/* Now check if reverse charge call allowed */
	if (reverse_charged && !(format[auth_line].l_flags & LF_REV_CHARGE))
		close_with_diag(x25, 0x00, 0x19, 1);
	if (format[auth_line].l_flags & LF_NATIVE)  force_mode = M_NATIVE;
	if (format[auth_line].l_flags & LF_MESSAGE) force_mode = M_MESSAGE;
	if (format[auth_line].l_flags & LF_HIDE)    force_mode = M_HIDE;

#ifdef	X25
	if (debug)	if (debug & D_TRACE) logit(0, "type=%d, Ts29=%d ..\n", call_type, ts29);
	switch (call_type)
	{
	case ADDR_X25_BASE:
#ifdef	NSAP
	case ADDR_NSAP:
#endif	NSAP
	case ADDR_X25_FULL:
	case ADDR_X25_SUB:
		if (!accepted)	accept_call(x25);
	}
#endif	X25

	if (debug)	if (debug & D_TRACE) logit(0, "Ts29=%d ..\n", ts29);
	if (ts29 && !(format[auth_line].l_flags & LF_TS_NOACC))	accept_ts();

	sprintf(pid_text, "%d", my_pid);

#ifdef	TELNET
	/* ----------------------------------------------------------------
	 * The connection is marked as "telnet", so do it all internally.
	 * ----------------------------------------------------------------
	 */
	if (format[auth_line].l_telnet)
	{	char telnet_host[128];
		int ok = 1;
		struct sockaddr_in sin;
		register struct hostent *host;
		struct	servent *sp;
		int port = -1;
		char * tel_serv = "telnet";

		expand_dollar(telnet_host, format[auth_line].l_telnet,
			sizeof telnet_host);

		if (format[auth_line].l_tel_port)
			tel_serv = format[auth_line].l_tel_port;
		sp = getservbyname(tel_serv, "tcp");
		if (sp)
			port = sp->s_port;
		else  if (sp == 0 && isdigit(*tel_serv))
			port = htons(atoi(tel_serv));
		if (port == -1)
		{	logit(1, "No %s service", tel_serv); ok = 0;	}
		host = gethostbyname(telnet_host);
		if (host) {
			sin.sin_family = host->h_addrtype;
			bcopy(host->h_addr, (caddr_t)&sin.sin_addr, host->h_length);
		} else {
			sin.sin_family = AF_INET;
			sin.sin_addr.s_addr = inet_addr(telnet_host);
			if (sin.sin_addr.s_addr == -1) {
				logit(1, "unknown host %s\n", telnet_host);
				ok = 0;
			}
		}
		if (debug & D_TRACE) logit(1, "name %s gave %d, %s gave %08x\n",
			tel_serv, ntohs(port), telnet_host, *((long *)&(sin.sin_addr.s_addr)));
		sin.sin_port = port;
		pty = (ok) ? socket(AF_INET, SOCK_STREAM, 0, 0) : -1;
		if (pty  >= 0)
			if (connect(pty, (caddr_t)&sin, sizeof (sin), 0) >= 0)
			{	if (force_mode==M_AUTO) force_mode = M_NATIVE;
				pty_type	= PTY_TELNET;
				if (debug & D_TRACE) logit(3, "Telnet to %s\n", telnet_host);
				x29d(-1);
			}
			else logit(1, "Telnet connect failed (%d)\n", errno);
		else	if (ok) logit(1, "Telnet socket failed(%d)\n", errno);
		if (pty >= 0) close(pty);
		if (format[auth_line].l_flags & LF_ONLY_TELNET)
			fatal(x25, "Call failed");
	}
#endif	TELNET

	/* ----------------------------------------------------------------
	 * If the server expects an x25 socket, start it immediately.
	 * Otherwise, find a free pty and convert x29 to a pty.
	 * ----------------------------------------------------------------
	 */
	if (format[auth_line].l_flags & LF_FORK)
		start_login(x25, 4, -1, whence);

	/* Look for a free PTTY */
	strcpy(ttynam, DEF_TTYNAME);
	for (i = 0; i < LAST_PTY; i++) {
		ttynam[sizeof ttynam -3] = 'p' +(i / 16);
		ttynam[sizeof ttynam -2] = tohex(i % 16);
		pty = open(ttynam, O_RDWR, 0622);
		if (pty >= 0) break;
	}
	if (pty < 0) fatal(x25, "All terminal ports in use");
	if (pty <= 2)
	{	long vec = -1;
		if (debug & D_TRACE) logit(1, "pty is %d", pty);
		pty = nonstdfd(pty, &vec);
		if (debug & D_TRACE) logit(0, " -> %d (%08x)", pty, vec);
	}
	pty_type = PTY_PTY;
	if (x25 != 0) (void) dup2(x25, 0);

	/* Try to arrange that when the tty is opened, it becomes the
	 * controlling tty.
	 * To do this, we must arrange not to have a controlling tty and
	 * to be a session leader.
	 * This can be done in a number of ways .....
	 *
	 * BSD:   TIOCNOTTY on /dev/tty and/or setpgrp(0,0)
	 * SYSV:  setpgrp();
	 * POSIX: setsid()
	 * 
	 * Lets try all of these ....
	 */
#ifdef	TIOCNOTTY
	/* TIOCNOTTY */
	t = open("/dev/tty", O_RDWR, 0622);
	if (t >= 0) {
		ioctl(t, TIOCNOTTY, (char *)0);
		close(t);
	}
#endif	/* TIOCNOTTY */
	setsid();
	setpgrp(0,0);
	ttynam[TTY_BASE] = 't';
	t = open(ttynam, O_RDWR, 0622);	/* slave side of pty */
	if (t < 0) fatalperror(ttynam, errno);
	ioctl(t, TIOCGETP, (char *)&b);
	b.sg_flags = CRMOD|XTABS|ANYP|ECHO;
	ioctl(t, TIOCSETP, &b);
	(void) signal(SIGCHLD, SIG_DFL);

	switch(fork())
	{
	case -1:	fatalperror("x29d fork", errno);
	case 0:		/*my_pid=getpid();*/ start_login(t, -1, pty, whence);
	default:	x29d(t);
	}
	/* NOTREACHED */
}

start_login(t, to, pty, whence)
char *whence;
{	char buff[1024];
	char **args;
	char *server = format[auth_line].l_command;
	char *comname = format[auth_line].l_comname;
	extern char **environ;
	char *newenv[ENVSIZE];
	char _envp[ENVLEN];
	char *envp = _envp;
	int newenvp		= 0;

	if (pty < 0)
	{	sprintf(envp, "TERM=network");
		newenv[newenvp++] = envp; while (*envp++);
	}

	sprintf(envp, "X25DTE=%s",	calling_dte);
	newenv[newenvp++] = envp; while (*envp++);

	sprintf(envp, "X25MAC=%s",	calling_mac);
	newenv[newenvp++] = envp; while (*envp++);

	sprintf(envp, "CALLING_AEF=%s",	calling_aef);
	newenv[newenvp++] = envp; while (*envp++);
	sprintf(envp, "CALLED_AEF=%s",	called_aef);
	newenv[newenvp++] = envp; while (*envp++);

	sprintf(envp, "CALLED_DTE=%s",	called_dte);
	newenv[newenvp++] = envp; while (*envp++);
	sprintf(envp, "CALLING_DTE=%s",	calling_dte);
	newenv[newenvp++] = envp; while (*envp++);

	if (calling_name && *calling_name)
	{	sprintf(envp, "CALLING_NAME=%s",	calling_name);
		newenv[newenvp++] = envp; while (*envp++);
	}
	if (calling_shortname && *calling_shortname)
	{	sprintf(envp, "CALLING_SHORTNAME=%s",	calling_shortname);
		newenv[newenvp++] = envp; while (*envp++);
	}
	if (calling_shortusname && *calling_shortusname)
	{	sprintf(envp, "CALLING_SHORTUSNAME=%s",	calling_shortusname);
		newenv[newenvp++] = envp; while (*envp++);
	}

	sprintf(envp, "PROTOCOL=%s",
#ifdef	X25_TCP
		(call_type == ADDR_TCP) ? "X25B" :
#endif	X25_TCP
#ifdef	NSAP
		(call_type == ADDR_NSAP) ? "NSAP" :
#endif	NSAP
#ifdef	X25
		(call_type == ADDR_X25_BASE) ? "X25" :
		(call_type == ADDR_X25_FULL) ? "X25" :
		(call_type == ADDR_X25_SUB) ? "X25" :
#endif	X25
		"Unknown");
	newenv[newenvp++] = envp; while (*envp++);
	sprintf(envp, "X25_FD=%d",	NET_FD);
	newenv[newenvp++] = envp; while (*envp++);
	sprintf(envp, "STARTTIME=%08x",	time(0L));
	newenv[newenvp++] = envp; while (*envp++);

	for(; *environ && newenvp < ENVSIZE-2;) newenv[newenvp++] = *environ++;
	newenv[newenvp] = NULL;

	if (!comname && !strcmp(server, DEF_COMMAND)) comname = DEF_ARGS;

	expand_dollar(buff, (comname) ? comname : server, sizeof buff);
	if (debug & D_CALL)
	{	char *ptyname = (pty<0) ? "" : rindex(ttynam, '/');
		if (!ptyname) ptyname = ttynam;
		else if (*ptyname == '/') ptyname++;

		logit(3, "++ %s '%s'%s%s (%d %s)\n",
			server, buff, (pty<0) ? "":" & ",
			(pty<0) ? "" : ptyname, my_pid, whence);
		logit(3, "Call %s %d'%s'%s%s (%d)\n",
			server, strlen(buff), buff, (pty<0) ? "":" & ",
			(pty<0) ? "" : ptyname, my_pid);
	}

	args = split_argv(buff, sizeof buff);

	if (pty >= 0) (void) close(pty);


	if (to >= 0)
	{	if (to != t)   (void) dup2(t, to);
		if (to != x25) (void) close(x25);
	}
	else if (t >= 0)
	{	if (t != x25) (void) close(x25);
		if (t != 0) (void) dup2(t, 0);
		if (t != 1) (void) dup2(t, 1);
		if (t != 2) (void) dup2(t, 2);
		if (t != 0 && t != 1 && t != 2) (void) close(t);
	}

	if (format[auth_line].l_gid > 0)
			setgid(format[auth_line].l_gid);
	if (format[auth_line].l_uid > 0)
		setuid(format[auth_line].l_uid);
	errno = -1;
	execve(format[auth_line].l_command, args, newenv);
logit(3, "exec of `%s' failed (%d)\n", format[auth_line].l_command, errno);
	fatalperror (format[auth_line].l_command, errno);
	/*NOTREACHED*/
}

pty_gone(n)
{
	if (debug & D_TRACE) logit(1, "Pty gone (%d)\n", no_pty);
	no_pty++;
}

/*
 * Main loop.  Select from pty and network, and
 * hand data to x29 receiver.
 */
x29d(t)
{
	register int pcc=0, fcc=0, cc;
	register char *fbp;
	register char *pbp = pibuf;
	char echobuf[sizeof pibuf +1];
	int pgrp, x25_interrupt();
	int ptybit	= 1 << pty;
	int x25bit	= 1 << x25;
	int net_skip;
	int echoplex    = 0;

#ifndef	NOZAPARGV
	if (zap_argv)
	{	char *pntr = zap_argv + strlen(zap_argv) +1;
		sprintf(pntr, "<%s%c>%s%c    ",
			calling_name, 0,
			(ts29) ? called_ybts : (cudf+PID_LEN), 0);
	}
#endif	NOZAPARGV

	ts29_skip	= (ts29) ? 1 : 0;
	net_skip	= 1 + ts29_skip;

	if (debug)	if (debug & D_TRACE) logit(1, "Debug = %04x\n", debug);

	/* x29d does not want ^C and/or ^Z ... loose the cntrolling tty */
#ifdef	TIOCNOTTY
	/* TIOCNOTTY */
	{	int t = open("/dev/tty", O_RDWR, 0622);
		if (t >= 0) {
			ioctl(t, TIOCNOTTY, (char *)0);
			close(t);
		}
	}
#endif	/* TIOCNOTTY */
	/* There is a BUG whereby SunOS 4.1+ does NOT set pgrp to 0 ! */
	if ((cc=setpgrp(0,0)) == -1 || getpgrp(0) != 0)
	{	char *set = (cc == -1) ? "" : " (SEEMED)"; 
		if ((cc=setpgrp(0, 1)) == -1)
		{	if ((cc=setpgrp(0, getpid()+1)) == -1)
				logit(3, "can't find ANY pgrp%s\n",  set);
			else	logit(3, "setpgrp(0, getpid()+1) %d-%d%s\n",
					cc, getpgrp(0));
		}
		else	logit(3, "setpgrp(0, 1) %d-%d%s\n",
				cc, getpgrp(0), set);
	}

	/* In case we didn't loose the $$!!$$ terminal ... */
	(void) signal(SIGINT, SIG_IGN);
	(void) signal(SIGHUP, SIG_IGN);
	(void) signal(SIGTSTP, SIG_IGN);
	(void) signal(SIGTTOU, SIG_IGN);

	ioctl(x25, FIONBIO, (char *)&one);
	ioctl(pty, FIONBIO, (char *)&one);
	set_width(pty, termwidth);

	if (debug  &D_TRACE)	logit(1, "pty_type=%d, force_mode=%d\n",
				pty_type, force_mode);
	switch (pty_type)
	{
#ifdef	TELNET
	case PTY_TELNET:
		break;
#endif	TELNET
	default:
		/* Set into pkt mode if that is possible */
		errno = -1;
#ifdef	PKT_MODE
		if (force_mode == M_AUTO && (0
#ifdef	TIOCPKT_IOCTL
			|| (!ioctl(pty, TIOCPKT, (char *)&one))
#endif	TIOCPKT_IOCTL
#ifdef	TIOCTCNTL
			|| (!ioctl(pty, TIOCTCNTL, (char *)&one))
#endif	TIOCTCNTL
		   ) )
		{	if (debug  &D_TRACE)	logit(1, "Use PKTmode\n");
			use_pkt_tty++;
		}
		else if (debug  &D_TRACE)	logit(1, "Not PKTmode %d\n", errno);
#else	PKT_MODE
		if (debug  &D_TRACE)	logit(1, "No  PKTmode  available\n");
#endif	PKT_MODE

		/* Set into half duplex mode if wanted */
		if (use_pkt_tty ||
			force_mode == M_MESSAGE || force_mode == M_HIDE)
		{
			errno = -1;
#ifdef	TIOCREMECHO
			if (!ioctl(pty, TIOCREMECHO, (char *)&one))
			{	if (debug  &D_TRACE) logit(1, "Set REM%x OK\n",
					TIOCREMECHO);
			}
			else
#endif	TIOCREMECHO
			{	if (debug  &D_TRACE)	logit(1, "Use echoplex (%d)\n", errno);
				doechoplex++;
			}
		}
		else	if (debug  &D_TRACE)	logit(5, "Don't need echoplex\n");

		if (doechoplex)
		{	; /* should set according to echo */
		}

		if (force_mode == M_AUTO
#ifdef	PKT_MODE
		    && !use_pkt_tty
#endif	PKT_MODE
		   )
		{	if (debug  &D_TRACE)	logit(1, "Resort to native mode\n");
			force_mode = M_NATIVE;
		}
	}

	signal(SIGCHLD, pty_gone);
	signal(SIGURG, x25_interrupt);	/* for out-of-band data */
	pgrp = -getpgrp(0);
	ioctl(x25, SIOCSPGRP, (char *)&pgrp);

#ifdef	NEEDED
	switch(call_type)
	{
	}
#endif	NEEDED


	/* Set up the parameter tables ... */
	init_params();
	if (force_mode == M_NATIVE)
	{	native_mode();
#ifdef	NDEF
		{	struct sgttyb b;
			struct tchars tchars;
			int f = b.sg_flags;
			ioctl(pty, TIOCGETP, (char *)&b);
			b.sg_flags |=  (CBREAK /*| XTABS*/);
			b.sg_flags &= ~(RAW | ALLDELAY);
			if (f != b.sg_flags) logit (1, "pty %x -> %x\n", f, b.sg_flags);
			ioctl(pty, TIOCSETP, (char *)&b);
		}
#endif	NDEF
	}
	else if (force_mode == M_MESSAGE) message_mode();
	else if (force_mode == M_HIDE)	  hide_mode();
	/* Now lets sync with the far end ... */

	/* Tell him what I have */
	bcopy(tell_pad, pibuf, sizeof tell_pad);
	pibuf[1] = 2;	/* set params */
	setparams(pibuf, sizeof tell_pad);

	/* ... and ask what he has */
	pibuf[1] = 4;	/* read params */
	getparams(pibuf, 2);

	if (format[auth_line].x_banner)
	{	int len;
		*pibuf = 0;
		expand_dollar(pibuf+1, format[auth_line].x_banner,
			sizeof pibuf-1);
		send_x25(pibuf, strlen(pibuf+1)+1);
	}

	for (;;) {
		long ibits=0, obits=0, ebits=ptybit | x25bit;

		/* Never look for input if there's still
		 * stuff in the corresponding output buffer
		 */
		if (fcc >= 0)			/* net connection alive? */
			/* pty output pending & pty still there? */
			if (fcc && pcc >= 0)		obits |= ptybit;
			/* pty still alive? */
			else if (pcc >= 0)		ibits |= x25bit;

		if (pcc >= 0)			/* pty connection alive? */
			/* x25 output pending & x25 still there? */
			if (pcc && fcc >= 0)		obits |= x25bit;
			/* net still alive? */
			else if (fcc >= 0)		ibits |= ptybit;

		if(!(ibits | obits))			break;

		if (ibits != (x25bit | ptybit) && n_ibits > 0)
		{	n_ibits--;
			logit(1, "ibits = %08x (%08x) %d %d\n",
				ibits, obits, pcc, fcc);
		}

	{	int was = ibits;
		if (no_pty)
		{	/* the pty is dead -- data in pipeline ? */
		}
		else (void) select(32, &ibits, &obits, &ebits, 0);
		if (was != (x25bit | ptybit) && n_ibits > 0)
		{	n_ibits--;
			if (debug & D_BITS)
				logit(1, "ibits-->%08x (%08x)\n", ibits, obits);
		}
	}
		if (ebits)	if (n_ebits > 0)
		{	n_ebits--; if (debug & D_BITS)
			logit(1, "ebits = %08x (io=%x,%x) %d\n",
				ebits, ibits, obits, n_ebits); }

		if (!(ibits | obits))
			{ sleep(1); logit(1, "nobits\n"); continue; }
		/*
		 * Something to read from the network...
		 */
		if (ibits & x25bit)
		{
			switch(call_type)
			{
#ifdef	X25_TCP
			case ADDR_TCP:
				fibuf[0] = '\377';
				fcc = x25b_read_data(x25, fibuf, fibuf+1,
					BUFSIZ-1);
	/*TEMP HACK  --  mask below is for bust ARM compiler  --  HACK TEMP*/
				if (fcc == 0 && (fibuf[0] & 0xff) == 0xff)
					logit(1, "0 read & EOF\n");
				else if (fcc >= 0)
				{	fcc++;
					if(fibuf[0] == INT_DATA)
					{	char *msg = "\r\n *** INT\r\n";
						logit(1, "INT received %d: %02x %02x %02x\n",
							fcc, fibuf[0], fibuf[1], fibuf[2]);
						int_pty();
						fcc = 0;
						errno = EWOULDBLOCK;
					}
				}
			break;
#endif	X25_TCP
#ifdef	X25
			default:
#ifdef	SUNLINK
				fcc = recv(x25, fibuf, BUFSIZ, 0);
#endif	SUNLINK
#endif	X25
			}
			if (debug & D_TRACE_CHARS)
			{	int i;
				logit(1, "%dr%3d ", net_skip, fcc);
				for (i=0; i<fcc; i++) logc(fibuf[i]);
				logit(0, ".\n");
			}
			in_bytes += fcc;
			in_pkts += (fcc-1 / PKT_SIZ) +1;
			fbp = fibuf + net_skip;
			if (fcc < 0 && errno == EWOULDBLOCK)	fcc = 0;
			else if(fcc <= 0)			fcc = EOF;
			else if(fibuf[0] & q_bit_on)	fcc = x29_qbit(fcc);
			else if(ts29 && fibuf[1])	fcc = x29_qbit(fcc);
			else
			{	fcc -= net_skip;
				if ((param13 & 2) && fcc > 1 &&
					fbp[fcc-1] == '\n' &&
					fbp[fcc-2] == '\r')
					fcc--;
			}
			if (fcc > 0) obits |= ptybit;
		}

		/*
		 * Something to read from the pty...
		 */
		if (ibits & ptybit || (no_pty && pcc == 0)) {
			if (debug & D_PTY_INFO)
			logit(1, "ip:f=%d, p=%d, np=%d\n", fcc, pcc, no_pty);
			*(pbp = pibuf) = '\0';	/* X25 Q bit etc */
			pcc = read(pty, pibuf+1, PKT_SIZ+1);
			if (debug & D_PTY_RES)
			{	int i;
				logit(1, "R%3d: ", pcc);
				for (i=1; i<=pcc; i++) logc(pibuf[i]);
				logit(0, ".\n");
			}
			if (pcc < 0 && errno == EWOULDBLOCK && !no_pty)
								pcc = 0;
			else if (pcc <= 0)		no_pty =0, pcc = EOF;
#ifdef	PKT_MODE
			else if (use_pkt_tty)
			{	u_char flags = *(++pbp);
#ifdef	TIOCPKT_IOCTL
				if (flags & TIOCPKT_IOCTL)
				{	if (debug  &D_TRACE) logit(1,
					   "Pkt info %d: %02x\n", pcc, flags);
					pcc = reflect_ttystruct(pbp, t, 0);
				}
				else
#endif	TIOCPKT_IOCTL
				if (flags & 0x40)
				{	if (debug  &D_TRACE) logit(1,
					   "PKT info %d: %02x\n", pcc, flags);
					pcc = reflect_ttystruct(pbp, t, 0);
				}
				else if (flags)
				{	if (debug  &D_TRACE) logit(1,
					   "PKT INFO %d: %02x\n", pcc, flags);
					pcc = reflect_ttystruct(pbp, t, 0);
				}
				else if (echoplex)
				{	char flags = pbp[0];
					int i,j;
					if (debug  &D_TRACE) logit(1,
						"Discard echo %d/%d:",
						echoplex, pcc-1);
					for (i=0; i<echoplex; i++) if
						(pbp[1] == echobuf[i])
					{	pcc --;
						pbp ++;
						if (debug  &D_TRACE) logc(pbp[0]);
					}
					if (debug  &D_TRACE)
					{
					logit(0, ":@%d/%d:", echoplex-i, pcc-1);
						for (; i<echoplex; i++)
							logc(echobuf[i]);
						logit(0, ":");
						for (i=1; i<pcc; i++)
							logc(pbp[i]);
						logit(0, ":\n");
					}
					pbp[0] = flags;
					echoplex = 0;
					if (pcc == 1)
					{
						if (pbp[0] == 0)
							pcc = 0;
						else logit(1, "echoplex gave 1 byte: %02x\n", pbp[0]);
					}
				}
			}
#endif	PKT_MODE
			else
			{	pcc++;	/* X25 Q bit etc */
				if (pcc > 2 &&	pibuf[1] == 0x13 &&
						pibuf[pcc-1] == 0x11)
				{	int n;
					logit(1, "%d: set of xon/xoff\n", pcc);

					for (n=2; n<pcc-1; n++)
						if (pibuf[n] != 0x13) break;
					if (n == pcc-1)
					{
					logit(1, "%d: all xon/xoff\n", pcc);
						pcc = 0;
					}
				}
#ifdef	TELNET
				switch (pty_type)
				{
				case PTY_TELNET:
				{	char *p = pibuf+1;
					while (pcc>1 && (p=index(p, '\377')))
					{	int step = 3;
						if (debug & D_TELNET) logit(1,
					"Telnet: strip (%d) %02x %02x %02x\n",
							pcc,
							p[0] & 0xff,
							p[1] & 0xff,
							p[2] & 0xff);
						pcc -= step;
						bcopy(p+step, p, pcc -
								(p-pibuf));
					}
				}
				}
#endif	TELNET
			}
			if (pcc > 0) obits |= x25bit;
		}

		if (debug & D_PTY_INFO)	logit(1, "i:f=%d, p=%d\n", fcc, pcc);
		if ((obits & x25bit) && pcc > 0)
		{	if (debug & D_TRACE_CHARS)
			{	int i;
				logit(1, "w%3d: ", pcc);
				for (i=0; i<pcc; i++) logc(pbp[i]);
				logit(0, ".\n");
			}
			if((cc = send_x25(pbp, pcc)) == pcc) pcc = 0;
			else if (errno != EWOULDBLOCK)
			{	if (block_err > 0)
				     logit(1, "send_x25 gave %d/%d (%d %d)\n",
						cc, pcc, errno, block_err--);
				else pcc = EOF;
			}
			else
			{ if (block_log > 0)
			  { block_log--;
			    if (cc > 0)
				logit(1, "send_x25 blocked after %d/%d\n",
					cc, pcc);
			    else if (cc == 0)
				logit(1, "send_x25 %d would block\n", pcc);
			    else
				if (debug & D_SENDX25)
					logit(1, "send_x25 %d blocked\n", pcc);
			  }
			}
		}

		if (debug & D_PTY_INFO)	logit(1, "op:f=%d, p=%d\n", fcc, pcc);
		if ((obits & ptybit) && fcc > 0
			&& ! ( (doechoplex>0) && ibits && ptybit)
		   )
		{
		    if (debug & D_PTY_INFO) logit(1,
			"write(%d, %x/%x, %d)\n", pty, fbp, fibuf, fcc);
		    if ((cc = write(pty, fbp, fcc)) > 0)
		    {	if (debug & D_TRACE_CHARS)
			{	int i;
				logit(1, "W%3d: ", fcc);
				for (i=0; i<fcc; i++) logc(fbp[i]);
				logit(0, ".\n");
			}
			if (cc = fcc) ;
			else if (errno != EWOULDBLOCK)
				logit(1, "write to pty gave %d/%d (%d)\n",
					cc, fcc, errno);
			else 	logit(1, "write to pty blocked after %d/%d\n",
					cc, fcc);
			if (doechoplex>0)
			{	echoplex = cc;
				bcopy(fbp, echobuf, echoplex);
				/* Guess how many will be echoed !! */
				if ((param13 & 4) && fbp[echoplex-1] == '\r')
					echobuf[echoplex++] = '\n';
			}
			fcc -= cc;
			fbp += cc;
		    }
		    else if (cc == 0)
			logit(1, "write to pty %d would block\n", fcc);
		    else	logit(1, "write to pty %d blocked\n");
		}
		if (debug & D_PTY_INFO)	logit(1, "d:f=%d, p=%d\n", fcc, pcc);
	}
	if (debug  &D_TRACE) logit(1, "Cleanup(0) -- f=%d, p=%d\n", fcc, pcc);
	cleanup(0);
}

fatal(f, msg)
char *msg;
{	char buf[BUFSIZ];
	*buf = '\0';
	sprintf(buf+1, "x29d: %s\n", msg);
	if (debug & D_ERR) logit(1, "Write '%.*s' to %d (%d)\n",
		index(buf+1, '\n') - buf+1, buf+1, f, x25);
	if (f != x25) (void) write(f, buf+1, (index(buf+1, '\n')-(buf+1))+1);
	else (void) send(f, buf, (index(buf+1, '\n')-buf)+1, 0);
	sleep(1);
	if (f == x25) close_with_diag(f, 0x12, 0x34, 0);
	sleep(1);
	exit(1);
}

fatalperror(msg, err)
char *msg;
{	char buf[BUFSIZ];
	extern char *sys_errlist[];

	sprintf(buf, "%s: %s", msg, sys_errlist[err]);
	fatal(x25, buf);
}

send_reset(x25, cause, diagnostic)
{	logit(1, "send RESET %02x %02x to %d\n", cause, diagnostic, x25);

	switch(call_type)
	{
#ifdef	X25_TCP
	case ADDR_TCP:
		logit(1, "Opps -- can't RESET over TCP yet ....\n");
		return 1;
#endif	X25_TCP

#ifdef	X25
	default:
#ifdef	SUNLINK
		return x25_send_reset(x25, cause, diagnostic);
#else	SUNLINK
		Well ? what ?
#endif	SUNLINK
#endif	X25
	}

#ifndef	X25
	return 1;
#endif	X25
}

/*
 * process incoming significant event.
 */

x25_interrupt(n)
{	int type = -1;
	char data = (char) -1;

	logit(1, "X25_INT %d\n", n);

	switch(call_type)
	{
#ifdef	X25_TCP
	case ADDR_TCP:
		type = INT_DATA;
		logit(1, "Should check type\n");
		if (param7 != 5) int_pty(type, data);
		else logit(1, "param7 is %x, so await ind of break\n", param7);
#endif	X25_TCP

#ifdef	X25
	default:
#ifdef	SUNLINK
	{	int rc, val;
		char buff[6];
		while (!(rc = ioctl(x25, X25_OOB_TYPE, &val)) && val)
		{	if (type != -1)	logit(1,
				"Multiple OOBs (%02x %02x)\n", type, val);
			switch (val)
			{
			case INT_DATA:
			{	int n = recv(x25, &data, 1, MSG_OOB);
				logit(1, "INT data (%d) was %02x\n", n, data);

		/* if there is no indication of break on the way, int now */
				switch (param7)
				{
				case 1: int_pty(type, data);		break;
				case 21:
				case 5:	logit(1, "await ind of break\n");break;
				default:logit(1,
					"Unexpected INT with param7 = %02x\n",
					param7);
					send_reset(x25, 0, 0);
					buff[1] = 2;	/* set params */
					buff[2] = P_8;	/* discard output */
					buff[3] = 0;	/* off */
					setparams(buff, 4);
					buff[1] = 4;	/* read params */
					getparams(buff, 2);
				}
			}	break;
			case VC_RESET:
				logit(1, "RESET (%d)\n", n);
				switch (param7)
				{
				case 2: int_pty(type, data);		break;
				default:logit(1,
					"Unexpected RESET with param7 = %02x\n",
					param7);
					buff[1] = 2;	/* set params */
					buff[2] = P_8;	/* discard output */
					buff[3] = 0;	/* off */
					setparams(buff, 4);
					buff[1] = 4;	/* read params */
					getparams(buff, 2);
				}
				break;
			default:
				logit(1, "OOB type %02x\n", val);
			}
			type = val;
		}
		logit(1, "Last sigurg call: %d %02x so type = %02x (%d)\n",
			rc, val, type, errno);
	}
#endif	SUNLINK
#endif	X25
	}
}

/*
 * Send interrupt to process on other side of pty.
 * If it is in raw mode, just write NULL;
 * otherwise, write intr char.
 */

int_pty(type, val)
{
	struct sgttyb b;
	struct tchars tchars;

	logit(1, "X25_INT: raw = %x (%d/%d)\n", b.sg_flags & RAW, type, val);

	switch (pty_type)
	{
#ifdef	TELNET
	case PTY_TELNET:	return;
#endif	TELNET
	}

	ioctl(pty, TIOCGETP, (char *)&b);
	if (debug & D_ERR) logit(1, "X25_INT: raw = %x\n", b.sg_flags & RAW);
	if (b.sg_flags & RAW)
		(void) write(pty, "\0", 1);
	else {	ioctl(pty, TIOCFLUSH, (char *)&zero);
		ioctl(pty, TIOCGETC, (char *)&tchars);
		logit(1, "X25_INT: raw = %x, so %02x\n",
				b.sg_flags & RAW, tchars.t_intrc);
		(void) write(pty, &tchars.t_intrc, 1);
	}
}

cleanup(n)
{	static count = 0;
	struct sgttyb sg;
	count++;
	(void) signal(SIGCHLD, SIG_IGN);
	(void) signal(SIGHUP, SIG_IGN);

	if (count > 3) kill(0, SIGKILL);
	if (count > 2) exit(n);
	if (count < 2) logit(3, "++ %d/%d in, %d/%d out (%d, %d) (%d)\n",
		in_pkts, in_bytes,
		out_pkts, out_bytes, n, count, my_pid);
	if (count < 2) logit(3, "%d/%d in, %d/%d out (%d, %d) (%d)\n",
		in_pkts, in_bytes,
		out_pkts, out_bytes, n, count, my_pid);
	/* Has the tty process exited ? */
	if (count == 1 && n == SIGCHLD)
	{	static char buff [] = { (1 << Q_BIT), 1 };

		signal(SIGALRM, cleanup);
		alarm(10);
		logit(1, "Send inv to clear gave %d\n",
			send_x25(buff, sizeof buff));
	}
	sleep(1);

#ifdef	X25
#ifndef	NOSUNCLEARCONFIRMBUG
	/* Ensure that it awaits the CONFIRMATION */
	diag_setup_data(x25, 0, 0, 0, (char *) 0, 0);
#endif	/* NOSUNCLEARCONFIRMBUG */
#endif	X25

	if (count < 2 && debug  &D_TRACE) logit(1, "rmut()\n");
	rmut();
	if (count < 2 && debug  &D_TRACE) logit(1, "close(%d)\n", pty);
	close(pty);
	if (count < 2 && debug  &D_TRACE) logit(1, "vhangup()\n");
	vhangup();
	if (count < 2 && debug  &D_TRACE) logit(1, "shutdown()\n");
	shutdown(x25, 2);
/*	kill(0, SIGKILL);*/
	if (count < 2 && debug  &D_TRACE) logit(1, "exit(%d)\n", n);
	exit(n);
}

enable_output()
{	char message[4];
	/* Always re-enable normal output */
	message[0] = q_bit_on;
	message[1] = X29_SET_PARMS;
	message[2] = P_8;
	message[3] = 0;
	(void) send_x25(message, sizeof(message));
};

/*
 * Process Q BIT (control) packets from the net.
 * The only message that we are interested in are
 * those indicating output is being discarded.
 */

x29_qbit(n)
{
	register unsigned char *p;

	if (debug  &D_TRACE)
	{	int i;
		logit(1, "Qbit %d:", n);
		for (i=0; i<n; i++) logit(0, " %02x", fibuf[i] & 0xff);
		logit(0, "\n");
	}
	switch (fibuf[1 + ts29_skip]) {
	case X29_INDICATION_OF_BREAK:
		logit(1, "Ind of Break\n");
		int_pty();
	case X29_SET_PARMS:
	case X29_SET_AND_READ_PARMS:
/*	case X29_PARAMETER_INDICATION:	*/
	case 0:
		for(p = (unsigned char *) (&fibuf[2+ts29_skip]);
		    p < (unsigned char *) (fibuf+n); p +=2) switch(*p)
		{
		default:	curr_params.x3_params[*p] = p[1];	break;
		case P_8:	curr_params.x3_params[*p] = p[1];
				if (p[1]) enable_output();
				break;
		case P_10:	curr_params.x3_params[*p] = p[1];
				if (p[1] >= 40 && p[1] <= 255)
					set_width(pty, p[1]);
				break;
		case P_11: {
				static char speeds[] =
				{	B110, B134, B300,  B1200, B600,
					B75,  B150, B1800, B200, B110, B50, 
					B1200, /* 1200/75 */
					B2400, B4800, B9600,
					EXTA, EXTA, EXTA, EXTA };
				curr_params.x3_params[*p] = p[1];
				switch (pty_type)
				{
#ifdef	TELNET
				case PTY_TELNET:	break;
#endif	TELNET
				default:

					if(p[1] >= 0 && p[1] < sizeof(speeds))
					{	struct sgttyb b;
						ioctl(pty, TIOCGETP,
								(char *)&b);
						b.sg_ispeed =
						b.sg_ospeed = speeds[p[1]];
						ioctl(pty, TIOCSETN,
								(char *)&b);
					}
				}
			};	break;
		}
		break;

	case 1:
		logit(1, "Invitation to clear (%d): ", n);
		for(p = (unsigned char *) (fibuf+1);
		    p < (unsigned char *)(fibuf+n); p++)
			logit(0, " %02x", *p);
		logit(0, "\n");
		return EOF;
	case 5:
		logit(1, "Error (%d): ", n);
		for(p = (unsigned char *) (fibuf+1);
		    p < (unsigned char *)(fibuf+n); p++)
			logit(0, " %02x", *p);
		logit(0, "\n");
		return EOF;
		
	default:	logit(1, "Unexpected Qbit packet: len %d:", n);
			for(p = (unsigned char *) (fibuf+1);
			    p < (unsigned char *)(fibuf+n); p++)
				logit(0, " %02x", *p);
			logit(0, "\n");
	}

	return 0;
}

char	wtmpf[]	= "/usr/adm/wtmp";
char	utmp[] = "/etc/utmp";
#define SCPYN(a, b)	strncpy(a, b, sizeof (a))
#define SCMPN(a, b)	strncmp(a, b, sizeof (a))

rmut()
{
	register int f, found = 0;

	if (strncmp(ttynam, DEF_TTYNAME, TTY_BASE))	return;
	f = open(utmp, O_RDWR, 0644);
	if (f >= 0) {
		while(read(f, (char *)&wtmp, sizeof (wtmp)) == sizeof (wtmp)) {
			if (SCMPN(wtmp.ut_line, ttynam+TTY_BASE) ||
			    wtmp.ut_name[0]==0)
				continue;
			(void) lseek(f, -(long)sizeof (wtmp), 1);
			SCPYN(wtmp.ut_name, "");
			SCPYN(wtmp.ut_host, "");
			time(&wtmp.ut_time);
			(void) write(f, (char *)&wtmp, sizeof (wtmp));
			found++;
		}
		close(f);
	}
	if (found) {
		f = open(wtmpf, O_WRONLY, 0644);
		if (f >= 0) {
			SCPYN(wtmp.ut_line, ttynam+TTY_BASE);
			SCPYN(wtmp.ut_name, "");
			SCPYN(wtmp.ut_host, "");
			time(&wtmp.ut_time);
			(void) lseek(f, (long)0, 2);
			(void) write(f, (char *)&wtmp, sizeof (wtmp));
			close(f);
		}
	}
	chmod(ttynam, 0666);
	chown(ttynam, 0, 0);
	ttynam[TTY_BASE] = 'p';
	chmod(ttynam, 0666);
	chown(ttynam, 0, 0);
}

init_params()
{
	param1 = 1;	/* escape enabled	    */
	param2 = 1;	/* echo on		    */
	param3 = (doechoplex==0)  ? DEF_P3 : 126 ;/* forward 	~48	    */
	param4 = 0;	/* timeout = 0		    */
	param5 = 0;	/* pad won't flow-control terminal (?)		    */
	param6 = 1;	/* print PAD messages	    */
	param7 = 21;	/* break command	(5) */
	param8 = 0;	/* don't discard o/p	    */
	param9 = 0;	/* no crfill		    */
	param10 = 0;	/* no line wrap		(*) */
	param11 = 14;	/* 9600			    */
	param12 = 1;	/* user can flow-control pad (0) */
	param13 = DEF_P13;	/* CRMOD	~6	    */
	param14 = 0;	/* no lffill		    */
	param15 = 1;	/* editing on		    */
	param16 = 0x7f;	/* char delete		    */
	param17 = 0x18;	/* line delete		    */
	param18 = 0x12;	/* redisplay line	    */
}

native_mode()
{	param2 = 0;	/* echo on		    */
	param3 = 0;	/* forward -- non-standard  */
	param4 = 10;	/* timeout = 0.5 sec	    */
	param7 = 1;	/* break command -- non-standard */
	param9 = 0;	/* no crfill		    */
	param10 = 0;	/* no line wrap		    */
	param13 = 0;	/* CRMOD		    */
	param14 = 0;	/* no lffill		    */
	param15 = 0;	/* editing on		    */
}

hide_mode()
{	param2 = 0;	/* echo on		    */
}

message_mode()
{
	param13 = 6;	/* CRMOD */
}

setparams(buff, n)
char *buff;
{	int i;
	if (n == 2) for (i=1, n += 2*P_MAX; i <= P_MAX; i++)
	{	buff[(i*2)  ] = i;
		buff[(i*2)+1] = curr_params.x3_params[i];
	}
	else for (i=2; i<n; i+=2)
	{	int par = buff[i];
		if (0 < par && par <= P_MAX)
			buff[i+1] = curr_params.x3_params[par];
		else	buff[i+1] = 0;
	}
	*buff = q_bit_on;
	(void) send_x25(buff, n, 0);
}

getparams(buff, n)
char *buff;
{	*buff = q_bit_on;
	(void) send_x25(buff, n);
}

/* Convert the DTE into a friendly name ... */
lookup_name(calling_name, calling_mac, calling_aef, calling_dte, calling_ybts, calling_longname)
char *calling_name;
char *calling_dte;
char *calling_aef;
char *calling_mac;
char *calling_ybts;
char *calling_longname;
{
	/* We already HAVE the info we need ... */
	if (*calling_name && *calling_longname) return;

	if (calling_mac && *calling_mac)
	{	sprintf(calling_name, "M%s/%s", calling_mac, (calling_aef) ? calling_aef : "");
		sprintf(calling_longname, "MAC=%s/AEF=%s", calling_mac, (calling_aef) ? calling_aef : "");
		return;
	}
#ifndef	NONRSDBM
	if (nrs_init() >= 0)
	{
/* The REAL definitions are buried deep in the unix-niftp headers ... */
#ifndef	MAXNETS
#define MAXNETS 3       /* maximum number of nets */
typedef struct  net_site {
	char    *net_name;      /* name of network */
	char    *ts29_addr;     /* address for Ts29 TG connections */
	char    *x29_addr;      /* address for x29 TG connections */
	int     n_ftptrans;     /* max number of transfers/TS connection */
	int     n_ftpgates;     /* number of gateways to go through (NIFTP) */
	char    *ftp_addr;      /* address for NIFTP connections */
	char    *mail_addr;     /* address for Mail connections */
	int     n_jtmpgates;    /* number of gateways to Jtmp */
	char    *jtmp_addr;     /* jtmp address */
	int     n_newsgates;    /* number of gateways to news */
	char    *news_addr;     /* news address */
	} net_entry;


struct  host_entry      {
	char    *host_name;     /* name of host */
	char    *host_alias;    /* alias of host */
	char    *host_info;     /* info about a host */
	long    n_timestamp;    /* time when entry was added */
	int     n_context;      /* don't ask me what this is.... */
	int     h_number;       /* Numeric host number */
	char    n_localhost;    /* is this a local host ? */
	char    n_oldhost;      /* is this from the old hosts file */
	char    n_disabled;     /* is this host disabled */
	int     n_nets;         /* number of network entries */
	net_entry  n_addrs[MAXNETS];    /* net site entries */
	};
		struct  host_entry      *dbase_get();
#endif	MAXNETS

		char buff[20+128];
		int stripped = 0;
		char	*endp;

		struct  host_entry      *Hp;
		sprintf(buff, "%c.%s%s%s", (*calling_dte == '0') ? 'j' : 'p',
		    calling_dte, (*calling_ybts) ? "." : "", calling_ybts);
		endp = buff + strlen(buff);
		endp[1] = 0;

		Hp = dbase_get(buff);
		while (!Hp && stripped < (endp - buff -2))
		{	endp[-stripped] = endp[-stripped-1];
			endp[-(++stripped)] = '\0';
			Hp = dbase_get(buff);
		}
		if (Hp)
		{	sprintf(calling_name, "%s%s%s",
				(Hp->host_alias) ? Hp->host_alias :
						   Hp->host_name,
				(stripped) ? "+" : "",
				endp-stripped+1);
			sprintf(calling_longname, "%s%s%s",
				Hp->host_name,
				(stripped) ? "+" : "",
				endp-stripped+1);
			dbmclose();
			return;
		}
		else	logit(1, "NRS lookup of %s (%s|%s) failed\n",
				calling_dte, buff, endp-stripped+1);
		dbmclose();
	}
	else	logit(1, "Nrs init failed\n");
#endif	NONRSDBM
#ifndef	NOGETHOSTBYADDR
	{	struct hostent *hp, *gethostbyaddr();
		if (hp=gethostbyaddr(calling_dte,strlen(calling_dte), AF_X25))
		{	strcpy(calling_name, hp->h_name);
			strcpy(calling_longname, (hp->h_aliases[0]) ?
				hp->h_aliases[0] : hp->h_name);
			return;
		}
		else	logit(1, "gethostbyaddr on %s failed\n", calling_dte);
	}
#endif	NOGETHOSTBYADDR
}

set_width(fd, width)
{	int rc = -1;
	if (!width)	return;

	switch (pty_type)
	{
#ifdef	TELNET
	case PTY_TELNET:	return;
#endif	TELNET
	}

#ifdef  TIOCGSIZE        /* e.g. sun */
	{	struct ttysize ttysize;
		if (ioctl(fd, TIOCGSIZE, &ttysize) >= 0)
		{	if ((ttysize.ts_cols | ttysize.ts_lines) &&
				debug  &D_TRACE)
				logit(1, "tty = %d/%d cols, %d rows\n",
				    ttysize.ts_cols, width, ttysize.ts_lines);
			if (rc == -1) rc = ttysize.ts_cols;
#ifdef	SUNSTTYCOLSONLY
			if (ttysize.ts_lines)
#endif	SUNSTTYCOLSONLY
			ttysize.ts_cols = width;
			ioctl(fd, TIOCSSIZE, &ttysize);
		}
	}
#endif  TIOCGSIZE
#ifdef  TIOCGWINSZ        /* e.g. ultrix */
	{	struct winsize winsize;
		if (ioctl(fd, TIOCGWINSZ, &winsize) >= 0)
		{	if ((winsize.ws_col | winsize.ws_row) &&
				debug  &D_TRACE)
				logit(1, "window = %d/%d col, %d rows\n",
				    winsize.ws_col, width, winsize.ws_row);
			if (rc == -1) rc = winsize.ws_col;
#ifdef	SUNSTTYCOLSONLY
			if (winsize.ws_row)
#endif	SUNSTTYCOLSONLY
			winsize.ws_col = width;
			ioctl(fd, TIOCSWINSZ, &winsize);
		}
	}
#endif  TIOCGWINSZ

	return rc;
}

accept_ts()
{	static char accept[] = { 1 << Q_BIT, 0x11, 0x80 };
	int ts29_was = ts29;
	int n;

	if (debug) logit(1, "send YB accept (type=%d)!!\n", call_type);
	/* we really DO want to send qualified data !! */
	ts29 = 0;
	if ((n=send_x25(accept, sizeof accept)) != sizeof accept)
	{	ts29 = ts29_was;
		logit(1, "accept rejected(%d/%d, %d)\n",
			n, sizeof accept, errno);
		close_with_diag(x25, 0x23, 0x45, 1);
	}
	ts29 = ts29_was;
}

/* Send data to x25 -- buff[0] contains the Q etc bits */
send_x25(buff, len)
register char *buff;
register len;
{	int qualified	= 0;
	int stripped	= 0;
	int rc;
	char *flags	= buff;
	char flag;

	if (x25b_debug & D_SENDX25) logit(1, "%s %02x %d: ",
		(ts29) ? "TS29" : "~ts29", *buff, len);
	switch(call_type)
	{
#ifdef	X25_TCP
	case ADDR_TCP:
		if (ts29)
		{	if (*buff)
			{	if (*buff != (1 << Q_BIT))
				logit(0, "TS29: Bits other than Q set (%02x)\n", *buff);
				*buff = 0x80;
			}
			flags = &flag;
			flag = 0;
		}
		else len--, stripped++;

		if (len == 0) if (debug & D_WARN)
			logit(0, "Sending 0 bytes to x25 [%02x]\n", *buff);
		rc = x25b_write_data(x25, flags, buff+stripped,len);
		if (x25b_debug & D_SENDX25) logit(0, "%02x/%02x %d>%d: ",
			*flags, buff[stripped]& 0xff,
			len, rc);
		break;
#endif	X25_TCP

#ifdef	X25
	default:
#ifdef	SUNLINK
		if (ts29)
		{	if (*buff)
			{	if (*buff != (1 << Q_BIT))
				logit(1, "TS29: Bits other than Q set (%02x)\n", *buff);
				*buff = 0x80;
			}
		}
		else
		{	if (*buff)
			{	int data = *buff;
				(void) ioctl(x25, X25_SEND_TYPE, &data);
				qualified++;
			}
			buff++, len--, stripped++;
		}

		if (len == 0) if (debug & D_SENDX25)
			logit(1, "Sending 0 bytes to x25 [%02x]\n", buff[-stripped]);

		rc = send(x25, buff, len, 0);
		if (qualified)	(void) ioctl(x25, X25_SEND_TYPE, &zero);
#endif	SUNLINK
		break;
#endif	X25
	}

	if (rc > 0 || rc == len)
	{	out_bytes += rc;
		out_pkts += (rc-1 / PKT_SIZ) +1;
		rc += stripped;
	}
	if (x25b_debug & D_SENDX25) logit(0, "send_x25 (%d) %d>%d>%d\n",
			call_type, len, len-stripped, rc);

	return rc;
}

reflect_ttystruct(buff, t, force)
char *buff;
{	struct sgttyb b;
	struct sgttyb tb;
	struct	x3_struct new;
	register char *buffp = buff;
	int i;
	int flags;
	int echo;
	int immed;
	int crmod;
	int ttywidth	= 80;

#ifdef  TIOCGSIZE        /* e.g. sun */
	{	struct ttysize ttysize;
		if (ioctl(pty, TIOCGSIZE, &ttysize) >= 0)
			ttywidth = ttysize.ts_cols;
	}
#endif  TIOCGSIZE
#ifdef  TIOCGWINSZ        /* e.g. ultrix */
	{	struct winsize winsize;
		if (ioctl(pty, TIOCGWINSZ, &winsize) >= 0)
			ttywidth = winsize.ws_col;
	}
#endif  TIOCGWINSZ

	new = curr_params;

	if (ioctl(pty, TIOCGETP, (char *)&b) < 0)
	{	logit(1, "Reflect tty struct TIOCGETP failed\n");
		return 0;
	}
	if (ioctl(t, TIOCGETP, (char *)&tb) < 0)
	{	if (debug  &D_TRACE) logit(1, "Reflect struct TIOCGETP failed\n");
	}
	flags = b.sg_flags;
	immed	= flags & (RAW | CBREAK);
	echo	= flags & (ECHO);
	crmod	= flags & (CRMOD);
	if (doechoplex) doechoplex = (echo) ? 1 : -1;

	if (flags != tb.sg_flags)
		logit(1, "Got %04x, %04x\n", flags, tb.sg_flags);
	if (debug  &D_TRACE) logit(1, "reflect tty %x", flags);
	/* 1, 5, 6, 7, 8, 9, 12, 14 */
	new.x3_params[2]	= (echo)	? 1 : 0;
	new.x3_params[3]	= (immed)	? 0 : (doechoplex) ? 126 : DEF_P3;
	new.x3_params[4]	= (immed)	? 4 : 0;
	new.x3_params[10]	= (immed)	? 0 : ttywidth;
	new.x3_params[13]	= (immed || !crmod)	? 0 : DEF_P13;
	new.x3_params[15]	= (immed)	? 0 : 1;
	*buffp++ = q_bit_on;
	*buffp++ = 6;	/* set & read */
	for (i=1; i<=P_MAX; i++)
		if (pass.x3_params[i] && (force ||
			curr_params.x3_params[i] != new.x3_params[i]))
		{	*buffp++ = i;
			*buffp++ = new.x3_params[i];
			if (debug  &D_TRACE) logit(0, " %d:%d->%d", 
			   i, curr_params.x3_params[i], new.x3_params[i]);
			curr_params.x3_params[i] = new.x3_params[i];
		}
	if (debug  &D_TRACE)
	{	int i;
		logit(0, " so Qbit %d:", buffp - buff);
		for (i=0; i<(buffp - buff); i++)
			logit(0, " %02x", buff[i] & 0xff);
		logit(0, " giving %d\n", buffp - buff);
	}
	return (buffp == buff+2) ? 0 : buffp - buff;
}

void help()
{ printf("\
 -A: set the X.121 address to listen on (any subaddresses allowed)\n\
 -a: set the full X.121 address to listen on\n\
 -b: set the base X.121 address (e.g. for -s)\n\
 -c: set the default authorisation strin\n\
 -C: set the link identifier\n\
 -d: set the x25b debug level\n\
 -D: set the debug level\n\
 -f: set the auth file\n\
 -F: backwards compatible version of -C\n\
 -H  force HIDE mode, i.e. x29d discards expected echo\n\
 -h  give this help\n\
 -I  indicates that this has been invoked by inetd\n\
 -i: set the interval (secs) between checking if auth file hgas changed\n\
 -K: set the file to hold the process ID of currently running server\n\
 -k: set the type of kill to send to server\n\
 -l: set the log file to use\n\
 -L: set the max length of a `short' name\n\
 -M  force message mode\n\
 -m  subsequent listens have a null PID mask, so wildcard protocols\n\
 -N  force native mode\n\
 -n: set the NSAP to listen on\n\
 -p: set the port to listen on for TCP\n\
 -P: set the maximum packet size\n\
 -s: set the subaddress to listen on\n\
 -t  like -m, but sets the actual PID length to 0\n\
 -W: set the maximum window size\n");
}

#include "commond.c"
