/* Copyright (c) Piete Brooks 1988 */
#ifndef	lint
char RCSid[]="$Header: x25r.c,v 1.4 89/01/25 06:10:13 pb Exp $";
#endif	lint

/*
 * x29in -- handle random incoming X29 service
 *
 * Invoked by X.25 listener with fd = 4
 */

#include <stdio.h>
#include <errno.h>
#include <sys/file.h>
#include <sys/types.h>
#include <sys/ioctl.h>
#include <sys/signal.h>
#include <sys/mbuf.h>		/* just for MLEN! */
#include <sys/socket.h>
#include <sundev/syncstat.h>	/* for struct ss_dstats &tc. */
#include <netx25/x25_ctl.h>	/* for out-of-band types */
#include <netx25/x25_pk.h>
#include <netx25/x25_ioctl.h>
#define	FULL_X25STR
#include "x25b.h"
extern errno;

#ifdef	__STDC__
#ifndef	VOID
#define	VOID void
#endif	VOID
#define	ARGS(x)	x
#else	/* __STDC__ */
#ifndef	VOID
#define	VOID
#endif	VOID
#define	ARGS(x)	()
#endif	/* __STDC__ */

char *getenv();
char *index();
char *ctime();
long time();

int  pollloop	ARGS((int, int, int));
int  process_loc ARGS((int, int));
VOID x25_int	ARGS((int));
int  process_x25 ARGS((int, int));
int  sprintf_dtes ARGS((char *, unsigned char *, int));
int  sprintf_facil ARGS((char *, unsigned char *, int));
VOID sprintf_clr ARGS((char *, unsigned char *, int));
VOID sprintf_diag ARGS((char *, X25_CAUSE_DIAG *));
VOID init_deb	ARGS(());
VOID time_stamp	ARGS(());

/*
VOID x25b_logit ARGS((int, char *, ...));
VOID x25b_perror ARGS((int, char *, ...));
int  select	ARGS((int, int *, int *, int *, struct timeval *));
*/

int  dup	ARGS((int));
int  exit	ARGS((int));
int  fflush	ARGS((FILE *));
VOID fprintf	ARGS((FILE *, char *, ...));
int  getopt	ARGS((int, char **, char*));
int  getpid	ARGS(());
int  ioctl	ARGS((int, int, char*));
int  open	ARGS((char *, int, int));
int  perror	ARGS((char *));
int  recv	ARGS((int, char *, int, int));
int  send	ARGS((int, char *, int, int));
int  sleep	ARGS((int));
char *sprintf	ARGS((char *, char *, ...));
int  strcmp	ARGS((char *, char *));
int  x25b_open_x29_2 ARGS((char *, char *, char *, char *, char *, char *, char *, int, int));
int  x25b_open_ybts4 ARGS((char *, char *, char *, char *, char *, char *, char *, int, int, int));
int  x25b_read_data ARGS((int, char *, char *, int));
int  x25b_write_data ARGS((int, char *, char *, int, int));

char logfile[] = "/tmp/x29in.log";
FILE *debfile;
int   debfd;
int   pid;

char optargs[]	= "c:D:f:H:h:x:X:y:Y:z";
extern	char *optarg;
extern	int optind;
int	zap_d	= 0;
int	debug	= 0;
int	x25 = 4;
int	(*old_urg)();
int	x25_ints = 0;
int	x25_resets = 0;
char extra_info[1024];
char setup[] = { 6, 10, 0, 13, 0};
char hard_fail[] = { '$', 'C', '\n' };
char soft_fail[] = { '$', 'E', '\n' };

VOID main(argc, argv)
char **argv;
{
	int  fdout = -1;
	int  fdin  = -1;
	char *x25dte = (char *) 0;
	char *x25name = (char *) 0;
	char *called_dte = (char *) 0;
	char *ybts_called = (char *) 0;
	char *ybts_calling = (char *) 0;
	char *cudf	= (char *) 0;
	char *host	= (char *) 0;
	char *file	= (char *) 0;
	int ybts	= 0;
	int i;
	int rc;

	x25b_debug = zap_d;
	pid = getpid();
	*extra_info = '\0';

	init_deb();

	for (i=0; i<argc; i++) fprintf(debfile, "%d=%s\n", i, argv[i]);

	while ((i = getopt(argc, argv, optargs)) != EOF) switch(i)
	{
	default:
		fprintf(debfile, "%s: bad args for: %s [%s]\n",
			*argv, *argv, optargs);
		fprintf(stderr, "%s: bad args for: %s [%s]\n",
			*argv, *argv, optargs);
		exit(1);
	case 'D': debug = atoi(optarg);					break;
	case 'h': host	= optarg;					break;
	case 'H': x25name= optarg;					break;
	case 'f': file = optarg;					break;
	case 'x': x25dte= optarg;					break;
	case 'X': called_dte= optarg;					break;
	case 'Y': ybts_called = optarg;					break;
	case 'y': ybts_calling = optarg;				break;
	case 'z': ybts = -1;						break;
	case 'c': cudf	= optarg;					break;
	}

	{	int one=1;
		errno = -1;
		if (ioctl(x25, SIOCSPGRP, (char *) &pid) < 0)
			fprintf(debfile,
			"Failed to set process group for fd %d to %d (%d)\n",
				x25, pid, errno);
		old_urg = signal(SIGURG, x25_int);

		if (ioctl(x25, X25_HEADER, (char *) &one))
			fprintf(debfile,
			"EARLY set X25_HEADER(%d) failed %d\n", x25, errno);
		if (ioctl(x25, X25_RECORD_SIZE, (char *) &one))
			fprintf(debfile, "Failed to set record size\n");
		fflush(debfile);
	}

	if (!ybts_called)	ybts_called = getenv("YBTSCALLED");
	if (ybts_called && !host)
	{	char *sep;
		host = ybts_called;
		if (sep = index(ybts_called, '.'))
		{	*sep++ = '\0';
			ybts_called = sep;
		}
	}
	if (!ybts_calling)	ybts_calling = getenv("YBTSTEXT");
	if (!x25dte)		x25dte = getenv("X25DTE");
	if (!called_dte)	called_dte = getenv("CALLED_DTE");
	if (!x25name)		x25name = getenv("CALLED_SHORTNAME");
	time_stamp();
	fprintf(debfile, "Call from %s with %s%s%s/%s %s/%s (%s|%s)\n",
			(host)		? host		: "<unset>",
			(x25name)	? x25name	: "",
			(x25name)	? "="		: "",
			(x25dte)	? x25dte	: "<unset>",
			(cudf)		? ":"		: "",
			(cudf)		? cudf		: "", 
			(called_dte)	? called_dte	: "*",
			(ybts_calling)	? ybts_calling	: "-",
			(ybts_called)	? ybts_called	: "-");
	fflush(debfile);
	rc = open_file(file, called_dte, cudf, x25dte, x25name, host,
		&fdout, &fdin);

	if (!rc)
	{	fprintf(debfile, "Open failed\n");
		exit(3);
	}
/*	write2x25(x25, setup, sizeof setup, (1<<3)); */
	i = process(x25, fdout, fdin);
	time_stamp();
	fprintf(debfile, "Call cleared by %s%s%s\n",
		(i == 1) ? "loc" : (i == 2) ? "x25" : (i == 3) ? "sel" : "???",
		(*extra_info) ? " " : "", extra_info);
	exit(0);
}

int open_file(file, called_dte, cudf, x25dte, x25name, host, pfdout, pfdin)
char * file;
char * called_dte;
char * cudf;
char * x25dte;
char * x25name;
char * host;
int  * pfdout;
int  *pfdin;
{	char fname[128];
	char *filename;
	int	append = 0;

	if (!file || !*file)
	{	sprintf(fname, "/tmp/x29in.%06d", getpid());
		file = fname;
	}
	filename = file;

	if (*file == '|') return p2open(file+1, pfdout, pfdin);
	if (*file == '>')
	{	file++;
		if (*file == '>')
		{	file++;
			append |= O_APPEND;
		}
	}


	*pfdout = open(file, O_WRONLY | O_CREAT | append, 0644);

	if (*pfdout < 0)
	     fprintf(debfile, "%s gave %d (%d)\n", filename, *pfdout, errno);

	return (*pfdout >= 0) ? 1 : 0;
}

int process(x25, fdout, fdin)
{	if (fdin >= 0)	return pollloop(x25, fdout, fdin);

	while (process_x25(x25, fdout) >= 0)	;
	return 2;	
}

int pollloop(x25, fdout, fdin)
{
	int	v;
	int	xmask	= 1 << x25;
	int	imask	= 1 << fdin;
	int	defmask = (xmask | imask);
	int	max = ((x25 > fdin) ? x25 : fdin) +1;
	int	mask	= defmask;

	for (; (v=select(max, &mask, (int *) 0, (int *) 0, 0)) > 0 && mask;
		mask = defmask)
	{
		if (mask & imask) if (process_loc(fdin,  x25) <= 0) return 1;
		if (mask & xmask) if (process_x25(x25, fdout) <= 0) return 2;
	}
	return 3;
}

/* Read from the local stream & write to the X25 stream */
int process_loc(fdin, x25)
{	char buff[1024+1];
	int qbit = 0;
	int eof = 0;
	int rc;
	int len;
	int skip = 1;
	extern struct x25io _x25io;

	len=read(fdin, buff, sizeof buff);

	if (debug & 4)
	{	int i;
		fprintf(debfile, "Read %d bytes from cmd", len);
		for (i=0; i<len; i++) fprintf(debfile, " %02x", buff[i] & 0xff);
		fprintf(debfile, "\n");
		fflush(debfile);
	}
	if (len <= 0)
	{	int rc = p2close(fdin);
		fprintf(debfile, "exit code %08x\n", rc);
		if (rc) sprintf(extra_info, "exit code %08x\n", rc);
		qbit = (1 << Q_BIT);
		qbit = 0;
/*		eof++;		*/
		bcopy(hard_fail, buff+skip, sizeof hard_fail);
		len = sizeof hard_fail;
	}
	rc = (len > 0) ? write2x25(x25, buff+skip, len, qbit) : len;
	return (rc > 0 && len > 0 && !eof) ? rc : -1;
}

VOID x25_int(sig)
{	int type;
	char data;
	int n;

	if (sig != -1) fprintf(debfile, "X25_INT %d\n", sig);

	while (!ioctl(x25, X25_OOB_TYPE, (char *) &type) && type)	switch(type)
	{
	case INT_DATA:
		errno = -1;
		n = recv(x25, &data, 1, MSG_OOB);
		time_stamp();
		fprintf(debfile, "INT data (%d) was %02x (%d) -- ignored\n",
				n, data, x25_ints);
		if (n <= 0)
		{	fprintf(debfile, "INT ERROR (%d) %d\n", n, errno);
			if (errno == ENOTCONN)	return;
			if (x25_ints > 10) sleep (1 << ((x25_ints/10)-1));
			if (x25_ints > 30)	return;
		}
		x25_ints++;
		break;
	case VC_RESET:
		time_stamp();
		fprintf(debfile, "RESET (%d) -- ignored\n", type, x25_resets);
		x25_resets++;
		break;
	default:
		time_stamp();
		fprintf(debfile, "OOB type %02x -- ignored\n", type);
	}

	fflush(debfile);
}

/* Read from the X25 stream & write to the local stream */
int process_x25(x25, fdout)
{	char buff[1024];
	int len;
	int ok;
	x25_int(-1);

	len = recv(x25, buff, sizeof buff, 0);
	ok = (len > 0 && ! (*buff & ~(1 << 0)));
	if ((debug & 236) || (!ok && debug & 4))
	{	int i;
		fprintf(debfile, "Read %d bytes from x25",
			len);
		for (i=0; i<len; i++) fprintf(debfile, " %02x", buff[i] & 0xff);
		fprintf(debfile, "\n");
		fflush(debfile);
	}
	if (len <= 0)
	{	X25_CAUSE_DIAG diag;

		if (!ioctl(x25, X25_RD_CAUSE_DIAG, (char *) &diag) &&
			(diag.flags != ((1<<DIAG_TYPE) | (1<<RECV_DIAG)) ||
			 diag.datalen != 2 ||
			 diag.data[0] != 0 ||
			 diag.data[1] != 0 ))
			sprintf_diag(extra_info, &diag);
		return -1;
	}
	if (ok)	return write(fdout, buff+1, len-1);
	if ((*buff & (1 << 3)) && buff[1] == 6)
	{	int i;
		fprintf(debfile, "set & read, so reply\n");
		buff[1] = 0;
		for (i=2; i<len-1; i += 2) switch (buff[i])
		{
		case 10:	buff[i+1] = 0;	break;
		case 13:	buff[i+1] |= 1;	break;
		}
		write2x25(x25, buff+1, len-1, *buff);
		return len;
	}
	if ((*buff & (1 << 3)) && buff[1] == 1)
	{	fprintf(debfile, "Inv to clear\n");
		return -1;
	}
	fprintf(debfile, "len %d: buff was %02x: %02x %02x %02x %02x\n",
		len, buff[0] & 0xff, buff[1] & 0xff, buff[2] & 0xff,
		buff[3] & 0xff, buff[4] & 0xff);
	return len-1;
}

write2x25(x25, buff, len, _qbit)
char *buff;
char _qbit;
{	int rc;
	int skip=0;
	int qbit = _qbit;
	if (debug & 4)
	{	int i;
		fprintf(debfile, "Write %d bytes to x25 with %02x:",
			len, _qbit);
		for (i=0; i<len; i++) fprintf(debfile, " %02x", buff[i] & 0xff);
		fprintf(debfile, "\n");
		fflush(debfile);
	}

	if (qbit) if (ioctl(x25, X25_SEND_TYPE, (char *) &qbit) == -1)
			fprintf(debfile, "Failed to set TYPE %02x (%d)\n",
				qbit, errno);
	rc = (len > 0) ? send(x25, buff+skip, len, 0) : len;
	if (rc != len)
	{	time_stamp();
		fprintf(debfile, "send %d gave %d (%d)\n", len, rc, errno);
		fflush(debfile);
	}
	if (qbit)
	{	qbit=0;
		if (ioctl(x25, X25_SEND_TYPE, (char *) &qbit) == -1)
		       fprintf(debfile, "Failed to reset TYPE %02x (%d)\n",
				qbit, errno);
		fflush(debfile);
	}
	return rc;
}

int sprintf_dtes(buff, data, len)
char *buff;
unsigned char *data;
{ if (len > 0)
  { int la1 =  data[0]       & 0x0f;
    int la2 = (data[0] >> 4) & 0x0f;
    int bytes = (la1+la2+1)/2;
    if (len > bytes)
    {	int i;
	sprintf(buff, " Addresses %01x/%01x: ", la1, la2);
	while(*buff) buff++;
        for(i=1; bytes; i++, bytes--)
	{ sprintf(buff, "%02x%s", data[i], (bytes == (la2/2)+1) ? " " : "");
	  while(*buff) buff++;
	}
        return i;
    }
  }
  return 0;
}

int sprintf_facil(buff, data, len)
char *buff;
unsigned char *data;
{ int i;
  int skip = 0;

  for (i=0; i<len; i++)	if (skip)
  {	skip--;
	sprintf(buff, " %02x", data[i]);
	while(*buff) buff++;
  }
  else
  {	int args;

	switch (data[i] & 0xc0)
	{	case 0x00:	args = 1;			break;
		case 0x40:	args = 2;			break;
		case 0x80:	args = 3;			break;
		default:	/* Keep the stupid compiler happy ! */
		case 0xc0:	args = data[i+1] +1;		break;
	}

	if (args > (len -i))	goto defalt;

        switch(data[i])
	{
	case 0x00:
	if ((data[i+1] != 0x00) && (data[i+1] != 0xff))	goto defalt;
	sprintf(buff, " NOM call%s", (data[i+1]) ? "ed" : "ing");
	i += args;
	break;

	case 0xc1:
	if (args != 5)	goto defalt;
	sprintf(buff, " Call Duration %02x%02x%02x%02x",
		data[i+2], data[i+3], data[i+4], data[i+5]);
	i += args;
	break;

	case 0xc2:
	if (args != 9)	goto defalt;
	sprintf(buff, " Call stats %02x%02x%02x%02x %02x%02x%02x%02x",
		data[i+2], data[i+3], data[i+4], data[i+5],
		data[i+6], data[i+7], data[i+8], data[i+9]);
	i += args;
	break;

	defalt:
	sprintf(buff, " invalid");
	while(*buff) buff++;
	default:
	sprintf(buff, " facil %02x len %d", data[i], args);
	skip = args;
	}
	while(*buff) buff++;
  }
  if (skip) sprintf(buff, " -- invalid facilities %d byte%s missing",
		skip, (skip == 1) ? "" : "s");
  return i;
}

VOID sprintf_clr(buff, data, len)
char *buff;
unsigned char *data;
{ int i = 0;
  int facil = 0;

  if (i <= len-2)
  { int inc;
    sprintf(buff, " %02x diag %02x", data[i], data[i+1]);
    i += 2;
    while(*buff) buff++;

    i += (inc = sprintf_dtes(buff, data + i, len -i));
    while(*buff) buff++;

    if (inc && i <= len-1 && data[i] <= len-i)
    { facil = data[i];
      i++;
      sprintf(buff, (facil) ? " Facilities %d:" : " No Facilities", facil);
      while(*buff) buff++;
    }

    i += sprintf_facil(buff, data + i, facil);
    while(*buff) buff++;

    if (i < len)
    { sprintf(buff, " Data:");
      while(*buff) buff++;
      for(; i<len; i++)
      { sprintf(buff, " %02x", data[i]);
        while(*buff) buff++;
      }
    }
  }
}

VOID sprintf_diag(buff, diag)
char *buff;
X25_CAUSE_DIAG *diag;
{
  if (diag->flags & ~((1 << RECV_DIAG) | (1 << DIAG_TYPE)))
	sprintf(buff, " (flags %02x)", diag->flags); while(*buff) buff++;
  if (!(diag->flags & (1<<RECV_DIAG)))
	sprintf(buff, " (no info)"); while(*buff) buff++;
  sprintf(buff, " %s:", (diag->flags & (1<<DIAG_TYPE)) ? "clear" : "reset");
  while(*buff) buff++;
  sprintf_clr(buff, diag->data, diag->datalen);
}

VOID time_stamp()
{	char *t_time;
	long now;

	(void) time(&now);
	t_time = ctime(&now) + 4;
	t_time[15] = 0;
	fprintf(debfile, "%s:%04x: ", t_time, pid);
}

VOID init_deb()
{	if (*logfile && strcmp(logfile, "-") &&
		(debfd = open(logfile, O_WRONLY | O_APPEND | O_CREAT, 0644))&&
		(debfile=fdopen(debfd,"a")));
	else if (debfd = dup(2)) debfile = fdopen(debfd, "a");
}

VOID x25b_logit(mask, format, a1, a2, a3, a4)
char *format;
char *a1, *a2, *a3, *a4;
{
	fprintf(debfile ? debfile : stderr, format, a1, a2, a3, a4);
	fflush(debfile ? debfile : stderr);
}

VOID x25b_perror(mask, format, a1, a2, a3, a4)
char *format;
char *a1, *a2, *a3, *a4;
{
	fprintf((debfile) ? debfile : stderr, format, a1, a2, a3,a4);
	fflush((debfile) ? debfile : stderr);
	perror("");
	fflush(stderr);
}

int x25b_debug = 0;


#include <signal.h>
#define	RDR	0
#define	WTR	1

extern	char	*calloc();
extern	int	getdtablesize();

static	int	*popen_pid;

p2open(cmd, pfdo, pfdi)
char	*cmd;
int	*pfdi, *pfdo;
{
	int pi[2];
	int po[2];
#define	my_i	pi[RDR]
#define	my_o	po[WTR]
#define	his_i	po[RDR]
#define	his_o	pi[WTR]
	int pid;

	/* Allocate the array to store the PIDs for popen()'d pipes.
	 * The array is allocated dynamically to allow programs to move
	 * to systems with a larger file descriptor tables without
	 * being recompiled.
	 */
	if (popen_pid == NULL) {
		popen_pid = (int *)calloc(getdtablesize(),sizeof(int));
		if (popen_pid == NULL)	return 0;
	}

	if(pipe(pi) < 0)
		return 0;
	if(pipe(po) < 0)
	{	close(pi[0]);
		close(pi[1]);
		return 0;
	}

	if((pid = fork()) == 0) {
		close(my_i);
		close(my_o);
		if (his_i != 0) { dup2(his_i, 0); close(his_i); }
		if (his_o != 1) { dup2(his_o, 1); close(his_o); }
		close(2);
		open("/dev/null", 2, 0);
		execl("/bin/sh", "sh", "-c", cmd, 0);
		_exit(1);
	}
	close(his_i);
	close(his_o);
	if(pid == -1) { close(my_i); close(my_o); return 0; }

	popen_pid[my_o] = pid;
	popen_pid[my_i] = pid;
	*pfdi = my_i;
	*pfdo = my_o;

	return 2;
}

p2close(fd)
{
	register r, (*hstat)(), (*istat)(), (*qstat)();
	int status;

	close(fd);

	/* If the pid array has not been allocated, then this wasn't
	 * opened with popen(), so return the error status.
	 */
	if (popen_pid == NULL) return(-1);

	istat = signal(SIGINT, SIG_IGN);
	qstat = signal(SIGQUIT, SIG_IGN);
	hstat = signal(SIGHUP, SIG_IGN);
	while((r = wait(&status)) != popen_pid[fd] && r != -1)
		;
	if(r == -1)
		status = -1;

	signal(SIGINT, istat);
	signal(SIGQUIT, qstat);
	signal(SIGHUP, hstat);
	return(status);
}
