int write_data = 1;
int avoid_sun_bug = 1;
/* Copyright (c) Piete Brooks 1988 */
#ifndef	lint
char RCSid[]="$Header: /Nfs/heaton/glob/src/etc/x25d/src/RCS/ybtsd.c,v 1.15 1991/07/17 09:21:33 pb Exp $";
#endif	lint

/*
 * ybtsd.c
 *
 * Stand-in for the Sun/York YBTS daemon.
 * Listens for incoming calls and forks off Q-end processes to handle them
 *
 * Initial code by pb@cam.cl
 * Further mods by andrew@brunel.me
 * Further mods by pb@cam.cl (use /etc/ybts-auth with regexp, allow non FCS)
 */

#include "x25d.h"

/* some pragmats used in the auth file */
#ifndef	DO_PRAGMAT
#define	DO_PRAGMAT		"#ybtsdo"
#endif	DO_PRAGMAT
#ifndef	REGEXP_PRAGMAT
#define	REGEXP_PRAGMAT		"#regexp"
#endif	REGEXP_PRAGMAT
#ifndef	NOREGEXP_PRAGMAT
#define	NOREGEXP_PRAGMAT	"#noregexp"
#endif	NOREGEXP_PRAGMAT
#ifndef	IGNORE_PRAGMAT
#define	IGNORE_PRAGMAT		"#ignore"
#endif	IGNORE_PRAGMAT
#ifndef	IFHOST_PRAGMAT
#define	IFHOST_PRAGMAT		"#ifhost"
#endif	IFHOST_PRAGMAT
#ifndef	ELIFHO_PRAGMAT
#define	ELIFHO_PRAGMAT		"#elifhost"
#endif	ELIFHO_PRAGMAT
#ifndef	ELSEHO_PRAGMAT
#define	ELSEHO_PRAGMAT		"#elsehost"
#endif	ELSEHO_PRAGMAT
#ifndef	ENDIFH_PRAGMAT
#define	ENDIFH_PRAGMAT		"#endifhost"
#endif	ENDIFH_PRAGMAT
#ifndef	ONLYHOST_PRAGMAT
#define	ONLYHOST_PRAGMAT	"#onlyhost"
#endif	ONLYHOST_PRAGMAT
#ifndef	FORMATX29_PRAGMAT
#define	FORMATX29_PRAGMAT	"#formatx29"
#endif	FORMATX29_PRAGMAT
#ifndef	FORMATYBTS_PRAGMAT
#define	FORMATYBTS_PRAGMAT	"#formatybts"
#endif	FORMATYBTS_PRAGMAT
#ifndef	FORMATGETOPT_PRAGMAT
#define	FORMATGETOPT_PRAGMAT	"#formatgetopt"
#endif	FORMATGETOPT_PRAGMAT

#ifndef	MAX_CHILD
#define	MAX_CHILD		40
#endif	MAX_CHILD
#ifndef	MAX_AUTH
#define	MAX_AUTH		60
#endif	MAX_AUTH
#ifndef	DEF_AUTH
#define	DEF_AUTH		"/usr/lib/niftp/qj:ftp|ftp.mail:*"
#endif	DEF_AUTH
#ifndef	DEF_COMMAND
#define	DEF_COMMAND		"/usr/lib/niftp/qj"
#endif	DEF_COMMAND
#ifndef	YBTSAUTH
#define	YBTSAUTH		"/etc/ybts-auth"
#endif	YBTSAUTH
#ifndef	YBTSAUTH_INTERVAL
#define	YBTSAUTH_INTERVAL	(60 * 5)	/* look each 5 mins */
#endif	YBTSAUTH_INTERVAL

#ifndef	KILL_FILE
#define	KILL_FILE		"/usr/adm/ybtsd.pid"
#endif	KILL_FILE


/* Misc other bits .... */
#ifndef	LOGFILE
#define	LOGFILE			"/usr/adm/ybtsd.log"
#endif	LOGFILE
#ifndef	LOGFILE_INTERVAL
#define	LOGFILE_INTERVAL	((60 * 60 * 24) + (60 * 20))
#endif	LOGFILE_INTERVAL
#ifndef	LOGFILE_SHORT_INTERVAL
#define	LOGFILE_SHORT_INTERVAL	(60)
#endif	LOGFILE_SHORT_INTERVAL
#ifndef	PID_LEN
#define	PID_LEN			4
#endif	PID_LEN
#ifndef	MAXADDRS
#define	MAXADDRS		40
#endif	MAXADDRS
#ifndef	MAXARGS
#define	MAXARGS			40	/* maximum size of server arg list */
#endif	MAXARGS

#ifndef	NOX25_TCP
#ifndef	X25_TCP
#define	X25_TCP
#endif	X25_TCP
#endif	NOX25_TCP

#include <pwd.h>		/* get struct passwd definition */
#include <sgtty.h>
#include <sys/wait.h>
#ifdef	X25_TCP
#define	FULL_X25STR
#include "x25b.h"
#endif	X25_TCP

#include "regexp.h"
#include "regexp.c"
#include "regerror.c"
#include "regsub.c"

#define toHEX(n) "0123456789ABCDEF"[n]
#define tohex(n) "0123456789abcdef"[n]
#define ENVLEN		(64*40)	/* size of buffer to hold env data */
#define	ENVSIZE		100	/* max # of env variables */
#define NET_FD 4		/* Child processes expect the net on fd 4 */
#define	ACCEPT	0x10
#define NAMES		((sizeof names) / (sizeof names[0]))

#ifdef	ANY_NSAP
#define	NSAP
#endif

/* Type of listening address */
#ifdef	X25
#define	ADDR_X25_FULL	1
#define	ADDR_X25_SUB	2
#define	ADDR_X25_BASE	3
#endif	X25
#ifdef	X25_TCP
#define	ADDR_TCP	4
#endif	X25_TCP
#ifdef	NSAP
#define	ADDR_NSAP	5
#endif	NSAP

/* auth file format */
#define	FORMAT_X29	1
#define	FORMAT_YBTS	2
#define	FORMAT_GETOPT	3

#define	LF_REV_CHARGE	2		/* Allow reverse charge calls	*/
#define	LF_X29		4		/* this is an X29 call		*/
#define	LF_TS29		8		/* this is a TS29 call		*/
#define	LF_NATIVE	16		/* use native mode		*/
#define	LF_MESSAGE	32		/* use message mode		*/
#define	LF_HIDE		64		/* use hide mode (no echo)	*/
#ifdef	TELNET
#define	LF_ONLY_TELNET	128		/* Only try telnet		*/
#endif	TELNET
#define	LF_FORK		256		/* Fork child directly		*/
#define	LF_USER_ACPT	512		/* User accepts call		*/
#define	LF_TS_NOACC	1024		/* Don't do TS accept		*/

union patt {
	regexp	*p_prog;
	char 	*p_str;
};
struct format {
	union patt	l_called_dte;
	union patt	l_called_aef;
	union patt	l_called_addr;
	union patt	l_calling_addr;
	char	*l_command;
	char	*l_comname;
	char    *x_banner;
	char	*l_telnet;
	char	*l_tel_port;
	char	*l_rest;
	int	l_flags;
	int	l_scan;
	int	l_uid;
	int	l_gid;
	int	l_cug;
} format[MAX_AUTH];
#define	s_calling_addr	l_calling_addr.p_str
#define	s_called_addr	l_called_addr.p_str
#define	s_called_dte	l_called_dte.p_str
#define	s_called_aef	l_called_aef.p_str
#define	p_calling_addr	l_calling_addr.p_prog
#define	p_called_addr	l_called_addr.p_prog
#define	p_called_dte	l_called_dte.p_prog
#define	p_called_aef	l_called_aef.p_prog

struct child {
	int	pid;
	int	type;
} children[MAX_CHILD];

extern char	*ctime();
extern char	*getenv();
extern char	*index();
extern char	*rindex();
extern char	*malloc();

char	**split_argv();
char	*decode_flags();
char	*get_dat();
char	*lower();
char	*make_regexp();
char	*save_str();
#ifdef	X25
int	accept_call();
int	diag_close();
#endif	X25
int	add_line();
int	cleanup();
int	clear_format();
int	expand_dollar();
int	format_copy();
int	grimreaper();
int	init_deb();
int	logit();
int	read_dte();
int	valid_request();
void	read_auth();

char *optarg;
extern	int optind;
extern	errno;
#ifdef	X25
extern accepted;
#endif	X25

FILE *debfile	= stderr;
char *address[MAXADDRS];
char *x25link[MAXADDRS];
#ifdef	X25
char *basename[MAXADDRS];
#endif	X25
char *calling_shortname = (char *) 0;
char _calling_shortname[128];
char *def_auth	= DEF_AUTH;
#ifdef	X25
char def_x25_addr[] = "\0<------ space for patching def_x25_addr ----->";
#endif	X25
#ifdef	X25_TCP
char def_tcp_addr[] = "ybts-secure\0<------ space for patching def_tcp_addr ----->";
#endif	X25_TCP
char *logfile	= LOGFILE;
char *authfile	= YBTSAUTH;
char *kill_file = KILL_FILE;

char calling_addr[20 + 128];

char calling_dte[20];
char calling_name[128];
char calling_ybts[128];
char called_aef[200];
char called_dte[20];
char called_ybts[128];
char cudf[128];
int cudflen;

char *calling_dte_p		= calling_dte;
char *calling_name_p		= calling_name;
char *calling_ybts_p		= calling_ybts;
char *called_dte_p		= called_dte;
char *called_aef_p		= called_aef;
char *called_ybts_p		= called_ybts;

char optargs[]	= "a:b:c:d:f:k:i:l:n:p:s:A:C:D:F:IK:M:P:W:";

int auth_count[MAX_AUTH];
int addr_type[MAXADDRS];
u_char	protocol_id[] = { 0x7f, 0xff, 0xff, 0xff };

int activehost	= 0;
int addresses	= 0;
int inetd	= 0;
int lcn		= -1;
int debug	= 0;
int max_child	= -1;
int auth_format;
int def_auth_format	= FORMAT_YBTS;
int auth_line;
int call_type;
int debfd	= 2;
int formats	= 0;
int my_pid;
int use_regexp;
int one		= 1;
int x25;
int ts29	= 1;
int fcc		= 0;
int base_logit_counts= 100;
int logit_counts= 100;
int authfile_interval	= YBTSAUTH_INTERVAL;
int logfile_interval	= LOGFILE_INTERVAL;
int logfile_short_interval= LOGFILE_SHORT_INTERVAL;
int reverse_charged = 0;

long last_log;		/* last attempt to reopen the log file */
long last_auth;		/* last attempt to look at authfile */
long starttime;		/* when the call arrived */
long xtime();
time_t auth_timestamp;

#define v(x)	x, sizeof(x) -1
struct {
	char	*name;
	int	len;
	char	**val;
} names[] = {
	{	v("called_dte"),	&called_dte_p,		},
	{	v("called_aef"),	&called_aef_p,		},
	{	v("called_ybts"),	&called_ybts_p,		},
	{	v("calling_ybts"),	&calling_ybts_p,	},
	{	v("calling_dte"),	&calling_dte_p,		},
	{	v("calling_name"),	&calling_name_p,	},
	{	v("calling_shortname"),	&calling_shortname,	}
};
#undef v

main(argc, argv, env)
char **argv;
char **env;
{
#ifdef	X25
#ifdef	SUNLINK
	CONN_DB hosts[MAXADDRS];
	CONN_DB	from;
#endif	SUNLINK
	int	pktsize = 0;
	int	wndsize	= 0;
	char	*base_x25	= (char *) 0;
	char	*x25_link	= (char *) 0;
#define	HOST	hosts[activehost]
#endif	X25
#ifdef	X25_TCP
	struct sockaddr_in sins[MAXADDRS], sfrom;
#define	SIN	sins[activehost]
#endif	X25_TCP
	int listen_fds;
	int fds[MAXADDRS];	/* the file descriptors	*/
	int fdt[MAXADDRS];	/* the type of socket	*/
	fd_set	xx;		/* mask for select */
	int currhost;
	int pid;
	char **args;
	char *server		= DEF_COMMAND;
	char *comname;
	char *newenv[ENVSIZE];
	char buff[1024];
	char _envp[ENVLEN];
	char *envp = _envp;
	char *kill_string = (char *) 0;
	char *explan;		/* Explanation text */
	char *qual;		/* Quality of service */
	int  uqd_len = 0;	/* Unqualified data length */
/*	char *envpe = envp + sizeof _envp; /* Should check ... */
	int newenvp		= 0;
	int fromlen;
	int i;
	int s;
	int maxpfd = getdtablesize();
	int maxfd = 0;

	my_pid = getpid();
	FD_ZERO(&xx);
#ifdef	FD_SETSIZE
	if (maxpfd > FD_SETSIZE) maxpfd = FD_SETSIZE;
#endif	/* FD_SETSIZE */

	while ((i = getopt(argc, argv, optargs)) != EOF) switch(i)
	{
	default:
		fprintf(stderr, "%s: bad args for: %s [%s] (near `%s' `%s')\n",
			*argv, *argv, optargs,
			argv[optind], (optarg) ? optarg : "<no optarg>");
		exit(1);
#ifdef	NSAP
	case 'n': if (addresses < MAXADDRS)
		  {	addr_type[addresses] = ADDR_NSAP;
			x25link[addresses] = x25_link;
			address[addresses++] = optarg;
		  }
		  else fprintf(stderr, " **** address %s ignored\n", optarg);
									break;
#endif	/* NSAP */
#ifdef	X25
	case 'a': if (addresses < MAXADDRS)
		  {	addr_type[addresses] = ADDR_X25_BASE;
			x25link[addresses] = x25_link;
			address[addresses++] = optarg;
		  }
		  else fprintf(stderr, " **** address %s ignored\n", optarg);
									break;
	case 'A': if (addresses < MAXADDRS)
		  {	addr_type[addresses] = ADDR_X25_FULL;
			x25link[addresses] = x25_link;
			address[addresses++] = optarg;
		  }
		  else fprintf(stderr, " **** address %s ignored\n", optarg);
									break;
	case 'b': base_x25 = optarg;
		  if (strlen(base_x25) != 12) fprintf(stderr,
			" **** base address %s is %d characters\n",
			base_x25, strlen(base_x25));
									break;
#endif	X25
	case 'c': def_auth = optarg;					break;
	case 'C': fcc++;						break;
	case 'D': debug = atoi(optarg);					break;
	case 'd': x25b_debug = atoi(optarg);				break;
	case 'f': authfile = optarg;					break;
#ifdef  X25
	case 'F': x25_link = optarg;					break;
#endif  X25
	case 'M': max_child = atoi(optarg);
		  if (max_child == 0 || max_child >= MAX_CHILD)
		  {	fprintf(stderr,
		 		"max_child must be 1 - %d. Ignoring `%s'\n",
				MAX_CHILD, optarg);
			max_child = -1;
		  }							break;
	case 'K': kill_file = optarg;                                   break;
	case 'k': kill_string = optarg;					break;
	case 'I': inetd++;						break;
	case 'i': authfile_interval = atoi(optarg);			break;
	case 'l': logfile = optarg;					break;
#ifdef	X25_TCP
	case 'p': if (addresses < MAXADDRS)
		  {	addr_type[addresses] = ADDR_TCP;
			address[addresses++] = optarg;
		  }
		  else fprintf(stderr, " **** port %s ignored\n", optarg);
									break;
#endif	X25_TCP
#ifdef	X25
	case 'P': i = atoi(optarg);
		  if ((i & -i) != i)
		  	fprintf(stderr,
			"Packet size (%s) must be a power of two\n", optarg);
		  else if (i < 32 || i > 1024)
			fprintf(stderr,
			"Packet size (%s) is not sensible -- ignored\n",
				optarg);
		  else	pktsize = i;
		  break;
	case 's': if (addresses < MAXADDRS)
		  {	addr_type[addresses] = ADDR_X25_SUB;
			basename[addresses] = base_x25;
			x25link[addresses] = x25_link;
			address[addresses++] = optarg;
		  }
		  else fprintf(stderr, " **** subaddress %s ignored\n", optarg);
		break;
	case 'W': i = atoi(optarg);
		  if (i < 1 || i > 7)
			fprintf(stderr,
			"Window size (%s) is not sensible -- ignored\n",
				optarg);
		  else	wndsize = i;
		  break;
#endif	X25
	}

	logit_counts = base_logit_counts;

	if (kill_string) exit(send_kill(kill_string));

	if (optind == 1 && argc == 2 && is_inetd_arg(argv[1]))
		optind++, inetd++;

	if (inetd)
	{
		int len = sizeof(sfrom);
		x25 = 0;
		call_type = ADDR_TCP;
		getpeername(x25, (struct sockaddr *)&sfrom, &len);
		init_deb("ybtsd inetd open");
		goto inetd_to_here;
	}

	/* If no addresses or subaddresses, listen on null address */
	if (!addresses)
	{
#ifdef	NSAP
		addr_type[addresses] = ADDR_NSAP;
		x25link[addresses] = x25_link;
		address[addresses++] = def_x25_addr;
#endif
#ifdef	X25
		addr_type[addresses] = ADDR_X25_BASE;
		x25link[addresses] = x25_link;
		address[addresses++] = def_x25_addr;
#endif
#ifdef	X25_TCP
		addr_type[addresses] = ADDR_TCP;
		address[addresses++] = def_tcp_addr;
#endif
	}

	read_auth();

	for (currhost=0, activehost = 0;
		currhost < addresses && activehost < MAXADDRS; currhost++)
	{	int s;
		char *addr = address[currhost];
		if (!addr)
		{	logit(1, "Null address !!\n");
			break;
		}

		switch(addr_type[currhost])
		{
		default:
		logit(1, "Internal confusion -- type %d\n", addr_type[currhost]);
					break;
#ifdef	X25
#ifdef	NSAP
		case ADDR_NSAP:
#endif	/* NSAP */
		case ADDR_X25_BASE:
		case ADDR_X25_FULL:
		case ADDR_X25_SUB:
#ifdef	NSAP
		if (addr_type[currhost] == ADDR_NSAP)
			HOST.hostlen |= ANY_NSAP | AEF_ON;
#endif
		s = x25_bind_4(address[currhost],
			protocol_id, sizeof protocol_id, 0, &one,
			&HOST, basename[currhost], x25link[currhost],
			(addr_type[currhost] == ADDR_X25_SUB) ? 1 :
#ifdef	NSAP
			addr_type[currhost] == ADDR_NSAP ? -2 :
#endif
			(addr_type[currhost] == ADDR_X25_BASE) ? 0 : -1);
		if (s < 0)
		{	logit(1, "Failed to listen on '%s' (%d, %d)\n",
					address[currhost], s, errno);
			continue;
		}

		logit(1, "%2d Listening", s);
		if (HOST.hostlen & ADR_LEN_MASK)
		{	logit(0, " on %d: ", HOST.hostlen);
			for(i=0; i<((HOST.hostlen & ADR_LEN_MASK)/2); i++)
				logit(0, "%02x", HOST.host[i] & 0xff);
			if (HOST.hostlen & 1)
				logit(0, "%x", ((HOST.host[(HOST.hostlen & ADR_LEN_MASK)/2])>>4) & 0xf);
		}
		else if (HOST.hostlen)
			logit(0, " with addr mask %02x", HOST.hostlen);
		if (basename[currhost])
			logit(0, " base %s", basename[currhost]);
#ifdef	ANY_LINK
		if (! (HOST.hostlen & ANY_LINK))
			logit(0, " only");
#endif	/* ANY_LINK */
		if (x25link[currhost])
			logit(0, " on link %s", x25link[currhost]);
#ifdef	AEF_ON
		if (HOST.hostlen & AEF_ON)
			logit(0, " (84)");
#endif	/* AEF_ON */
#ifdef	ANY_NSAP
		if (HOST.hostlen & ANY_NSAP)
			logit(0, " on any nsap");
#endif	/* ANY_NSAP */
#ifdef	ANY_SUBADDRESS
		if (HOST.hostlen & ANY_SUBADDRESS)
			logit(0, " on any subaddr");
#endif	/* ANY_SUBADDRESS */
#ifdef	EXACT_MATCH
		if (HOST.datalen & EXACT_MATCH)
			logit(0, " with exact PID match");
#endif	/* EXACT_MATCH */

		logit(0, " pid=");
#ifdef	EXACT_MATCH
		for (i=0; i<HOST.datalen & ~EXACT_MATCH; i++)
#else	/* EXACT_MATCH */
		for (i=0; i<HOST.datalen; i++)
#endif	/* EXACT_MATCH */
			logit(0, "%02x", HOST.data[i] & 0xff);
		logit(0, "\n");

/*		if (ioctl(s, X25_RD_FACILITY, &facil) < 0)
		{	perror("ybtsd Failed to read facilties");
			close(s);
			continue;
		}
*/
		{
		struct facilities data;
		data.x4_fflags = 0;

		data.x4_fast_select = (fcc) ? FACIL_FCS_CLR : FACIL_YES;
		data.x4_fflags |= FACIL_F_FAST_SELECT;
#ifndef	SUNFACILBUG
		data.x4_reverse_charge	= 1;
		data.x4_fflags |= FACIL_F_REVERSE_CHARGE;
#else	SUNFACILBUG
		data.x4_reverse_charge	= 0;
		for (i=0; i<formats; i++)
		{	if (format[i].l_flags & LF_REV_CHARGE)
			{	data.x4_reverse_charge	= 1;
				data.x4_fflags |= FACIL_F_REVERSE_CHARGE;
				break;
			}
		}
#endif	SUNFACILBUG

		data.x4_sendpktsize = pktsize;
		data.x4_fflags |= FACIL_F_SENDPKTSIZE;
		data.x4_recvpktsize = pktsize;
		data.x4_fflags |= FACIL_F_RECVPKTSIZE;
		data.x4_sendwndsize = wndsize;
		data.x4_fflags |= FACIL_F_SENDWNDSIZE;
		data.x4_recvwndsize = wndsize;
		data.x4_fflags |= FACIL_F_RECVWNDSIZE;
		if (x25_set_facil(s, &data, 0) < 0)
		{	perror("ybtsd Failed to set facilties");
			close(s);
			continue;
		}
		}

#ifdef	SUNLINK
		/* I'll accept or reject the call, thankyou */
		if (ioctl(s, X25_CALL_ACPT_APPROVAL, &one) < 0)
		{	perror("ybtsd Listen failed");
			close(s);
			continue;
		}
#endif	SUNLINK

		if (x25_listen(s, 5, &one) < 0)
		{	perror("ybtsd Listen failed");
			close(s);
			continue;
		}

		break;
#endif	X25

#ifdef	X25_TCP
		case ADDR_TCP:
		s = socket(AF_INET, SOCK_STREAM, 0);
		if (s < 0)
		{	perror("ybtsd Failed to open tcp socket");
			continue;
		}
		bzero(&SIN, sizeof sins[0]);
		SIN.sin_family	= AF_INET;
		{	struct servent *sp = getservbyname(addr, "tcp");
			if (sp == NULL)
			{	if ('0' <= *addr && *addr <= '9')
					SIN.sin_port = htons(atoi(addr));
				else
				{	logit(1, "no %s/tcp service\n", addr);
					close(s);
					continue;
				}
			}
			else SIN.sin_port = sp->s_port;
		}
		logit(1, "%2d Listening on %s (%d)\n", s,
				addr, ntohs(SIN.sin_port));

		if (bind(s, (struct sockaddr *)&SIN, sizeof sins[0]) < 0)
		{	perror("ybtsd Failed to bind socket");
			close(s);
			continue;
		}
		if (listen(s, 5) < 0)
		{	perror("ybtsd Listen failed");
			close(s);
			continue;
		}
		break;
#endif	X25_TCP
		}
		if (s >= maxpfd)
		{	fprintf(stderr, "too many fds to listen on\n");
			close(s);
			continue;
		}
		FD_SET(s, &xx);
		if (s+1 > maxfd) maxfd = s+1;
		fdt[activehost  ] = addr_type[currhost];
		fds[activehost++] = s;
	}

	if (!maxfd)
	{	logit(1, "No valid address\n");
		exit(1);
	}
	listen_fds = activehost;

	init_deb("ybtsd start");

#ifndef NOFORK
	if (!(debug & 16) && fork()) exit(0);
	else	my_pid = getpid();
#endif NOFORK

	if (kill_file && *kill_file)
	{       FILE *kill = fopen(kill_file, "w");
		if (kill)
		{
			fprintf(kill, "%d\n", my_pid);
			fclose(kill);
		}
		else logit(12, "Failed to open kill file `%s'\n", kill_file);
	}

	if (!(debug & 16))
	{
		/* No more need for stdin, stderr, etc, so ZAP them */
		close(0);
		close(1);
		close(2);
		i = open("/dev/null", 0);
		if (i >= 0)
		{	(void) dup2(i, 1);
			(void) dup2(i, 2);
			if (i) { dup2(i, 0); close(i);}
		}
		else logit(5, "Failed to open /dev/null");

		/* and detach the terminal */
		i = open("/dev/tty", 2);
		if (i >= 0)
		{	(void) ioctl(i, TIOCNOTTY, (char *) 0);
			close(i);
		}
		else logit(5, "Failed to open /dev/tty");
	}

	(void) signal(SIGHUP, read_auth);
	(void) signal(SIGCHLD, grimreaper);
	(void) signal(SIGPIPE, SIG_IGN);

	logit(3, "%d: %s started, maxfd=%d for %d fd%s\r\n",
		my_pid, index(RCSid, ':') +2, maxfd, listen_fds,
		(listen_fds == 1) ? "" : "s");

	for(;;)
	{	long this_time;
		int slot;
		int max = (max_child > 0) ? max_child : MAX_CHILD;

		fd_set	yy;
		yy = xx;		/* result of select */


if (debug & 2)
{
	int i;
	logit(0+0, "Select on:");
	for(i=0; i<4; i++) logit(0+0, " %08x", ((int *)(&yy))[i]);
	logit(0+0, "\n");
}
		if (select(maxfd, &yy, 0, (int *) 0, 0) <= 0)
		{	if (errno == EINTR)	continue;
			logit(7, "Select on %d fds failed\n", maxfd);
			perror("select");
			exit(1);
		}


if (debug & 2)
{
	int i;
	logit(0+0, "Gave   on:");
	for(i=0; i<4; i++) logit(0+0, " %08x", ((int *)(&yy))[i]);
	logit(0+0, "\n");
}
		activehost = -1;
		for (i=0; i<listen_fds; i++) if (FD_ISSET(fds[i], &yy))
			{ activehost = i; break; }

		if (activehost < 0)
		{	logit(3, "Failed to find selected fd\n");
			exit(1);
		}

		s = fds[activehost];

		for (slot=0; slot< max; slot++)
			if (!children[slot].pid) break;

		switch (call_type = fdt[activehost])
		{
#ifdef	X25
#ifdef	NSAP
		case ADDR_NSAP:
#endif
		case ADDR_X25_BASE:
		case ADDR_X25_FULL:
		case ADDR_X25_SUB:
		fromlen = sizeof(from);
		x25 = x25_accept(s, &from, &HOST, 0, &one);
		if (ioctl(x25, X25_RD_LCGN, &lcn))
			logit(5, "Failed to read LCN\n");
		if (slot >= max && max_child >= 0)
		{	logit(1, "Too many children (%d)\n", max_child);
			close_with_diag(x25, 0x00, 0x11, 0);
			continue;
		}
		break;
#endif	X25

#ifdef	X25_TCP
		case ADDR_TCP:
		fromlen = sizeof sfrom;
		x25 = accept(s, (struct sockaddr *)&sfrom, &fromlen);
#endif	X25_TCP
		}
		(void) time(&this_time);
		if (x25 < 0)
		{	if (errno == EINTR)	continue;
			logit(3, "");
			perror("ybtsd Accept failed");
			exit(1);
		}

		/* Should we look at authfile again ? */
		if ((this_time - last_auth) > authfile_interval)
		{	struct stat statbuf;
			if (stat(authfile, &statbuf))
				perror(authfile);
			else if (statbuf.st_mtime != auth_timestamp)
			{	logit(1, "%x != %x\n",
					statbuf.st_mtime, auth_timestamp);
				read_auth();
			}
			else	last_auth = this_time;
		}

#ifndef NOFORK
		if (!(debug & 8))
		{	
			while ((pid = fork()) < 0)
				sleep(60);
			if (pid < 0) continue;

			if (pid)
			{	close(x25);	/* parent listens */
	
			    	if (slot < max)
			    	{	children[slot].pid = pid;
					children[slot].type= -1;
			    	}
			}
			else if (slot >= max)
			{	if (max_child >= 0)
				{	logit(1, "Too many children (%d)\n",
						max_child);
					close_with_diag(x25, 0x11, 0x11/*??*/, 1);
				}
				logit(1, "Should have junked as no slot\n");
			}
			else	break;
		  }
		  else
#endif	NO_FORK
			break;
		  logit_counts = base_logit_counts;
	}

	logit_counts = base_logit_counts;
	starttime = xtime(0);
	my_pid = getpid();
	for (i=0; i<listen_fds; i++) if (FD_ISSET(fds[i], &xx))
		close(fds[i]);

	/* OK -- we have a child processing an incoming call ... */

	switch (fdt[activehost])
	{
#ifdef	X25
#ifdef	NSAP
	case ADDR_NSAP:
#endif
	case ADDR_X25_BASE:
	case ADDR_X25_FULL:
	case ADDR_X25_SUB:
#ifdef	SUNLINK

	{	FACILITY_DB facil;
/* Test for bug ... */
	if (ioctl(x25, X25_RD_FACILITY, &facil) < 0)
		close_with_diag(x25, 0x13, 0x13/*??*/, 1);
	if (facil.reverse_charge) logit(1, "Rev %d\n", facil.reverse_charge);
/* ..... */
	if (facil.recvpktsize != 128 ||
	    facil.sendpktsize != 128 ||
	    facil.recvwndsize != 2 ||
	    facil.sendwndsize != 2 ||
	    facil.recvthruput ||
	    facil.sendthruput)
		logit(1, "pkt=%d/%d, window=%d/%d, thru=%d/%d\n", 
			facil.recvpktsize, facil.sendpktsize,
			facil.recvwndsize, facil.sendwndsize,
			facil.recvthruput, facil.sendthruput);
	if ((facil.fast_select_type == FAST_CLR_ONLY && !fcc) ||
	    (facil.fast_select_type != FAST_CLR_ONLY &&  fcc))
		logit(1, "FST=%d, but fcc=%d\n", facil.fast_select_type, fcc);
	else if (facil.fast_select_type == FAST_CLR_ONLY || fcc)
		logit(1, "FST=%d, fcc=%d\n", facil.fast_select_type, fcc);
	fcc = facil.fast_select_type == FAST_CLR_ONLY;

	reverse_charged = facil.reverse_charge;
	}
	for (i=0; i<from.hostlen/2; i++) {
		calling_dte[ 2*i   ]	= tohex((from.host[i] >> 4) & 0x0f);
		calling_dte[(2*i)+1]	= tohex((from.host[i]     ) & 0x0f);
	}
	calling_dte[from.hostlen] = '\0';

	bin2hex(&from, calling_dte);
	bin2hex(&HOST, called_dte);
#ifdef	X25_RD_LOCAL_ADR
	{	CONN_ADR loc;
		if (ioctl(x25, X25_RD_LOCAL_ADR, &loc)) {
			perror("ioctl(X25_RD_LOCAL_ADR)");
			exit(1);
		}
		bin2hex(&loc, called_dte);
	}
#endif	/* X25_RD_LOCAL_ADR */

	bcopy(from.data+4, cudf, cudflen = from.datalen-4);
#endif	SUNLINK
	if (fcc)
	{	USER_DATA_DB result;
		strcpy(result.data, "010 This data is discarded 010");
		result.datalen = (write_data) ? strlen(result.data) : 0;

		if (write_data || avoid_sun_bug)
			if (ioctl(x25, X25_WR_USER_DATA, &result) < 0)
				logit(5, "Write user data failed\n");
			else	logit(1, "Written %d bytes of user data\n",
					result.datalen);
		else	logit(1, "Omit user data (AT YOUR OWN RISK!!)\n");
		dump_call_info(calling_dte, called_dte, cudf, cudflen);

		close_with_diag_and_data(x25, 0x03, 0x91, 1, "<121--121>", 10);
	}
	break;
#endif	X25

#ifdef	X25_TCP
	case ADDR_TCP:
	{	struct hostent *host, *gethostbyaddr();
		struct x25io data;
		char *inet_ntoa();
		char *called;

inetd_to_here:
		called = data.x_destination;
		host = gethostbyaddr((char *)&sfrom.sin_addr,
				sizeof sfrom.sin_addr, AF_INET);

		if (x25b_receive_call(x25, &data) <= 0)
		{	logit(5, "Failed to read caller info\n");
			exit(1);
		}

		/* Is it actually called + calling [+calling name] encoded? */
		if (*called & 0x80)
		{	int called_len  = *(called++)		& 0x7f;
			int calling_len =   called[called_len]	& 0x7f;
			int callingn_len=   called[called_len+calling_len+1];

			strncpy(calling_dte, called+called_len+1,
				calling_len);
			called[called_len] = '\0';
			calling_dte[calling_len] = '\0';
			if (callingn_len)
			{	callingn_len &= 0x7f;
				if (debug & 2) logit(1,
					"Calling name is %d: %s\n",
					callingn_len,
					called+called_len+calling_len+2);
				if (callingn_len)
				{	calling_shortname=_calling_shortname;
					if (callingn_len >= sizeof _calling_shortname)
					callingn_len = sizeof _calling_shortname -1;
					
					strncpy(calling_shortname,
						called+called_len+calling_len+2,
						callingn_len);
					calling_shortname[callingn_len] = '\0';
				}
			}
		}
		else	*calling_dte = '\0';

		logit(3, "%s@%s to %s\n",
			data.x_username,
			(host) ? host->h_name : inet_ntoa(sfrom.sin_addr),
			called);
		strncpy(called_dte, called, sizeof called_dte);
		called_dte[sizeof called_dte -1] = '\0';
		bcopy(data.x_cudf+4, cudf, cudflen = data.x_cudflen-4);
#ifdef	X25
		accepted = 1;
#endif	X25
	}
#endif	X25_TCP
	}

	/* Non fast call select, so read the rest of the data */
	if (*cudf & 64)
	{	char	save[2];
		int	len;
		unsigned char	*base;

#ifdef	X25
		logit(1, "*cudf=%02x, accepted=%d\n", (*cudf)&0xff, accepted);
		if (!accepted)	accept_call(x25);
#else	X25
		logit(1, "*cudf=%02x\n", (*cudf)&0xff);
#endif	X25
		*cudf &= ~64;

		/* Save away the buffer info as it is over-written */
		cudflen -= sizeof save;
		base = (unsigned char *) cudf + cudflen;
		bcopy(base, save, sizeof save);

		errno = -1;
		len = recv(x25, base, sizeof cudf - cudflen, 0);

		/* Check it is qualified and an accept */
		if (len <= sizeof save ||
			base[0] != (1 << Q_BIT) ||
			base[1] != ACCEPT)
		{	logit(5,
			"Got %d bytes, flags %02x type %02x data %02x\n",
				len, base[0], base[1], base[2]);
			dump_call_info(calling_dte, called_dte, cudf, cudflen);
			perror("recv rest of CONNECT");
			close_with_diag(x25, 0x10/*??*/, 0x10/*??*/, 1);
		}
		bcopy(save, base, sizeof save);
		cudflen += len;
	}

	logit(3, "%s<%s",
#ifdef	X25
		(accepted) ? "NFS-" : 
#endif	X25
		"", calling_dte);

	{	char *d1, *d2;
		i = ts_buff_decode8_not_used(cudf, buff, cudflen, &uqd_len,
			4, &d1, &d2, &qual, &explan);
		if (i < 2)
		{	logit(0, "\ninvalid CUDF (%d):", i);
			for (i=0; i<cudflen; i++)
				logit(0, " %02x", cudf[i] & 0xff);
			logit(0, " so exiting\n");
			dump_call_info(calling_dte, called_dte, cudf, cudflen);
			close_with_diag(x25, 0x11, 0x11/*??*/, 1);
		}
		strcpy(called_ybts, d1);
		strcpy(calling_ybts, d2);
	}

	logit(0, ".%s >%s.%s", calling_ybts,
		(*called_dte) ? called_dte : "*", called_ybts);
	if (lcn >= 0)		logit(0, " on %03x", lcn);
	if (qual && *qual)	logit(0, " q='%s'", qual);
	if (explan && *explan)	logit(0, " e='%s'", explan);
	if (uqd_len) logit(0, " +%d", uqd_len-1);
	logit(0, "\n");

	sprintf(calling_addr, "%s%s%s",
		calling_dte,
		(*calling_dte) ? "." : "",
		calling_ybts);
	if ((auth_line = valid_request(lower(called_ybts),
					lower(calling_addr), 1)) < 0)
		close_with_diag_and_data(x25, 0x00, (write_data) ? 0x43 : 0x00, 1,
			"\0\0\0\0\0\0\0\000121 no service 121", 26);

	/* Now check if reverse charge call allowed */
	if (reverse_charged &&
		!(format[auth_line].l_flags & LF_REV_CHARGE))
		close_with_diag(x25, 0x19, 0x19/**/, 1);

#ifdef	X25
	/* Does the user want to do the accept ? */
	if (debug & 2) logit(0, "Flags=%x, %d\n",
		format[auth_line].l_flags,
		format[auth_line].l_flags & LF_USER_ACPT);
if (!(format[auth_line].l_flags & LF_USER_ACPT))
	if (debug & 2) logit(0, "So accept\n");
if (format[auth_line].l_flags & LF_USER_ACPT)
	if (debug & 2) logit(0, "Let user accept\n");
	if (
#ifndef	SUNACPTBUG
		!(format[auth_line].l_flags & LF_USER_ACPT) &&
#endif	SUNACPTBUG
		!accepted)	accept_call(x25);
#else	X25
	if (debug & 2) logit(1, "No X25\n");
#endif	X25

	sprintf(envp, "X25DTE=%s",	calling_dte);
	newenv[newenvp++] = envp; while (*envp++);
	sprintf(envp, "YBTSCALLED=%s",	called_ybts);
	newenv[newenvp++] = envp; while (*envp++);
	sprintf(envp, "YBTSTEXT=%s",	calling_ybts);
	newenv[newenvp++] = envp; while (*envp++);

	sprintf(envp, "CALLED_DTE=%s",	called_dte);
	newenv[newenvp++] = envp; while (*envp++);
	sprintf(envp, "CALLING_DTE=%s",	calling_dte);
	newenv[newenvp++] = envp; while (*envp++);
	sprintf(envp, "CALLED_YBTS=%s",	called_ybts);
	newenv[newenvp++] = envp; while (*envp++);
	sprintf(envp, "CALLING_YBTS=%s",calling_ybts);
	newenv[newenvp++] = envp; while (*envp++);

	if (calling_name && *calling_name)
	{	sprintf(envp, "CALLING_NAME=%s",	calling_name);
		newenv[newenvp++] = envp; while (*envp++);
	}
	if (calling_shortname && *calling_shortname)
	{	sprintf(envp, "CALLING_SHORTNAME=%s",	calling_shortname);
		newenv[newenvp++] = envp; while (*envp++);
	}

	if (qual)
	{	sprintf(envp, "QUAL_SERV=%s",	qual);
		newenv[newenvp++] = envp; while (*envp++);
	}
	if (explan)
	{	sprintf(envp, "EXP_TEXT=%s",	explan);
		newenv[newenvp++] = envp; while (*envp++);
	}

	if (uqd_len > 0)
	{	sprintf(envp, "UNQUAL_DATA=");
		newenv[newenvp++] = envp;
		while (*envp++);
		for (i=1; i<uqd_len; i++)
		{	sprintf(envp-1, "%02x",
				cudf[cudflen - uqd_len +i] & 0xff);
			while (*envp++);
		}
	}

	sprintf(envp, "PROTOCOL=%s",
#ifdef	X25_TCP
		(call_type == ADDR_TCP) ? "X25B" :
#endif	X25_TCP
#ifdef	X25
#ifdef	NSAP
		(call_type == ADDR_NSAP) ? "NSAP" :
#endif	/* NSAP */
		(call_type == ADDR_X25_BASE) ? "X25" :
		(call_type == ADDR_X25_FULL) ? "X25" :
		(call_type == ADDR_X25_SUB) ? "X25" :
#endif	X25
		"Unknown");
	newenv[newenvp++] = envp; while (*envp++);
	sprintf(envp, "X25_FD=%d",	NET_FD);
	newenv[newenvp++] = envp; while (*envp++);
	sprintf(envp, "STARTTIME=%08x",	starttime);
	newenv[newenvp++] = envp; while (*envp++);

	for(; *env && newenvp < ENVSIZE-2;) newenv[newenvp++] = *env++;
	newenv[newenvp] = NULL;

	if (format[auth_line].l_command && *format[auth_line].l_command)
		server = format[auth_line].l_command;
	comname = format[auth_line].l_comname;

	expand_dollar(buff, (comname) ? comname : server, sizeof buff);
	logit(3, "Invoke '%s' with %d'%s'\n", server, strlen(buff), buff);

	args = split_argv(buff, sizeof buff);

	if (x25 != NET_FD)
	{	errno = -1;
		if (dup2(x25, NET_FD) == NET_FD)
			close(x25);
		else	logit(7, "dup2(%d, %d) failed\n", x25, NET_FD);
	}

	if (format[auth_line].l_gid > 0)
			setgid(format[auth_line].l_gid);
	if (format[auth_line].l_uid > 0)
		setuid(format[auth_line].l_uid);

	execve(server, args, newenv);
	logit(7, "%s (%s) (%s, %s, %s)\n",
		server, args[0], newenv[0], newenv[1], newenv[2]);
	perror("execve failed");
	close_with_diag(x25, 0x13, 0x00/*??*/, 1);
}

ts_buff_decode8_not_used(raw, buff, len, rem_len, argc, a0, a1, a2, a3)
register char *raw, *buff;
char **a0, **a1, **a2, **a3;
register int len;
int *rem_len;
{   char **argv[4];
    int param;

    if (!buff) buff=raw;
    argv[0] = a0;
    argv[1] = a1;
    argv[2] = a2;
    argv[3] = a3;
    if (argc > sizeof argv / sizeof argv[0])
	argc = sizeof argv / sizeof argv[0];

    for (param=0; param < argc; param++)
    {	register int i;
	register char *p;
	if (len ==0)		break;
	if (!*raw)		break;		/* terminating zero octet */
	len--;
	if (!(*raw & 0x80))	return -(param+1);
	if ((i = (*raw++ & 0x3f)) > len) return (param+1) * -11;
	if (argv[param]) *argv[param] = buff;
	for (;i>0; len--, i--) *buff++ = (*raw++) & 0xff;
	*buff++ = '\0';
    }

    if (rem_len) *rem_len = len;

    return param;
}

#ifdef	NOftime
long xtime(zero)
long *zero;
{
	return 	time(zero) * 1000;
}
#else

#include <sys/timeb.h>

/* ARGSUSED */
long xtime(zero)
long *zero;
{
	struct timeb x;
	ftime(&x);
	return (long) ((x.time * 1000) + x.millitm);
}
#endif	NOftime

dump_call_info(calling_dte, called_dte, cudf, cudflen)
char *calling_dte;
char *called_dte;
char *cudf;
{	int i;
	logit(3, "From %s got%s", calling_dte,
#ifdef	X25
		(accepted) ? " NFS" : 
#endif	X25
		"");
	for(i=0; i<=cudflen; i++)
		logit(0, "%c%02x", (i == cudflen) ? '(' : ' ',
			cudf[i] & 0xff);
	logit(0, ")");
	if (called_dte) logit(0, " to %s", called_dte);
	logit(0, "\n");
}

#include "commond.c"
