/* Copyright (c) Piete Brooks 1988 */
#ifndef	lint
static char RCSid[]="$Header: /Nfs/heaton/glob/src/etc/x25d/src/RCS/ybtslib.c,v 1.15 1991/07/17 09:21:37 pb Exp $";
#endif	lint

/* ybtsd.c
 *
 * Stand-in for the Sun/York YBTS daemon.
 *
	s = x25_bind(dte, pid, sizeof pid, 0, (int *) 0, 0);
	x25_listen(s, 1, 0)
	x25 = x25_accept(s, 0, 0, 0, 0);
	accept_call(x25);
	... rest ...

	CONN_DB from, host;
	int get_hdr = 1;
	s = x25_bind(dte, pid, pid_len, pid_mask, &get_hdr, &host);
	zap_facilities(&facilities)
	... set required facilities ...
	x25_set_facil(s, &facilities, &facil)
	x25_listen(s, n, 0)
	while (1)
	{	
		... select on x25 and others ...

		if (sel_mask & sel_x25)
		{	int x25 = x25_accept(s, &from, &host, &pid_mask, get_hdr);
			if (!fork())	break;
			close(x25);
		}
	}
	accept_call(x25);
	x25_read_facil(s, &facilities, &facil)
	doit(&from);
 */

#include "x25d.h"
#include "x25b.h"

#define toHEX(n) "0123456789ABCDEF"[n]
#define tohex(n) "0123456789abcdef"[n]

extern char	*index();
extern char	*malloc();

#ifdef	SUNLINK
int	accept_call();
int	diag_close();
int	read_dte();
extern	errno;

int accepted	= 0;
int i_accept = 1;


x25_bind_2(dte, pid, pid_len, pid_mask, get_hdr, host, base_addr)
char *dte;
char *pid;
int *get_hdr;
CONN_DB *host;
char *pid_mask;
char *base_addr;
{	return x25_bind_3(dte, pid, pid_len, pid_mask, get_hdr, host, base_addr, (char *) 0);
}

x25_bind_3(dte, pid, pid_len, pid_mask, get_hdr, host, base_addr, link)
char *dte;
char *pid;
int *get_hdr;
CONN_DB *host;
char *pid_mask;
char *base_addr;
char *link;
{	
	return x25_bind_4(dte, pid, pid_len, pid_mask, get_hdr, host,
		base_addr, link, strlen(dte) < 4);
}

x25_bind_4(dte, pid, pid_len, pid_mask, get_hdr, host, base_addr, link, sub)
char *dte;
char *pid;
int *get_hdr;
CONN_DB *host;
char *pid_mask;
char *base_addr;
char *link;
int sub; /* <0 -> full address, =0 -> base address (any sub), >1 -> is sub */
{	CONN_DB _host;
	int s;
	int one = 1;

	if (!host) host = &_host;
	bzero(host, sizeof(*host));
	s = socket(AF_X25, SOCK_STREAM, 0);
	if (s < 0)	return -1;
	/* maybe ioctl(ls, SIOCSPGRP, &pgrp) and signal(SIGURG, sigurg) */

	if (sub < -1)
	/* This is a FULL NSAP */
	{
#ifdef	AEF_NSAP
		FACILITY facility;

		facility.type = T_CALLED_AEF;
		facility.f_cd_aef_type = AEF_NSAP;
		if (!read_dte(facility.f_cd_aef, 0, dte))
		{	close(s);
			return -3;
		}
		facility.f_cd_aef_len = strlen(dte);
		if (ioctl(s, X25_SET_FACILITY, &facility))
		{	close(s);
			return -3;
		}
#endif	AED_NSAP
	}
	else if (sub <= 0)
	/* If a FULL address, always listen on any subaddress */
	{	if (!read_dte(host->host, 0, dte))
		{	close(s);
			return -3;
		}
		host->hostlen = strlen(dte);
#ifdef	ANY_SUBADDRESS
		if (sub == 0)
			host->hostlen |= ANY_SUBADDRESS;
#endif	/* ANY_SUBADDRESS */
	}
	else 
	{	
		/* If a subaddress and base addr is given use that */
		if (base_addr && *base_addr)
		{	if (!read_dte(host->host, 0, base_addr))
			{	close(s);
				return -3;
			}
			host->hostlen = strlen(base_addr);
		}
		else
		{
#ifdef	SUBADR_ONLY
if (x25b_debug & 2) logit(1, "subaddr only\n");
			/* if a subaddress and SUNLINK 6+, do it RIGHT ! */
			host->hostlen &= ~ANY_SUBADDRESS;
#else	/* SUBADR_ONLY */
if (x25b_debug & 2) logit(1, "!!subaddr only!!\n");
			/* if a subaddress and SUNLINK <6, hack it ! */
			if (ioctl(s, X25_RD_HOSTADR, host) < 0)
			{	close(s);
				return -2;
			}
#endif	/* SUBADR_ONLY */
		}
		if (!read_dte(host->host, host->hostlen & ADR_LEN_MASK, dte))
		{	close(s);
			return -4;
		}
		host->hostlen += strlen(dte);
	}

	host->datalen	= pid_len;
	bcopy(pid, host->data, pid_len);
#ifdef	ANY_LINK
	if (!link || !*link) /* && ! sub */
		host->hostlen |= ANY_LINK;
#endif	/* ANY_LINK */

	if (bind(s, (struct sockaddr *)host, sizeof host[0]) < 0)
	{	close(s);
		return -7;
	}

#ifdef	X25_SET_LINK
	if (link && *link)
	{	int linkid = atoi(link);
		if (linkid <=0 && *link != '0')
		{	logit(0, "Invalid link number '%s'\n", link);
			close(s);
			return -5;
		}
		if (linkid >= 0) {
			if (ioctl(s, X25_SET_LINK, &linkid)) {
				logit(0, "ioctl(X25_SET_LINK) failed %d\n",
					errno);
				perror("ioctl(X25_SET_LINK)");
				close(s);
				return -6;
			}
		}
	}
#endif	/* X25_SET_LINK */

	if (pid_mask)
	{	MASK_DATA_DB mask;
		int len= (pid_len>sizeof mask.mask) ?sizeof mask.mask:pid_len;
		bcopy(pid_mask, mask.mask, len);
		mask.masklen =  len;
		ioctl(s, X25_WR_MASK_DATA, &mask);
	}

	/* Ensure that the Q bit can be read */
	if (get_hdr && ioctl(s, X25_HEADER, get_hdr))
		logit(1, "Failed to set X25_HEADER to one (%d)\n", errno);
	if (ioctl(s, X25_RECORD_SIZE, &one))
		logit(1, "Failed to set X25_RECORD_SIZE to one (1)\n", errno);

	/* Maybe X25_WR_FACILITY */

	/* I'll accept or reject the call, thankyou */
	if (i_accept >= 0 && ioctl(s, X25_CALL_ACPT_APPROVAL, &i_accept) < 0)
#ifndef	SUNACPTAPPROVALBUG
		return -1
#endif	SUNACPTAPPROVALBUG
	;
	return s;
}

zap_facilities(data)
struct facilities *data;
{	bzero(data, sizeof data[0]);	}

/* Set facilities in from */
x25_set_facil(s, from, facil)
struct facilities *from;
#if	(SUNLINK_VER < 700)
FACILITY_DB *facil;
#endif
{
#if	(SUNLINK_VER < 700)
	FACILITY_DB _facil;

	if (!facil) facil = &_facil;

	if (ioctl(s, X25_RD_FACILITY, facil) < 0) return -1;
	facil_from_std(from, facil);
	if (ioctl(s, X25_WR_FACILITY, facil) < 0) return -2;
#else
	FACILITY facility;
	u_int	oldmask, newmask;
#define	SET(x) (from->x4_fflags & FACIL_F_/**/x)
	if (x25b_debug & D_TRACE)
	{	facility.type = T_FACILITIES;
		if (ioctl(s, X25_GET_FACILITY, &facility))
		{	logit(1, "X25_GET_FACILITY failed %d\n", errno);
			oldmask = 0;
		}
		else oldmask = facility.f_facilities;
		logit(1, "Oldmask=%x\n", oldmask);
	}
	if (from->x4_fflags & (FACIL_F_RECVWNDSIZE | FACIL_F_SENDWNDSIZE)) 
	{	facility.f_recvpktsize=SET(RECVWNDSIZE) ? from->x4_recvwndsize: 0;
		facility.f_sendwndsize=SET(SENDWNDSIZE) ? from->x4_sendwndsize: 0;
		if (set_facility(s, &facility, T_WINDOW_SIZE, 0, "window size"))
			logit(1, "%x and %x\n", facility.f_recvpktsize, facility.f_sendwndsize);
	}
	if (from->x4_fflags & (FACIL_F_RECVPKTSIZE | FACIL_F_SENDPKTSIZE)) 
	{	facility.f_recvpktsize=SET(RECVPKTSIZE) ? from->x4_recvpktsize: 0;
		facility.f_sendpktsize=SET(SENDPKTSIZE) ? from->x4_sendpktsize: 0;
		set_facility(s, &facility, T_PACKET_SIZE, 0, "packet size");
	}
	if (from->x4_fflags & (FACIL_F_RECVWNDSIZE | FACIL_F_SENDWNDSIZE)) 
	{	facility.f_recvpktsize=SET(RECVWNDSIZE) ? from->x4_recvwndsize: 0;
		facility.f_sendwndsize=SET(SENDWNDSIZE) ? from->x4_sendwndsize: 0;
		if (set_facility(s, &facility, T_WINDOW_SIZE, 0, "window size"))
			logit(1, "%x and %x\n", facility.f_recvpktsize, facility.f_sendwndsize);
	}
	if (SET(REVERSE_CHARGE))
	{	facility.f_reverse_charge= from->x4_reverse_charge;
		facility.f_nrpoa = 1;
		if (set_facility(s, &facility, T_REVERSE_CHARGE, 1,
				"reverse charge")) return -1;
	}
	if (SET(RPOA))
	{	facility.f_rpoa_index[0]= from->x4_rpoa;
		if (set_facility(s, &facility, T_RPOA, 1, "RPOA")) return -1;
	}
	facility.f_fast_select_type =
		(from->x4_fast_select == FACIL_FCS_CLR)	? FAST_CLR_ONLY :
		(from->x4_fast_select == FACIL_YES)	? FAST_ACPT_CLR :
							  FAST_OFF;
	set_facility(s, &facility, T_FAST_SELECT_TYPE, 0, "fast select");
#undef	SET
	if (x25b_debug & D_TRACE)
	{	facility.type = T_FACILITIES;
		if (ioctl(s, X25_GET_FACILITY, &facility))
		{	logit(1, "X25_GET_FACILITY failed %d\n", errno);
			newmask = 0;
		}
		else newmask = facility.f_facilities;
		logit(1, "Mask %x -> %x\n", oldmask, newmask);
	}
#endif
	return 0;
}

#ifdef	X25_SET_FACILITY
static int set_facility(s, facilityp, type, fatal, text)
FACILITY *facilityp;
int type;
int fatal;
char *text;
{
	facilityp -> type = type;
	if (ioctl(s, X25_SET_FACILITY, facilityp))
	{	logit(1, "X25_SET_FACILITY %s failed (%d)\n",
			text, errno);
		return(-1);
	}
	return 0;
}
#endif

x25_read_facil(x25, to, facil)
struct facilities *to;
#if	(SUNLINK_VER < 700)
FACILITY_DB *facil;
#endif
{
#if	(SUNLINK_VER < 700)
	FACILITY_DB _facil;
	if (!facil) facil = &_facil;

	if (ioctl(x25, X25_RD_FACILITY, facil) < 0)	return -1;
	facil_to_std(to, facil);
#else
	FACILITY facility;
	u_int fmask;
#define IF_GET(x) facility.type = T_/**/x; if (ioctl(x25, X25_GET_FACILITY, &facility))
	IF_GET(FACILITIES)
	{	logit(1, "X25_GET_FACILITY failed %d\n", errno);
		return -1;
	}
	fmask = facility.f_facilities;
	logit(1, "Mask %x\n", fmask);
	IF_GET(PACKET_SIZE);
	else
	{	to->x4_recvpktsize = facility.f_recvpktsize;
		to->x4_sendpktsize = facility.f_sendpktsize;
	}
	IF_GET(WINDOW_SIZE);
	else
	{	to->x4_recvwndsize = facility.f_recvwndsize;
		to->x4_sendwndsize = facility.f_sendwndsize;
	}
#undef	IF_GET
#endif
	return 0;
}

#if	(SUNLINK_VER < 700)
/* copy facilities in from to device specific format */
facil_from_std(from, facil)
struct facilities *from;
FACILITY_DB *facil;
{	
#define	_pset(F, t, f) if (from->x4_fflags & F) facil->t = f
#define	pset(F, t, f) _pset(F, t, from->f)
	pset(FACIL_F_RECVPKTSIZE,	recvpktsize,	x4_recvpktsize);
	pset(FACIL_F_SENDPKTSIZE,	sendpktsize,	x4_sendpktsize);
	pset(FACIL_F_RPOA,		rpoa,		x4_rpoa);
	if (from->x4_fflags & FACIL_F_RPOA)	 facil->rpoa_req = 1;
	pset(FACIL_F_REVERSE_CHARGE,	reverse_charge,	x4_reverse_charge);
	pset(FACIL_F_RECVWNDSIZE,	recvwndsize,	x4_recvwndsize);
	pset(FACIL_F_SENDWNDSIZE,	sendwndsize,	x4_sendwndsize);
	pset(FACIL_F_RECVTHRUPUT,	recvthruput,	x4_recvthruput);
	pset(FACIL_F_SENDTHRUPUT,	sendthruput,	x4_sendthruput);
	pset(FACIL_F_CUG_INDEX,		cug_index,	x4_cug_index);
	if (from->x4_fflags & FACIL_F_CUG_INDEX) facil-> cug_req = 1;
	_pset(FACIL_F_FAST_SELECT,	fast_select_type,
		(from->x4_fast_select == FACIL_FCS_CLR) ? FAST_CLR_ONLY :
		(from->x4_fast_select == FACIL_YES) ? FAST_ACPT_CLR :
			FAST_OFF);
#undef	pset
#undef	_pset
}

/* copy from device specific format into standard format */
facil_to_std(to, facil)
struct facilities *to;
FACILITY_DB *facil;
{
#define	_pset(F, f, t) { to->x4_fflags |= F; to->t=f; }
#define	pset(F, f, t) _pset(F, facil->f, t)
	pset(FACIL_F_RECVPKTSIZE,	recvpktsize,	x4_recvpktsize);
	pset(FACIL_F_SENDPKTSIZE,	sendpktsize,	x4_sendpktsize);
	if (facil->rpoa_req)
		pset(FACIL_F_RPOA,	rpoa,		x4_rpoa);
	pset(FACIL_F_REVERSE_CHARGE,	reverse_charge,	x4_reverse_charge);
	pset(FACIL_F_RECVWNDSIZE,	recvwndsize,	x4_recvwndsize);
	pset(FACIL_F_SENDWNDSIZE,	sendwndsize,	x4_sendwndsize);
	pset(FACIL_F_RECVTHRUPUT,	recvthruput,	x4_recvthruput);
	pset(FACIL_F_SENDTHRUPUT,	sendthruput,	x4_sendthruput);
	if (facil->cug_req)
		pset(FACIL_F_CUG_INDEX,	cug_index,	x4_cug_index);
	_pset(FACIL_F_FAST_SELECT,
		(facil->fast_select_type == FAST_CLR_ONLY) ? FACIL_FCS_CLR :
		(facil->fast_select_type == FAST_ACPT_CLR) ? FACIL_FCS:
							     FACIL_NO,
							x4_fast_select);
#undef	pset
#undef	_pset
}
#endif

x25_listen(s, n, get_hdr)
int *get_hdr;
{	int rc;
	int one=1;

	if ((rc=listen(s, n)) < 0) return rc;

#ifdef	SUNINHERITBUG
	/* Ensure that the Q bit can be read -- is this the right time ? */
	if (get_hdr && ioctl(s, X25_HEADER, get_hdr))
		logit(1, "Failed to set X25_HEADER to one (2)\n", errno);
	if (ioctl(s, X25_RECORD_SIZE, &one))
		logit(1, "Failed to set X25_RECORD_SIZE to one (2)\n", errno);
#endif	/* SUNINHERITBUG */

	return 0;
}

x25_accept(s, from, host, pid_mask, get_hdr)
CONN_DB *from;
CONN_DB *host;
{	int fromlen = sizeof(from[0]);
	int x25;
	int i;
	int one = 1;

	if ((x25 = accept(s, (struct sockaddr *)from, &fromlen)) < 0)
		return x25;

	accepted = 0;

#ifdef	SUNINHERITBUG
	/* Ensure that the Q bit can be read -- Belt & braces ... */
	if (get_hdr && ioctl(x25, X25_HEADER, get_hdr))
		logit(1, "Failed to set X25_HEADER to one (3)\n", errno);
	if (ioctl(x25, X25_RECORD_SIZE, &one))
		logit(1, "Failed to set X25_RECORD_SIZE to one (3)\n", errno);
#endif	/* SUNINHERITBUG */

#if	defined(SUNCUDFBUG) || defined(SUNCUDF2BUG)
	{	int rlen = fromlen - (from->data-(unsigned char*)from);
		int slip = rlen - from->datalen;
		/* There seems to be some sort of compiler alignment problem
		* which seems to put the first data byte at from.data[+/-1]
		* (+1 for sun3 OS 3.x; -1 for sun4 OS 4.x)
		*/
		if (slip && x25b_debug & 2)
		{	int i;
			logit(1, "CUDF with two extra bytes: ");
			for (i= -2; i<= rlen+2; i++)
				logit(0, " %02x", from->data[i] & 0xff);
		  	logit(0, "\n");
		}
		switch (slip)
		{
		case 0: logit(1, " *** no need to bcopy from->data\n"); break;
		case 1:	logit(1,	 /* 5.x SunLink X.25 on Sun3 */
		" *** Sun3/5.x: had to copy CUDF down as %02x (%02x)\n",
				from->data[0] & 0xff, host->data[0] & 0xff);
			bcopy(from->data +1, from->data, from->datalen);
			break;
		default:logit(1,	/* 6.0 SunLink X.25 on Sun4 */
    " *** Sun4/6.0: had to copy CUDF up as %d != %d, %02x (%02x), guess %d\n",
				fromlen, (from->data - (unsigned char *)from),
				from->data[0] & 0xff, host->data[0] & 0xff,
				rlen+1);
			(void) bcopy(from->data-1, from->data, rlen+1);
			from->datalen = rlen+1;
		}
		if (slip && x25b_debug & 2)
		{	int i;
			logit(1, "CUDF with two extra bytes: ");
			for (i= -2; i<= rlen+2; i++)
				logit(0, " %02x", from->data[i]&0xff);
		  	logit(0, "\n");
		}
	}
#endif	/* SUNCUDF[2]BUG */

#ifdef	SUNACPTBUG
	/*	If an incoming call is closed before it has been accepted,
	 *	then the process (even if unpriveledged) falls over and causes
	 *	the kernel to panic.
	 */
	accept_call(x25);
#endif	SUNACPTBUG

	return x25;
}

get_nsaps(x25, called, len_d, calling, len_g)
char *called;
int *len_d;
char *calling;
int *len_g;
{	int got = 0;
#ifdef	X25_GET_FACILITY
	FACILITY f;

	if (called && len_d && ((*len_d) > 0))
	{
		f.type = T_CALLED_AEF;
		if (ioctl(x25, X25_GET_FACILITY, &f) != -1 &&
		    f.f_cd_aef_len <= *len_d)
		{	bcopy(f.f_cd_aef, called, f.f_cd_aef_len);
			*len_d = f.f_cd_aef_len;
			got |= 1;
		}
	}
#endif
	return (got == 0) ? -1 : got;
}

get_mac(x25, mac)
#ifdef	X25_RD_MACADDR
X25_MACADDR *mac;
#endif
{
	if (!mac)	return -1;

#ifdef	X25_RD_MACADDR
	return ioctl(x25, X25_RD_MACADDR, mac);
#else
	return -1;
#endif
}
/* Read the YBTS connect message if present */
ybts_read_connect(x25, host)
CONN_DB *host;
{	unsigned char *cudf = (host->data) +4;

	/* Non fast call select, so read the rest of the data */
	if (*cudf & 64)
	{	char	temp[128];
		int	len;
		int	skip = 1;
		unsigned char	*base;

		if (!accepted)	accept_call(x25);
		*cudf &= ~64;

		base = (host->data) + host->datalen;

		errno = -1;
		len = recv(x25, temp, sizeof host->data - host->datalen, 0);

		/* Check it is qualified and an accept */
		if ((len > 0) && (temp[0] == (1 << Q_BIT)))
			if (len <= 2 || temp[1] != CONNECT) return -1;
			else skip++;
		else	if (temp[0] != CONNECT)	return -1;
		len -= skip;
		bcopy(temp+skip, base, len);
		host->datalen += len;
	}
	return 0;
}

/* Send a YBTS accept message */
ybts_send_accept(x25, recall, qual, exp)
char *recall, *qual, *exp;
{	int qbit = 1 << Q_BIT;
	int zero = 0;
	char buff[1024];
	sprintf(buff, "%c%c%s%c%s%c%s",
		0x11,
		((recall || qual || exp) ? 0x80 : 0) |
			((recall) ? strlen(recall) : 0),
		(recall) ? recall : "",
		((qual || exp) ? 0x80 : 0) |
			((qual) ? strlen(qual) : 0),
		(qual) ? qual : "",
		((exp) ? 0x80 : 0) |
			((exp) ? strlen(exp) : 0),
		(exp) ? exp : "");
	ioctl(x25, X25_SEND_TYPE, &qbit);
	write(x25, buff, strlen(buff));
	ioctl(x25, X25_SEND_TYPE, &zero);
}

accept_call(x25)
{
	if (accepted)	return 1;

	if (ioctl(x25, X25_SEND_CALL_ACPT) < 0)
	{ logit(1, "accept failed %d\n", errno);
		return -1;
	}
	accepted++;
	return 0;
}
#endif	SUNLINK

ts_buff_decode8(raw, buff, len, rem_len, argc, a0, a1, a2, a3)
register char *raw, *buff;
char **a0, **a1, **a2, **a3;
register int len;
int *rem_len;
{   char **argv[4];
    int param;

    if (!buff) buff=raw;
    argv[0] = a0;
    argv[1] = a1;
    argv[2] = a2;
    argv[3] = a3;
    if (argc > sizeof argv / sizeof argv[0])
	argc = sizeof argv / sizeof argv[0];

    for (param=0; param < argc; param++)
    {	register int i;
	register char *p;
	if (len ==0)		break;
	if (!*raw)		break;		/* terminating zero octet */
	len--;
	if (!(*raw & 0x80))	return -(param+1);
	if ((i = (*raw++ & 0x3f)) > len) return (param+1) * -11;
	if (argv[param]) *argv[param] = buff;
	for (;i>0; len--, i--) *buff++ = (*raw++) & 0xff;
	*buff++ = '\0';
    }

    if (rem_len) *rem_len = len;

    return param;
}

read_dte(buff, offset, string)
char *buff;
char *string;
{	for (;*string; string++, offset++)
	{	int	val = (*string) - '0';

		if (offset >= (MAXHOSTADR-1) || val<0 || val>9) return 0;

		if (offset & 1)
			buff[offset/2] |= val;
		else	buff[offset/2]  = val << 4;
	}

	return 1;
}

#ifdef	SUNLINK
diag_close(fd, cause, diagnostic, exit_rc)
{	diag_close_data(fd, cause, diagnostic, exit_rc, 0, 0);
}

diag_close_data(fd, cause, diagnostic, exit_rc, buff, len)
char *buff;
{	diag_setup_data(fd, cause, diagnostic, exit_rc, buff, len);

	(void) close(fd);
	if (exit_rc) exit(exit_rc);
}

diag_setup_data(fd, cause, diagnostic, exit_rc, buff, len)
char *buff;
{
	X25_CAUSE_DIAG	diag;

#if	(defined(SUNACPTBUG) || defined(SUNACPT2BUG))
	/* ==================================================== */
	/* ==================================================== */
	/* Currently a close before accepting panics the kernel */
	/* under SUNLINK 5.x and junks the codes under 6.0      */
	/* ==================================================== */
	/* ==================================================== */
	if (!accepted) accept_call(fd);
#endif	/* some SUNACPTBUG */
	diag.flags	= (1 << RECV_DIAG) | (1 << DIAG_TYPE);
	diag.flags	= (1 << WAIT_CONFIRMATION) | (1 << DIAG_TYPE);
	diag.datalen	= 2+len;
	diag.data[0]	= cause;
	diag.data[1]	= diagnostic;
	bcopy(buff, &(diag.data[2]), len);
	logit(1, "diag_close_data fd=%d, %x %x, exit=%x (%x:%d)\n",
		fd, cause, diagnostic, exit_rc, buff, len);
	if (ioctl(fd, X25_WR_CAUSE_DIAG, &diag))
		perror("x29d ioctl X25_WR_CAUSE_DIAG");
}

/* Convert the host.host field into hex characters.
 * buff should be 16+1 bytes long
 */
bin2hex(host, buff)
CONN_DB *host;
char *buff;
{	bintohex(buff, host->host, host->hostlen & ADR_LEN_MASK);
}

bintohex(to, from, len)
char *to;
char *from;
int len;
{	int i;
	for (i=0; i<len/2; i++)
	{	to[ 2*i   ]	= toHEX((from[i] >> 4) & 0x0f);
		to[(2*i)+1]	= toHEX((from[i]     ) & 0x0f);
	}
	to[len] = '\0';
}

read_host_addr(s, buff, host)
char *buff;
CONN_DB *host;
{	CONN_DB _host;
	if (!host) host = &_host;

	if (ioctl(s, X25_RD_HOSTADR, host) < 0)
		return -1;
	bin2hex(host, buff);
	return 0;
}

/*
 * x25_send_reset() sends a Reset packet with specified diagnostic.
 * It awaits Reset Confirm.
 */
x25_send_reset(s, cause, diagnostic)
{
        X25_CAUSE_DIAG  diag;

        diag.flags = (1 << WAIT_CONFIRMATION);
        diag.datalen = 2;
        diag.data[0] = cause;		/* cause */
        diag.data[1] = diagnostic;	/* diagnostic */
        if (ioctl(s, X25_WR_CAUSE_DIAG, &diag)) {
                logit(1, "ioctl(X25_WR_CAUSE_DIAG) gave errno %d\n", errno);
                return 1;
	}
	return 0;
}
#endif	SUNLINK
