static char RCSid[] = "$Id: Ctext.c,v 1.3 1993/02/22 23:38:15 kadhim Exp $";
/* Collect a C compound statement as a single literal string */
/* Copyright (c) 1991, The Regents of the University of Colorado */

#include "err.h"
#include "source.h"
#include "gla.h"
#include "obstack.h"

static struct obstack Text;	/* Storage */


/***/
void
CtextInit()
/* Initialize the compound statement module
 ***/
{
   obstack_init(&Text);
}

typedef enum {			/* Scanner states */
   InText,
   InComment,
   InCharacter,
   InString
} States;

typedef enum {			/* Last character flags */
   Uninteresting,
   Backslash,
   Slash,
   Star
} Flags;

/***/
char *
Ctext( start, len )
char *start; int len;
/* Scan a C compound statement after the opening brace
 *    On entry
 *       start points to the opening brace
 *       len=1
 *    On exit-
 *       Ctext points to the character position following the
 *          closing brace
 ***/

{
   register char c ;
   register char *p = start + len;
   int nest = 0;
   States state = InText;
   Flags last = Uninteresting;

   obstack_1grow(&Text, *start);

   for (;;) {
      if (*p == '\0') {
         refillBuf(p);
         p = TokenEnd;
         if (*p == '\0') {
            message(ERROR,"file ends in C text",0,&curpos);
            obstack_1grow(&Text, 0); return p;
         }
      }
      c = *p++;
      obstack_1grow(&Text, c);

      if (c == '\n') { LineNum++; StartLine = p - 1; }

      switch (last) {
      case Backslash:
         last = Uninteresting; continue;
      case Slash:
         last = Uninteresting;
         if (c == '*') { state = InComment; continue; }
         break;
      case Star:
         last = Uninteresting;
         if (c == '/') { state = InText; continue; }
      default:
         ;
      }

      switch (c) {
      case '\"':
         if (state == InText) state = InString;
         else if (state == InString) state = InText;
         break;
      case '\'':
         if (state == InText) state = InCharacter;
         else if (state == InCharacter) state = InText;
         break;
      case '\\':
         if (state == InCharacter || state == InString) last = Backslash;
         break;
      case '/':
         if (state == InText) last = Slash;
         break;
      case '*':
         if (state == InComment) last = Star;
         break;
      case '{':
         if (state == InText) nest++;
         break;
      case '}':
         if (state == InText) {
            if (nest == 0) {
		obstack_1grow(&Text, 0); 
		return p;
	    }
            nest--;
         }
         break;
      default:
         ;
      }
   }
}

/***/
void
CtextFinl(c, length, t, v)
char *c; int length, *t; char **v;
{
   *v = obstack_finish(&Text);
}
