static char rcs_id[]="$Id: name.c,v 1.3 1992/07/11 20:56:53 kadhim Exp $";
/* PDL attribute computations for name analysis */
/* Copyright (c) 1992, The Regents of the University of Colorado */

#include <stdio.h>
#include "err.h"	/* error module */
#include "csm.h"	/* string table module */
#include "deftbl.h"	/* definition table module */
#include "envmod.h"	/* environment module */
#include "ptg_gen.h"    /* output generation definitions */
#include "func.h"	/* definition for OpOutput */
#include "header.h"	/* definition for ExtOutput */
#include "name.h"	/* constants and exported functions */
#include "pdl_gen.h"	/* PDL generated functions */

int GetHandle;		/* identifier handle for "Get" */
int SetHandle;		/* identifier handle for "Set" */
int TypeHandle;		/* identifier handle for "TYPE" */

/* Create an environment for operation names and predefine the operations */
/* 'Get' and 'Set' */
Environment InitOpEnv()
{
  int temp;

  mkidn("Get", 3, &temp, &GetHandle);
  mkidn("Set", 3, &temp, &SetHandle);
  return NewEnv();
}

/* Create an environment for type and property names and predefine the */
/* keyword 'TYPE' */
Environment InitEnv()
{
  Environment env;
  int temp;
  DefTableKey key;

  mkidn("TYPE", 4, &temp, &TypeHandle);
  env = NewEnv();
  key = DefineIdn(env, TypeHandle);
  SetKind(key, TypeClass, TypeClass);
  return env;
}

/***/
void
KindIs(key,kind)
DefTableKey key; int kind;
/* Verify the definition of an entity
 *    On entry-
 *       key defines the entity
 *       kind specifies the type of entity
 *    On exit-
 *       The Kind and Index properties have been set
 ***/
{
   int CurrentKind;

   switch (CurrentKind = GetKind(key,Undefined)) {
   case PropertyClass:
   case TypeClass:
      if (CurrentKind != kind) SetKind(key, NameClash, NameClash);
   case NameClash:
      return;
   case Undefined:
      SetKind(key, kind, NameClash);
   }
}

/* Set all properties for an operation declaration key */
void
OpDefine(key,output,arglist,formallist,extrn,sym)
DefTableKey key; OpOutput output; PTGNode arglist; PTGNode formallist; 
ExtOutput extrn; int sym;
{
  SetFuncOut(key, output, output);
  SetArgList(key, arglist, arglist);
  SetFormalList(key, formallist, formallist);
  SetExtOut(key, extrn, extrn);
  SetSym(key, sym, sym);
  SetDefine(key, Defined, MultDefined);
  return;
}

