;;
;; example zenirc customization script - ben@piglet.cr.usgs.gov 
;;
;; $Header: /home/fsf/friedman/src/zenirc/zenirc/scripts/RCS/zenirc-example.el,v 1.1 1993/10/09 22:19:56 ben Exp $
;;

;; set your nickname on irc
(setq zenirc-nick "ben")

;; set your "irc name", displayed when people do a /who or /whois on you.
(setq zenirc-name "oedipus rpc.rexd")

;; this is your irc server name
(setq zenirc-hostname "ucsd.edu")

;; the following will cause zenirc to notice when someone mentions your name
;; on irc, or sends you a message.
(setq zenirc-signal-list 
      (list (concat "\\(PRIVMSG\\|NOTICE\\).*" zenirc-nick)))

;; zenirc can beep when it notices something, this turns that off.
(setq zenirc-beep-on-signal nil)

;; this is a list of annoying things to ignore. This list ignores messages
;; from nickserv, anything with the word "fnord" in it, and messages from
;; the major dweeb craig
(setq zenirc-ignorance-list 
      '("^:NickServ!Nickserv@hpsystem2.informatik.tu-muenchen.de" "fnord"
	"^:craig!craig@netsys1.netsys.com"))

;; this causes messages to be formatted similar to ircII. the default is to
;; show nick!user@host instead of just nick, which I find eliminates the need
;; for nickserv, but you might be more used to ircII-style.
(setq zenirc-user-format "%s")

;;
;; the following is an example of adding a new ctcp reply type to zenirc.
;; in this case, it is "BOZOS", which returns a list of people who have
;; been bozotic with me
;;
(setq zenirc-clientinfo-list
'((ACTION . "ACTION contains action descriptions for atmosphere")
;; this is the addition to the default list
  (BOZOS . "BOZOS returns a list of people who have been bozotic with me")
  (CLIENTINFO . "CLIENTINFO gives information about available CTCP commands")
  (ERRMSG . "ERRMSG returns error messages")
  (PING . "PING returns the arguments it receives")
  (FINGER . "FINGER shows real name, and login name of user (idle time is not yet implemented in ZenIRC)")
;; sojge sure is a wordy bastard.
  (SOURCE . "takes 0 arguments and returns a description of where to find the source code of the client. The description is made up out of zero or more lines followed by an end marker. Every line is a CTCP reply with the SOURCE keyword, a space, the name of a FTP-server, a colon, a directory name, a colon, and 0 or more file names. If no file names are given, all the files in the named directory are needed. The end marker contains just the keyword.")
  (TIME . "TIME tells you the time on the user's host")
  (USERINFO . "USERINFO returns user settable information")
  (VERSION . "VERSION shows client type, version, and environment")))

;; note addition of BOZOS--------------*****
(setq zenirc-clientinfo-string "ACTION BOZOS CLIENTINFO ERRMSG FINGER PING SOURCE TIME USERINFO VERSION :Use CLIENTINFO <COMMAND> to get more specific information")

;;
;; this is the handler for a CTCP BOZOS query
;;
(defun zenirc-ctcp-query-BOZOS-hook (proc parsedctcp from to)
  ;; if verbose ctcp is on, tell the user we got the query
  (if zenirc-verbose-ctcp
      (zenirc-display-string 
       proc (format "[info] responding to BOZOS query from %s to %s\n" 
       (zenirc-format-nickuserhost-hook from) to)))
  ;; send a reply to the BOZOS query
  (process-send-string 
   proc 
   (concat "NOTICE  " (zenirc-extract-nick from)
	   " :\C-aBOZOS phone poxav veep noah dmarcher lila neil wabbit laura weirdo jason belladona mycroft amazin CHRISTIAN\C-a\n")))
