;;; $Id: irchat-timer.el,v 1.5 1994/08/02 07:15:19 tmo Exp $
;;;
;;; see file irchat-copyright.el for change log and copyright info

(if (string-match "18" (emacs-version))
    (defun irchat-timer (function interval)
      "Timers are not supported under emacs 18."
      nil)
  (if (string-match ".*Lucid.*" (emacs-version))
      (progn
	(defun irchat-cancel-timer (timer)
	  "Cancel timer."
	  (delete-timer timer))
	(defun irchat-start-timer (function interval)
	  "Add timer function."
	  (interactive)
	  (if interval
	      (start-itimer "IRCHAT" function interval interval))))
    (progn
      (eval-when-compile
	(require 'timer))
      (defun irchat-cancel-timer (timer)
	"Cancel timer."
	(cancel-timer timer))
      (defun irchat-start-timer (function interval)
	"Add timer function."
	(interactive)
	(if interval
	    (run-at-time (format "%d sec" interval) interval function))))))

;;;
;;; eof
;;;

