;;;
;;;
;;; zenirc-french-mode.el 
;;; French language interface for Zen Internet Relay Chat client
;;;
;;; Copyright (C) 1993, 1994 Ben A. Mesander
;;;
;;; Author: Nicolas Pioch <Nicolas.Pioch@enst.fr> (Nap)
;;; Maintainer: ben@gnu.ai.mit.edu
;;; Keywords: extensions
;;; Created: 1994/02/28
;;;
;;; $Id: zenirc-french-mode.el,v 1.2 1994/06/21 19:31:56 ben Exp $
;;;
;;; History:
;;;   Initial revision Mon Feb 28 08:07:21 MET 1994
;;;
;;; This program is free software; you can redistribute it and/or modify
;;; it under the terms of the GNU General Public License as published by
;;; the Free Software Foundation; either version 2, or (at your option)
;;; any later version.
;;;
;;; This program is distributed in the hope that it will be useful,
;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;; GNU General Public License for more details.
;;;
;;; You should have received a copy of the GNU General Public License
;;; along with this program; if not, you can either send email to this
;;; program's maintainer or write to: The Free Software Foundation,
;;; Inc.; 675 Massachusetts Avenue; Cambridge, MA 02139, USA.
;;;
;;; Commentary:
;;; "it's like operating a nazi sub or something."
;;;    --Ben A. Mesander <ben@gnu.ai.mit.edu>
;;;
;;;
;;; Code:

; your channel join message
(zenirc-set-text-list-ent
 'join_you
 "[info] Entre dans %s.\n") 
; channel join message
(zenirc-set-text-list-ent
 'join
 "[info] %s entre dans %s.\n") 
; welcome to irc message
(zenirc-set-text-list-ent
 's001
 "[info] Vous perdez votre temps.\n") 
; server name & version # msg
(zenirc-set-text-list-ent
 's002 
 "[info] Votre serveur IRC est %s, version %s.\n")
; when the server was built
(zenirc-set-text-list-ent
 's003
 "[info] Serveur cre %s.\n") 
; # users on connect message
(zenirc-set-text-list-ent 
 's251 
 "[info] %s louzeurs visibles et %s invisibles sur %s serveurs.\n")
; irc operators msg
(zenirc-set-text-list-ent
 's252 
 "[info] %s crtins sont en ligne.\n") 
; unk connects msg
(zenirc-set-text-list-ent
 's253 
 "[info] %s connexions non identifies.\n") 
; number of channels
(zenirc-set-text-list-ent 's254 "[info] %s groupes.\n") 
; # of clients and servers
(zenirc-set-text-list-ent 
 's255 			
 "[info] %s clients et %s serveurs connects sur ce serveur.\n")
; someone is away
(zenirc-set-text-list-ent
 's301
 "[info] %s est absent: %s\n") 
; userhost reply
(zenirc-set-text-list-ent
 's302
 "[info] identification: %s.\n") 
(zenirc-set-text-list-ent
 's305
 "[info] Vous n'tes plus marqu absent.\n")
(zenirc-set-text-list-ent
 's306
 "[info] Vous tes marqu absent.\n")
; user part of /whois list
(zenirc-set-text-list-ent
 's311
 "[info] %s (%s@%s) est %s\n") 
; server part of /whois list
(zenirc-set-text-list-ent
 's312
 "[info] %s sur le serveur %s (%s)\n") 
; /whois operator status
(zenirc-set-text-list-ent
 's313
 "[info] %s est un crtin.\n") 
; user part of /whowas list
(zenirc-set-text-list-ent
 's314
 "[info] %s (%s@%s) tait %s.\n") 
; end of /who list replies
(zenirc-set-text-list-ent
 's315
 "[info] Fin de /who.\n") 
; end of /whois list replies
(zenirc-set-text-list-ent
 's318
 "[info] Fin de /whois.\n") 
; /whois idle time
(zenirc-set-text-list-ent
 's317 
 "[info] %s a t inactif %d secondes.\n") 
; channel part of whois data
(zenirc-set-text-list-ent 
 's319
 "[info] %s participe : %s\n") 
; header for LIST cmd
(zenirc-set-text-list-ent
 's321
 "[info] Groupes\tLouzeurs\tSujet\n") 
; each channel in LIST cmd
(zenirc-set-text-list-ent
 's322
 "[info] %s\t%s\t%s\n")	
; trailer for LIST cmd 
(zenirc-set-text-list-ent
 's323
 "[info] Fin de /list.\n") 
; channel mode
(zenirc-set-text-list-ent
 's324
 "[info] Mode de %s: %s %s.\n") 
; no topic message
(zenirc-set-text-list-ent
 's331
 "[info] %s n'a pas de sujet.\n") 
(zenirc-set-text-list-ent
 's332 
 "[info] %s sujet: %s\n") ; topic message
; invite reply
(zenirc-set-text-list-ent
 's341
 "[info] Vous invitez %s dans %s.\n") 
; summon reply
(zenirc-set-text-list-ent
 's342
 "[info] Vous incitez %s  perdre son temps.\n") 
(zenirc-set-text-list-ent
 's351
 "[info] Version: %s %s %s.\n") ; version reply
; header for /who list reply
(zenirc-set-text-list-ent
 's352_header 
 "[info] Pseudo  Etat Nom du Groupe  login et machine        Nom\n") 
; /who list reply
(zenirc-set-text-list-ent
 's352
 "[info] %-9s %-3s  %-15s %s@%s (%s)\n") 
; displayed after channel join
(zenirc-set-text-list-ent
 's353
 "[info] Louzeurs sur %s: %s\n") 
(zenirc-set-text-list-ent
 's364
 "[info] %s %s %s\n")    ; /links reply
; end of /links reply
(zenirc-set-text-list-ent
 's365
 "[info] Fin de /links.\n") 
; banlist reply
(zenirc-set-text-list-ent
 's367
 "[info] %s interdit  %s.\n")     
; end of banlist reply
(zenirc-set-text-list-ent
 's368
 "[info] Fin de liste d'interdiction.\n")
(zenirc-set-text-list-ent
 's371
 "[info] %s\n")          ; info reply
(zenirc-set-text-list-ent
 's372
 "[motd] %s\n")		; message of the day
(zenirc-set-text-list-ent
 's375
 "[motd] Message du jour:\n")	; start of motd
; displayed at end of motd
(zenirc-set-text-list-ent
 's376
 "[motd] Fin de message.\n") 
; irc op status
(zenirc-set-text-list-ent 
 's381
 "[info] Vous etes maintenant un crtin total.\n") 
; rehash server msg
(zenirc-set-text-list-ent
 's382
 "[info] Rechargement: %s\n") 
(zenirc-set-text-list-ent 
 's391
 "[info] Heure sur le serveur %s: %s.\n")   ; TIME reply
; header for users rpl
(zenirc-set-text-list-ent
 's392 
 "[info] Login Terminal  Machine\n")  
(zenirc-set-text-list-ent
 's393
 "[info] %s\n") ; body of users rpl
; nobody for users rpl
(zenirc-set-text-list-ent
 's395
 "[info] Personne n'est connect.\n")  
; there is no such nick/chan
(zenirc-set-text-list-ent 
 's401
 "[info] Louzeur ou groupe inconnu: %s.\n") 
; there is no such server
(zenirc-set-text-list-ent
 's402
 "[info] Serveur inconnu: %s.\n") 
; there is no such channel
(zenirc-set-text-list-ent
 's403
 "[info] Groupe inconnu: %s.\n")
; you can't send to channel
(zenirc-set-text-list-ent
 's404
 "[info] Impossible d'crire  %s.\n") 
; too many channels
(zenirc-set-text-list-ent
 's405
 "[info] Trop de groupes: %s.\n") 
(zenirc-set-text-list-ent ; no whowas data
 's406 
 "[info] Le serveur ne se souvient plus de %s.\n") 
(zenirc-set-text-list-ent 
 's407
 "[info] Destinataires dupliqus, message non envoy: %s\n") ; user@host
; no recipient given
(zenirc-set-text-list-ent
 's411
 "[info] Destinataire manquant.\n")
; you didn't send anything.
(zenirc-set-text-list-ent 
 's412
 "[info] Texte manquant.\n") 
; no toplevel domain spec
(zenirc-set-text-list-ent
 's413
 "[info] Domaine manquant: %s\n")
(zenirc-set-text-list-ent
 's414 ; wild toplevel
 "[info] Domaine invalide: %s.\n") 
(zenirc-set-text-list-ent ; you sent server spam
 's421
 "[info] Charabia: %s.\n") 
(zenirc-set-text-list-ent 
 's422 			; deprecate operators
 "[info] Certains crtins sont trop ignorants pour crer un mot de bienvenue.\n")
(zenirc-set-text-list-ent 
 's423 			; deprecate operators
 "[info] Les crtins de %s sont trop ignorants pour fournir les informations administratives.\n")
; you didn't provide a nick
(zenirc-set-text-list-ent
 's431
 "[info] Pseudonyme manquant.\n") 
; invalid nick
(zenirc-set-text-list-ent
 's432
 "[info] Pseudonyme invalide: %s.\n") 
; invalid nick
(zenirc-set-text-list-ent
 's433
 "[info] Pseudonyme %s dja utilis.\n") 
(zenirc-set-text-list-ent 
 's436
 "[info] Collision de pseudonymes: %s.\n") ; nickicide
; can't do it to those not present
(zenirc-set-text-list-ent 
 's441
 "[info] %s n'est pas sur %s.\n") 
; you can't do that dave.
(zenirc-set-text-list-ent
 's442
 "[info] Vous n'tes pas sur %s.\n") 
; invite error
(zenirc-set-text-list-ent
 's443
 "[info] %s est dj sur %s.\n") 
; SUMMON reply
(zenirc-set-text-list-ent
 's444
 "[info] %s n'est pas connect.\n")	
(zenirc-set-text-list-ent ; disabled summon
 's445
 "[info] Un quelconque crtin vous refuse l'usage de /summon.\n")
(zenirc-set-text-list-ent 
 's446 ; disabld users
 "[info] Un quelconque crtin vous refuse l'usage de /users.\n") 
; gotta do the USER NICK thing
(zenirc-set-text-list-ent
 's451
 "[info] Vous n'tes pas encore enregistr.\n") 
; as 421
(zenirc-set-text-list-ent
 's461
 "[info] Paramtres insuffisants: %s\n")
(zenirc-set-text-list-ent ; cannot USER twice
 's462
 "[info] Vous ne pouvez pas vous enregistrer  nouveau.\n") 
(zenirc-set-text-list-ent ; server refuses this client
 's463
 "[info] Un quelconque crtin fasciste vous empche de vous connecter.\n")
; bad PASS command
(zenirc-set-text-list-ent
 's464
 "[info] Le mot de passe ne semble pas valable.\n") 
(zenirc-set-text-list-ent 
 's465 ; creep
 "[info] Vous n'tes pas autoris  utiliser ce serveur.\n") 
; chan key set already
(zenirc-set-text-list-ent
 's467
 "[info] Il y a dj une cl sur %s.\n") 
(zenirc-set-text-list-ent
 's471
 "[info] Impossible de rentrer sur %s (limite atteinte).\n")
					; too many ppl
(zenirc-set-text-list-ent
 's472
 "[info] Mode %s inconnu.\n") ; duh
(zenirc-set-text-list-ent
 's473
 "[info] Impossible de rentrer sur %s (sur invitation).\n")
					; fascist nerds
(zenirc-set-text-list-ent
 's474
 "[info] Impossible de rentrer sur %s (interdit d'acces).\n")
					; you're banned
(zenirc-set-text-list-ent
 's475
 "[info] Impossible de rentrer sur %s (cl invalide).\n") ; bad key
(zenirc-set-text-list-ent
 's481
 "[info] Vous n'tes pas encore assez crtin pour cela.\n") ; oper only
(zenirc-set-text-list-ent
 's482
 "[info] Vous n'tes pas assez puissant sur %s.\n") ; chanop needed
(zenirc-set-text-list-ent
 's483
 "[info] Hep! Vous ne pouvez pas tuer un serveur.\n")
					; can't kill a server
(zenirc-set-text-list-ent
 's491
 "[info] Pas de crtins connus sur votre site.\n") ; no o-line
(zenirc-set-text-list-ent
 's501
 "[info] Mode utilisateur inconnu.\n") ; you did something silly
(zenirc-set-text-list-ent
 's502
 "[info] Vous ne pouvez pas changer le mode de quelqu'un d'autre.\n")
					; as above
(zenirc-set-text-list-ent
 'ctcp_action
 "[ACTION->%s] %s %s\n") ; ctcp ACTION display
(zenirc-set-text-list-ent
 'ctcp_clientinfo
 "[interrogation] CLIENTINFO de %s sur %s.\n") ; ctcp CLIENTINFO inform
(zenirc-set-text-list-ent
 'ctcp_errmsg
 "[interrogation] ERRMSG de %s sur %s.\n") ; ctcp ERRMSG inform
(zenirc-set-text-list-ent
 'ctcp_finger
 "[interrogation] FINGER de %s sur %s.\n") ; ctcp FINGER inform
(zenirc-set-text-list-ent
 'ctcp_ping
 "[interrogation] PING de %s sur %s.\n") ; ctcp PING inform
(zenirc-set-text-list-ent
 'ctcp_source
 "[interrogation] SOURCE de %s sur %s.\n") ; ctcp SOURCE inform
(zenirc-set-text-list-ent
 'ctcp_time
 "[interrogation] TIME de %s sur %s.\n") ; ctcp TIME inform
(zenirc-set-text-list-ent
 'ctcp_userinfo
 "[interrogation] USERINFO de %s sur %s.\n") ; ctcp USERINFO inform
(zenirc-set-text-list-ent
 'ctcp_version
 "[interrogation] VERSION de %s sur %s.\n") ; ctcp VERSION inform
(zenirc-set-text-list-ent
 'debug 
 "[debug] %s\n")       ; displayed by debugging code
(zenirc-set-text-list-ent
 'error
 "[%s] %s\n")           ; server error message
(zenirc-set-text-list-ent
 'invite
 "[info] %s vous invite  perdre du temps sur %s.\n") ; invite
(zenirc-set-text-list-ent
 'kick
 "[info] %s a t ject de %s par %s.\n") ; someone was peeved
(zenirc-set-text-list-ent
 'kick_you
 "[info] Vous avez t ject de %s par %s.\n") ; loser
(zenirc-set-text-list-ent
 'kill
 "[info] Vous avez t tu: %s.") ; your time is up.
(zenirc-set-text-list-ent
 'mode
 "[info] %s a chang le mode sur %s: %s.\n") ; MODE change
(zenirc-set-text-list-ent
 'nick
 "[info] %s a chang de pseudo pour %s.\n") ; nick change
(zenirc-set-text-list-ent
 'nosend
 "[info] Pas de victime pour ce message.\n") ; msg not sent
(zenirc-set-text-list-ent
 'notice
 "{%s%s} %s\n")        ; NOTICE
(zenirc-set-text-list-ent
 'notice_you
 "{%s} %s\n")      ; NOTICE sent to your nick
(zenirc-set-text-list-ent
 'now-querying
 "[info] Victime: %s.\n") ; /query foo 
(zenirc-set-text-list-ent
 'part_you
 "[info] Dpart de: %s.\n") ; your part from channel message
(zenirc-set-text-list-ent
 'part
 "[info] %s quitte %s.\n") ;part from channel message
(zenirc-set-text-list-ent
 'privmsg
 "<%s%s> %s\n")       ; PRIVMSG
(zenirc-set-text-list-ent
 'privmsg_you
 "*%s* %s\n")     ; PRIVMSG sent to your nick
(zenirc-set-text-list-ent
 'query
 "[interrogation] de %s sur %s, contenu %s.\n") ; ctcp query
(zenirc-set-text-list-ent
 'query_unknown
 "commande CTCP inconnue.") ; we don't grok this
(zenirc-set-text-list-ent
 'query_unbalanced 	; someone is being lame
 "[mauvaise interrogation] de %s vers %s, contenu %s.\n")
(zenirc-set-text-list-ent
 'query_unbalanced_reply
 "mauvaise rponse CTCP.") ; odd number of ^A's
(zenirc-set-text-list-ent
 'quit
 "[info] %s arrte de perdre du temps: %s\n") ; user signoff
(zenirc-set-text-list-ent
 'reply
 "[reponse] de %s sur %s, contenu %s.\n") ; ctcp reply
(zenirc-set-text-list-ent
 'reply_unbalanced
 "[mauvaise rponse] de %s sur %s, contenu %s.\n") ;weird
(zenirc-set-text-list-ent
 'send
 "(envoy sur %s)\n")       ; you sent a message/notice
(zenirc-set-text-list-ent
 'server
 "[serveur] %s\n")      ; unknown server message
(zenirc-set-text-list-ent
 'signal
 "[signal dans %s]")     ; signal in echo area
(zenirc-set-text-list-ent
 'topic
 "[info] %s a chang le sujet sur %s pour: %s\n") ; topic message
(zenirc-set-text-list-ent
 'wallops
 "-%s- %s\n")	; WALLOPS notice
;;; fin de fichier
