;;;
;;;
;;; zenirc-latin-mode.el 
;;; Latin language interface for Zen Internet Relay Chat client
;;;
;;; Copyright (C) 1993, 1994 Ben A. Mesander
;;;
;;; Author: Richard Todd (rmtodd@servalan.servalan.com)
;;; Maintainer: ben@gnu.ai.mit.edu
;;; Keywords: extensions
;;; Created: 1994/02/28
;;;
;;; This program is free software; you can redistribute it and/or modify
;;; it under the terms of the GNU General Public License as published by
;;; the Free Software Foundation; either version 2, or (at your option)
;;; any later version.
;;;
;;; This program is distributed in the hope that it will be useful,
;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;; GNU General Public License for more details.
;;;
;;; You should have received a copy of the GNU General Public License
;;; along with this program; if not, you can either send email to this
;;; program's maintainer or write to: The Free Software Foundation,
;;; Inc.; 675 Massachusetts Avenue; Cambridge, MA 02139, USA.
;;;
;;; Commentary:
;;; "i like latin-mode, it's like operating a trojan horse or something."
;;;   --- Dave Archer (dmarcher@acsu.buffalo.edu)
;;; "with zenirc-latin-mode, a netsplit reminds me of the part in carmina
;;;  burana where everyone's drinking." --- Dave Archer
;;; "god, i love the latin mode.. makes me feel like caligula" --- James Price
;;;
;;;
;;; Code:

; your channel join message
(zenirc-set-text-list-ent
 'join_you
 "[info] Apud %s iniis.\n") 
; channel join message
(zenirc-set-text-list-ent
 'join
 "[info] %s apud %s iniit.\n") 
; welcome to irc message
(zenirc-set-text-list-ent
 's001
 "[info] Tempus tuum perdis.\n") 
; server name & version # msg
(zenirc-set-text-list-ent
 's002 
 "[info] Servum IRC tuum %s (%s) est.\n")
; when the server was built
(zenirc-set-text-list-ent
 's003
 "[info] Diem %s servum factum est.\n") 
; 211 response
(zenirc-set-text-list-ent
 's211
 "[info] %s connectio %s momentibus erat.\nMissi : %s/%s, Recepti: %s/%s, Mittendi: %s\n")
; 212 response
(zenirc-set-text-list-ent
 's212
 "[info] %s\t->\ttempus: %s\tbytes: %s\n") ; Command stats
; 215 response
(zenirc-set-text-list-ent
 's215
 "[info] I machina/nomen:\t%s/%s\n") ; I-lines
; 216 response
(zenirc-set-text-list-ent
 's216
 "[info] K machina/nomen clientis:\t%s/%s\n") ; K-lines
(zenirc-set-text-list-ent
 's219 
 "[info] /stats perfectus est.\n") ; End of /stats I guess
(zenirc-set-text-list-ent
 's221
 "[info] Tuus modus  %s nunc est.\n") ; user mode
(zenirc-set-text-list-ent
 's241
 "[info] LEAF hostmask/altitudo:\t\t%s/%s\n") ; L-lines
(zenirc-set-text-list-ent
 's243
 "[info] O cognomen/login@machina:\t%s/%s\n") ; O-lines
(zenirc-set-text-list-ent
 's244
 "[info] HUB  hostmask/nomen servi:\t%s/%s\n") ; H-lines
; # users on connect message
(zenirc-set-text-list-ent 
 's251 
 "[info] %s clientes visibiles et %s clientes invisibles apud %s serva sunt.\n")
; irc operators msg
(zenirc-set-text-list-ent
 's252 
 "[info] %s nothi pravi adsunt.\n") 
;; unk connects msg
(zenirc-set-text-list-ent
 's253 
 "[info] %s conjunctiones incognitae sunt.\n") 
; number of channels
(zenirc-set-text-list-ent 's254 "[info] %s fora sunt.\n") 
; # of clients and servers
(zenirc-set-text-list-ent 
 's255 			
 "[info] %s clientes et %s serva huic servo loquiuntur.\n")
(zenirc-set-text-list-ent
 's256
 "[info] Descriptio procurationis %s:\n") ; admin info
; someone is away
(zenirc-set-text-list-ent
 's301
 "[info] %s abest: %s\n") 
; userhost reply
(zenirc-set-text-list-ent
 's302
 "[info] identificatio: %s.\n") 
; ison reply
(zenirc-set-text-list-ent
 's303
 "[info] Tempus perdit nunc: %s\n")
(zenirc-set-text-list-ent
 's305
 "[info] Nuntio te non abesse.\n")
(zenirc-set-text-list-ent
 's306
 "[info] Nuntio te abesse.\n")
; user part of /whois list
(zenirc-set-text-list-ent
 's311
 "[info] %s (%s@%s) %s est.\n") 
; server part of /whois list
(zenirc-set-text-list-ent
 's312
 "[info] %s apud servum %s (%s)\n") 
; /whois operator status
(zenirc-set-text-list-ent
 's313
 "[info] %s nothus pravus est.\n") 
; user part of /whowas list
(zenirc-set-text-list-ent
 's314
 "[info] %s (%s@%s)  %s erat.\n") 
; end of /who list replies
(zenirc-set-text-list-ent
 's315
 "[info] /who perfectus est.\n") 
; end of /whois list replies
(zenirc-set-text-list-ent
 's318
 "[info] /whois perfectus est.\n") 
; /whois idle time
(zenirc-set-text-list-ent
 's317 
 "[info] %s per %d momenta quietus erat.\n") 
; channel part of whois data
(zenirc-set-text-list-ent 
 's319
 "[info] %s adest in: %s\n") 
; header for LIST cmd
(zenirc-set-text-list-ent
 's321
 "[info] Forum\tQuot Clientes?\tRes\n") 
; each channel in LIST cmd
(zenirc-set-text-list-ent
 's322
 "[info] %s\t%s\t%s\n")	
; trailer for LIST cmd 
(zenirc-set-text-list-ent
 's323
 "[info] /list perfectus est.\n") 
; channel mode
(zenirc-set-text-list-ent
 's324
 "[info] Modus %s: %s %s.\n") 
; no topic message
(zenirc-set-text-list-ent
 's331
 "[info] %s nullam rem habet.\n") 
(zenirc-set-text-list-ent
 's332 
 "[info] Res %s : %s\n") ; topic message
; invite reply
(zenirc-set-text-list-ent
 's341
 "[info] %s in %s invitas.\n") 
; summon reply
(zenirc-set-text-list-ent
 's342
 "[info] %s tempus perdere rogas.\n") 
(zenirc-set-text-list-ent
 's351
 "[info] Version: %s %s %s.\n") ; version reply
; header for /who list reply
; Bleah, Latin doesn't really have a good short word for 'nickname', so we'll 
; invent one.  
(zenirc-set-text-list-ent
 's352_header 
 "[info] Cognomen Status Nomen Fori     Login et Machina        Nomen\n") 
;; /who list reply
(zenirc-set-text-list-ent
 's352
 "[info] %-9s %-3s  %-15s %s@%s (%s)\n") 
; displayed after channel join
(zenirc-set-text-list-ent
 's353
 "[info] Homines in %s: %s\n") 
(zenirc-set-text-list-ent
 's364
 "[info] %s %s %s\n")    ; /links reply
; end of /links reply
(zenirc-set-text-list-ent
 's365
 "[info] /links perfectus est.\n") 
; banlist reply
(zenirc-set-text-list-ent
 's367
 "[info] %s interdicit %s.\n")     
; end of banlist reply
(zenirc-set-text-list-ent
 's368
 "[info] Tabula interdictionum perfecta est.\n")
(zenirc-set-text-list-ent
 's371
 "[info] %s\n")          ; info reply
(zenirc-set-text-list-ent
 's372
 "[motd] %s\n")		; message of the day
(zenirc-set-text-list-ent
 's375
 "[motd] Nuntius hodiernus:\n")	; start of motd
; displayed at end of motd
(zenirc-set-text-list-ent
 's376
 "[motd] Nuntius hodiernus perfectus est.\n") 
; irc op status
(zenirc-set-text-list-ent 
 's381
 "[info] Nunc nothus pravus est.\n") 
; rehash server msg
; Yeah, right, like there's a word for 'rehash' in Latin.  
(zenirc-set-text-list-ent
 's382
 "[info] Rehashit: %s\n") 
(zenirc-set-text-list-ent 
 's391
 "[info] Dies apud servum %s: %s.\n")   ; TIME reply
; header for users rpl
(zenirc-set-text-list-ent
 's392 
 "[info] Login Terminal  Machina\n")  
(zenirc-set-text-list-ent
 's393
 "[info] %s\n") ; body of users rpl
; nobody for users rpl
(zenirc-set-text-list-ent
 's395
 "[info] Nemo adest.\n")  
; there is no such nick/chan
(zenirc-set-text-list-ent 
 's401
 "[info] %s nec cognomen nec forum est.\n") 
; there is no such server
(zenirc-set-text-list-ent
 's402
 "[info] Servum %s nescio.\n") 
; there is no such channel
(zenirc-set-text-list-ent
 's403
 "[info] Forum %s nescio.\n")
; you can't send to channel
(zenirc-set-text-list-ent
 's404
 "[info] %s loqui non potes.\n") 
; too many channels
(zenirc-set-text-list-ent
 's405
 "[info] Plura fora quam loqui potes: %s.\n") 
(zenirc-set-text-list-ent ; no whowas data
 's406 
 "[info] %s servum nescit.\n") 
(zenirc-set-text-list-ent 
 's407
 "[info] Receptores duplices; nuntium non misit: %s\n") ; user@host
; no recipient given
(zenirc-set-text-list-ent
 's411
 "[info] Nullus receptor adfuit.\n")
; you didn't send anything.
(zenirc-set-text-list-ent 
 's412
 "[info] Nullus nuntius adfuit.\n") 
; no toplevel domain spec
(zenirc-set-text-list-ent
 's413
 "[info] Nullum regnum supremum adfuit: %s\n")
(zenirc-set-text-list-ent
 's414 ; wild toplevel
 "[info] Regnum vitiosum est: %s.\n") 
(zenirc-set-text-list-ent ; you sent server spam
 's421
 "[info] Stercus est: %s.\n") 
(zenirc-set-text-list-ent 
 's422 			; deprecate operators
 "[info] Quidam nothus pravus imperitus est; nuntium hodiernum non fecit.\n")
(zenirc-set-text-list-ent 
 's423 			; deprecate operators
 "[info] Quidam nothus pravus imperitus est; procurationem non descripsit.\n")
; you didn't provide a nick
(zenirc-set-text-list-ent
 's431
 "[info] Nullus cognomen adfuit.\n") 
; invalid nick
(zenirc-set-text-list-ent
 's432
 "[info] Cognomen vitiosum est: %s.\n") 
; invalid nick
(zenirc-set-text-list-ent
 's433
 "[info] Aliquis cognomen %s iam utebatur.\n") 
(zenirc-set-text-list-ent 
 's436
 "[info] Concursus cognominum: %s.\n") ; nickicide
; can't do it to those not present
(zenirc-set-text-list-ent 
 's441
 "[info] %s in %s non est.\n") 
; you can't do that dave.
(zenirc-set-text-list-ent
 's442
 "[info] In %s non es.\n") 
; invite error
(zenirc-set-text-list-ent
 's443
 "[info] %s iam in %s est.\n") 
; SUMMON reply
(zenirc-set-text-list-ent
 's444
 "[info] %s non conjunctus est.\n")	
(zenirc-set-text-list-ent ; disabled summon
 's445
 "[info] Te /summon uti aliqui nothus pravus non permittit.\n")
(zenirc-set-text-list-ent 
 's446 ; disabld users
 "[info] Te /users uti aliqui nothus pravus non permittit.\n")
; gotta do the USER NICK thing
(zenirc-set-text-list-ent
 's451
 "[info] Nondum perscripsit.\n") 
(zenirc-set-text-list-ent
 's461
 "[info] Parum parameteres: %s\n")
(zenirc-set-text-list-ent ; cannot USER twice
 's462
 "[info] Non perscriptere iterum potes.\n")
(zenirc-set-text-list-ent ; server refuses this client
 's463
 "[info] Te connectere aliqui nothus pravus cerritus non permittit.\n")
; bad PASS command
(zenirc-set-text-list-ent
 's464
 "[info] Tessera vitiosa est.\n") 
(zenirc-set-text-list-ent 
 's465 ; creep
 "[info] Hoc servam uti non tibi licet.\n")
; chan key set already
(zenirc-set-text-list-ent
 's467
 "[info] Tessera huius fori iam adest.\n")
(zenirc-set-text-list-ent
 's471
 "[info] Apud %s inire non potes (plures clientes).\n")
					; too many ppl
(zenirc-set-text-list-ent
 's472
 "[info] Modum %s nescio.\n") ; duh
(zenirc-set-text-list-ent
 's473
 "[info] Apud %s inire non potes (nulla invitatio est).\n")
					; fascist nerds
(zenirc-set-text-list-ent
 's474
 "[info] Apud %s inire non potes. Interdiceris.\n")
					; you're banned
(zenirc-set-text-list-ent
 's475
 "[info] Apud %s inire non potes (tesseram non habes).\n")
(zenirc-set-text-list-ent
 's481
 "[info] Hic solum nothos pravos licet.\n") ; oper only
(zenirc-set-text-list-ent
 's482
 "[info] Censor %s non es.\n")
(zenirc-set-text-list-ent
 's483
 "[info] Eh! Servum caedere non potes!\n")
;					; can't kill a server
(zenirc-set-text-list-ent
 's491
 "[info] Nulli nothi pravi ab tua machina permissi sunt.\n")
(zenirc-set-text-list-ent
 's501
 "[info] Hanc modum nescio.\n") ; you did something silly
(zenirc-set-text-list-ent
 's502
 "[info] Modum alii mutare non potes.\n")
;					; as above
(zenirc-set-text-list-ent
 'ctcp_action
 "[ACTIO->%s] %s %s\n") ; ctcp ACTION display
(zenirc-set-text-list-ent
 'ctcp_clientinfo
 "[quaestio] CLIENTINFO ab %s ad %s.\n") ; ctcp CLIENTINFO inform
(zenirc-set-text-list-ent
 'ctcp_errmsg
 "[quaestio] ERRMSG ab %s ad %s.\n") ; ctcp ERRMSG inform
(zenirc-set-text-list-ent
 'ctcp_finger
 "[quaestio] FINGER ad %s ad %s.\n") ; ctcp FINGER inform
(zenirc-set-text-list-ent
 'ctcp_ping
 "[quaestio] PING ab %s ad %s.\n") ; ctcp PING inform
(zenirc-set-text-list-ent
 'ctcp_ping_reply
 "[reponsum] PING %s %s momentibus abest.\n") ; ctcp PING inform
(zenirc-set-text-list-ent
 'ctcp_source
 "[quaestio] SOURCE ab %s ad %s.\n") ; ctcp SOURCE inform
(zenirc-set-text-list-ent
 'ctcp_time
 "[quaestio] TIME ab %s ad %s.\n") ; ctcp TIME inform
(zenirc-set-text-list-ent
 'ctcp_userinfo
 "[quaestio] USERINFO ab %s ad %s.\n") ; ctcp USERINFO inform
(zenirc-set-text-list-ent
 'ctcp_version
 "[quaestio] VERSION ab %s ad %s.\n") ; ctcp VERSION inform
(zenirc-set-text-list-ent
 'debug 
 "[debug] %s\n")       ; displayed by debugging code
(zenirc-set-text-list-ent
 'error
 "[%s] %s\n")           ; server error message
(zenirc-set-text-list-ent
 'invite
 "[info] %s te apud %s invitat.\n"); invite
(zenirc-set-text-list-ent
 'kick
 "[info] %s de %s ejectum est per %s.\n") ; someone was peeved
(zenirc-set-text-list-ent
 'kick_you
 "[info] De %s ejectum es per %s.\n") ; loser
(zenirc-set-text-list-ent
 'kill
 "[info] Caesus es: %s.") ; your time is up.
(zenirc-set-text-list-ent
 'mode
 "[info] %s modum de %s mutavit: %s\n") ; MODE change
(zenirc-set-text-list-ent
 'nick
 "[info] %s cognomen mutavit ad %s.\n") ; nick change
(zenirc-set-text-list-ent
 'nosend
 "[info] Nulla victima in nuntios habes.\n")
(zenirc-set-text-list-ent
 'notice
 "{%s%s} %s\n")        ; NOTICE
(zenirc-set-text-list-ent
 'notice_you
 "{%s} %s\n")      ; NOTICE sent to your nick
(zenirc-set-text-list-ent
 'notify_list
 "[info] Ei quos exspectas: %s\n")
(zenirc-set-text-list-ent
 'notify_on
 "[info] %s tempus perdere videbam.\n")
(zenirc-set-text-list-ent
 'notify_off
 "[info] %s tempus perdere non iam video.\n")
(zenirc-set-text-list-ent
 'now_querying
 "[info] Victima: %s.\n") ; /query foo 
(zenirc-set-text-list-ent
 'part_you
 "[info] Exis de: %s.\n") ; your part from channel message
(zenirc-set-text-list-ent
 'part
 "[info] %s exiit de %s.\n") ;part from channel message
(zenirc-set-text-list-ent
 'privmsg
 "<%s%s> %s\n")       ; PRIVMSG
(zenirc-set-text-list-ent
 'privmsg_you
 "*%s* %s\n")     ; PRIVMSG sent to your nick
(zenirc-set-text-list-ent
 'query
 "[quaestio] ab %s ad %s, res %s.\n") ; ctcp query
(zenirc-set-text-list-ent
 'query_unknown
 "Mandatum CTCP ignotum.") ; we don't grok this
(zenirc-set-text-list-ent
 'query_unbalanced 	; someone is being lame
 "[mala quaestio] ab %s ad %s, res %s.\n")
(zenirc-set-text-list-ent
 'query_unbalanced_reply
 "Malum reponsum CTCP.") ; odd number of ^A's
(zenirc-set-text-list-ent
 'quit
 "[info] %s tempus perdere intermisit: %s\n") ; user signoff
(zenirc-set-text-list-ent
 'reply
 "[reponsum] ab %s ad %s, res %s.\n") ; ctcp reply
(zenirc-set-text-list-ent
 'reply_unbalanced
 "[malum reponsum] ab %s ad %s, res %s.\n") ;weird
(zenirc-set-text-list-ent
 'send
 "(ad %s missus est)\n")       ; you sent a message/notice
(zenirc-set-text-list-ent
 'server
 "[servum] %s\n")      ; unknown server message
(zenirc-set-text-list-ent
 'signal
 "[signum in %s]")     ; signal in echo area
(zenirc-set-text-list-ent
 'topic
 "[info] %s res %s mutavit: %s\n") ; topic message
(zenirc-set-text-list-ent
 'wallops
 "-%s- %s\n")	; WALLOPS notice
;;;; 
