/*
 * Copyright(c) 1997-2000 - All Rights Reserved
 *
 * See the COPYRIGHT file.
 */

#ifndef _term_h_
# define _term_h_

#ifndef SUNOS_5
# if defined(HAVE_TERMCAP_H)
#  include <termcap.h>
# else
#  include <term.h>
# endif /* HAVE_TERMCAP_H */
#else
extern	int	tgetent(char *, char *);
extern	int	tgetnum(char [2]);
extern	char *	tgetstr(char [2], char **);
extern	char *	tgoto(char *, int, int);

extern	int	tputs(char *, int, int (*)(int));
#endif

extern	char	*CM,
		*DO,
		*CE,
		*CL,
		*SO,
		*SE,
		*US,
		*UE,
		*MD,
		*ME,
		*BL;
extern	int	CO,
		LI;

/* real functions */
void		term_init();
void		term_reinit();
int		term_size();
void		term_end();
void		term_putchar(unsigned int);
int		term_puts(char *, int);
int		term_putes(char *, int, u_char *, u_int);
void		term_flush();
int		term_scroll(int, int, int);
void		term_status(char *, int);
void		term_input(char *, int);

/* MACROs */
#define sic_tputs(s)		(tputs(s, 0, PUTS_ARG_TYPE putchar))

#define term_clear()		(sic_tputs(CL))
#define term_clreol()		(sic_tputs(CE));
#define term_move_cursor(c, r)	(sic_tputs(tgoto(CM, (c), (r))))
#define term_beep()		(sic_tputs(BL), fflush(stdout))
#define term_underline_on()	(sic_tputs(US))
#define term_underline_off()	(sic_tputs(UE))
#define term_standout_on()	(sic_tputs(SO))
#define term_standout_off()	(sic_tputs(SE))
#define	term_bold_on()		(sic_tputs(MD))
#define	term_bold_off()		(sic_tputs(ME))

#define TERM_UNDERLINE	0x01
#define	TERM_STANDOUT	0x02
#define	TERM_BOLD	0x04
#define	TERM_HIDE	0x08

#define	TERM_CLIENT	(TERM_UNDERLINE|TERM_STANDOUT|TERM_BOLD)

#define TERM_EUNDERLINE	0x10
#define	TERM_ESTANDOUT	0x20
#define	TERM_EBOLD	0x40
#define	TERM_EHIDE	0x80

#define	TERM_ECLIENT	(TERM_EUNDERLINE|TERM_ESTANDOUT|TERM_EBOLD)


#endif
