/*
 * buftvtots - pull a Unix-format (struct timeval) time stamp out of
 *	       an octet stream and convert it to a l_fp time stamp.
 *	       This is useful when using the clock line discipline.
 */
#include <sys/types.h>
#include <sys/time.h>

#include "ntp_fp.h"
#include "ntp_unixtime.h"

/*
 * Conversion tables
 */
extern u_long ustotslo[];
extern u_long ustotsmid[];
extern u_long ustotshi[];

int
buftvtots(bufp, ts)
	char *bufp;
	l_fp *ts;
{
	register u_char *bp;
	register u_long sec;
	register u_long usec;

	bp = (u_char *)bufp;

	sec = (u_long)*bp++ & 0xff;
	sec <<= 8;
	sec += (u_long)*bp++ & 0xff;
	sec <<= 8;
	sec += (u_long)*bp++ & 0xff;
	sec <<= 8;
	sec += (u_long)*bp++ & 0xff;

	usec = (u_long)*bp++ & 0xff;
	usec <<= 8;
	usec += (u_long)*bp++ & 0xff;
	usec <<= 8;
	usec += (u_long)*bp++ & 0xff;
	usec <<= 8;
	usec += (u_long)*bp & 0xff;

	if (usec > 999999)
		return 0;

	ts->l_ui = sec + (u_long)JAN_1970;
	TVUTOTSF(usec, ts->l_uf);
	return 1;
}
