# NTP_CACHEVERSION(component, version)
# ------------------------------------
# compare this configure script's cache version stamp with the stamp
# saved by the prior run in config.cache.  If they differ, clear all
# cache variables to avoid using results cached with a script that
# is known to differ in a cache-invalidating manner.
#
# Note: use immediately following AC_INIT in configure.ac, as clearing
# all _cv_ variables only makes sense immediately after loading, before
# use or modification.
#
# It is assumed that parent configure.ac files which use
# AC_CONFIG_SUBDIR to invoke child configure.ac files have used 
# NTP_CACHEVERSION if any children do.  The top-level configure script
# will clear a previous cache lacking any saved cache version number,
# while children do not.  The reason is the children can rely on the
# parent having cleared any cache variables predating this mechanism.
# Therefore the child can rely on the config.cache generated by the
# parent on the first run despite not finding its version stamp
# previously saved.

AC_DEFUN_ONCE([NTP_CACHEVERSION], [
    AC_BEFORE([$0], [AM_INIT_AUTOMAKE])dnl
    AC_BEFORE([$0], [AM_CONFIG_HEADER])dnl
    AC_BEFORE([$0], [AC_PROG_CC])dnl

    ntp_cache_flush=1
    case "$ntp_cv_[$1]_cache_version" in
     [$2])
	# same version, good
	ntp_cache_flush=0
	;;
     '')
	# No cache, predates ntp_cv_$1_cache_version, or is empty.
	case "$cache_file" in
	 ../*)
	    # Parent configure will have cleared cache once already.
	    # This will misfire if a top-level configure is invoked
	    # with --config-cache= value beginning with '../', is
	    # there a better way to detect this configure was
	    # invoked by a parent directory configure?
	    ntp_cache_flush=0
	    ;;
	 /dev/null)
	    ntp_cache_flush=0
	esac
	;;
     *)
	# configure cache version mismatches config.cache version
    esac
    case "$ntp_cache_flush" in
     1)
	# Clear all *_cv_* variables except our various components' 
	# ntp_cv_*_cache_version vars.
	
	c_varname_list=`set |
			sed 's/=.*$//' |
			grep -F _cv_ | 
			grep -v 'ntp_cv_.*_cache_version'
		       `
	for c_varname in $c_varname_list
	do
	    dnl use AS_UNSET([$c_varname]) eventually
	    eval ${c_varname}=; 
	    $as_unset $c_varname
	done
	
	dnl use AS_UNSET([c_varname_list c_varname]) eventually
	c_varname_list=; $as_unset c_varname_list c_varname
	
	AC_MSG_NOTICE([$cache_file saved by another version, ignored.])
	AC_MSG_NOTICE([configure script cache version: [$2]])
	c_version="${ntp_cv_[$1]_cache_version:-(no version found)}"
	AC_MSG_NOTICE([$cache_file version: $c_version])
	$as_unset c_version
    esac

    # save configure version in config.cache for next time
    ntp_cv_[$1]_cache_version="[$2]"

    $as_unset ntp_cache_flush
])dnl
