#include<iostream.h>
#include"primitives.h"
#ifndef NULL
#define NULL ((void *)0)
#endif

// This class definition contains information regarding the
// defined broadcast tables.
// This portion contains all the relevant information:
// the destination node, and the element whose value is going to change
// and what to change the value to.
class list_values{
private:
  list_values *next;
  list_values *prev;
// EXTRA BITS FOR TRACKING USE
	short whichelement;
	short whichvalue;
	short forwhichnode;
public:
  list_values(short a,short x, short y):
    next(NULL),
    prev(NULL),
    forwhichnode(a),
    whichelement(x),
    whichvalue(y)
    {
    }

  inline list_values *get_next()
    {
      return next;
    }
  inline void set_next(list_values *n)
    {
      next=n;
    }
  list_values *get_prev()
    {
      return prev;
    }
  short getforwhichnode()
	{
	return forwhichnode;
	}
  
  inline short getelement()
	{
	return whichelement;
	}
  inline short getvalue()
	{
	return whichvalue;
	}
  void set_prev(list_values *n)
    {
      prev=n;
    }
  void insert_after(list_values *n)
    {
      list_values *after=next;
      n->next=after;
      next=n;
      n->prev=this;
      if (after!=NULL){
	after->prev=n;
      }
    }
  ~list_values()
    {
	/*
	cout<<"deleting elements/list3"<<endl;
	delete next;
	delete prev; 
	cout<<"done list3"<<endl;*/
    }
  list_values* remove1(list_values *n)
    {
     (n->prev)->set_next(n->next);
     (n->next)->set_prev(n->prev);
     delete n;
    } 
};

class list3 {
private:
  list_values *head, *tail;
public:
  list3() :
    head(NULL),
    tail(NULL)
    {
    }
  list_values* remove(list_values *n)
    {
      if (head==NULL) 
		{
		delete n;
		return(NULL);}
      else if (n==head)
	{
	 if (n->get_next()==NULL)
		{
		head=NULL;	
		delete n;
		return(NULL);
		}
	 else{
	 make_head(n->get_next());
	 delete n;}

	}
	else if (n==tail)
		{
		if (n->get_prev()==NULL)
			{
			head=NULL;
			tail=NULL;
			return(NULL);
			}
		else
			make_tail(n->get_prev());
		}
      else 
	{
		n->remove1(n);	
	}
    }
  list_values* next(list_values *n)
    {
      return n->get_next();
    }
  void prepend(list_values *n) 
    {
      n->insert_after(head);
      n->set_prev(NULL);
      head=n;
    }
  void append(list_values *n){
    if (head==NULL){
      head=tail=n; }
    else {
      insert_after(n,tail);
    }
  }
  void insert_after (list_values *n, list_values *p)
    {
      p->insert_after(n);
      if (n->get_next()==NULL){
	tail=n;
      }
    }
  list_values* first()
    {
      return head;
    }
  list_values* last()
    {
      return tail;
    }

  void make_head(list_values *node) {
    head = node;
    node->set_prev(NULL);
  }
 void make_tail(list_values *node) {
	tail=node;
	node->set_next(NULL);
	}

};
