/*********************************************************/
#include	<std.h>
#include	<rt11.h>
#include	<mmmhdr.h>

/*********************************************************/
/***** external functions from genlib */
int	putdec(),getdec();

/*********************************************************/
/***** external functions from supprt */
int	link(),initnode();
int	inirtrav(),iniptrav();
TREEPTR	rtrav(),ptrav(),getnode();
FILE	getifile(),getofile();

/*********************************************************/
/****** external functions from getmmm */

/*********************************************************/
/****** external functions from putmmm */
int	segment();

/*********************************************************/
/****** external functions from diolib */
int	dread(),dwrite(),dlseek();	
FILE	dopen(),dclose();

/*********************************************************/
/****** external functions from vcgdrv */
int	paint(),drwcur(),mover(),enbp(),encur(),revers();

/*********************************************************/
/****** entry points */
int	reinit(),revcol(),curup(),curdown(),curright(),curleft();
int	getpic(),plane(),defseg();
int	lclip(),rclip(),tclip(),bclip();
int	moveseg(),paste(),select(),nscale(),istore(),iread(),prtimg();


/*********************************************************/
/* this is the image editor. */

#define ALLPLANE  7	/* mask to select all 3 planes */ 
int	lcurx = 0 ;	/* logical cursor x pos  */
int	lcury = 0 ;	/* logical cursor y pos  */
int	curx = 0 ;	/* physical cursor x pos */
int	cury = 0 ;	/* physical cursor y pos */
int	curdis = 5 ;	/* cursor jump size      */
int	cursiz = 5 ;	/* cursor size           */
int	curplane = 1;   /* current plane(s) on display  */
int	actplane = 1;   /* active working plane(s)  */
int	dismode	=0;	/* color mode 0=>B on W, 1=>W on B */
int	selflag = 0;	/* selflag=1 => autoselect */

/* external globals */
TEXT	linbuf[];
TEXT	filenam[];
TEXT	opnerr[] ;
FILE	fd ;
TREEPTR	top,mtop,delnode ;
int	dumpflag;

TREEPTR	present = NULL;
TREEPTR	newnode = NULL;

/* 1 ********************************************************/
/* reinitialize image page */
reinit()
{
freenodes(top);			/* free all node */
top = NULL;
present = NULL;
setup();
}

/***************************************************/
/* sets up display parameters */
setup()
{
initbm();			/* check if display is initialized */
curplane=1;
actplane=1;
selflag = 0;
dismode = 1;			/* black on white mode */
enbp(dismode,curplane);		/* enable curplane */
encur(actplane);		/* enable cursor */
clear(ALLPLANE,0,0,DISXMAX,DISYMAX);	/*  clear all planes */
curx=cury=lcurx=lcury=0;
drwcur(curx,cury,cursiz);
}

/*********************************************************/
/* displays image in substructure top */
dispimg(top)
TREEPTR	top;
{
setup();			/* initialize display */
drwcur(curx,cury,cursiz);	/* remove cursor */
repain(0,top,0,0,DISXMAX,DISYMAX);	/* paint entire surface */
hilite(top);
present=top;
}


/* 2 ********************************************************/
/* reverse display mode */
revcol()
{
revers();		/* command to display hardware to reverse mode*/
dismode ^= 1;
}

/* 3 ********************************************************/
/* moves cursor up. Scrolls display if necessary */
curup()
{
curmov(0,-curdis);
}

/* 4 ********************************************************/
/* moves cursor down. Scrolls display if necessary */
curdown()
{
curmov(0,curdis);
}

/* 5 ********************************************************/
/* moves cursor right. Scrolls display if necessary */
curright()
{
curmov(curdis,0);
}

/* 6 ********************************************************/
/* moves cursor left. Scrolls display if necessary */
curleft()
{
curmov(-curdis,0);
}

/* 7 ********************************************************/
/* gets input bitmap file parameters */
inbmfile(node)
FAST	TREEPTR	node;

{
node->dataflag=1;		/* node has data */
cpystr(node->filnam,filenam,NULL);	/* copy file name */

dread(fd,&node->xsiz,2);	/* read x and y size of bitmap */
dread(fd,&node->ysiz,2);
dclose(fd);
putstr(STDOUT,"x size = ",NULL);/* display the values */
putdec(node->xsiz,"\n");
putstr(STDOUT,"y size = ",NULL);
putdec(node->ysiz,"\n");

}

/**********************************************************/
/* fills current segment with bitmap specified by user */
/* scales image to fit in the segment */

fit()
{
FAST	TREEPTR	node;
TEXTPTR	s;

node=wchnode();
if ( (fd = getifile(filenam,"BIT") ) < 0) return;	/* get in file */
inbmfile(node);			/* get bitmap parameters */
inpres(node);			/* get bitmap resolution from user */
node->startx=0;			/* entire image will be painted */
node->starty=0;

s = getstr("fit x,y,both? ",linbuf);
dehilite(node);

if (*s == 'X') {		/* fit X; adjust Y size on screen */
	node->magy = node->magx = node->scrxsiz;
	node->magybas = node->magxbas = node->xsiz;
	node->scrysiz=muldiv(node->ysiz,node->magy,node->magybas);
	}
else if (*s == 'Y' ) {		/* fit Y; adjust X size on screen */

	node->magy = node->magx = node->scrysiz;
	node->magybas = node->magxbas = node->ysiz;
	node->scrxsiz=muldiv(node->xsiz,node->magx,node->magxbas);
	}
else {				/* fit X and Y */
	node->magx = node->scrxsiz;
	node->magxbas = node->xsiz;
	node->magy = node->scrysiz;
	node->magybas = node->ysiz;
	}

magfactor(node);		/* reduce mag factors */
node->segxsiz=sizmap(node->scrxsiz,SCRXRES,SCRXMM,node->resx,node->resxmm);
node->segysiz=sizmap(node->scrysiz,SCRYRES,SCRYMM,node->resy,node->resymm);

repain(1,node,node->scrxpos,node->scrypos,node->scrxsiz,node->scrysiz);
hilite(node);
}


/* 7 ********************************************************/
/* gets input bitmap and attach it to struct. as child of
present node */

getpic()

{
FAST	TREEPTR	node;

if ( !(newnode = node = getnode() ) ) return;	/* allocate new node */
initnode(node);	
if ( (fd = getifile(filenam,"BIT") ) < 0) return; /* get bitmap file */
inbmfile(node);				/* get bitmap parameters */
inpres(node);				/* ask user for resolution info */
inpsiz(node);				/* ask user for size info */
if (node->segxsiz > node->xsiz) node->segxsiz = node->xsiz ;  /* clip size */
if (node->segysiz > node->ysiz) node->segysiz = node->ysiz ;
gtscrsiz(node);				/* convert size to screen res. */

setnewnode(node);			/* attach node and display */
}

/* 9 ********************************************************/
/* defines new segment containing no data. attaches it to struct.
as child of present node */

defseg()

{
if ( !(newnode = getnode()) ) return;	/* alloc. new node */
initnode(newnode);
inpres(newnode);			/* ask user for res. info */
inpsiz(newnode);			/* ask user for size info */
setnewnode(newnode);			/* attach node and display */

}	/* of defseg */

/**********************************************************/
/* gets resolution info from user */

inpres(node)
FAST	TREEPTR	node;

{
FAST	TEXTPTR	s;

s = getstr("xres:",linbuf);		/* ask for X res. */
if  ( *s == 'V' ) {			/* VCG (Peritek) res. */
	node->resx = SCRXRES;
	node->resxmm = SCRXMM;
	}
else if ( *s ) {			/* get user specified res.*/
	s += btoi(s,10,&node->resx,10);
	btoi(s,10,&node->resxmm,10);
	}				/*default is fax res. */
	
s = getstr("yres:",linbuf);		/* ask for Y res. */
if  ( *s == 'V' ) {			/* VCG (Peritek) res. */
	node->resy = SCRYRES;
	node->resymm = SCRYMM;
	}
else if ( *s ) {			/* get user specified res. */
	s += btoi(s,10,&node->resy,10);
	btoi(s,10,&node->resymm,10);
	}				/* default is fax res. */

getmag(node);				/* figure out mag. factor */
}

/**********************************************************/
/* gets size of picture to be painted from user */
/* defaults to full size of input image */

inpsiz(node)
FAST	TREEPTR	node;

{
if ( !( node->segxsiz=getdec("xsiz:") ) ) node->segxsiz=node->xsiz;
if ( !( node->segysiz=getdec("ysiz:") ) ) node->segysiz=node->ysiz;
gtscrsiz(node);
}


/**********************************************************/
/* processes new image. links it to structure and displays it */
setnewnode(node)
FAST	TREEPTR	node;

{
node->scrxpos=lcurx;		/* note screen position */
node->scrypos=lcury;

drwcur(curx,cury,cursiz);	/* erase cursor */
if (actplane == 1){		/* if image plane, then */
	border(present);	/* erase borders */
	link(present,node);	/* link */
	present=node;
	newnode=NULL;
	}

/* paint image on screen and other images that overlap it */
repain(1,node,node->scrxpos,node->scrypos,node->scrxsiz,node->scrysiz);

hilite(node);

}

/*  ********************************************************/
/* converts segment size in native res. to size in screen res. */
gtscrsiz(node)
FAST	TREEPTR	node;
{
node->scrxsiz=sizmap(node->segxsiz,node->resx,node->resxmm,SCRXRES,SCRXMM);
node->scrysiz=sizmap(node->segysiz,node->resy,node->resymm,SCRYRES,SCRYMM);
}

/****************************************************************/
/* calculates mag. factors needed to map image from native res. to
screen res. */
getmag(node)
FAST	TREEPTR	node;
{
node->magx = SCRXRES*node->resxmm;
node->magxbas = SCRXMM*node->resx;
node->magy = SCRYRES*node->resymm;
node->magybas = SCRYMM*node->resy;
magfactor(node);
}

/* **********************************************************/
/* reduces mag. factors so that all numbers <= 100 */
magfactor(node)
FAST	TREEPTR	node;
{
factor(&node->magx,&node->magxbas);
factor(&node->magy,&node->magybas);
}

/* 8 ********************************************************/
/* select user specified plane(s). Henceforth, all planes
specified are displayed; active plane is last plane in list given
by user */

plane()

{
int	p1;
FAST	TEXT	*s;

s = getstr("which plane(s)?",linbuf);
drwcur(curx,cury,cursiz);
curplane=0;

for (s=s+btoi(s,10,&p1,10); (p1 > 0); s=s+btoi(s,10,&p1,10)){
	actplane=p1;
	curplane |= 1 << (p1-1);
	}
enbp(dismode,curplane);
encur(actplane);
drwcur(curx,cury,cursiz);

}

/* 10 ********************************************************/
/* clip left edge of current image */
lclip()

{
FAST	TREEPTR	node;
int	xpos,deltax,dmax;

node=wchnode();
deltax=node->scrxpos-lcurx;		/* how much to be clipped */
if (-deltax >= node->scrxsiz) return;	/* cant clip more than scrxsiz */
xpos = min(node->scrxpos,lcurx);	/* xpos of clipped rect. */ 
dehilite(node);

if ( node->dataflag ) {			/* if data node */
/* make sure left edge does not go beyond zero */
	dmax = muldiv(node->startx,node->magx,node->magxbas);
	if (deltax > dmax ) { /* dmax is nodes startx mapped to screen res */
		deltax = dmax;		/* stop left edge at 0 */
		xpos = node->scrxpos-dmax;
		}
	node->startx -= muldiv(deltax,node->magxbas,node->magx);
	}
	
node->scrxpos -= deltax;
cliphz(node,xpos,deltax);

}

/* 11 ********************************************************/
/* clips right edge of current node */
rclip()

{
FAST	TREEPTR	node;
int	xpos,deltax,dmax,rhs;

node = wchnode();
rhs = node->scrxpos+node->scrxsiz-1;		/* right edge of image */
deltax = lcurx-rhs;			/* x size to be clipped */
xpos = min(lcurx,rhs) + 1;		/* x pos. of clipped rect. */
if (-deltax >= node->scrxsiz) return;
dehilite(node);
if ( node->dataflag) {			/* stop right edge at max. X */
	dmax = muldiv(node->xsiz-node->startx,node->magx,node->magxbas);
	if (node->scrxsiz+deltax > dmax ) deltax = dmax-node->scrxsiz;
	}
cliphz(node,xpos,deltax);
}

/* 10.1 ********************************************************/
/* processe left or right clipping. Resets x size values
and adjusts display */

cliphz(node,xpos,deltax)
FAST	TREEPTR	node;
int	xpos,deltax;

{
int 	pflag;

/* set X sizes */
node->segxsiz += sizmap(deltax,SCRXRES,SCRXMM,node->resx,node->resxmm);
node->scrxsiz += deltax;

/* erase clipped rect. */
erase(node->upptr,xpos,node->scrypos,abs(deltax),node->scrysiz);
if (deltax > 0 ) pflag = 1;
else	pflag = 0;

/* repaint clipped rectangle only. If new empty rect. 
then paint everything in that area, else paint only current image
and overlapping images */
repain(pflag,node,xpos,node->scrypos,abs(deltax),
	node->scrysiz);

hilite(node);
}


/* 12 ********************************************************/
/* clips top edge of current node */
/* very similar to lclip */
tclip()

{
FAST	TREEPTR	node;
int	ypos,deltay,dmax;

node=wchnode();
deltay = node->scrypos-lcury;
ypos=min(node->scrypos,lcury);
if (-deltay >= node->scrysiz) return;
dehilite(node);
if ( node->dataflag ) {
	dmax = muldiv(node->starty,node->magy,node->magybas);
	if (deltay > dmax ) {
		deltay = dmax;
		node->starty = 0;
		ypos = node->scrypos-dmax;
		}
	else node->starty -= muldiv(deltay,node->magybas,node->magy);
	}
	
node->scrypos -= deltay;
clipvrt(node,ypos,deltay);
}

/* 13 ********************************************************/
/* clips bottom edge of current image. bery similar to rclip */
bclip()

{
FAST	TREEPTR	node;
int	ypos,deltay,dmax,rhs;

node=wchnode();
rhs = node->scrypos+node->scrysiz-1;
deltay = lcury-rhs;
ypos = min(lcury,rhs) + 1;
if (-deltay >= node->scrysiz) return;
if ( node->dataflag) {
	dmax=muldiv(node->ysiz-node->starty,node->magy,node->magybas);
	if (node->scrysiz+deltay > dmax ) deltay = dmax-node->scrysiz;
	}
dehilite(node);
clipvrt(node,ypos,deltay);
}

/* 12.1 ********************************************************/
/* performs vertical clipping. very similar to cliphz */
clipvrt(node,ypos,deltay)
FAST	TREEPTR	node;
int	ypos,deltay;

{
int pflag;

node->scrysiz += deltay;
node->segysiz += sizmap(deltay,SCRYRES,SCRYMM,node->resy,node->resymm);
erase(node->upptr,node->scrxpos,ypos,node->scrxsiz,abs(deltay));

if (deltay > 0)	pflag = 1;
else	pflag = 0;
repain(pflag,node,node->scrxpos,ypos,node->scrxsiz,abs(deltay));
hilite(node);

}

/* 14 ********************************************************/
/* moves current image to place pointed to by cursor */
moveseg()

{
FAST	TREEPTR	node,child;
int	ox,oy,nx,ny,dx,dy,x1,y1,pflag;
TEXTPTR	s;

node = wchnode();
ox=node->scrxpos;		/* remember old position */
oy=node->scrypos;
if ( node->lptr ) {		/* if children */
	s = getstr("want to move whole sub-structure?",linbuf);
	dehilite(node);
	if ( *s == 'Y' ) adjpos(node,lcurx,lcury); /* new pos. for all */
	}
else	dehilite(node);

node->scrxpos=lcurx;		/* new pos. for current node */
node->scrypos=lcury;

if ( allhere(node,ox,oy) ){	/* if everything is here on screen */
	mover(actplane,actplane,mapx(ox),mapy(oy),	/* then move screen*/
	curx,cury,node->scrxsiz,node->scrysiz);		/* area */
	repain(2,node,lcurx,lcury,node->scrxsiz,node->scrysiz);
	}		/* and repaint new area with overlapping images */

else	{ /* erase old area and repaint new area with image and overlappers */

	erase(node,lcurx,lcury,node->scrxsiz,node->scrysiz);
	repain(1,node,lcurx,lcury,node->scrxsiz,node->scrysiz);
	}

/* repaint old area that is not overlapped by new area */
pntrst(node,ox,oy,node->scrxsiz,node->scrysiz,
	lcurx,lcury,node->scrxsiz,node->scrysiz);
hilite(node);
}


/********************************************************/
/* repaints the area in rect (x1,x2,dx1,dx2) that
is not overlapped by the rect. (x2,y2,dx2,dy2).	*/

pntrst(node,x1,y1,dx1,dy1,x2,y2,dx2,dy2)
int x1,y1,dx1,dy1,x2,y2,dx2,dy2;
FAST	TREEPTR	node;
{
/* if no overlap then repaint all of area1 */
if(ovlap(x1,y1,dx1,dy1,x2,y2,dx2,dy2,&x2,&y2,&dx2,&dy2) <= 0 ) {
	erase(node->upptr,x1,y1,dx1,dy1);
	repain(0,top,x1,y1,dx1,dy1);
	}
else {	/* (x2,y2,dx2,dy2) is now the intersection of the two rects. 
	Its complement consists of two rectangles; compute these two
	rects. and repaint their area */

	if(x2==x1) x2=x1+dx2;
	else 	x2=x1;
	erase(node->upptr,x2,y2,dx1-dx2,dy2);
	repain(0,top,x2,y2,dx1-dx2,dy2);

	if(y2==y1) y2=y1+dy2;
	else 	y2=y1;
	erase(node->upptr,x1,y2,dx1,dy1-dy2);
	repain(0,top,x1,y2,dx1,dy1-dy2);
     }
}


/* 15 ********************************************************/
/* get image in workplane (plane 2) and attach it to image */
paste()

{
if(newnode) {		/* newnode is the node in the workplane */
	border(newnode);
	enbp(dismode,(curplane= (actplane=1)));
	encur(1);	/* switch to plane 1 */
	dehilite(present);
	link(present,newnode);
	present=newnode;
	newnode->scrxpos=lcurx;		/* set position */
	newnode->scrypos=lcury;
	repain(1,newnode,newnode->scrxpos,newnode->scrypos,
		newnode->scrxsiz,newnode->scrysiz);
	hilite(present);
	newnode = NULL;
	}
}

/* 16 ********************************************************/
/* allows user to select nodes by relationship to present node */
traverse()
{
FAST	TREEPTR	node;
TEXTPTR	s;

s = getstr("father(F),son(S),right brother(L),left brother(L)?",linbuf);
drwcur(curx,cury,cursiz);
encur(1);
border(present);
node=NULL;
if (*s =='F') node=present->upptr;
else if (*s =='S') node=present->lptr;
else if (*s =='B') node=present->rptr;
else if (*s =='L') node=fndleft(present);
if ( node && (node != mtop) ) present=node;
else putstr(STDOUT,"huh?\n",NULL);
border(present);
encur(actplane);
drwcur(curx,cury,cursiz);

}

/* 17 ********************************************************/
/* scale current image by user specified scale factors */
nscale()
{
FAST	TREEPTR	node;
FAST	TEXT	*s;
int	nx,nxbas,ny,nybas;

node=wchnode();

s = getstr("x mag?",linbuf);
s += btoi(s,10,&nx,10);
s += btoi(s,10,&nxbas,10);

s = getstr("y mag?",linbuf);
s += btoi(s,10,&ny,10);
s += btoi(s,10,&nybas,10);

doscale(node,nx,nxbas,ny,nybas);
}

/* 17 ********************************************************/
/* scales curent image so that right edge matches cursor X */
xscale()
{
FAST	TREEPTR	node;
int	nx,nxbas,ny,nybas;
TEXTPTR	s;

node=wchnode();

/* compute scale factor. assume Y size is to be scaled as well */
nx = ny = (lcurx - node->scrxpos);
nxbas = nybas = node->scrxsiz;

s = getstr("want to scale y as well (Y,N)? ",linbuf);
if (*s == 'N') ny = nybas = 1;
	
doscale(node,nx,nxbas,ny,nybas);
}

/* 17 ********************************************************/
/* similar to xscale for y size */
yscale()
{
FAST	TREEPTR	node;
int	nx,nxbas,ny,nybas;
TEXTPTR	s;

node=wchnode();

nx = ny = (lcury - node->scrypos);
nxbas = nybas = node->scrysiz;

s = getstr("want to scale x as well (Y,N)? ",linbuf);
if (*s == 'N') nx = nxbas = 1;
	
doscale(node,nx,nxbas,ny,nybas);
}

/**********************************************/
/* scales current image by nx/nxbas, ny/nybas */
doscale(node,nx,nxbas,ny,nybas)
FAST TREEPTR	node;
int	nx,nxbas,ny,nybas;
{
FAST TREEPTR child;
int	xsiz,ysiz;
TEXTPTR	s;

if ( (nx <= 0) || (nxbas <= 0) || (ny <= 0) || (nybas <= 0) ) {
	putstr(STDOUT,"huh?\n",NULL);
	return;
	}

if (node->lptr) s = getstr("want to scale whole sub-structure?",linbuf);
else	s = NULL;

dehilite(node);

/* remember old size */
xsiz=node->scrxsiz;
ysiz=node->scrysiz;

factor(&nx,&nxbas);
factor(&ny,&nybas);

/* change mag factor for node */
node->magx *= nx;
node->magxbas *= nxbas;
node->magy *= ny;
node->magybas *= nybas;
magfactor(node);

/* new segment and screen size */
node->segxsiz=muldiv(node->segxsiz,nx,nxbas);
node->segysiz=muldiv(node->segysiz,ny,nybas);
gtscrsiz(node);

if ( s && (*s == 'Y') ) {	/* scale all children */
	iniptrav(node->lptr);
	while( child = ptrav() ){
		child->magx *= nx;
		child->magxbas *= nxbas;
		child->magy *= ny;
		child->magybas *= nybas;
		magfactor(child);
	
		child->scrxpos = node->scrxpos + 
			muldiv(child->scrxpos-node->scrxpos,nx,nxbas);
		child->scrypos = node->scrypos + 
			muldiv(child->scrypos-node->scrypos,ny,nybas);
	
		child->segxsiz=muldiv(child->segxsiz,nx,nxbas);
		child->segysiz=muldiv(child->segysiz,ny,nybas);
		gtscrsiz(child);
		}
	}

/* repaint new area */
repain(1,node,node->scrxpos,node->scrypos,node->scrxsiz,node->scrysiz);

/* repaint old are that does not overlap with newarea */
pntrst(node,node->scrxpos,node->scrypos,xsiz,ysiz,
	node->scrxpos,node->scrypos,node->scrxsiz,node->scrysiz);

hilite(node);

}



/* 18 ********************************************************/
/* store image as MMM body */

istore()
{
if ((fd = getofile(filenam,"TMM")) < 0) return;	/* get output file */
getformat();				/* get format */
storimg(present);
dclose(fd);
}


/* 19 ********************************************************/
/* read MMM from file and attach it to struct. */
iread()

{
FAST	TREEPTR	node;

if ((fd = getifile(filenam,"TMM") ) < 0) return;	/* get input file */
dumpflag = 0;				/* no dump */
dehilite(present);
readmmm(present);
dclose(fd);

repain(1,present,lcurx,lcury,DISXMAX,DISYMAX);
hilite(present);

}

/* 20 ********************************************************/
/* make single fax res. bitmap of current struct. */
prtimg()

{
if ((fd = getofile(filenam,"BIT") ) < 0) return;
puttree(present);
dclose(fd);
}

/*********************************************************/
/* set cursor junp size */
setcur()
{
curdis = getdec("jump size:");
}


/*********************************************************/
/* move cursor by (delx,dely0 */
/* scroll screen if necessary */

curmov(delx,dely)
int	delx,dely;

{
FAST	int	d;

drwcur(curx,cury,cursiz);	/* erase cursor */
d = curx+delx;
if ( d < 0 ) {			/* beyond left edge of screen */
	if (curx == lcurx ) curx = (lcurx = 0);	/* wall at 0 of log. screen */
	else	{
		border(present);	/* scroll right */
		if ( (lcurx += delx) < 0) {
			d -= lcurx;
			lcurx =0;	/* wall at 0 of logical screen */
			}
		curx=0;
		scrlright(-d);
		border(present);
		}
	}
else if (d >= DISXMAX) {	/* scroll if beyond right edge of screen */
	border(present);	/* no wall here */
	curx = DISXMAX-1;
	d -= curx;
	lcurx += delx;
	scrlleft(d);
	border(present);
	}
else	{
	curx = d;
	lcurx += delx;
	}

d = cury+dely;			/* move cursor along Y direction */
if ( d < 0 ) {			/* similar as above */
	if (cury == lcury ) cury = (lcury = 0);
	else	{
		border(present);
		if ( (lcury += dely) < 0 ) {
			d -= lcury;
			lcury=0;
			}
		cury=0;
		scrldown(-d);
		border(present);
		}
	}
else if (d >= DISYMAX) {
	border(present);
	cury = DISYMAX-1;
	d -= cury;
	lcury += dely;
	scrlup(d);
	border(present);
	}
else	{
	cury = d;
	lcury += dely;
	}

/*  selseg(); */

if (selflag ) select();		/* if auto select than select segment */
drwcur(curx,cury,cursiz);
	
}	/* of curmov */


/*********************************************************/
/* finds out if cursor is within segment pointed to by node */
/* returns YES if true otherwise returns NO */

BOOL cinseg(x,y,node)
FAST	TREEPTR	node;
int	x,y;

{
if ( (x < node->scrxpos) || (y < node->scrypos) || 
	(x > (node->scrxpos + node->scrxsiz)) ||
	(y > (node->scrypos + node->scrysiz)) )
return(NO);
return(YES);

}	/* of cinseg */

/*********************************************************/
/* toggles autoselect mode */

autosel()
{
if ( selflag) {
	selflag = 0;
	putstr(STDOUT,"autoselect OFF\n",NULL);
	}
else	{
	selflag = 1;
	putstr(STDOUT,"autoselect ON\n",NULL);
	select();
	}
}

/*********************************************************/
/* selects node pointed to by cursor. If > 1 node satisfy
the conditons the topmost one is selected */

select()
{
FAST	TREEPTR	node;

/* traverse tree in reverse preorder and select
the first one that contains the cursor */
inirtrav(top);
for (node=rtrav(); node && ( !cinseg(lcurx,lcury,node) );
	node=rtrav() );

if (node && ( node != present) ) {
	dehilite(present);
	hilite(present=node);
	}

} /* of selseg */


/*********************************************************/
/* undeletes a substructure ( the last one deleted ) and
attaches it to struct. */
undelete()
{
FAST	TREEPTR	node;

if ( (!delnode) || (delnode->alg < ALGBITMAP) ||
	(delnode->alg > ALGCCITT) ) {
	putstr(STDOUT,"huh\n",NULL);
	return;
	}
node = makcopy(delnode);	/* make copy of deleted struct. */
dehilite(present);
link(present,node);		/* attach it */
present = node;
adjpos(node,lcurx,lcury);	/* set position params. */

repain(1,node,node->scrxpos,node->scrypos,node->scrxsiz,node->scrysiz);
hilite(node);
}

/*********************************************************/
/* deletes current substruct, and holds it in delnode */
delete()

{
if ( !present) return;
if ( delnode) freenodes(delnode);	/* free prviously deleted nodes */
delnode = present;

if ( (present = present->upptr) == mtop) present = NULL;

dehilite(delnode);
erase(delnode,delnode->scrxpos,delnode->scrypos,delnode->scrxsiz,
	delnode->scrysiz);
unlink(delnode);
repain(0,top,delnode->scrxpos,delnode->scrypos,delnode->scrxsiz,
	delnode->scrysiz);
hilite(present);
}



/*********************************************************/
/* repaints rect (x,y,dx,dy) on screen with data from from
node and other segments that overlap it.
If flag = 0, paints area with all segments that qualify
        = 1 paints area with node and segments that overlap it
	= 2 paints only those segments that overlap node. */

repain(flag,thsnode,x,y,dx,dy)
FAST	TREEPTR	thsnode;
int	flag,x,y,dx,dy;

{
FAST 	TREEPTR	node;

/* take each node in preorder in the tree and paint that portion of
it that qualifies to painted in the specified area */

if (actplane == 1) iniptrav(top);
else	iniptrav(thsnode);

for ( node=ptrav(); node && (node != thsnode) ;node = ptrav() )
	if(flag == 0) rpain(node,x,y,dx,dy);

if  ( node ) {
	if( flag <= 1)  rpain(node,x,y,dx,dy);
	while( node=ptrav() ) rpain(node,x,y,dx,dy);
	}

}	/* of repain */


/*********************************************************/
/* paints rect. (x,y,dx,dy) with data from node; figures out what
area of the image qualifies to be painted */

rpain(node,x,y,dx,dy)
FAST	TREEPTR	node;
int	x,y,dx,dy;

{
FAST	TREEPTR	snode;
int	actx,sx,sy;

/* find intersection of area with image and all its ancestors */
for (snode = node; snode && (snode != mtop); snode = snode->upptr)
	if(ovlap(x,y,dx,dy,snode->scrxpos,snode->scrypos,
		snode->scrxsiz,snode->scrysiz,
		&x,&y,&dx,&dy) <= 0 ) return;
 
/* find intersection with current screen window */
if (ovlap(x,y,dx,dy,lcurx-curx,lcury-cury,DISXMAX,DISYMAX,
	&x,&y,&dx,&dy) <= 0) return ;

/* now (x,y,dx,dy) is the window to be painted in the virtual screen */

if (node->dataflag == 0) {	/* empty segment, clear the area */
	clear(actplane,mapx(x),mapy(y),dx,dy);
	return;
	}

if ((fd = dopen(node->filnam,0,1) ) < 0) {	/* open datafile */
	putstr(STDOUT,opnerr,node->filnam,"\n",NULL);
	return;
	}

dlseek(fd,node->filptr,SEEKABS);	/* station at beginning of data */
if (node->alg == ALGMBITMAP) {
	dread(fd,&actx,2);		/* read bitmap size */
	dread(fd,linbuf,2);
	}
else	actx = node->xsiz;

/* compute origin of window in the data bitmap */
sx= node->startx + muldiv( (x-node->scrxpos),node->magxbas,node->magx);
sy= node->starty + muldiv( (y-node->scrypos),node->magybas,node->magy);

paint(fd,actx,actplane,sx,sy,mapx(x),mapy(y),dx,dy,
	node->magx,node->magy,node->magxbas,node->magybas);

dclose(fd);
}	/* of rpain */


/************************************************************/
/* puts structure at thsnode into one bitmap of fax res. */
puttree(thsnode)
FAST	TREEPTR	thsnode;

{
FAST 	TREEPTR	node;
long	savebgn,getpos(),savend;
int ox,oy;

/* compute size of output bitmap */
ox = sizmap(thsnode->scrxsiz,SCRXRES,SCRXMM,DEFXRES,DEFXMM);
oy = sizmap(thsnode->scrysiz,SCRYRES,SCRYMM,DEFYRES,DEFYMM);

/* write out size info */
dwrite(fd,&ox,2);
dwrite(fd,&oy,2);
savebgn = getpos(fd);

intimg(fd,ox,oy);		/* initialize output bitmap */
savend = getpos(fd);

putstr(STDOUT,"intimg done \n",NULL);
dlseek(fd, savebgn, SEEKABS);
prtseg(thsnode,thsnode);	/* print this segment */

iniptrav(thsnode->lptr);	/* print all its children */
while( node=ptrav() ) {
	dlseek(fd, savebgn, SEEKABS);
	prtseg(thsnode,node);
	}
dlseek(fd, savend, SEEKABS);

}	/* of puttree */


/*********************************************************/
/* pastes data of node onto output bitmap file */
/* performs usual clipping */
prtseg(topnode,node)
FAST	TREEPTR	topnode,node;

{
int	x,y,dx,dy;
int	ix,sxi,syi,sxo,syo;
FILE	fdi;
FAST	TREEPTR	snode;
int	ox;

x = node->scrxpos;
y = node->scrypos;
dx = node->scrxsiz;
dy = node->scrysiz;

/* find actual visible area of this segment */
for (snode = node; snode != topnode; snode = snode->upptr)
		if(ovlap(x,y,dx,dy,snode->scrxpos,snode->scrypos,
			snode->scrxsiz,snode->scrysiz,
			&x,&y,&dx,&dy) <= 0 ) return;
 
if (ovlap(x,y,dx,dy,topnode->scrxpos,topnode->scrypos,
	sizmap(1728,DEFXRES,DEFXMM,SCRXRES,SCRXMM),
	sizmap(2200,DEFYRES,DEFYMM,SCRYRES,SCRYMM),
	&x,&y,&dx,&dy) <= 0)
	return ;

/* ox = xsize of output bitmap */
/* (sx,sy) = origin of this bitmap in output bitmap */
ox = sizmap(topnode->scrxsiz,SCRXRES,SCRXMM,DEFXRES,DEFXMM);
sxo= sizmap(x-topnode->scrxpos,SCRXRES,SCRXMM,DEFXRES,DEFXMM);
syo= sizmap(y-topnode->scrypos,SCRYRES,SCRYMM,DEFYRES,DEFYMM);


if ( !node->dataflag ) {
	return;
	}

if ((fdi = dopen(node->filnam,0,1)) < 0) {
	putstr(STDOUT,opnerr,node->filnam,"\n",NULL);
	return;
	}
dlseek(fdi,node->filptr,SEEKABS);
if (node->alg == ALGMBITMAP ) {
	dread(fdi,&ix,2);
	dread(fdi,linbuf,2);
	}
else	ix=node->xsiz;

/* compute origin of window in source bitmap */
sxi= node->startx + muldiv(x-node->scrxpos,node->magxbas,node->magx);
syi= node->starty + muldiv(y-node->scrypos,node->magybas,node->magy);

pstimg(fdi,fd,ix,ox,sxi,syi,sxo,syo,
	sizmap(dx,SCRXRES,SCRXMM,DEFXRES,DEFXMM),
	sizmap(dy,SCRYRES,SCRYMM,DEFYRES,DEFYMM),
	muldiv(node->magx,DEFXRES,DEFXMM),
	muldiv(node->magxbas,SCRXRES,SCRXMM),
	muldiv(node->magy,DEFYRES,DEFYMM),
	muldiv(node->magybas,SCRYRES,SCRYMM) );

dclose(fdi);
}	/* of putseg */


/*********************************************************/
/* puts out segment node as bitmap in its own resolution */
putseg(node)
FAST	TREEPTR	node;

{
int	ix;
FILE	fdi;
int	mx,mxb,my,myb;

if ((fdi = dopen(node->filnam,0,1)) < 0) {
	putstr(STDOUT,opnerr,node->filnam,"\n",NULL);
	return;
	}
dlseek(fdi,node->filptr,SEEKABS);
if (node->alg == ALGMBITMAP ) {
	dread(fdi,&ix,2);
	dread(fdi,linbuf,2);
	}
else	ix=node->xsiz;

gactmag(node,&mx,&mxb,&my,&myb);
pstimg(fdi,fd,ix,node->segxsiz,node->startx,node->starty,0,0,
	node->segxsiz,node->segysiz,mx,mxb,my,myb);

dclose(fdi);
}	/* of putseg */

/*********************************************************/
/* erase rect(x,y,dx,dy) on the screen */
/* erases only that portion that 'belongs' to segment node */
erase(node,x,y,dx,dy)
FAST	TREEPTR	node;
int	x,y;
int	dx,dy;

{
FAST	TREEPTR	snode;

for (snode = node; snode && (snode != mtop); snode = snode->upptr)
	if(ovlap(x,y,dx,dy,snode->scrxpos,snode->scrypos,
		snode->scrxsiz,snode->scrysiz,
		&x,&y,&dx,&dy) <= 0 ) return;
 
if (ovlap(0,0,DISXMAX,DISYMAX,mapx(x),mapy(y),dx,dy,
	&x,&y,&dx,&dy) > 0 ) clear(actplane,x,y,dx,dy);

}


/*********************************************************/
/* returns pointer to active current node */
TREEPTR	wchnode()
{
if ( actplane == 1) return(present);
return(newnode);
}

/*********************************************************/
/* finds out if node's data is all present on the screen and
if it will be all present when the segment is moved
to new position (lcurx,lcury). (ox,oy) is the present position  */

BOOL allhere(thsnode,ox,oy)
FAST	TREEPTR	thsnode;
int	ox,oy;
{
FAST	TREEPTR	node;
int	nx,ny,dx,dy;

/* all present on sceen after move? */
if ( ovlap(curx,cury,thsnode->scrxsiz,thsnode->scrysiz,
	0,0,DISXMAX,DISYMAX,&nx,&ny,&dx,&dy) <= 0 ) return(NO);
if ( (dx!=thsnode->scrxsiz) || (dy!=thsnode->scrysiz) ) return(NO);

/* all present on sceen before move? */
if (ovlap(mapx(ox),mapy(oy),thsnode->scrxsiz,thsnode->scrysiz,
	0,0,DISXMAX,DISYMAX,&nx,&ny,&dx,&dy) <= 0 ) return(NO);
if ((dx!=thsnode->scrxsiz) || (dy!=thsnode->scrysiz) ) return(NO);
 
/* is it clipped by any of its parents ? */
node = thsnode;
while ( ( node = node->upptr) && (node != mtop ) ) {
	if (ovlap(ox,oy,thsnode->scrxsiz,thsnode->scrysiz,
	node->scrxpos,node->scrypos,node->scrxsiz,node->scrysiz,
	&nx,&ny,&dx,&dy) <= 0 ) return(NO);
	if ((dx!=thsnode->scrxsiz) || (dy!=thsnode->scrysiz) ) return(NO);

	if (ovlap(thsnode->scrxpos,thsnode->scrypos,
	thsnode->scrxsiz,thsnode->scrysiz,
	node->scrxpos,node->scrypos,node->scrxsiz,node->scrysiz,
	&nx,&ny,&dx,&dy) <= 0 ) return(NO);
	if ((dx!=thsnode->scrxsiz) || (dy!=thsnode->scrysiz) ) return(NO);
	}
	
/* any one overlapping it ? */
iniptrav(top);
for ( node=ptrav(); (node != thsnode) && node ; node = ptrav() ) ;

while (  node=ptrav() )
	if(ovlap(ox,oy,thsnode->scrxsiz,thsnode->scrysiz,
	  node->scrxpos,node->scrypos,node->scrxsiz,node->scrysiz,
	  &nx,&ny,&dx,&dy) > 0 ) 
		return(NO);

return(YES);

}	/* of allhere */

/***************************************************************/
/* scroll up dy bits on screen */
/* moves image, clears vacated area and repaints vacated area */

scrlup(dy)
int	dy;
{
if (dy < DISYMAX) mover(actplane,actplane,0,dy,0,0,DISXMAX,DISYMAX-dy);
else dy = DISYMAX;
clear(curplane,0,DISYMAX-dy,DISXMAX,dy);
repain(0,top,lcurx-curx,lcury-dy+1,DISXMAX,dy);
}

/***************************************************************/
/* scroll down dy bits on screen */
scrldown(dy)
int	dy;
{
if (dy < DISYMAX) mover(actplane,actplane,0,0,0,dy,DISXMAX,DISYMAX-dy);
else dy = DISYMAX;
clear(curplane,0,0,DISXMAX,dy);
repain(0,top,lcurx-curx,lcury,DISXMAX,dy);
}

/***************************************************************/
/* scroll right dx bits on screen */
scrlright(dx)
int	dx;
{
if (dx < DISXMAX) mover(actplane,actplane,0,0,dx,0,DISXMAX-dx,DISYMAX);
else dx = DISXMAX;
clear(curplane,0,0,dx,DISYMAX);
repain(0,top,lcurx,lcury-cury,dx,DISYMAX);
}

/***************************************************************/
/* scroll left dx bits on screen */
scrlleft(dx)
int	dx;
{
if (dx < DISXMAX) mover(actplane,actplane,dx,0,0,0,DISXMAX-dx,DISYMAX);
else dx = DISXMAX;
clear(curplane,DISXMAX-dx,0,dx,DISYMAX);
repain(0,top,lcurx-dx+1,lcury-cury,dx,DISYMAX);
}

/*********************************************************/
/* hilite current segment and all its parents */
hilite(node)
FAST	TREEPTR	node;
{
border(node);
drwcur(curx,cury,cursiz);
}

/*********************************************************/
/* remove hilite rects. and cursor */
dehilite(node)
FAST	TREEPTR	node;
{
drwcur(curx,cury,cursiz);
border(node);
}

/*********************************************************/
/* draw dashed borders around segment node and all its ancestors.
Dashes increase in size as one goes up the family tree */
border(node)
FAST	TREEPTR	node;

{
FAST	TREEPTR	snode;
int	dash ;

dash = 0;

for ( snode=node; snode && (snode != mtop); snode=snode->upptr)
	recnode(snode,dash += 2);
} 	/* of border */

/********************************************************/
/* draw rect. around node of dash size dash */
recnode(node,dash)
int	dash;
FAST	TREEPTR	node;
{
FAST	TREEPTR	snode;
int	ox,oy,dx,dy;

/* map segment to physical screen and draw rect. */
if (ovlap(0,0,DISXMAX,DISYMAX,mapx(node->scrxpos),
	mapy(node->scrypos),node->scrxsiz,node->scrysiz,
	&ox,&oy,&dx,&dy) <= 0 )  return;
drwrec(ox,oy,dx,dy,dash);

}
                                                                                                                                                                                                                                                                                                                                                                                   