;  DSP-93 MACROS  94.07.13 @ 15:47 EST
;  Version for TAPR/AMSAT DSP-93, File - MACROS.ASM
;
;  Module Name:
;       MACROS.ASM
;  Creator:
;       Mike Zingman N4IRR
;  Purpose:
;
;  Used in:
;
;  Expected warnings:
;       None
;
;  Revision history:
;       Created: 94.07.13 By Mike Zingman N4IRR
;
; Copyright (c) 1994 by Tucson Amateur Packet Radio Corporation
; 
; This document, and it executable, are the property of the Tucson Amateur
; Packet Radio Corp., a Arizona non-profit corporation, and all are copyright
; 1994.  Permission is hereby granted for the non-commercial use of these
; properties only by licensed amateur radio operators.  All other rights are
; reserved  by the Tucson Amateur Packet Radio Corp. 
; 
; This software is provided for use only to non-commercial amateur radio
; users.  Commercial inquiries should be made to Tucson Amateur Packet Radio
; Corp.
; 
; TAPR (Tucson Amateur Packet Radio Corporation) makes no warranty of any
; kind, express or implied, including without limitation, any warranties
; and/or fitness for a particular purpose of this software.  TAPR shall not be
; liable for any damages, whether direct, indirect, special or consequential
; arising from a failure of this software to operate in the manner desired by
; the user.  TAPR shall not be liable for any damage to data or property that
; may be caused directly or indirectly by using the software.
; 
; IN NO EVENT WILL TUCSON AMATEUR PACKET RADIO CORP. BE LIABLE FOR ANY
; INCIDENTAL OR CONSEQUENTIAL DAMAGE ARISING OUT OF USE OR INABILITY TO USE
; THE PROGRAM, OR FOR ANY CLAIM BY ANY OTHER PARTY.
;
;  Updates:
;
;--------------------------------------------------------------------------



; *************************************************************************
; *
; *  Macro Name:
; *      BEGIN_DATA( OrgAddress )
; *
; *  Purpose:
; *     This macro defines the origin in the code segment that the
; *     initialized data is to begin.
; *
; *  Preconditions:
; *
; *  Globals affected:
; *
; *  Notes:
; *     The address passed may be any valid memory address.  Note that
; *     it will be common for the programmer to use $ (current program
; *     pointer address).
; *
; *  Usage:
; *     BEGIN_DATA( ValidAddress )
; *     Where ValidAddress is a location in the Code segment where the
; *     image if the initialized data is to begin.
; *
; ************************************************************************

#DEFINE BEGIN_DATA(CSEG_ADDRESS) \
#DEFCONT \CSEG_DATA .EQU CSEG_ADDRESS
#DEFCONT \ .ORG CSEG_ADDRESS



; *************************************************************************
; *
; *  Macro Name:
; *      DATA( VarName, Value )
; *
; *  Purpose:
; *      This macro defines storage in the code segment while also
; *      creating a symbol representing the location the data will
; *      reside in data memory after an initialization block move.
; *
; *  Preconditions:
; *      The BEGIN_DATA macro must have been used before this macro
; *      is called.
; *
; *  Globals affected:
; *      The program counter will be incremented each time this macro
; *      is called.
; *
; *  Notes:
; *      This macro is used to create "initialized" memory.  Since TASM
; *      and the DSP-93 are not segmented memory machines, this method
; *      of creating storage in the code segment and defining the symbol
; *      for use in the data segment is used.
; *      Note that the macro uses the arbitrary 060h location to begin
; *      definitions in the data segment.
; * 
; *  Usage:
; *      DATA( LabelName, DataValue )
; *        LabelName is the name of the symbol being defined
; *        DataValue is the intialized value of the memory location
; *
; ************************************************************************

PAGE_OFFSET .EQU 060h

#DEFINE DATA(VarName,Value) \
#DEFCONT \VarName .EQU ($-CSEG_DATA+PAGE_OFFSET)
#DEFCONT \ .word Value

