;  DSP-93 Monitor Entry Points
;  Version for TAPR/AMSAT DSP-93
;
;  Module Name:
;       MONITOR.INC
;  Creator:
;       Mike Zingman N4IRR
;  Purpose:
;       This file defines the DSP-93 monitor functions and addresses. Symbolic
;       names for all of the entry points have been assigned.  This file should
;       be used instead of the absolute addresses since a linker does not exist.
;       The file may also contain any macros defined in the future that can
;       help in using the monitor functions.
;  Used in:
;       All files that use the DSP-93 monitor should include this definition
;       file.  This file will only be included once.
;
;       For use with monitor rom versions 2.12 or higher.
;  Expected warnings:
;       None
;  Revision history:
;       Created: 94.07.13 By Mike Zingman N4IRR
;       Updated function addresses from information on beta-dsp
;       Added conditional assembly for multiple inclusion
;       Added a 0 in definition for SIN_TBL  N5BRG 94.08.07
;       Updated function addresses for version 2.10 Monitor.  N5BRG
;       Corrected call address for GETVAL16. N5BRG 94.12.07
;       Updated to match Monitor ROMs 2.15.
;
; Copyright (c) 1994 by Tucson Amateur Packet Radio Corporation
; 
; This document, and it executable, are the property of the Tucson Amateur
; Packet Radio Corp., a Arizona non-profit corporation, and all are copyright
; 1994.  Permission is hereby granted for the non-commercial use of these
; properties only by licensed amateur radio operators.  All other rights are
; reserved  by the Tucson Amateur Packet Radio Corp. 
; 
; This software is provided for use only to non-commercial amateur radio
; users.  Commercial inquiries should be made to Tucson Amateur Packet Radio
; Corp.
; 
; TAPR (Tucson Amateur Packet Radio Corporation) makes no warranty of any
; kind, express or implied, including without limitation, any warranties
; and/or fitness for a particular purpose of this software.  TAPR shall not be
; liable for any damages, whether direct, indirect, special or consequential
; arising from a failure of this software to operate in the manner desired by
; the user.  TAPR shall not be liable for any damage to data or property that
; may be caused directly or indirectly by using the software.
; 
; IN NO EVENT WILL TUCSON AMATEUR PACKET RADIO CORP. BE LIABLE FOR ANY
; INCIDENTAL OR CONSEQUENTIAL DAMAGE ARISING OUT OF USE OR INABILITY TO USE
; THE PROGRAM, OR FOR ANY CLAIM BY ANY OTHER PARTY.
;

#IFNDEF __MONITOR__
#DEFINE __MONITOR__

DEBUG    .EQU    0400h      ; Start of N5EG Debug Routine
GETVAL16 .EQU    0402h      ; Get 16 bit word from SIO
                            ; Result placed in GETVAL_MEM listed below.
GET4HEX  .EQU    0402h      ; Get four HEX digits.  Same as GETVAL16
                            ; Result placed in GET4HEXMEM listed below.
GET2HEX  .EQU    0404h      ; Get  two HEX digits. 
                            ; Result placed in GET2HEXMEM listed below.
GETCHAR  .EQU    0406h      ; Get  one HEX digit. 
                            ; Result placed in GETCAR_MEM listed below.
HEXOUT   .EQU    0408h      ; Sends data in accumulator to SIO
INBIT    .EQU    040Ah      ; Collects data from SIO, results in  AR(ARP)
OUTBIT   .EQU    040Ch      ; Sends Lower 8 bits of AR(ARP) to SIO (Uses OUTBIT_TMP)
OUTBIT2  .EQU    040Eh      ; Sends lower 8 bits of OUTBIT2_MEM to SIO (Uses OUTBIT_TMP)
PRVAL08  .EQU    0410h      ; Print value at PRVAL_MEM to SIO
PRVAL16  .EQU    0412h      ; Print value at PRVAL_MEM to SIO
RESET    .EQU    0414h      ; Reset the DSP-93
SD_CRLF  .EQU    0416h      ; Send CR and LF to SIO
SD_STR   .EQU    0418h      ; Print string pointed to by current AR(R).
                            ; C style strings used
SP1      .EQU    041Ah      ; Send 1 space to SIO
SP2      .EQU    041Ch      ;      2
SP3      .EQU    041Eh      ;      3
SP4      .EQU    0420h      ;      4
SP5      .EQU    0422h      ;      5
SP6      .EQU    0424h      ;      6
SP7      .EQU    0426h      ;      7
SP8      .EQU    0428h      ;      8
SP9      .EQU    042Ah      ;      9
SP10     .EQU    042Ch      ;      10
MWAIT_A  .EQU    042Eh      ; Entry for about N * 1 mS wait.
                            ; N is the value in AR2
MWAIT1   .EQU    0430h      ; Entry for a 32 mS wait.
PM_BLK_MV .EQU   0432h      ; Moves a block of code PROG -> DATA
MP_BLK_MV .EQU   0434h      ; Moves a block of code DATA -> PROG
    

GETCAR_MEM  .EQU 0001h      ; GETCHAR  places data here
GET2HEXMEM  .EQU 0002h      ; GET2HEX  places data here
GET4HEXMEM  .EQU 0003h      ; GET4HEX  places data here
GETVAL_MEM  .EQU 0003h      ; GETVAL16 places data here
OUTBIT_TMP  .EQU 0060h      ; Temp storage for OUTBIT, OUTBIT2
OUTBIT2_MEM .EQU 0062h      ; Memory location output to SIO by OUTBIT2
PRVAL_MEM   .EQU 0006h      ; 8 or 16 bits here are sent to SIO. MSB first
DEBUGPC     .EQU 007Eh      ; Pass Counter used by CALL DEBUG
DEBUGML     .EQU 007Fh      ; Starting data memory location used by CALL DEBUG

;	A  540 degree SIN/COS table is included with the monitor.  The
;	table  is 16 bit values in increments of .25 degrees.  The  table
;	starts  at  program memory location 7751h through 7FC0h  when  the
;	monitor  is in LOW speed and it is moved to program memory  loca-
;	tion F000 through F86F when you switch to high speed.

SIN_TBL      .EQU   0F000h
	
#ENDIF
	

