;  DSP-93 Port Assignments  94.07.13 @ 15:47 EST
;  Version for TAPR/AMSAT DSP-93, 
;
;  Module Name:
;       PORTS.ASM
;  Creator:
;       Mike Zingman N4IRR
;  Purpose:
;       This file defines the DSP-93 I/O ports and I/O bits.  The file 
;       assigns symbolic names for each of the ports and bits.  The user
;       should make use of the TASM bitwise AND (&) and OR (|) operators
;       to manipulate the bits.  The programmer is discouraged from using
;       hex values in programs, as other users may have to read the listings,
;       and the symbolic names assign greater meaning to the code.
;  Used in:
;       All files that use the DSP-93 I/O ports should include this definition
;       file.  This file will only be included once.
;  Expected warnings:
;       None
;  Revision history:
;       Created: 94.07.13 By Mike Zingman N4IRR From info found in Monitor Doc
;       Fixed AIO_ENABLE and AIO_RESET from changes to monitor doc (N4IRR)
;       Fixed bit ranges of TNC_INPUT to MSB data from LSB data in doc (N4IRR)
;       Added conditional assembly for multiple inclusion (N4IRR)
;       Add AIO configuration symbols (W5RKN) 08-11-94
;       Add Additional EQU for LED on and OFF (N4IRR)
;       Add 1's complements of several macros (W5RKN) 08-18-94
;       Changed 1's complement to complement symbol not number (N4IRR)
;
; Copyright (c) 1994 by Tucson Amateur Packet Radio Corporation
; 
; This document, and it executable, are the property of the Tucson Amateur
; Packet Radio Corp., a Arizona non-profit corporation, and all are copyright
; 1994.  Permission is hereby granted for the non-commercial use of these
; properties only by licensed amateur radio operators.  All other rights are
; reserved  by the Tucson Amateur Packet Radio Corp. 
; 
; This software is provided for use only to non-commercial amateur radio
; users.  Commercial inquiries should be made to Tucson Amateur Packet Radio
; Corp.
; 
; TAPR (Tucson Amateur Packet Radio Corporation) makes no warranty of any
; kind, express or implied, including without limitation, any warranties
; and/or fitness for a particular purpose of this software.  TAPR shall not be
; liable for any damages, whether direct, indirect, special or consequential
; arising from a failure of this software to operate in the manner desired by
; the user.  TAPR shall not be liable for any damage to data or property that
; may be caused directly or indirectly by using the software.
; 
; IN NO EVENT WILL TUCSON AMATEUR PACKET RADIO CORP. BE LIABLE FOR ANY
; INCIDENTAL OR CONSEQUENTIAL DAMAGE ARISING OUT OF USE OR INABILITY TO USE
; THE PROGRAM, OR FOR ANY CLAIM BY ANY OTHER PARTY.
;

;  PORT IO ASSIGNMENTS
;  Revised to 23 DEC 1993

;  PORT CONNECTIONS AND PROGRAM ASSIGNMENTS

#IFNDEF __PORTS__
#DEFINE __PORTS__


PORT_00h    .EQU    0       ;  Not defined for basic system
UART_WRITE  .EQU    01h     ;  UART Write
HS_CLOCK    .EQU    02h     ;  HIGH SPEED CLK & H_AIO
UART_CTRL   .EQU    03h     ;  UART CONTROL REGISTER
AIO_SELECT  .EQU    04h     ;  H_AIO SELECT OUTPUT
UART_READ   .EQU    05h     ;  UART READ  (READ ONLY)
TNC_OUTPUT  .EQU    06h     ;  TNC OUTPUT
RADIO_GAIN  .EQU    07h     ;  RADIO PORT SELECT AND GAIN & AIO ENABLE
PORT_08     .EQU    08h     ;  Not defined for basic system
PORT_09     .EQU    09h     ;  Not defined for basic system
TNC_INPUT   .EQU    0Ah     ;  TNC INPUT  (READ ONLY)
RADIO_CTRL  .EQU    0Bh     ;  RADIO PORT DIGITAL CONTROL
PORT_0C     .EQU    0Ch     ;  Not defined for basic system
PORT_0D     .EQU    0Dh     ;  Not defined for basic system
PORT_0E     .EQU    0Eh     ;  Not defined for basic system
PORT_0F     .EQU    0Fh     ;  Not defined for basic system

;  PORT 06h (TNC_OUTPUT)    TNC OUTPUT
CDI         .EQU    0100h   ;  CDI and LED 205       TNC-1 
CDI_OFF     .EQU   ~CDI     ;  CDI and LED 205 OFF   TNC-1 
KEYI_206    .EQU    0200h   ;  KEYI and LED206       TNC-6 
KEYI_206_OFF .EQU  ~KEYI_206;  KEYI and LED206 OFF   TNC-6 
KEYI_207    .EQU    0400h   ;  KEYI and LED207       TNC-10
KEYI_207_OFF .EQU  ~KEYI_207;  KEYI and LED207 OFF   TNC-10
CTSI        .EQU    0800h   ;  CTSI                  TNC-9 
XCLKI       .EQU    1000h   ;  Transmit Clock        TNC-11
RCLKI       .EQU    2000h   ;  Receive Clock         TNC-13
RDI         .EQU    4000h   ;  Receive Data          TNC-17
TDI         .EQU    8000h   ;  Transmit Data         TNC-20


LED_206     .EQU    KEYI_206    
LED_206_OFF .EQU    KEYI_206_OFF
LED_207     .EQU    KEYI_207    
LED_207_OFF .EQU    KEYI_207_OFF
LED_205     .EQU    CDI
LED_205_OFF .EQU    CDI_OFF

;   PORT 07h (RADIO_GAIN) RADIO PORT SELECT AND GAIN & AIO ENABLE
AUX_IN      .EQU    00h     ;  I/O 201 PIN 7  AUX IN  AUXILLARY AUDIO IN RADIO 1
AUX_IN_DFLT .EQU    01h     ;  I/O 202 PIN 7  AUX IN  AUXILLARY AUDIO IN (DEFAULT)
AUX_2       .EQU    02h     ;  Jx03 PIN 14    AUX #2  AUDIO BUSS #2
AUX_1       .EQU    03h     ;  Jx03 PIN 12    AUX #1  AUDIO BUSS #1
XMIT_2      .EQU    04h     ;  I/O 202 PIN 1  XMIT 2  TRANSMIT MONITOR RADIO 2
REC_IN_1    .EQU    05h     ;  I/O 201 PIN 2  REC IN  RECEIVE AUDIO RADIO 1
XMIT_1      .EQU    06h     ;  I/O 201 PIN 1  XMIT 1  TRANSMIT MONITOR RADIO 1
REC_IN_2    .EQU    07h     ;  I/O 202 PIN 2  REC IN  RECEIVE AUDIO RADIO 2

GAIN0       .EQU    00h     ;  FEEDBACK    Unity gain
GAIN1       .EQU    08h     ;  FDBK R201   Gain = 2  
GAIN2       .EQU    10h     ;  FDBK R204   Gain = 4  
GAIN3       .EQU    18h     ;  FDBK R205   Gain = 8  
GAIN4       .EQU    20h     ;  FDBK R206   Gain = 16 
GAIN5       .EQU    28h     ;  FDBK R207   Gain = 32 
GAIN6       .EQU    30h     ;  FDBK R208   Gain = 64 
GAIN7       .EQU    38h     ;  FDBK R203   Comparator

LED_202     .EQU    40h     ;  U215-10  PANEL LED 202 (DEFAULT OFF)
LED_202_OFF .EQU   ~LED_202 ;  U215-10  PANEL LED 202 (DEFAULT OFF)
LED_201     .EQU    80h     ;  U215-11  PANEL LED 201 (DEFAULT ON)
LED_201_OFF .EQU   ~LED_201 ;  U215-11  PANEL LED 201 (DEFAULT ON)

AIO_ENABLE  .EQU    4000h   ;  U210-9      *AIO_EN  ENABLE FOR AIO DR & DX SIO
AIO_RESET   .EQU    8000h   ;  U208-2      *AIO_RST Reset for AIO converter (*RESET)


;  PORT 0Ah (TNC_INPUT)    TNC INPUT  (READ ONLY)
CDO         .EQU    0100h   ;  TNC-2            TNC *CD O
RTSO        .EQU    0200h   ;  TNC-5            TNC *RTS O
UNACK_PKTS  .EQU    0400h   ;  TNC-8            TNC PIN 8
CONNO       .EQU    0800h   ;  TNC-7            TNC  CONN 0
RCLKO       .EQU    1000h   ;  TNC-14           REC CLOCK
XCLKO       .EQU    2000h   ;  TNC-16           TRANSMIT CLOCK
RDO         .EQU    4000h   ;  TNC-18           RECEIVE DATA
TDO         .EQU    8000h   ;  TNC-19           TRANSMIT DATA



;  PORT 0Bh (RADIO_CTRL) RADIO PORT DIGITAL CONTROL
PTT_R1      .EQU    01h     ;  I/O 201 PIN 3 PUSH TO TALK RADIO 1
PTT_R1_OFF  .EQU   ~PTT_R1  ;  I/O 201 PIN 3 PUSH TO TALK RADIO 1 OFF
FREQ_UP_R1  .EQU    02h     ;  I/O 201 PIN 4 FREQUENCY TUNE UP PULSE
FREQ_DN_R1  .EQU    04h     ;  I/O 201 PIN 5 FREQEUNCY TUNE DOWN & 470 TO PIN 6
ICOM_R1     .EQU    04h     ;  I/O 201 PIN 6 470 OHM RESISTOR TO PIN 5
PTT_R2      .EQU    08h     ;  I/O 202 PIN 3 PUSH TO TALK RADIO 2
PTT_R2_OFF  .EQU   ~PTT_R2  ;  I/O 202 PIN 3 PUSH TO TALK RADIO 2 OFF
FREQ_UP_R2  .EQU    10h     ;  I/O 202 PIN 4 FREQUENCY TUNE UP PULSE
FREQ_DN_R2  .EQU    20h     ;  I/O 202 PIN 5 FREQEUNCY TUNE DOWN & 470 TO PIN 6
ICOM_R2     .EQU    20h     ;  I/O 202 PIN 6 470 OHM RESISTOR TO PIN 5
LED_204     .EQU    80h     ;  U215-13   PANEL LED 204 (DEFAULT OFF)
LED_204_OFF .EQU   ~LED_204 ;  U215-13   PANEL LED 204 OFF (DEFAULT OFF)
LED_203     .EQU    40h     ;  U215-12   PANEL LED 203 (DEFAULT ON)
LED_203_OFF .EQU   ~LED_203 ;  U215-12   PANEL LED 203 OFF (DEFAULT ON)

; AIO Configuration data

AIO_CONFIG   .EQU    3         ;  AIO configuration
AIO_INSADHPF .EQU    1<<2      ;  Insert A/D HPF
AIO_ENLOOPB  .EQU    1<<3      ;  Enable loopback function
AIO_AUXIN    .EQU    1<<4      ;  Enable AUX IN
AIO_SYNC     .EQU    1<<5      ;  Synchronous Tx and Rx
AIO_INSSINX  .EQU    1<<9      ;  Insert sin x/x filter (SINC)
AIO_GAIND60  .EQU    0         ;  Gain Control Register bit D6 = 0
AIO_GAIND61  .EQU    1<<6      ;  Gain Control Register bit D6 = 1
AIO_GAIND70  .EQU    0         ;  Gain Control Register bit D7 = 0
AIO_GAIND71  .EQU    1<<7      ;  Gain Control Register bit D7 = 1

#DEFINE CMDA_VAL(VALUE) ((VALUE<<9)|(VALUE<<2))
#DEFINE CMDB_VAL(VALUE) ((VALUE<<9)|(VALUE<<2)|2)

;Typical uses:
;
;;  AIO configuration: HPF in, Sync, 3 V half scale, sin x/x
;CMDC .EQU AIO_CONFG|AIO_INSADHPF|AIO_SYNC|AIO_GAIND60|AIO_GAIND70|AIO_INSSINX
;
;AIO_RST LALK AIO_RESET|GAIN4|REC_IN_1  ;  reset D15 to disconnect AIO (DX&DR)
;
;AIO_INI LALK LED_202|GAIN4|REC_IN_1    ;  LED 202 on, radio 1, gain = 16
;
;        LALK AIO_ENABLE|GAIN4|REC_IN_1 ;  load AIO run, radio 1, gain = 16


#ENDIF
