/*
 * Install/Remove/Query a service under WindowsNT 3.5
 */
#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

VOID
main(int argc, char *argv[])
{ 
	SC_HANDLE   schService;
	SC_HANDLE   schSCManager;

    if (argc != 3) {
        printf("usage: instsrv <service name> <exe location>\n");
        printf("           to install a service, or:\n");
        printf("       instsrv <service name> remove\n");
        printf("           to remove a service\n");
        printf("       instsrv <service name> query\n");
        printf("           to query a service configuration\n");
        exit(1);
    }

    schSCManager = OpenSCManager(
                        NULL,                   // machine (NULL == local)
                        NULL,                   // database (NULL == default)
                        SC_MANAGER_ALL_ACCESS   // access required
                        );

    if (!stricmp(argv[2], "remove")) {
		/* remove a service */
    	if ((schService = OpenService(schSCManager, argv[1], SERVICE_ALL_ACCESS)) == NULL) {
        	printf("OpenService failed (%u)\n", GetLastError());
        	exit(1);
    	}
    	if(DeleteService(schService))
        	printf("DeleteService SUCCESS\n");
    	else
        	printf("DeleteService failed (%u)\n", GetLastError());
    } else if (!stricmp(argv[2], "query")) {
		/* query service configuration info */
		QUERY_SERVICE_CONFIG serviceInfo[100];
		LPQUERY_SERVICE_CONFIG ptr = &serviceInfo[0]; /* need enough space */
		DWORD bytes;

    	if ((schService = OpenService(schSCManager, argv[1], SERVICE_ALL_ACCESS)) == NULL) {
        	printf("OpenService failed (%u)\n", GetLastError());
        	exit(1);
    	}

		if (QueryServiceConfig(schService, 
				ptr,
				(DWORD) 100 * sizeof(QUERY_SERVICE_CONFIG), 
				(LPDWORD)&bytes)) {
            printf("QueryService SUCCESS\n");
			printf("Service info for %s is as follows:\n", serviceInfo[0].lpDisplayName);
			printf("LoadOrderGroup = %s, TagId = %u, Dependencies = %s\n",
				serviceInfo[0].lpLoadOrderGroup, serviceInfo[0].dwTagId, serviceInfo[0].lpDependencies);
		} else
        	printf("QueryService failed (%u)\n", GetLastError());
    } else {
		/* install a service */
        if ((schService = CreateService(
        schSCManager,               // SCManager database
        argv[1],                // name of service
        argv[1],                // name to display (new parameter after october beta)
        SERVICE_ALL_ACCESS,         // desired access
        SERVICE_WIN32_OWN_PROCESS,  // service type
        SERVICE_AUTO_START,         // start type
        SERVICE_ERROR_NORMAL,       // error control type
        argv[2],         			// service's binary
        NULL,                       // test load ordering group
        NULL,                       // no tag identifier
        "Tcpip\0",                  // after TCP/IP is started
        NULL,                       // LocalSystem account
        NULL)) == NULL) {           // no password
        	printf("CreateService failed (%u)\n", GetLastError());
    	} else
        	printf("CreateService SUCCESS\n");
	}

    CloseServiceHandle(schSCManager);
}
									   

