# Generated by default/object.tt
package Paws::NetworkFirewall::RuleVariables;
  use Moose;
  has IPSets => (is => 'ro', isa => 'Paws::NetworkFirewall::IPSets');
  has PortSets => (is => 'ro', isa => 'Paws::NetworkFirewall::PortSets');

1;

### main pod documentation begin ###

=head1 NAME

Paws::NetworkFirewall::RuleVariables

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::NetworkFirewall::RuleVariables object:

  $service_obj->Method(Att1 => { IPSets => $value, ..., PortSets => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::NetworkFirewall::RuleVariables object:

  $result = $service_obj->Method(...);
  $result->Att1->IPSets

=head1 DESCRIPTION

Settings that are available for use in the rules in the RuleGroup where
this is defined.

=head1 ATTRIBUTES


=head2 IPSets => L<Paws::NetworkFirewall::IPSets>

A list of IP addresses and address ranges, in CIDR notation.


=head2 PortSets => L<Paws::NetworkFirewall::PortSets>

A list of port ranges.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::NetworkFirewall>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

